package cdm.product.collateral.validation;

import cdm.base.datetime.DayTypeEnum;
import cdm.product.collateral.CollateralInterestNotification;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import java.math.BigDecimal;
import java.time.LocalTime;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class CollateralInterestNotificationValidator implements Validator<CollateralInterestNotification> {

	private List<ComparisonResult> getComparisonResults(CollateralInterestNotification o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("trigger", (String) o.getTrigger() != null ? 1 : 0, 1, 1), 
				checkCardinality("offset", (BigDecimal) o.getOffset() != null ? 1 : 0, 1, 1), 
				checkCardinality("notificationTime", (LocalTime) o.getNotificationTime() != null ? 1 : 0, 1, 1), 
				checkCardinality("notificationDayType", (DayTypeEnum) o.getNotificationDayType() != null ? 1 : 0, 1, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, CollateralInterestNotification o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("CollateralInterestNotification", ValidationType.CARDINALITY, "CollateralInterestNotification", path, "", res.getError());
				}
				return success("CollateralInterestNotification", ValidationType.CARDINALITY, "CollateralInterestNotification", path, "");
			})
			.collect(toList());
	}

}
