package cdm.product.collateral.validation;

import cdm.product.collateral.DeliveryAmount;
import cdm.product.collateral.InterestAmountApplication;
import cdm.product.collateral.ReturnAmount;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class InterestAmountApplicationValidator implements Validator<InterestAmountApplication> {

	private List<ComparisonResult> getComparisonResults(InterestAmountApplication o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("returnAmount", (ReturnAmount) o.getReturnAmount() != null ? 1 : 0, 1, 1), 
				checkCardinality("deliveryAmount", (DeliveryAmount) o.getDeliveryAmount() != null ? 1 : 0, 1, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, InterestAmountApplication o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("InterestAmountApplication", ValidationType.CARDINALITY, "InterestAmountApplication", path, "", res.getError());
				}
				return success("InterestAmountApplication", ValidationType.CARDINALITY, "InterestAmountApplication", path, "");
			})
			.collect(toList());
	}

}
