package cdm.product.collateral.validation.datarule;

import cdm.base.datetime.BusinessCenterEnum;
import cdm.base.datetime.CompoundingTypeEnum;
import cdm.product.collateral.CollateralInterestCalculationParameters;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.24.0
 */
@RosettaDataRule("CollateralInterestCalculationParametersCompoundingBC2")
@ImplementedBy(CollateralInterestCalculationParametersCompoundingBC2.Default.class)
public interface CollateralInterestCalculationParametersCompoundingBC2 extends Validator<CollateralInterestCalculationParameters> {
	
	String NAME = "CollateralInterestCalculationParametersCompoundingBC2";
	String DEFINITION = "if compoundingType <> CompoundingTypeEnum -> Business then compoundingBusinessCenter is absent";
	
	class Default implements CollateralInterestCalculationParametersCompoundingBC2 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CollateralInterestCalculationParameters collateralInterestCalculationParameters) {
			ComparisonResult result = executeDataRule(collateralInterestCalculationParameters);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "CollateralInterestCalculationParameters", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationType.DATA_RULE, "CollateralInterestCalculationParameters", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(CollateralInterestCalculationParameters collateralInterestCalculationParameters) {
			try {
				if (notEqual(MapperS.of(collateralInterestCalculationParameters).<CompoundingTypeEnum>map("getCompoundingType", _collateralInterestCalculationParameters -> _collateralInterestCalculationParameters.getCompoundingType()), MapperS.of(CompoundingTypeEnum.BUSINESS), CardinalityOperator.Any).getOrDefault(false)) {
					return notExists(MapperS.of(collateralInterestCalculationParameters).<BusinessCenterEnum>mapC("getCompoundingBusinessCenter", _collateralInterestCalculationParameters -> _collateralInterestCalculationParameters.getCompoundingBusinessCenter()));
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements CollateralInterestCalculationParametersCompoundingBC2 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, CollateralInterestCalculationParameters collateralInterestCalculationParameters) {
			return Collections.emptyList();
		}
	}
}
