package cdm.product.common.schedule;

import cdm.product.common.schedule.WeightedAveragingObservation;
import cdm.product.common.schedule.WeightedAveragingObservation.WeightedAveragingObservationBuilder;
import cdm.product.common.schedule.WeightedAveragingObservation.WeightedAveragingObservationBuilderImpl;
import cdm.product.common.schedule.WeightedAveragingObservation.WeightedAveragingObservationImpl;
import cdm.product.common.schedule.meta.WeightedAveragingObservationMeta;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * A single weighted averaging observation.
 * @version 5.24.0
 */
@RosettaDataType(value="WeightedAveragingObservation", builder=WeightedAveragingObservation.WeightedAveragingObservationBuilderImpl.class, version="5.24.0")
@RuneDataType(value="WeightedAveragingObservation", model="cdm", builder=WeightedAveragingObservation.WeightedAveragingObservationBuilderImpl.class, version="5.24.0")
public interface WeightedAveragingObservation extends RosettaModelObject {

	WeightedAveragingObservationMeta metaData = new WeightedAveragingObservationMeta();

	/*********************** Getter Methods  ***********************/
	/**
	 * Observation date time, which should be used when literal observation dates are required. The CDM specifies that the zoned date time is to be expressed in accordance with ISO 8601, either as UTC as an offset to UTC.
	 */
	ZonedDateTime getDateTime();
	/**
	 * Observation number, which should be unique, within a series generated by a date schedule.
	 */
	Integer getObservationNumber();
	/**
	 * Observation weight, which is used as a multiplier for the observation value.
	 */
	BigDecimal getWeight();

	/*********************** Build Methods  ***********************/
	WeightedAveragingObservation build();
	
	WeightedAveragingObservation.WeightedAveragingObservationBuilder toBuilder();
	
	static WeightedAveragingObservation.WeightedAveragingObservationBuilder builder() {
		return new WeightedAveragingObservation.WeightedAveragingObservationBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends WeightedAveragingObservation> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends WeightedAveragingObservation> getType() {
		return WeightedAveragingObservation.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("dateTime"), ZonedDateTime.class, getDateTime(), this);
		processor.processBasic(path.newSubPath("observationNumber"), Integer.class, getObservationNumber(), this);
		processor.processBasic(path.newSubPath("weight"), BigDecimal.class, getWeight(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface WeightedAveragingObservationBuilder extends WeightedAveragingObservation, RosettaModelObjectBuilder {
		WeightedAveragingObservation.WeightedAveragingObservationBuilder setDateTime(ZonedDateTime dateTime);
		WeightedAveragingObservation.WeightedAveragingObservationBuilder setObservationNumber(Integer observationNumber);
		WeightedAveragingObservation.WeightedAveragingObservationBuilder setWeight(BigDecimal weight);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("dateTime"), ZonedDateTime.class, getDateTime(), this);
			processor.processBasic(path.newSubPath("observationNumber"), Integer.class, getObservationNumber(), this);
			processor.processBasic(path.newSubPath("weight"), BigDecimal.class, getWeight(), this);
		}
		

		WeightedAveragingObservation.WeightedAveragingObservationBuilder prune();
	}

	/*********************** Immutable Implementation of WeightedAveragingObservation  ***********************/
	class WeightedAveragingObservationImpl implements WeightedAveragingObservation {
		private final ZonedDateTime dateTime;
		private final Integer observationNumber;
		private final BigDecimal weight;
		
		protected WeightedAveragingObservationImpl(WeightedAveragingObservation.WeightedAveragingObservationBuilder builder) {
			this.dateTime = builder.getDateTime();
			this.observationNumber = builder.getObservationNumber();
			this.weight = builder.getWeight();
		}
		
		@Override
		@RosettaAttribute("dateTime")
		@RuneAttribute("dateTime")
		public ZonedDateTime getDateTime() {
			return dateTime;
		}
		
		@Override
		@RosettaAttribute("observationNumber")
		@RuneAttribute("observationNumber")
		public Integer getObservationNumber() {
			return observationNumber;
		}
		
		@Override
		@RosettaAttribute("weight")
		@RuneAttribute("weight")
		public BigDecimal getWeight() {
			return weight;
		}
		
		@Override
		public WeightedAveragingObservation build() {
			return this;
		}
		
		@Override
		public WeightedAveragingObservation.WeightedAveragingObservationBuilder toBuilder() {
			WeightedAveragingObservation.WeightedAveragingObservationBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(WeightedAveragingObservation.WeightedAveragingObservationBuilder builder) {
			ofNullable(getDateTime()).ifPresent(builder::setDateTime);
			ofNullable(getObservationNumber()).ifPresent(builder::setObservationNumber);
			ofNullable(getWeight()).ifPresent(builder::setWeight);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			WeightedAveragingObservation _that = getType().cast(o);
		
			if (!Objects.equals(dateTime, _that.getDateTime())) return false;
			if (!Objects.equals(observationNumber, _that.getObservationNumber())) return false;
			if (!Objects.equals(weight, _that.getWeight())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (dateTime != null ? dateTime.hashCode() : 0);
			_result = 31 * _result + (observationNumber != null ? observationNumber.hashCode() : 0);
			_result = 31 * _result + (weight != null ? weight.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "WeightedAveragingObservation {" +
				"dateTime=" + this.dateTime + ", " +
				"observationNumber=" + this.observationNumber + ", " +
				"weight=" + this.weight +
			'}';
		}
	}

	/*********************** Builder Implementation of WeightedAveragingObservation  ***********************/
	class WeightedAveragingObservationBuilderImpl implements WeightedAveragingObservation.WeightedAveragingObservationBuilder {
	
		protected ZonedDateTime dateTime;
		protected Integer observationNumber;
		protected BigDecimal weight;
		
		@Override
		@RosettaAttribute("dateTime")
		@RuneAttribute("dateTime")
		public ZonedDateTime getDateTime() {
			return dateTime;
		}
		
		@Override
		@RosettaAttribute("observationNumber")
		@RuneAttribute("observationNumber")
		public Integer getObservationNumber() {
			return observationNumber;
		}
		
		@Override
		@RosettaAttribute("weight")
		@RuneAttribute("weight")
		public BigDecimal getWeight() {
			return weight;
		}
		
		@Override
		@RosettaAttribute("dateTime")
		@RuneAttribute("dateTime")
		public WeightedAveragingObservation.WeightedAveragingObservationBuilder setDateTime(ZonedDateTime _dateTime) {
			this.dateTime = _dateTime == null ? null : _dateTime;
			return this;
		}
		
		@Override
		@RosettaAttribute("observationNumber")
		@RuneAttribute("observationNumber")
		public WeightedAveragingObservation.WeightedAveragingObservationBuilder setObservationNumber(Integer _observationNumber) {
			this.observationNumber = _observationNumber == null ? null : _observationNumber;
			return this;
		}
		
		@Override
		@RosettaAttribute("weight")
		@RuneAttribute("weight")
		public WeightedAveragingObservation.WeightedAveragingObservationBuilder setWeight(BigDecimal _weight) {
			this.weight = _weight == null ? null : _weight;
			return this;
		}
		
		@Override
		public WeightedAveragingObservation build() {
			return new WeightedAveragingObservation.WeightedAveragingObservationImpl(this);
		}
		
		@Override
		public WeightedAveragingObservation.WeightedAveragingObservationBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public WeightedAveragingObservation.WeightedAveragingObservationBuilder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getDateTime()!=null) return true;
			if (getObservationNumber()!=null) return true;
			if (getWeight()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public WeightedAveragingObservation.WeightedAveragingObservationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			WeightedAveragingObservation.WeightedAveragingObservationBuilder o = (WeightedAveragingObservation.WeightedAveragingObservationBuilder) other;
			
			
			merger.mergeBasic(getDateTime(), o.getDateTime(), this::setDateTime);
			merger.mergeBasic(getObservationNumber(), o.getObservationNumber(), this::setObservationNumber);
			merger.mergeBasic(getWeight(), o.getWeight(), this::setWeight);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			WeightedAveragingObservation _that = getType().cast(o);
		
			if (!Objects.equals(dateTime, _that.getDateTime())) return false;
			if (!Objects.equals(observationNumber, _that.getObservationNumber())) return false;
			if (!Objects.equals(weight, _that.getWeight())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (dateTime != null ? dateTime.hashCode() : 0);
			_result = 31 * _result + (observationNumber != null ? observationNumber.hashCode() : 0);
			_result = 31 * _result + (weight != null ? weight.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "WeightedAveragingObservationBuilder {" +
				"dateTime=" + this.dateTime + ", " +
				"observationNumber=" + this.observationNumber + ", " +
				"weight=" + this.weight +
			'}';
		}
	}
}
