package cdm.product.common.schedule.meta;

import cdm.product.common.schedule.CalculationPeriod;
import cdm.product.common.schedule.validation.CalculationPeriodTypeFormatValidator;
import cdm.product.common.schedule.validation.CalculationPeriodValidator;
import cdm.product.common.schedule.validation.datarule.CalculationPeriodEndDateChoice;
import cdm.product.common.schedule.validation.datarule.CalculationPeriodNotionalChoice;
import cdm.product.common.schedule.validation.datarule.CalculationPeriodRateChoice;
import cdm.product.common.schedule.validation.datarule.CalculationPeriodStartDateChoice;
import cdm.product.common.schedule.validation.exists.CalculationPeriodOnlyExistsValidator;
import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version 5.24.0
 */
@RosettaMeta(model=CalculationPeriod.class)
public class CalculationPeriodMeta implements RosettaMetaData<CalculationPeriod> {

	@Override
	public List<Validator<? super CalculationPeriod>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
			factory.<CalculationPeriod>create(CalculationPeriodNotionalChoice.class),
			factory.<CalculationPeriod>create(CalculationPeriodRateChoice.class),
			factory.<CalculationPeriod>create(CalculationPeriodStartDateChoice.class),
			factory.<CalculationPeriod>create(CalculationPeriodEndDateChoice.class)
		);
	}
	
	@Override
	public List<Function<? super CalculationPeriod, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}
	
	@Override
	public Validator<? super CalculationPeriod> validator(ValidatorFactory factory) {
		return factory.<CalculationPeriod>create(CalculationPeriodValidator.class);
	}

	@Override
	public Validator<? super CalculationPeriod> typeFormatValidator(ValidatorFactory factory) {
		return factory.<CalculationPeriod>create(CalculationPeriodTypeFormatValidator.class);
	}

	@Deprecated
	@Override
	public Validator<? super CalculationPeriod> validator() {
		return new CalculationPeriodValidator();
	}

	@Deprecated
	@Override
	public Validator<? super CalculationPeriod> typeFormatValidator() {
		return new CalculationPeriodTypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super CalculationPeriod, Set<String>> onlyExistsValidator() {
		return new CalculationPeriodOnlyExistsValidator();
	}
}
