package cdm.product.common.schedule.meta;

import cdm.product.common.schedule.ObservationSchedule;
import cdm.product.common.schedule.validation.ObservationScheduleTypeFormatValidator;
import cdm.product.common.schedule.validation.ObservationScheduleValidator;
import cdm.product.common.schedule.validation.datarule.ObservationScheduleAdjustedDate;
import cdm.product.common.schedule.validation.exists.ObservationScheduleOnlyExistsValidator;
import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version 5.24.0
 */
@RosettaMeta(model=ObservationSchedule.class)
public class ObservationScheduleMeta implements RosettaMetaData<ObservationSchedule> {

	@Override
	public List<Validator<? super ObservationSchedule>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
			factory.<ObservationSchedule>create(ObservationScheduleAdjustedDate.class)
		);
	}
	
	@Override
	public List<Function<? super ObservationSchedule, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}
	
	@Override
	public Validator<? super ObservationSchedule> validator(ValidatorFactory factory) {
		return factory.<ObservationSchedule>create(ObservationScheduleValidator.class);
	}

	@Override
	public Validator<? super ObservationSchedule> typeFormatValidator(ValidatorFactory factory) {
		return factory.<ObservationSchedule>create(ObservationScheduleTypeFormatValidator.class);
	}

	@Deprecated
	@Override
	public Validator<? super ObservationSchedule> validator() {
		return new ObservationScheduleValidator();
	}

	@Deprecated
	@Override
	public Validator<? super ObservationSchedule> typeFormatValidator() {
		return new ObservationScheduleTypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super ObservationSchedule, Set<String>> onlyExistsValidator() {
		return new ObservationScheduleOnlyExistsValidator();
	}
}
