package cdm.product.common.schedule.validation.datarule;

import cdm.base.datetime.BusinessCenterTime;
import cdm.observable.common.TimeTypeEnum;
import cdm.product.common.schedule.ObservationTerms;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.24.0
 */
@RosettaDataRule("ObservationTermsPricingTime")
@ImplementedBy(ObservationTermsPricingTime.Default.class)
public interface ObservationTermsPricingTime extends Validator<ObservationTerms> {
	
	String NAME = "ObservationTermsPricingTime";
	String DEFINITION = "if pricingTimeType = TimeTypeEnum -> SpecificTime then pricingTime exists";
	
	class Default implements ObservationTermsPricingTime {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ObservationTerms observationTerms) {
			ComparisonResult result = executeDataRule(observationTerms);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "ObservationTerms", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationType.DATA_RULE, "ObservationTerms", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(ObservationTerms observationTerms) {
			try {
				if (areEqual(MapperS.of(observationTerms).<TimeTypeEnum>map("getPricingTimeType", _observationTerms -> _observationTerms.getPricingTimeType()), MapperS.of(TimeTypeEnum.SPECIFIC_TIME), CardinalityOperator.All).getOrDefault(false)) {
					return exists(MapperS.of(observationTerms).<BusinessCenterTime>map("getPricingTime", _observationTerms -> _observationTerms.getPricingTime()));
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements ObservationTermsPricingTime {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, ObservationTerms observationTerms) {
			return Collections.emptyList();
		}
	}
}
