package cdm.product.common.settlement.validation.datarule;

import cdm.base.staticdata.party.BuyerSeller;
import cdm.product.common.settlement.PriceQuantity;
import cdm.product.common.settlement.SettlementTerms;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.24.0
 */
@RosettaDataRule("PriceQuantityActualSettlement")
@ImplementedBy(PriceQuantityActualSettlement.Default.class)
public interface PriceQuantityActualSettlement extends Validator<PriceQuantity> {
	
	String NAME = "PriceQuantityActualSettlement";
	String DEFINITION = "if buyerSeller exists then settlementTerms exists";
	
	class Default implements PriceQuantityActualSettlement {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, PriceQuantity priceQuantity) {
			ComparisonResult result = executeDataRule(priceQuantity);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "PriceQuantity", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationType.DATA_RULE, "PriceQuantity", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(PriceQuantity priceQuantity) {
			try {
				if (exists(MapperS.of(priceQuantity).<BuyerSeller>map("getBuyerSeller", _priceQuantity -> _priceQuantity.getBuyerSeller())).getOrDefault(false)) {
					return exists(MapperS.of(priceQuantity).<SettlementTerms>map("getSettlementTerms", _priceQuantity -> _priceQuantity.getSettlementTerms()));
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements PriceQuantityActualSettlement {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, PriceQuantity priceQuantity) {
			return Collections.emptyList();
		}
	}
}
