package cdm.product.common.settlement.validation.datarule;

import cdm.product.common.settlement.PriceQuantity;
import cdm.product.common.settlement.functions.RateOptionObservableCondition;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;


/**
 * @version 5.24.0
 */
@RosettaDataRule("PriceQuantityRateOptionObservable")
@ImplementedBy(PriceQuantityRateOptionObservable.Default.class)
public interface PriceQuantityRateOptionObservable extends Validator<PriceQuantity> {
	
	String NAME = "PriceQuantityRateOptionObservable";
	String DEFINITION = "RateOptionObservableCondition";
	
	class Default implements PriceQuantityRateOptionObservable {
	
		@Inject protected RateOptionObservableCondition rateOptionObservableCondition;
		
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, PriceQuantity priceQuantity) {
			ComparisonResult result = executeDataRule(priceQuantity);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "PriceQuantity", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationType.DATA_RULE, "PriceQuantity", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(PriceQuantity priceQuantity) {
			try {
				return ComparisonResult.of(MapperS.of(rateOptionObservableCondition.evaluate(priceQuantity)));
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements PriceQuantityRateOptionObservable {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, PriceQuantity priceQuantity) {
			return Collections.emptyList();
		}
	}
}
