package cdm.product.qualification.functions;

import cdm.product.template.AmericanExercise;
import cdm.product.template.Basket;
import cdm.product.template.BermudaExercise;
import cdm.product.template.Composite;
import cdm.product.template.EconomicTerms;
import cdm.product.template.EuropeanExercise;
import cdm.product.template.FxFeature;
import cdm.product.template.OptionExercise;
import cdm.product.template.OptionFeature;
import cdm.product.template.OptionPayout;
import cdm.product.template.OptionStyle;
import cdm.product.template.Payout;
import cdm.product.template.Product;
import cdm.product.template.Quanto;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.IQualifyFunctionExtension;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Arrays;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(Qualify_EquityOption_PriceReturnBasicPerformance_Basket.Qualify_EquityOption_PriceReturnBasicPerformance_BasketDefault.class)
public abstract class Qualify_EquityOption_PriceReturnBasicPerformance_Basket implements RosettaFunction,IQualifyFunctionExtension<EconomicTerms> {
	
	// RosettaFunction dependencies
	//
	@Inject protected Qualify_AssetClass_Equity qualify_AssetClass_Equity;

	/**
	* @param economicTerms 
	* @return is_product 
	*/
	@Override
	public Boolean evaluate(EconomicTerms economicTerms) {
		Boolean is_product = doEvaluate(economicTerms);
		
		return is_product;
	}

	protected abstract Boolean doEvaluate(EconomicTerms economicTerms);

	protected abstract MapperS<? extends OptionPayout> optionPayout(EconomicTerms economicTerms);

	public static class Qualify_EquityOption_PriceReturnBasicPerformance_BasketDefault extends Qualify_EquityOption_PriceReturnBasicPerformance_Basket {
		@Override
		protected Boolean doEvaluate(EconomicTerms economicTerms) {
			Boolean is_product = null;
			return assignOutput(is_product, economicTerms);
		}
		
		protected Boolean assignOutput(Boolean is_product, EconomicTerms economicTerms) {
			final ComparisonResult ifThenElseResult;
			if (exists(MapperS.of(economicTerms).<Boolean>map("getNonStandardisedTerms", _economicTerms -> _economicTerms.getNonStandardisedTerms())).getOrDefault(false)) {
				ifThenElseResult = areEqual(MapperS.of(economicTerms).<Boolean>map("getNonStandardisedTerms", _economicTerms -> _economicTerms.getNonStandardisedTerms()), MapperS.of(false), CardinalityOperator.All);
			} else {
				ifThenElseResult = ComparisonResult.of(MapperS.of(true));
			}
			is_product = ComparisonResult.of(MapperS.of(qualify_AssetClass_Equity.evaluate(economicTerms))).and(onlyExists(MapperS.of(economicTerms).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()), Arrays.asList("interestRatePayout", "creditDefaultPayout", "optionPayout", "commodityPayout", "forwardPayout", "fixedPricePayout", "securityPayout", "cashflow", "performancePayout", "assetPayout"), Arrays.asList("optionPayout"))).and(exists(optionPayout(economicTerms).<Product>map("getUnderlier", _optionPayout -> _optionPayout.getUnderlier()).<Basket>map("getBasket", product -> product.getBasket()))).and(exists(optionPayout(economicTerms).<OptionExercise>map("getExerciseTerms", _optionPayout -> _optionPayout.getExerciseTerms()).<OptionStyle>map("getOptionStyle", optionExercise -> optionExercise.getOptionStyle()).<AmericanExercise>map("getAmericanExercise", optionStyle -> optionStyle.getAmericanExercise())).or(exists(optionPayout(economicTerms).<OptionExercise>map("getExerciseTerms", _optionPayout -> _optionPayout.getExerciseTerms()).<OptionStyle>map("getOptionStyle", optionExercise -> optionExercise.getOptionStyle()).<EuropeanExercise>map("getEuropeanExercise", optionStyle -> optionStyle.getEuropeanExercise()))).or(exists(optionPayout(economicTerms).<OptionExercise>map("getExerciseTerms", _optionPayout -> _optionPayout.getExerciseTerms()).<OptionStyle>map("getOptionStyle", optionExercise -> optionExercise.getOptionStyle()).<BermudaExercise>map("getBermudaExercise", optionStyle -> optionStyle.getBermudaExercise())))).and(notExists(optionPayout(economicTerms).<OptionFeature>map("getFeature", _optionPayout -> _optionPayout.getFeature())).or(onlyExists(optionPayout(economicTerms).<OptionFeature>map("getFeature", _optionPayout -> _optionPayout.getFeature()), Arrays.asList("fxFeature", "strategyFeature", "averagingFeature", "barrier", "knock", "passThrough"), Arrays.asList("averagingFeature"))).or(exists(MapperS.of(optionPayout(economicTerms).<OptionFeature>map("getFeature", _optionPayout -> _optionPayout.getFeature()).<FxFeature>mapC("getFxFeature", optionFeature -> optionFeature.getFxFeature()).get()).<Quanto>map("getQuanto", fxFeature -> fxFeature.getQuanto()))).or(exists(MapperS.of(optionPayout(economicTerms).<OptionFeature>map("getFeature", _optionPayout -> _optionPayout.getFeature()).<FxFeature>mapC("getFxFeature", optionFeature -> optionFeature.getFxFeature()).get()).<Composite>map("getComposite", fxFeature -> fxFeature.getComposite())))).and(ifThenElseResult).get();
			
			return is_product;
		}
		
		@Override
		protected MapperS<? extends OptionPayout> optionPayout(EconomicTerms economicTerms) {
			return MapperS.of(MapperS.of(economicTerms).<Payout>map("getPayout", _economicTerms -> _economicTerms.getPayout()).<OptionPayout>mapC("getOptionPayout", payout -> payout.getOptionPayout()).get());
		}
	}
		
		@Override
		public String getNamePrefix() {
			return "Qualify";
		}
}
