package cdm.product.template.functions;

import cdm.base.datetime.BusinessCenterTime;
import cdm.product.template.ExpirationTimeTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(ExpirationTimeType.ExpirationTimeTypeDefault.class)
public abstract class ExpirationTimeType implements RosettaFunction {

	/**
	* @param expirationTime 
	* @param expirationTimeType 
	* @return success 
	*/
	public Boolean evaluate(BusinessCenterTime expirationTime, ExpirationTimeTypeEnum expirationTimeType) {
		Boolean success = doEvaluate(expirationTime, expirationTimeType);
		
		return success;
	}

	protected abstract Boolean doEvaluate(BusinessCenterTime expirationTime, ExpirationTimeTypeEnum expirationTimeType);

	public static class ExpirationTimeTypeDefault extends ExpirationTimeType {
		@Override
		protected Boolean doEvaluate(BusinessCenterTime expirationTime, ExpirationTimeTypeEnum expirationTimeType) {
			Boolean success = null;
			return assignOutput(success, expirationTime, expirationTimeType);
		}
		
		protected Boolean assignOutput(Boolean success, BusinessCenterTime expirationTime, ExpirationTimeTypeEnum expirationTimeType) {
			final ComparisonResult ifThenElseResult0;
			if (exists(MapperS.of(expirationTime)).and(exists(MapperS.of(expirationTimeType))).getOrDefault(false)) {
				ifThenElseResult0 = areEqual(MapperS.of(expirationTimeType), MapperS.of(ExpirationTimeTypeEnum.SPECIFIC_TIME), CardinalityOperator.All);
			} else {
				ifThenElseResult0 = ComparisonResult.successEmptyOperand("");
			}
			final ComparisonResult ifThenElseResult1;
			if (exists(MapperS.of(expirationTimeType)).and(areEqual(MapperS.of(expirationTimeType), MapperS.of(ExpirationTimeTypeEnum.SPECIFIC_TIME), CardinalityOperator.All)).getOrDefault(false)) {
				ifThenElseResult1 = exists(MapperS.of(expirationTime));
			} else {
				ifThenElseResult1 = ComparisonResult.successEmptyOperand("");
			}
			success = ifThenElseResult0.and(ifThenElseResult1).get();
			
			return success;
		}
	}
}
