package cdm.product.template.meta;

import cdm.product.template.ExerciseProcedure;
import cdm.product.template.validation.ExerciseProcedureTypeFormatValidator;
import cdm.product.template.validation.ExerciseProcedureValidator;
import cdm.product.template.validation.datarule.ExerciseProcedureExerciseProcedureChoice;
import cdm.product.template.validation.exists.ExerciseProcedureOnlyExistsValidator;
import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version 5.24.0
 */
@RosettaMeta(model=ExerciseProcedure.class)
public class ExerciseProcedureMeta implements RosettaMetaData<ExerciseProcedure> {

	@Override
	public List<Validator<? super ExerciseProcedure>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
			factory.<ExerciseProcedure>create(ExerciseProcedureExerciseProcedureChoice.class)
		);
	}
	
	@Override
	public List<Function<? super ExerciseProcedure, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}
	
	@Override
	public Validator<? super ExerciseProcedure> validator(ValidatorFactory factory) {
		return factory.<ExerciseProcedure>create(ExerciseProcedureValidator.class);
	}

	@Override
	public Validator<? super ExerciseProcedure> typeFormatValidator(ValidatorFactory factory) {
		return factory.<ExerciseProcedure>create(ExerciseProcedureTypeFormatValidator.class);
	}

	@Deprecated
	@Override
	public Validator<? super ExerciseProcedure> validator() {
		return new ExerciseProcedureValidator();
	}

	@Deprecated
	@Override
	public Validator<? super ExerciseProcedure> typeFormatValidator() {
		return new ExerciseProcedureTypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super ExerciseProcedure, Set<String>> onlyExistsValidator() {
		return new ExerciseProcedureOnlyExistsValidator();
	}
}
