package cdm.product.template.meta;

import cdm.product.template.ForwardPayout;
import cdm.product.template.validation.ForwardPayoutTypeFormatValidator;
import cdm.product.template.validation.ForwardPayoutValidator;
import cdm.product.template.validation.datarule.ForwardPayoutDeliveryCapacity;
import cdm.product.template.validation.datarule.ForwardPayoutFxSettlement;
import cdm.product.template.validation.datarule.ForwardPayoutPriceTimeIntervalQuantity;
import cdm.product.template.validation.datarule.ForwardPayoutSettlementDate;
import cdm.product.template.validation.datarule.ForwardPayoutSettlementTerms;
import cdm.product.template.validation.exists.ForwardPayoutOnlyExistsValidator;
import com.rosetta.model.lib.annotations.RosettaMeta;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.qualify.QualifyFunctionFactory;
import com.rosetta.model.lib.qualify.QualifyResult;
import com.rosetta.model.lib.validation.Validator;
import com.rosetta.model.lib.validation.ValidatorFactory;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Function;


/**
 * @version 5.24.0
 */
@RosettaMeta(model=ForwardPayout.class)
public class ForwardPayoutMeta implements RosettaMetaData<ForwardPayout> {

	@Override
	public List<Validator<? super ForwardPayout>> dataRules(ValidatorFactory factory) {
		return Arrays.asList(
			factory.<ForwardPayout>create(ForwardPayoutSettlementTerms.class),
			factory.<ForwardPayout>create(ForwardPayoutSettlementDate.class),
			factory.<ForwardPayout>create(ForwardPayoutFxSettlement.class),
			factory.<ForwardPayout>create(ForwardPayoutDeliveryCapacity.class),
			factory.<ForwardPayout>create(ForwardPayoutPriceTimeIntervalQuantity.class)
		);
	}
	
	@Override
	public List<Function<? super ForwardPayout, QualifyResult>> getQualifyFunctions(QualifyFunctionFactory factory) {
		return Collections.emptyList();
	}
	
	@Override
	public Validator<? super ForwardPayout> validator(ValidatorFactory factory) {
		return factory.<ForwardPayout>create(ForwardPayoutValidator.class);
	}

	@Override
	public Validator<? super ForwardPayout> typeFormatValidator(ValidatorFactory factory) {
		return factory.<ForwardPayout>create(ForwardPayoutTypeFormatValidator.class);
	}

	@Deprecated
	@Override
	public Validator<? super ForwardPayout> validator() {
		return new ForwardPayoutValidator();
	}

	@Deprecated
	@Override
	public Validator<? super ForwardPayout> typeFormatValidator() {
		return new ForwardPayoutTypeFormatValidator();
	}
	
	@Override
	public ValidatorWithArg<? super ForwardPayout, Set<String>> onlyExistsValidator() {
		return new ForwardPayoutOnlyExistsValidator();
	}
}
