package cdm.product.template.metafields;

import cdm.product.template.FixedPricePayout;
import cdm.product.template.FixedPricePayout.FixedPricePayoutBuilder;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.annotations.RuneMetaType;
import com.rosetta.model.lib.meta.BasicRosettaMetaData;
import com.rosetta.model.lib.meta.Reference;
import com.rosetta.model.lib.meta.Reference.ReferenceBuilder;
import com.rosetta.model.lib.meta.ReferenceWithMeta;
import com.rosetta.model.lib.meta.ReferenceWithMeta.ReferenceWithMetaBuilder;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import java.util.Objects;

import static java.util.Optional.ofNullable;

@RosettaDataType(value="ReferenceWithMetaFixedPricePayout", builder=ReferenceWithMetaFixedPricePayout.ReferenceWithMetaFixedPricePayoutBuilderImpl.class, version="0.0.0")
@RuneDataType(value="ReferenceWithMetaFixedPricePayout", model="cdm", builder=ReferenceWithMetaFixedPricePayout.ReferenceWithMetaFixedPricePayoutBuilderImpl.class, version="0.0.0")
public interface ReferenceWithMetaFixedPricePayout extends RosettaModelObject, ReferenceWithMeta<FixedPricePayout> {

	ReferenceWithMetaFixedPricePayoutMeta metaData = new ReferenceWithMetaFixedPricePayoutMeta();

	/*********************** Getter Methods  ***********************/
	FixedPricePayout getValue();
	String getGlobalReference();
	String getExternalReference();
	Reference getReference();

	/*********************** Build Methods  ***********************/
	ReferenceWithMetaFixedPricePayout build();
	
	ReferenceWithMetaFixedPricePayout.ReferenceWithMetaFixedPricePayoutBuilder toBuilder();
	
	static ReferenceWithMetaFixedPricePayout.ReferenceWithMetaFixedPricePayoutBuilder builder() {
		return new ReferenceWithMetaFixedPricePayout.ReferenceWithMetaFixedPricePayoutBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends ReferenceWithMetaFixedPricePayout> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends ReferenceWithMetaFixedPricePayout> getType() {
		return ReferenceWithMetaFixedPricePayout.class;
	}
	
	@Override
	default Class<FixedPricePayout> getValueType() {
		return FixedPricePayout.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processRosetta(path.newSubPath("value"), processor, FixedPricePayout.class, getValue());
		processor.processBasic(path.newSubPath("globalReference"), String.class, getGlobalReference(), this, AttributeMeta.META);
		processor.processBasic(path.newSubPath("externalReference"), String.class, getExternalReference(), this, AttributeMeta.META);
		processRosetta(path.newSubPath("reference"), processor, Reference.class, getReference());
	}
	

	/*********************** Builder Interface  ***********************/
	interface ReferenceWithMetaFixedPricePayoutBuilder extends ReferenceWithMetaFixedPricePayout, RosettaModelObjectBuilder, ReferenceWithMeta.ReferenceWithMetaBuilder<FixedPricePayout> {
		FixedPricePayout.FixedPricePayoutBuilder getOrCreateValue();
		@Override
		FixedPricePayout.FixedPricePayoutBuilder getValue();
		Reference.ReferenceBuilder getOrCreateReference();
		@Override
		Reference.ReferenceBuilder getReference();
		ReferenceWithMetaFixedPricePayout.ReferenceWithMetaFixedPricePayoutBuilder setValue(FixedPricePayout value);
		ReferenceWithMetaFixedPricePayout.ReferenceWithMetaFixedPricePayoutBuilder setGlobalReference(String globalReference);
		ReferenceWithMetaFixedPricePayout.ReferenceWithMetaFixedPricePayoutBuilder setExternalReference(String externalReference);
		ReferenceWithMetaFixedPricePayout.ReferenceWithMetaFixedPricePayoutBuilder setReference(Reference reference);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processRosetta(path.newSubPath("value"), processor, FixedPricePayout.FixedPricePayoutBuilder.class, getValue());
			processor.processBasic(path.newSubPath("globalReference"), String.class, getGlobalReference(), this, AttributeMeta.META);
			processor.processBasic(path.newSubPath("externalReference"), String.class, getExternalReference(), this, AttributeMeta.META);
			processRosetta(path.newSubPath("reference"), processor, Reference.ReferenceBuilder.class, getReference());
		}
		

		ReferenceWithMetaFixedPricePayout.ReferenceWithMetaFixedPricePayoutBuilder prune();
	}

	/*********************** Immutable Implementation of ReferenceWithMetaFixedPricePayout  ***********************/
	class ReferenceWithMetaFixedPricePayoutImpl implements ReferenceWithMetaFixedPricePayout {
		private final FixedPricePayout value;
		private final String globalReference;
		private final String externalReference;
		private final Reference reference;
		
		protected ReferenceWithMetaFixedPricePayoutImpl(ReferenceWithMetaFixedPricePayout.ReferenceWithMetaFixedPricePayoutBuilder builder) {
			this.value = ofNullable(builder.getValue()).map(f->f.build()).orElse(null);
			this.globalReference = builder.getGlobalReference();
			this.externalReference = builder.getExternalReference();
			this.reference = ofNullable(builder.getReference()).map(f->f.build()).orElse(null);
		}
		
		@Override
		@RosettaAttribute("value")
		@RuneAttribute("@data")
		@RuneMetaType
		public FixedPricePayout getValue() {
			return value;
		}
		
		@Override
		@RosettaAttribute("globalReference")
		@RuneAttribute("@ref")
		public String getGlobalReference() {
			return globalReference;
		}
		
		@Override
		@RosettaAttribute("externalReference")
		@RuneAttribute("@ref:external")
		public String getExternalReference() {
			return externalReference;
		}
		
		@Override
		@RosettaAttribute("address")
		@RuneAttribute("@ref:scoped")
		@RuneMetaType
		public Reference getReference() {
			return reference;
		}
		
		@Override
		public ReferenceWithMetaFixedPricePayout build() {
			return this;
		}
		
		@Override
		public ReferenceWithMetaFixedPricePayout.ReferenceWithMetaFixedPricePayoutBuilder toBuilder() {
			ReferenceWithMetaFixedPricePayout.ReferenceWithMetaFixedPricePayoutBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(ReferenceWithMetaFixedPricePayout.ReferenceWithMetaFixedPricePayoutBuilder builder) {
			ofNullable(getValue()).ifPresent(builder::setValue);
			ofNullable(getGlobalReference()).ifPresent(builder::setGlobalReference);
			ofNullable(getExternalReference()).ifPresent(builder::setExternalReference);
			ofNullable(getReference()).ifPresent(builder::setReference);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			ReferenceWithMetaFixedPricePayout _that = getType().cast(o);
		
			if (!Objects.equals(value, _that.getValue())) return false;
			if (!Objects.equals(globalReference, _that.getGlobalReference())) return false;
			if (!Objects.equals(externalReference, _that.getExternalReference())) return false;
			if (!Objects.equals(reference, _that.getReference())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (value != null ? value.hashCode() : 0);
			_result = 31 * _result + (globalReference != null ? globalReference.hashCode() : 0);
			_result = 31 * _result + (externalReference != null ? externalReference.hashCode() : 0);
			_result = 31 * _result + (reference != null ? reference.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "ReferenceWithMetaFixedPricePayout {" +
				"value=" + this.value + ", " +
				"globalReference=" + this.globalReference + ", " +
				"externalReference=" + this.externalReference + ", " +
				"reference=" + this.reference +
			'}';
		}
	}

	/*********************** Builder Implementation of ReferenceWithMetaFixedPricePayout  ***********************/
	class ReferenceWithMetaFixedPricePayoutBuilderImpl implements ReferenceWithMetaFixedPricePayout.ReferenceWithMetaFixedPricePayoutBuilder {
	
		protected FixedPricePayout.FixedPricePayoutBuilder value;
		protected String globalReference;
		protected String externalReference;
		protected Reference.ReferenceBuilder reference;
		
		@Override
		@RosettaAttribute("value")
		@RuneAttribute("@data")
		@RuneMetaType
		public FixedPricePayout.FixedPricePayoutBuilder getValue() {
			return value;
		}
		
		@Override
		public FixedPricePayout.FixedPricePayoutBuilder getOrCreateValue() {
			FixedPricePayout.FixedPricePayoutBuilder result;
			if (value!=null) {
				result = value;
			}
			else {
				result = value = FixedPricePayout.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("globalReference")
		@RuneAttribute("@ref")
		public String getGlobalReference() {
			return globalReference;
		}
		
		@Override
		@RosettaAttribute("externalReference")
		@RuneAttribute("@ref:external")
		public String getExternalReference() {
			return externalReference;
		}
		
		@Override
		@RosettaAttribute("address")
		@RuneAttribute("@ref:scoped")
		@RuneMetaType
		public Reference.ReferenceBuilder getReference() {
			return reference;
		}
		
		@Override
		public Reference.ReferenceBuilder getOrCreateReference() {
			Reference.ReferenceBuilder result;
			if (reference!=null) {
				result = reference;
			}
			else {
				result = reference = Reference.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("value")
		@RuneAttribute("@data")
		@RuneMetaType
		public ReferenceWithMetaFixedPricePayout.ReferenceWithMetaFixedPricePayoutBuilder setValue(FixedPricePayout _value) {
			this.value = _value == null ? null : _value.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("globalReference")
		@RuneAttribute("@ref")
		public ReferenceWithMetaFixedPricePayout.ReferenceWithMetaFixedPricePayoutBuilder setGlobalReference(String _globalReference) {
			this.globalReference = _globalReference == null ? null : _globalReference;
			return this;
		}
		
		@Override
		@RosettaAttribute("externalReference")
		@RuneAttribute("@ref:external")
		public ReferenceWithMetaFixedPricePayout.ReferenceWithMetaFixedPricePayoutBuilder setExternalReference(String _externalReference) {
			this.externalReference = _externalReference == null ? null : _externalReference;
			return this;
		}
		
		@Override
		@RosettaAttribute("address")
		@RuneAttribute("@ref:scoped")
		@RuneMetaType
		public ReferenceWithMetaFixedPricePayout.ReferenceWithMetaFixedPricePayoutBuilder setReference(Reference _reference) {
			this.reference = _reference == null ? null : _reference.toBuilder();
			return this;
		}
		
		@Override
		public ReferenceWithMetaFixedPricePayout build() {
			return new ReferenceWithMetaFixedPricePayout.ReferenceWithMetaFixedPricePayoutImpl(this);
		}
		
		@Override
		public ReferenceWithMetaFixedPricePayout.ReferenceWithMetaFixedPricePayoutBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public ReferenceWithMetaFixedPricePayout.ReferenceWithMetaFixedPricePayoutBuilder prune() {
			if (value!=null && !value.prune().hasData()) value = null;
			if (reference!=null && !reference.prune().hasData()) reference = null;
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getValue()!=null && getValue().hasData()) return true;
			if (getGlobalReference()!=null) return true;
			if (getExternalReference()!=null) return true;
			if (getReference()!=null && getReference().hasData()) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public ReferenceWithMetaFixedPricePayout.ReferenceWithMetaFixedPricePayoutBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			ReferenceWithMetaFixedPricePayout.ReferenceWithMetaFixedPricePayoutBuilder o = (ReferenceWithMetaFixedPricePayout.ReferenceWithMetaFixedPricePayoutBuilder) other;
			
			merger.mergeRosetta(getValue(), o.getValue(), this::setValue);
			merger.mergeRosetta(getReference(), o.getReference(), this::setReference);
			
			merger.mergeBasic(getGlobalReference(), o.getGlobalReference(), this::setGlobalReference);
			merger.mergeBasic(getExternalReference(), o.getExternalReference(), this::setExternalReference);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			ReferenceWithMetaFixedPricePayout _that = getType().cast(o);
		
			if (!Objects.equals(value, _that.getValue())) return false;
			if (!Objects.equals(globalReference, _that.getGlobalReference())) return false;
			if (!Objects.equals(externalReference, _that.getExternalReference())) return false;
			if (!Objects.equals(reference, _that.getReference())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (value != null ? value.hashCode() : 0);
			_result = 31 * _result + (globalReference != null ? globalReference.hashCode() : 0);
			_result = 31 * _result + (externalReference != null ? externalReference.hashCode() : 0);
			_result = 31 * _result + (reference != null ? reference.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "ReferenceWithMetaFixedPricePayoutBuilder {" +
				"value=" + this.value + ", " +
				"globalReference=" + this.globalReference + ", " +
				"externalReference=" + this.externalReference + ", " +
				"reference=" + this.reference +
			'}';
		}
	}
}

class ReferenceWithMetaFixedPricePayoutMeta extends BasicRosettaMetaData<ReferenceWithMetaFixedPricePayout>{

}
