package cdm.product.template.util;

import cdm.base.datetime.AdjustableOrRelativeDates;
import cdm.base.datetime.BusinessCenterTime;
import cdm.product.template.AmericanExercise;
import cdm.product.template.BermudaExercise;
import cdm.product.template.EuropeanExercise;
import cdm.product.template.ExpirationTimeTypeEnum;
import cdm.product.template.OptionStyle;
import com.rosetta.model.lib.mapper.MapperS;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

public class OptionStyleDeepPathUtil {
	public AdjustableOrRelativeDates chooseRelevantUnderlyingDate(OptionStyle optionStyle) {
		final MapperS<AmericanExercise> americanExercise = MapperS.of(optionStyle).<AmericanExercise>map("getAmericanExercise", _optionStyle -> _optionStyle.getAmericanExercise());
		if (exists(americanExercise).getOrDefault(false)) {
			return americanExercise.<AdjustableOrRelativeDates>map("getRelevantUnderlyingDate", _americanExercise -> _americanExercise.getRelevantUnderlyingDate()).get();
		}
		final MapperS<BermudaExercise> bermudaExercise = MapperS.of(optionStyle).<BermudaExercise>map("getBermudaExercise", _optionStyle -> _optionStyle.getBermudaExercise());
		if (exists(bermudaExercise).getOrDefault(false)) {
			return bermudaExercise.<AdjustableOrRelativeDates>map("getRelevantUnderlyingDate", _bermudaExercise -> _bermudaExercise.getRelevantUnderlyingDate()).get();
		}
		final MapperS<EuropeanExercise> europeanExercise = MapperS.of(optionStyle).<EuropeanExercise>map("getEuropeanExercise", _optionStyle -> _optionStyle.getEuropeanExercise());
		if (exists(europeanExercise).getOrDefault(false)) {
			return europeanExercise.<AdjustableOrRelativeDates>map("getRelevantUnderlyingDate", _europeanExercise -> _europeanExercise.getRelevantUnderlyingDate()).get();
		}
		return null;
	}
	
	public BusinessCenterTime chooseEarliestExerciseTime(OptionStyle optionStyle) {
		final MapperS<AmericanExercise> americanExercise = MapperS.of(optionStyle).<AmericanExercise>map("getAmericanExercise", _optionStyle -> _optionStyle.getAmericanExercise());
		if (exists(americanExercise).getOrDefault(false)) {
			return americanExercise.<BusinessCenterTime>map("getEarliestExerciseTime", _americanExercise -> _americanExercise.getEarliestExerciseTime()).get();
		}
		final MapperS<BermudaExercise> bermudaExercise = MapperS.of(optionStyle).<BermudaExercise>map("getBermudaExercise", _optionStyle -> _optionStyle.getBermudaExercise());
		if (exists(bermudaExercise).getOrDefault(false)) {
			return bermudaExercise.<BusinessCenterTime>map("getEarliestExerciseTime", _bermudaExercise -> _bermudaExercise.getEarliestExerciseTime()).get();
		}
		final MapperS<EuropeanExercise> europeanExercise = MapperS.of(optionStyle).<EuropeanExercise>map("getEuropeanExercise", _optionStyle -> _optionStyle.getEuropeanExercise());
		if (exists(europeanExercise).getOrDefault(false)) {
			return europeanExercise.<BusinessCenterTime>map("getEarliestExerciseTime", _europeanExercise -> _europeanExercise.getEarliestExerciseTime()).get();
		}
		return null;
	}
	
	public BusinessCenterTime chooseExpirationTime(OptionStyle optionStyle) {
		final MapperS<AmericanExercise> americanExercise = MapperS.of(optionStyle).<AmericanExercise>map("getAmericanExercise", _optionStyle -> _optionStyle.getAmericanExercise());
		if (exists(americanExercise).getOrDefault(false)) {
			return americanExercise.<BusinessCenterTime>map("getExpirationTime", _americanExercise -> _americanExercise.getExpirationTime()).get();
		}
		final MapperS<BermudaExercise> bermudaExercise = MapperS.of(optionStyle).<BermudaExercise>map("getBermudaExercise", _optionStyle -> _optionStyle.getBermudaExercise());
		if (exists(bermudaExercise).getOrDefault(false)) {
			return bermudaExercise.<BusinessCenterTime>map("getExpirationTime", _bermudaExercise -> _bermudaExercise.getExpirationTime()).get();
		}
		final MapperS<EuropeanExercise> europeanExercise = MapperS.of(optionStyle).<EuropeanExercise>map("getEuropeanExercise", _optionStyle -> _optionStyle.getEuropeanExercise());
		if (exists(europeanExercise).getOrDefault(false)) {
			return europeanExercise.<BusinessCenterTime>map("getExpirationTime", _europeanExercise -> _europeanExercise.getExpirationTime()).get();
		}
		return null;
	}
	
	public ExpirationTimeTypeEnum chooseExpirationTimeType(OptionStyle optionStyle) {
		final MapperS<AmericanExercise> americanExercise = MapperS.of(optionStyle).<AmericanExercise>map("getAmericanExercise", _optionStyle -> _optionStyle.getAmericanExercise());
		if (exists(americanExercise).getOrDefault(false)) {
			return americanExercise.<ExpirationTimeTypeEnum>map("getExpirationTimeType", _americanExercise -> _americanExercise.getExpirationTimeType()).get();
		}
		final MapperS<BermudaExercise> bermudaExercise = MapperS.of(optionStyle).<BermudaExercise>map("getBermudaExercise", _optionStyle -> _optionStyle.getBermudaExercise());
		if (exists(bermudaExercise).getOrDefault(false)) {
			return bermudaExercise.<ExpirationTimeTypeEnum>map("getExpirationTimeType", _bermudaExercise -> _bermudaExercise.getExpirationTimeType()).get();
		}
		final MapperS<EuropeanExercise> europeanExercise = MapperS.of(optionStyle).<EuropeanExercise>map("getEuropeanExercise", _optionStyle -> _optionStyle.getEuropeanExercise());
		if (exists(europeanExercise).getOrDefault(false)) {
			return europeanExercise.<ExpirationTimeTypeEnum>map("getExpirationTimeType", _europeanExercise -> _europeanExercise.getExpirationTimeType()).get();
		}
		return null;
	}
	
}
