package cdm.product.template.validation;

import cdm.product.template.MandatoryEarlyTerminationAdjustedDates;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class MandatoryEarlyTerminationAdjustedDatesValidator implements Validator<MandatoryEarlyTerminationAdjustedDates> {

	private List<ComparisonResult> getComparisonResults(MandatoryEarlyTerminationAdjustedDates o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("adjustedEarlyTerminationDate", (Date) o.getAdjustedEarlyTerminationDate() != null ? 1 : 0, 1, 1), 
				checkCardinality("adjustedCashSettlementValuationDate", (Date) o.getAdjustedCashSettlementValuationDate() != null ? 1 : 0, 1, 1), 
				checkCardinality("adjustedCashSettlementPaymentDate", (Date) o.getAdjustedCashSettlementPaymentDate() != null ? 1 : 0, 1, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, MandatoryEarlyTerminationAdjustedDates o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("MandatoryEarlyTerminationAdjustedDates", ValidationType.CARDINALITY, "MandatoryEarlyTerminationAdjustedDates", path, "", res.getError());
				}
				return success("MandatoryEarlyTerminationAdjustedDates", ValidationType.CARDINALITY, "MandatoryEarlyTerminationAdjustedDates", path, "");
			})
			.collect(toList());
	}

}
