package cdm.product.template.validation.datarule;

import cdm.base.datetime.BusinessCenterTime;
import cdm.product.template.AmericanExercise;
import cdm.product.template.ExpirationTimeTypeEnum;
import cdm.product.template.functions.ExpirationTimeType;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;


/**
 * @version 5.24.0
 */
@RosettaDataRule("AmericanExerciseExpirationTimeChoice")
@ImplementedBy(AmericanExerciseExpirationTimeChoice.Default.class)
public interface AmericanExerciseExpirationTimeChoice extends Validator<AmericanExercise> {
	
	String NAME = "AmericanExerciseExpirationTimeChoice";
	String DEFINITION = "ExpirationTimeType(expirationTime, expirationTimeType)";
	
	class Default implements AmericanExerciseExpirationTimeChoice {
	
		@Inject protected ExpirationTimeType expirationTimeType;
		
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, AmericanExercise americanExercise) {
			ComparisonResult result = executeDataRule(americanExercise);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "AmericanExercise", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationType.DATA_RULE, "AmericanExercise", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(AmericanExercise americanExercise) {
			try {
				return ComparisonResult.of(MapperS.of(expirationTimeType.evaluate(MapperS.of(americanExercise).<BusinessCenterTime>map("getExpirationTime", _americanExercise -> _americanExercise.getExpirationTime()).get(), MapperS.of(americanExercise).<ExpirationTimeTypeEnum>map("getExpirationTimeType", _americanExercise -> _americanExercise.getExpirationTimeType()).get())));
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements AmericanExerciseExpirationTimeChoice {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, AmericanExercise americanExercise) {
			return Collections.emptyList();
		}
	}
}
