package cdm.product.template.validation.datarule;

import cdm.product.template.Basket;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.24.0
 */
@RosettaDataRule("BasketChoice0")
@ImplementedBy(BasketChoice0.Default.class)
public interface BasketChoice0 extends Validator<Basket> {
	
	String NAME = "BasketChoice0";
	String DEFINITION = "required choice basketConstituent, portfolioBasketConstituent";
	
	class Default implements BasketChoice0 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, Basket basket) {
			ComparisonResult result = executeDataRule(basket);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "Basket", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationType.DATA_RULE, "Basket", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(Basket basket) {
			try {
				return choice(MapperS.of(basket), Arrays.asList("basketConstituent", "portfolioBasketConstituent"), ChoiceRuleValidationMethod.REQUIRED);
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements BasketChoice0 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, Basket basket) {
			return Collections.emptyList();
		}
	}
}
