package cdm.product.template.validation.datarule;

import cdm.base.datetime.BusinessCenterTime;
import cdm.product.template.BermudaExercise;
import cdm.product.template.ExpirationTimeTypeEnum;
import cdm.product.template.functions.ExpirationTimeType;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;


/**
 * @version 5.24.0
 */
@RosettaDataRule("BermudaExerciseExpirationTimeChoice")
@ImplementedBy(BermudaExerciseExpirationTimeChoice.Default.class)
public interface BermudaExerciseExpirationTimeChoice extends Validator<BermudaExercise> {
	
	String NAME = "BermudaExerciseExpirationTimeChoice";
	String DEFINITION = "ExpirationTimeType(expirationTime, expirationTimeType)";
	
	class Default implements BermudaExerciseExpirationTimeChoice {
	
		@Inject protected ExpirationTimeType expirationTimeType;
		
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, BermudaExercise bermudaExercise) {
			ComparisonResult result = executeDataRule(bermudaExercise);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "BermudaExercise", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationType.DATA_RULE, "BermudaExercise", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(BermudaExercise bermudaExercise) {
			try {
				return ComparisonResult.of(MapperS.of(expirationTimeType.evaluate(MapperS.of(bermudaExercise).<BusinessCenterTime>map("getExpirationTime", _bermudaExercise -> _bermudaExercise.getExpirationTime()).get(), MapperS.of(bermudaExercise).<ExpirationTimeTypeEnum>map("getExpirationTimeType", _bermudaExercise -> _bermudaExercise.getExpirationTimeType()).get())));
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements BermudaExerciseExpirationTimeChoice {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, BermudaExercise bermudaExercise) {
			return Collections.emptyList();
		}
	}
}
