package cdm.product.template.validation.datarule;

import cdm.base.datetime.BusinessCenterTime;
import cdm.product.template.EuropeanExercise;
import cdm.product.template.ExpirationTimeTypeEnum;
import cdm.product.template.functions.ExpirationTimeType;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;


/**
 * @version 5.24.0
 */
@RosettaDataRule("EuropeanExerciseExpirationTimeChoice")
@ImplementedBy(EuropeanExerciseExpirationTimeChoice.Default.class)
public interface EuropeanExerciseExpirationTimeChoice extends Validator<EuropeanExercise> {
	
	String NAME = "EuropeanExerciseExpirationTimeChoice";
	String DEFINITION = "ExpirationTimeType(expirationTime, expirationTimeType)";
	
	class Default implements EuropeanExerciseExpirationTimeChoice {
	
		@Inject protected ExpirationTimeType expirationTimeType;
		
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, EuropeanExercise europeanExercise) {
			ComparisonResult result = executeDataRule(europeanExercise);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "EuropeanExercise", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationType.DATA_RULE, "EuropeanExercise", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(EuropeanExercise europeanExercise) {
			try {
				return ComparisonResult.of(MapperS.of(expirationTimeType.evaluate(MapperS.of(europeanExercise).<BusinessCenterTime>map("getExpirationTime", _europeanExercise -> _europeanExercise.getExpirationTime()).get(), MapperS.of(europeanExercise).<ExpirationTimeTypeEnum>map("getExpirationTimeType", _europeanExercise -> _europeanExercise.getExpirationTimeType()).get())));
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements EuropeanExerciseExpirationTimeChoice {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, EuropeanExercise europeanExercise) {
			return Collections.emptyList();
		}
	}
}
