package cdm.product.template.validation.datarule;

import cdm.observable.asset.Money;
import cdm.product.template.InitialMargin;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.24.0
 */
@RosettaDataRule("InitialMarginMarginThreshold")
@ImplementedBy(InitialMarginMarginThreshold.Default.class)
public interface InitialMarginMarginThreshold extends Validator<InitialMargin> {
	
	String NAME = "InitialMarginMarginThreshold";
	String DEFINITION = "if marginThreshold exists then marginThreshold -> value > 0";
	
	class Default implements InitialMarginMarginThreshold {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, InitialMargin initialMargin) {
			ComparisonResult result = executeDataRule(initialMargin);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "InitialMargin", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationType.DATA_RULE, "InitialMargin", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(InitialMargin initialMargin) {
			try {
				if (exists(MapperS.of(initialMargin).<Money>map("getMarginThreshold", _initialMargin -> _initialMargin.getMarginThreshold())).getOrDefault(false)) {
					return greaterThan(MapperS.of(initialMargin).<Money>map("getMarginThreshold", _initialMargin -> _initialMargin.getMarginThreshold()).<BigDecimal>map("getValue", money -> money.getValue()), MapperS.of(BigDecimal.valueOf(0)), CardinalityOperator.All);
				}
				return ComparisonResult.successEmptyOperand("");
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements InitialMarginMarginThreshold {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, InitialMargin initialMargin) {
			return Collections.emptyList();
		}
	}
}
