package cdm.product.template.validation.datarule;

import cdm.product.template.OptionStyle;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.24.0
 */
@RosettaDataRule("OptionStyleOneOf0")
@ImplementedBy(OptionStyleOneOf0.Default.class)
public interface OptionStyleOneOf0 extends Validator<OptionStyle> {
	
	String NAME = "OptionStyleOneOf0";
	String DEFINITION = "one-of";
	
	class Default implements OptionStyleOneOf0 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, OptionStyle optionStyle) {
			ComparisonResult result = executeDataRule(optionStyle);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "OptionStyle", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationType.DATA_RULE, "OptionStyle", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(OptionStyle optionStyle) {
			try {
				return choice(MapperS.of(optionStyle), Arrays.asList("americanExercise", "bermudaExercise", "europeanExercise"), ChoiceRuleValidationMethod.REQUIRED);
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements OptionStyleOneOf0 {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, OptionStyle optionStyle) {
			return Collections.emptyList();
		}
	}
}
