package cdm.product.template.validation.datarule;

import cdm.product.template.OptionalEarlyTermination;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ChoiceRuleValidationMethod;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

/**
 * @version 5.24.0
 */
@RosettaDataRule("OptionalEarlyTerminationExerciseChoice")
@ImplementedBy(OptionalEarlyTerminationExerciseChoice.Default.class)
public interface OptionalEarlyTerminationExerciseChoice extends Validator<OptionalEarlyTermination> {
	
	String NAME = "OptionalEarlyTerminationExerciseChoice";
	String DEFINITION = "optional choice americanExercise, bermudaExercise, europeanExercise";
	
	class Default implements OptionalEarlyTerminationExerciseChoice {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, OptionalEarlyTermination optionalEarlyTermination) {
			ComparisonResult result = executeDataRule(optionalEarlyTermination);
			if (result.get()) {
				return Arrays.asList(ValidationResult.success(NAME, ValidationResult.ValidationType.DATA_RULE, "OptionalEarlyTermination", path, DEFINITION));
			}
			
			String failureMessage = result.getError();
			if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
				failureMessage = "Condition has failed.";
			}
			return Arrays.asList(ValidationResult.failure(NAME, ValidationType.DATA_RULE, "OptionalEarlyTermination", path, DEFINITION, failureMessage));
		}
		
		private ComparisonResult executeDataRule(OptionalEarlyTermination optionalEarlyTermination) {
			try {
				return choice(MapperS.of(optionalEarlyTermination), Arrays.asList("americanExercise", "bermudaExercise", "europeanExercise"), ChoiceRuleValidationMethod.OPTIONAL);
			}
			catch (Exception ex) {
				return ComparisonResult.failure(ex.getMessage());
			}
		}
	}
	
	@SuppressWarnings("unused")
	class NoOp implements OptionalEarlyTerminationExerciseChoice {
	
		@Override
		public List<ValidationResult<?>> getValidationResults(RosettaPath path, OptionalEarlyTermination optionalEarlyTermination) {
			return Collections.emptyList();
		}
	}
}
