package cdm.regulation.validation;

import cdm.regulation.DerivInstrmAttrbts;
import cdm.regulation.UndrlygInstrm;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class DerivInstrmAttrbtsValidator implements Validator<DerivInstrmAttrbts> {

	private List<ComparisonResult> getComparisonResults(DerivInstrmAttrbts o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("xpryDt", (String) o.getXpryDt() != null ? 1 : 0, 1, 1), 
				checkCardinality("pricMltplr", (String) o.getPricMltplr() != null ? 1 : 0, 1, 1), 
				checkCardinality("undrlygInstrm", (UndrlygInstrm) o.getUndrlygInstrm() != null ? 1 : 0, 1, 1), 
				checkCardinality("dlvryTp", (String) o.getDlvryTp() != null ? 1 : 0, 1, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, DerivInstrmAttrbts o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("DerivInstrmAttrbts", ValidationType.CARDINALITY, "DerivInstrmAttrbts", path, "", res.getError());
				}
				return success("DerivInstrmAttrbts", ValidationType.CARDINALITY, "DerivInstrmAttrbts", path, "");
			})
			.collect(toList());
	}

}
