package drr.enrichment.upi.functions;

import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.base.staticdata.asset.common.metafields.ReferenceWithMetaProductIdentifier;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.ReportableEvent.ReportableEventBuilder;
import java.util.Optional;
import javax.inject.Inject;


@ImplementedBy(EnrichReportableEventWithUpiForSwaption.EnrichReportableEventWithUpiForSwaptionDefault.class)
public abstract class EnrichReportableEventWithUpiForSwaption implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;

	/**
	* @param reportableEvent 
	* @param upi 
	* @return enrichedReportableEvent 
	*/
	public ReportableEvent evaluate(ReportableEvent reportableEvent, String upi) {
		ReportableEvent.ReportableEventBuilder enrichedReportableEventBuilder = doEvaluate(reportableEvent, upi);
		
		final ReportableEvent enrichedReportableEvent;
		if (enrichedReportableEventBuilder == null) {
			enrichedReportableEvent = null;
		} else {
			enrichedReportableEvent = enrichedReportableEventBuilder.build();
			objectValidator.validate(ReportableEvent.class, enrichedReportableEvent);
		}
		
		return enrichedReportableEvent;
	}

	protected abstract ReportableEvent.ReportableEventBuilder doEvaluate(ReportableEvent reportableEvent, String upi);

	protected abstract MapperS<? extends ProductIdentifier> addProductIdentifier(ReportableEvent reportableEvent, String upi);

	public static class EnrichReportableEventWithUpiForSwaptionDefault extends EnrichReportableEventWithUpiForSwaption {
		@Override
		protected ReportableEvent.ReportableEventBuilder doEvaluate(ReportableEvent reportableEvent, String upi) {
			ReportableEvent.ReportableEventBuilder enrichedReportableEvent = ReportableEvent.builder();
			return assignOutput(enrichedReportableEvent, reportableEvent, upi);
		}
		
		protected ReportableEvent.ReportableEventBuilder assignOutput(ReportableEvent.ReportableEventBuilder enrichedReportableEvent, ReportableEvent reportableEvent, String upi) {
			enrichedReportableEvent = toBuilder(reportableEvent);
			
			enrichedReportableEvent
				.getOrCreateOriginatingWorkflowStep()
				.getOrCreateBusinessEvent()
				.getOrCreateInstruction(0)
				.getOrCreateBefore().getOrCreateValue()
				.getOrCreateTrade()
				.getOrCreateTradableProduct()
				.getOrCreateProduct()
				.getOrCreateContractualProduct()
				.getOrCreateEconomicTerms()
				.getOrCreatePayout()
				.getOrCreateOptionPayout(0)
				.getOrCreateUnderlier()
				.getOrCreateContractualProduct()
				.addProductIdentifier(addProductIdentifier(reportableEvent, upi).<ReferenceWithMetaProductIdentifier>map("Type coercion", productIdentifier0 -> productIdentifier0 == null ? ReferenceWithMetaProductIdentifier.builder().build() : ReferenceWithMetaProductIdentifier.builder().setValue(productIdentifier0).build()).getMulti());
			
			enrichedReportableEvent
				.getOrCreateOriginatingWorkflowStep()
				.getOrCreateBusinessEvent()
				.getOrCreateAfter(0)
				.getOrCreateTrade()
				.getOrCreateTradableProduct()
				.getOrCreateProduct()
				.getOrCreateContractualProduct()
				.getOrCreateEconomicTerms()
				.getOrCreatePayout()
				.getOrCreateOptionPayout(0)
				.getOrCreateUnderlier()
				.getOrCreateContractualProduct()
				.addProductIdentifier(addProductIdentifier(reportableEvent, upi).<ReferenceWithMetaProductIdentifier>map("Type coercion", productIdentifier1 -> productIdentifier1 == null ? ReferenceWithMetaProductIdentifier.builder().build() : ReferenceWithMetaProductIdentifier.builder().setValue(productIdentifier1).build()).getMulti());
			
			return Optional.ofNullable(enrichedReportableEvent)
				.map(o -> o.prune())
				.orElse(null);
		}
		
		@Override
		protected MapperS<? extends ProductIdentifier> addProductIdentifier(ReportableEvent reportableEvent, String upi) {
			return MapperS.of(ProductIdentifier.builder()
				.setIdentifierValue(upi)
				.setSource(ProductIdTypeEnum.UPI)
				.build());
		}
	}
}
