package drr.projection.dtcc.rds.harmonized.csa.rewrite.trade.functions;

import cdm.base.staticdata.asset.common.AssetClassEnum;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.base.staticdata.party.PartyIdentifierTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.ClearingAccountOriginEnum;
import drr.regulation.common.CommonAssetClass;
import drr.regulation.common.CommonContractType;
import drr.regulation.common.functions.GetNotationString;
import drr.regulation.common.trade.CommonLeg;
import drr.regulation.common.trade.contract.UnderlyingIdentifier;
import drr.regulation.common.trade.payment.CommonPeriodicPayment;
import drr.regulation.common.util.functions.StringContains;
import drr.regulation.common.util.functions.SubString;
import drr.regulation.csa.rewrite.dtcc.DTCCAdditionalFields;
import drr.regulation.csa.rewrite.trade.CSATransactionReport;
import drr.standards.iosco.cde.price.PriceFormat;
import drr.standards.iosco.cde.price.PriceNotationEnum;
import drr.standards.iso.ActionTypeEnum;
import drr.standards.iso.ClearedEnum;
import drr.standards.iso.EmbeddedOptionTypeEnum;
import drr.standards.iso.EventTypeEnum;
import drr.standards.iso.FrequencyPeriodEnum;
import drr.standards.iso.InterestComputationMethod4Code;
import drr.standards.iso.OptionStyleEnum;
import drr.standards.iso.ReportLevelEnum;
import iso20022.dtcc.rds.harmonized.HarmonizedData;
import iso20022.dtcc.rds.harmonized.HarmonizedData.HarmonizedDataBuilder;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(Create_SubmissionHarmonizedData.Create_SubmissionHarmonizedDataDefault.class)
public abstract class Create_SubmissionHarmonizedData implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected GetNotationString getNotationString;
	@Inject protected StringContains stringContains;
	@Inject protected SubString subString;

	/**
	* @param drrReport 
	* @return harmonized 
	*/
	public HarmonizedData evaluate(CSATransactionReport drrReport) {
		HarmonizedData.HarmonizedDataBuilder harmonizedBuilder = doEvaluate(drrReport);
		
		final HarmonizedData harmonized;
		if (harmonizedBuilder == null) {
			harmonized = null;
		} else {
			harmonized = harmonizedBuilder.build();
			objectValidator.validate(HarmonizedData.class, harmonized);
		}
		
		return harmonized;
	}

	protected abstract HarmonizedData.HarmonizedDataBuilder doEvaluate(CSATransactionReport drrReport);

	public static class Create_SubmissionHarmonizedDataDefault extends Create_SubmissionHarmonizedData {
		@Override
		protected HarmonizedData.HarmonizedDataBuilder doEvaluate(CSATransactionReport drrReport) {
			HarmonizedData.HarmonizedDataBuilder harmonized = HarmonizedData.builder();
			return assignOutput(harmonized, drrReport);
		}
		
		protected HarmonizedData.HarmonizedDataBuilder assignOutput(HarmonizedData.HarmonizedDataBuilder harmonized, CSATransactionReport drrReport) {
			final Integer integer0 = MapperS.of(drrReport).<CommonLeg>map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<Integer>map("getFixedRatePaymentFrequencyPeriodMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFixedRatePaymentFrequencyPeriodMultiplier()).get();
			final Integer integer1 = MapperS.of(drrReport).<CommonLeg>map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<Integer>map("getFixedRatePaymentFrequencyPeriodMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFixedRatePaymentFrequencyPeriodMultiplier()).get();
			final Integer integer2 = MapperS.of(drrReport).<CommonLeg>map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<Integer>map("getFloatingRatePaymentFrequencyPeriodMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRatePaymentFrequencyPeriodMultiplier()).get();
			final Integer integer3 = MapperS.of(drrReport).<CommonLeg>map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<Integer>map("getFloatingRatePaymentFrequencyPeriodMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRatePaymentFrequencyPeriodMultiplier()).get();
			final String ifThenElseResult0;
			if (exists(MapperS.of(drrReport).<String>map("getPlatformIdentifier", cSATransactionReport -> cSATransactionReport.getPlatformIdentifier())).getOrDefault(false)) {
				ifThenElseResult0 = MapperS.of(drrReport).<String>map("getPlatformIdentifier", cSATransactionReport -> cSATransactionReport.getPlatformIdentifier()).get();
			} else if (areEqual(MapperS.of(drrReport).<ClearedEnum>map("getCleared", cSATransactionReport -> cSATransactionReport.getCleared()), MapperS.of(ClearedEnum.N), CardinalityOperator.All).or(areEqual(MapperS.of(drrReport).<ClearedEnum>map("getCleared", cSATransactionReport -> cSATransactionReport.getCleared()), MapperS.of(ClearedEnum.I), CardinalityOperator.All)).getOrDefault(false)) {
				ifThenElseResult0 = "BILT";
			} else {
				ifThenElseResult0 = null;
			}
			final MapperS<PriceNotationEnum> thenArg0 = MapperS.of(drrReport).<PriceNotationEnum>map("getPriceNotation", cSATransactionReport -> cSATransactionReport.getPriceNotation());
			final MapperS<PriceNotationEnum> thenArg1 = MapperS.of(drrReport).<CommonLeg>map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).<PriceNotationEnum>map("getSpreadNotation", commonLeg -> commonLeg.getSpreadNotation());
			final MapperS<PriceNotationEnum> thenArg2 = MapperS.of(drrReport).<CommonLeg>map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).<PriceNotationEnum>map("getSpreadNotation", commonLeg -> commonLeg.getSpreadNotation());
			final Integer integer4 = MapperS.of(drrReport).<CommonLeg>map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<Integer>map("getFloatingRateResetFrequencyMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRateResetFrequencyMultiplier()).get();
			final String ifThenElseResult1;
			if (areEqual(MapperS.of(drrReport).<OptionStyleEnum>map("getOptionStyle", cSATransactionReport -> cSATransactionReport.getOptionStyle()), MapperS.of(OptionStyleEnum.EURO), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult1 = "European";
			} else if (areEqual(MapperS.of(drrReport).<OptionStyleEnum>map("getOptionStyle", cSATransactionReport -> cSATransactionReport.getOptionStyle()), MapperS.of(OptionStyleEnum.AMER), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult1 = "American";
			} else if (areEqual(MapperS.of(drrReport).<OptionStyleEnum>map("getOptionStyle", cSATransactionReport -> cSATransactionReport.getOptionStyle()), MapperS.of(OptionStyleEnum.BERM), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult1 = "Bermudan";
			} else if (areEqual(MapperS.of(drrReport).<OptionStyleEnum>map("getOptionStyle", cSATransactionReport -> cSATransactionReport.getOptionStyle()), MapperS.of(OptionStyleEnum.ASIA), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult1 = "Asian";
			} else {
				ifThenElseResult1 = null;
			}
			final Integer integer5 = MapperS.of(drrReport).<CommonLeg>map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).<Integer>map("getQuantityFrequencyMultiplier", commonLeg -> commonLeg.getQuantityFrequencyMultiplier()).get();
			final Integer integer6 = MapperS.of(drrReport).<CommonLeg>map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).<Integer>map("getQuantityFrequencyMultiplier", commonLeg -> commonLeg.getQuantityFrequencyMultiplier()).get();
			final Integer integer7 = MapperS.of(drrReport).<CommonLeg>map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<Integer>map("getFloatingRateResetFrequencyMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRateResetFrequencyMultiplier()).get();
			final BigDecimal ifThenElseResult2;
			if (areEqual(MapperS.of(drrReport).<PriceNotationEnum>map("getStrikePriceNotation", cSATransactionReport -> cSATransactionReport.getStrikePriceNotation()), MapperS.of(PriceNotationEnum.MONETARY), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult2 = MapperS.of(drrReport).<PriceFormat>map("getStrikePrice", cSATransactionReport -> cSATransactionReport.getStrikePrice()).<BigDecimal>map("getMonetary", priceFormat -> priceFormat.getMonetary()).get();
			} else if (areEqual(MapperS.of(drrReport).<PriceNotationEnum>map("getStrikePriceNotation", cSATransactionReport -> cSATransactionReport.getStrikePriceNotation()), MapperS.of(PriceNotationEnum.DECIMAL), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult2 = MapperS.of(drrReport).<PriceFormat>map("getStrikePrice", cSATransactionReport -> cSATransactionReport.getStrikePrice()).<BigDecimal>map("getDecimal", priceFormat -> priceFormat.getDecimal()).get();
			} else if (areEqual(MapperS.of(drrReport).<PriceNotationEnum>map("getStrikePriceNotation", cSATransactionReport -> cSATransactionReport.getStrikePriceNotation()), MapperS.of(PriceNotationEnum.BASIS), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult2 = MapperS.of(drrReport).<PriceFormat>map("getStrikePrice", cSATransactionReport -> cSATransactionReport.getStrikePrice()).<BigDecimal>map("getBasis", priceFormat -> priceFormat.getBasis()).get();
			} else if (areEqual(MapperS.of(drrReport).<PriceNotationEnum>map("getStrikePriceNotation", cSATransactionReport -> cSATransactionReport.getStrikePriceNotation()), MapperS.of(PriceNotationEnum.PERCENTAGE), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult2 = MapperS.of(drrReport).<PriceFormat>map("getStrikePrice", cSATransactionReport -> cSATransactionReport.getStrikePrice()).<BigDecimal>map("getPercentage", priceFormat -> priceFormat.getPercentage()).get();
			} else {
				ifThenElseResult2 = null;
			}
			String ifThenElseResult3 = null;
			if (areEqual(MapperS.of(drrReport).<PriceNotationEnum>map("getStrikePriceNotation", cSATransactionReport -> cSATransactionReport.getStrikePriceNotation()), MapperS.of(PriceNotationEnum.MONETARY), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult3 = subString.evaluate(MapperS.of(drrReport).<String>map("getStrikePriceCurrency", cSATransactionReport -> cSATransactionReport.getStrikePriceCurrency()).get(), 1, 3);
			}
			final Boolean _boolean = stringContains.evaluate(MapperS.of(drrReport).<String>map("getStrikePriceCurrency", cSATransactionReport -> cSATransactionReport.getStrikePriceCurrency()).get(), "/");
			String ifThenElseResult4 = null;
			if ((_boolean == null ? false : _boolean)) {
				ifThenElseResult4 = subString.evaluate(MapperS.of(drrReport).<String>map("getStrikePriceCurrency", cSATransactionReport -> cSATransactionReport.getStrikePriceCurrency()).get(), 5, 3);
			}
			final MapperS<PriceNotationEnum> thenArg3 = MapperS.of(drrReport).<PriceNotationEnum>map("getStrikePriceNotation", cSATransactionReport -> cSATransactionReport.getStrikePriceNotation());
			BigDecimal ifThenElseResult5 = null;
			if (areEqual(MapperS.of(drrReport).<CommonLeg>map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).<BigDecimal>map("getTotalNotionalQuantity", commonLeg -> commonLeg.getTotalNotionalQuantity()), MapperS.of(drrReport).<CommonLeg>map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).<BigDecimal>map("getTotalNotionalQuantity", commonLeg -> commonLeg.getTotalNotionalQuantity()), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult5 = MapperS.of(drrReport).<CommonLeg>map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).<BigDecimal>map("getTotalNotionalQuantity", commonLeg -> commonLeg.getTotalNotionalQuantity()).get();
			}
			final String ifThenElseResult6;
			if (exists(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).<String>map("getVersionTransaction", dTCCAdditionalFields -> dTCCAdditionalFields.getVersionTransaction())).getOrDefault(false)) {
				ifThenElseResult6 = MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).<String>map("getVersionTransaction", dTCCAdditionalFields -> dTCCAdditionalFields.getVersionTransaction()).get();
			} else if (exists(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).<String>map("getVersionPPD", dTCCAdditionalFields -> dTCCAdditionalFields.getVersionPPD())).getOrDefault(false)) {
				ifThenElseResult6 = MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).<String>map("getVersionPPD", dTCCAdditionalFields -> dTCCAdditionalFields.getVersionPPD()).get();
			} else {
				ifThenElseResult6 = null;
			}
			final Integer integer8 = MapperS.of(drrReport).<CommonLeg>map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<Integer>map("getFloatingRatePaymentFrequencyPeriodMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRatePaymentFrequencyPeriodMultiplier()).get();
			final Integer integer9 = MapperS.of(drrReport).<CommonLeg>map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<Integer>map("getFloatingRatePaymentFrequencyPeriodMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRatePaymentFrequencyPeriodMultiplier()).get();
			final Integer integer10 = MapperS.of(drrReport).<CommonLeg>map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<Integer>map("getFloatingRatePaymentFrequencyPeriodMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRatePaymentFrequencyPeriodMultiplier()).get();
			final Integer integer11 = MapperC.<Integer>of(MapperS.of(drrReport).<CommonLeg>map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<Integer>map("getFixedRatePaymentFrequencyPeriodMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFixedRatePaymentFrequencyPeriodMultiplier()), MapperS.of(drrReport).<CommonLeg>map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<Integer>map("getFloatingRatePaymentFrequencyPeriodMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRatePaymentFrequencyPeriodMultiplier())).get();
			final Integer integer12 = MapperC.<Integer>of(MapperS.of(drrReport).<CommonLeg>map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<Integer>map("getFixedRatePaymentFrequencyPeriodMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFixedRatePaymentFrequencyPeriodMultiplier()), MapperS.of(drrReport).<CommonLeg>map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<Integer>map("getFloatingRatePaymentFrequencyPeriodMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRatePaymentFrequencyPeriodMultiplier())).get();
			final Integer integer13 = MapperC.<Integer>of(MapperS.of(drrReport).<CommonLeg>map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<Integer>map("getFloatingRatePaymentFrequencyPeriodMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRatePaymentFrequencyPeriodMultiplier()), MapperS.of(drrReport).<CommonLeg>map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<Integer>map("getFixedRatePaymentFrequencyPeriodMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFixedRatePaymentFrequencyPeriodMultiplier())).get();
			final Integer integer14 = MapperC.<Integer>of(MapperS.of(drrReport).<CommonLeg>map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<Integer>map("getFloatingRatePaymentFrequencyPeriodMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRatePaymentFrequencyPeriodMultiplier()), MapperS.of(drrReport).<CommonLeg>map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<Integer>map("getFixedRatePaymentFrequencyPeriodMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFixedRatePaymentFrequencyPeriodMultiplier())).get();
			String ifThenElseResult7 = null;
			if (areEqual(MapperS.of(drrReport).<CommonAssetClass>map("getAssetClass", cSATransactionReport -> cSATransactionReport.getAssetClass()), MapperS.of(CommonAssetClass.COMM), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult7 = MapperS.of(drrReport).<String>map("getQuantityUnitOfMeasureLeg2", cSATransactionReport -> cSATransactionReport.getQuantityUnitOfMeasureLeg2()).get();
			}
			String ifThenElseResult8 = null;
			if (areEqual(MapperS.of(drrReport).<CommonAssetClass>map("getAssetClass", cSATransactionReport -> cSATransactionReport.getAssetClass()), MapperS.of(CommonAssetClass.COMM), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult8 = MapperS.of(drrReport).<String>map("getQuantityUnitOfMeasureLeg1", cSATransactionReport -> cSATransactionReport.getQuantityUnitOfMeasureLeg1()).get();
			}
			harmonized = toBuilder(HarmonizedData.builder()
				.setAmendmentIndicator(MapperS.of(drrReport).<Boolean>map("getAmendmentIndicator", cSATransactionReport -> cSATransactionReport.getAmendmentIndicator()).get())
				.setCdePackageTransactionSpreadCurrency(MapperS.of(drrReport).<ISOCurrencyCodeEnum>map("getPackageTransactionSpreadCurrency", cSATransactionReport -> cSATransactionReport.getPackageTransactionSpreadCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
				.setClearingVenueIdType(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).<PartyIdentifierTypeEnum>map("getClearingVenueIDType", dTCCAdditionalFields -> dTCCAdditionalFields.getClearingVenueIDType()).map("to-string", PartyIdentifierTypeEnum::toDisplayString).get())
				.setClearingVenueId(MapperS.of(drrReport).<String>map("getCentralCounterparty", cSATransactionReport -> cSATransactionReport.getCentralCounterparty()).get())
				.setTradeParty1ClearingBrokerId(MapperS.of(drrReport).<String>map("getClearingMemberIdentifier", cSATransactionReport -> cSATransactionReport.getClearingMemberIdentifier()).get())
				.setTradeParty1ClearingBrokerIdType(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).<PartyIdentifierTypeEnum>map("getTradeParty1ClearingBrokerIDType", dTCCAdditionalFields -> dTCCAdditionalFields.getTradeParty1ClearingBrokerIDType()).map("to-string", PartyIdentifierTypeEnum::toDisplayString).get())
				.setBuyerPayer1(MapperS.of(drrReport).<String>map("getBuyerIdentifier", cSATransactionReport -> cSATransactionReport.getBuyerIdentifier()).get())
				.setCdeCallAmountLeg1(MapperS.of(drrReport).<BigDecimal>map("getCallAmount", cSATransactionReport -> cSATransactionReport.getCallAmount()).get())
				.setCdeCallCurrencyLeg1(MapperS.of(drrReport).<ISOCurrencyCodeEnum>map("getCallCurrency", cSATransactionReport -> cSATransactionReport.getCallCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
				.setCdeEffectiveDate(MapperS.of(drrReport).<Date>map("getEffectiveDate", cSATransactionReport -> cSATransactionReport.getEffectiveDate()).get())
				.setCustomBasketIndicator(MapperS.of(drrReport).<Boolean>map("getCustomBasketIndicator", cSATransactionReport -> cSATransactionReport.getCustomBasketIndicator()).get())
				.setCdeExpirationDate(MapperS.of(drrReport).<Date>map("getExpirationDate", cSATransactionReport -> cSATransactionReport.getExpirationDate()).get())
				.setCdeFinalContractualSettlementDate(MapperS.of(drrReport).<Date>map("getFinalContractualSettlementDate", cSATransactionReport -> cSATransactionReport.getFinalContractualSettlementDate()).get())
				.setCdeFirstExerciseDate(MapperS.of(drrReport).<Date>map("getFirstExerciseDate", cSATransactionReport -> cSATransactionReport.getFirstExerciseDate()).get())
				.setCdeFixedRateDayCountConventionLeg1(MapperS.of(drrReport).<CommonLeg>map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<InterestComputationMethod4Code>map("getFixedRateDayCountConvention", commonPeriodicPayment -> commonPeriodicPayment.getFixedRateDayCountConvention()).map("to-string", InterestComputationMethod4Code::toDisplayString).get())
				.setCdeFixedRateDayCountConventionLeg2(MapperS.of(drrReport).<CommonLeg>map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<InterestComputationMethod4Code>map("getFixedRateDayCountConvention", commonPeriodicPayment -> commonPeriodicPayment.getFixedRateDayCountConvention()).map("to-string", InterestComputationMethod4Code::toDisplayString).get())
				.setCdeFixedRatePaymentFrequencyPeriodMultiplierLeg1((integer0 == null ? null : BigDecimal.valueOf(integer0)))
				.setCdeFixedRatePaymentFrequencyPeriodMultiplierLeg2((integer1 == null ? null : BigDecimal.valueOf(integer1)))
				.setCdeFixedRatePaymentFrequencyPeriodLeg1(MapperS.of(drrReport).<CommonLeg>map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<FrequencyPeriodEnum>map("getFixedRatePaymentFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFixedRatePaymentFrequencyPeriod()).map("to-string", FrequencyPeriodEnum::toDisplayString).get())
				.setCdeFixedRatePaymentFrequencyPeriodLeg2(MapperS.of(drrReport).<CommonLeg>map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<FrequencyPeriodEnum>map("getFixedRatePaymentFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFixedRatePaymentFrequencyPeriod()).map("to-string", FrequencyPeriodEnum::toDisplayString).get())
				.setCdeFloatingRateDayCountConventionLeg1(MapperS.of(drrReport).<CommonLeg>map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<InterestComputationMethod4Code>map("getFloatingRateDayCountConvention", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRateDayCountConvention()).map("to-string", InterestComputationMethod4Code::toDisplayString).get())
				.setCdeFloatingRateDayCountConventionLeg2(MapperS.of(drrReport).<CommonLeg>map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<InterestComputationMethod4Code>map("getFloatingRateDayCountConvention", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRateDayCountConvention()).map("to-string", InterestComputationMethod4Code::toDisplayString).get())
				.setCdeFloatingRatePaymentFrequencyPeriodMultiplierLeg1((integer2 == null ? null : BigDecimal.valueOf(integer2)))
				.setCdeFloatingRatePaymentFrequencyPeriodMultiplierLeg2((integer3 == null ? null : BigDecimal.valueOf(integer3)))
				.setCdeFloatingRatePaymentFrequencyPeriodLeg1(MapperS.of(drrReport).<CommonLeg>map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<FrequencyPeriodEnum>map("getFloatingRatePaymentFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRatePaymentFrequencyPeriod()).map("to-string", FrequencyPeriodEnum::toDisplayString).get())
				.setCdeFloatingRatePaymentFrequencyPeriodLeg2(MapperS.of(drrReport).<CommonLeg>map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<FrequencyPeriodEnum>map("getFloatingRatePaymentFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRatePaymentFrequencyPeriod()).map("to-string", FrequencyPeriodEnum::toDisplayString).get())
				.setCdePlatformIdentifier(ifThenElseResult0)
				.setCdePriceCurrency(MapperS.of(drrReport).<ISOCurrencyCodeEnum>map("getPriceCurrency", cSATransactionReport -> cSATransactionReport.getPriceCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
				.setCdePriceNotation(MapperS.of(getNotationString.evaluate(thenArg0.get())).get())
				.setCdePutAmountLeg1(MapperS.of(drrReport).<BigDecimal>map("getPutAmount", cSATransactionReport -> cSATransactionReport.getPutAmount()).get())
				.setCdePutCurrencyLeg1(MapperS.of(drrReport).<ISOCurrencyCodeEnum>map("getPutCurrency", cSATransactionReport -> cSATransactionReport.getPutCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
				.setCdeQuantityUnitOfMeasureLeg1(MapperS.of(drrReport).<String>map("getQuantityUnitOfMeasureLeg1", cSATransactionReport -> cSATransactionReport.getQuantityUnitOfMeasureLeg1()).get())
				.setCdeQuantityUnitOfMeasureLeg2(MapperS.of(drrReport).<String>map("getQuantityUnitOfMeasureLeg2", cSATransactionReport -> cSATransactionReport.getQuantityUnitOfMeasureLeg2()).get())
				.setCdeReceiverIdentifierLeg2(MapperS.of(drrReport).<String>map("getReceiverIdentifierLeg2", cSATransactionReport -> cSATransactionReport.getReceiverIdentifierLeg2()).get())
				.setCdeSettlementLocationLeg1(MapperS.of(drrReport).<String>map("getSettlementLocation", cSATransactionReport -> cSATransactionReport.getSettlementLocation()).get())
				.setCdeSpreadNotationLeg1(MapperS.of(getNotationString.evaluate(thenArg1.get())).get())
				.setCdeSpreadNotationLeg2(MapperS.of(getNotationString.evaluate(thenArg2.get())).get())
				.setClearingStatus(MapperS.of(drrReport).<ClearedEnum>map("getCleared", cSATransactionReport -> cSATransactionReport.getCleared()).map("to-string", ClearedEnum::toDisplayString).get())
				.setEventType(MapperS.of(drrReport).<EventTypeEnum>map("getEventType", cSATransactionReport -> cSATransactionReport.getEventType()).map("to-string", EventTypeEnum::toDisplayString).get())
				.setFixingDateLeg1(MapperS.of(drrReport).<CommonLeg>map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).<ZonedDateTime>map("getFixingDate", commonLeg -> commonLeg.getFixingDate()).<Date>map("Date", zdt -> Date.of(zdt.toLocalDate())).get())
				.setFixingDateLeg2(MapperS.of(drrReport).<CommonLeg>map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).<ZonedDateTime>map("getFixingDate", commonLeg -> commonLeg.getFixingDate()).<Date>map("Date", zdt -> Date.of(zdt.toLocalDate())).get())
				.setIndexFactor(MapperS.of(drrReport).<BigDecimal>map("getIndexFactor", cSATransactionReport -> cSATransactionReport.getIndexFactor()).get())
				.setExchangeRate(MapperS.of(drrReport).<BigDecimal>map("getExchangeRate", cSATransactionReport -> cSATransactionReport.getExchangeRate()).get())
				.setLeg1FixedRateInitial(MapperS.of(drrReport).<CommonLeg>map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).<BigDecimal>map("getFixedRate", commonLeg -> commonLeg.getFixedRate()).get())
				.setLeg1NotionalQuantity(MapperS.of(drrReport).<CommonLeg>map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).<BigDecimal>map("getNotionalQuantity", commonLeg -> commonLeg.getNotionalQuantity()).get())
				.setLeg1SpreadCurrency(MapperS.of(drrReport).<CommonLeg>map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).<ISOCurrencyCodeEnum>map("getSpreadCurrency", commonLeg -> commonLeg.getSpreadCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
				.setLeg1TotalNotionalQuantity(MapperS.of(drrReport).<CommonLeg>map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).<BigDecimal>map("getTotalNotionalQuantity", commonLeg -> commonLeg.getTotalNotionalQuantity()).get())
				.setLeg2FixedRateInitial(MapperS.of(drrReport).<CommonLeg>map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).<BigDecimal>map("getFixedRate", commonLeg -> commonLeg.getFixedRate()).get())
				.setLeg2NotionalQuantity(MapperS.of(drrReport).<CommonLeg>map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).<BigDecimal>map("getNotionalQuantity", commonLeg -> commonLeg.getNotionalQuantity()).get())
				.setLeg2QuantityFrequency(MapperS.of(drrReport).<CommonLeg>map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).<FrequencyPeriodEnum>map("getQuantityFrequency", commonLeg -> commonLeg.getQuantityFrequency()).map("to-string", FrequencyPeriodEnum::toDisplayString).get())
				.setLeg2ResetFrequencyPeriod(MapperS.of(drrReport).<CommonLeg>map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<FrequencyPeriodEnum>map("getFloatingRateResetFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRateResetFrequencyPeriod()).map("to-string", FrequencyPeriodEnum::toDisplayString).get())
				.setLeg2ResetFrequencyPeriodMultiplier((integer4 == null ? null : BigDecimal.valueOf(integer4)))
				.setLeg2SettlementCurrency(MapperS.of(drrReport).<CommonLeg>map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).<ISOCurrencyCodeEnum>map("getSettlementCurrency", commonLeg -> commonLeg.getSettlementCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
				.setLeg2SpreadCurrency(MapperS.of(drrReport).<CommonLeg>map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).<ISOCurrencyCodeEnum>map("getSpreadCurrency", commonLeg -> commonLeg.getSpreadCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
				.setLeg2TotalNotionalQuantity(MapperS.of(drrReport).<CommonLeg>map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).<BigDecimal>map("getTotalNotionalQuantity", commonLeg -> commonLeg.getTotalNotionalQuantity()).get())
				.setNewSdrIdentifier(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).<String>map("getNewSDRIdentifier", dTCCAdditionalFields -> dTCCAdditionalFields.getNewSDRIdentifier()).get())
				.setNoaActionType(MapperS.of(drrReport).<ActionTypeEnum>map("getActionType", cSATransactionReport -> cSATransactionReport.getActionType()).map("to-string", ActionTypeEnum::toDisplayString).get())
				.setNonStandardTradeIndicator(MapperS.of(drrReport).<Boolean>map("getNonStandardizedTermIndicator", cSATransactionReport -> cSATransactionReport.getNonStandardizedTermIndicator()).get())
				.setNotionalAmount1(MapperS.of(drrReport).<CommonLeg>map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).<BigDecimal>map("getNotionalAmount", commonLeg -> commonLeg.getNotionalAmount()).get())
				.setNotionalAmount2(MapperS.of(drrReport).<CommonLeg>map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).<BigDecimal>map("getNotionalAmount", commonLeg -> commonLeg.getNotionalAmount()).get())
				.setNotionalCurrency1(MapperS.of(drrReport).<CommonLeg>map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).<ISOCurrencyCodeEnum>map("getNotionalCurrency", commonLeg -> commonLeg.getNotionalCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
				.setNotionalCurrency2(MapperS.of(drrReport).<CommonLeg>map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).<ISOCurrencyCodeEnum>map("getNotionalCurrency", commonLeg -> commonLeg.getNotionalCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
				.setOptionStyle(ifThenElseResult1)
				.setOptionType(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).<String>map("getOptionType", dTCCAdditionalFields -> dTCCAdditionalFields.getOptionType()).get())
				.setOriginalExecutionTimestamp(MapperS.of(drrReport).<ZonedDateTime>map("getExecutionTimestamp", cSATransactionReport -> cSATransactionReport.getExecutionTimestamp()).get())
				.setPayment1Payer(MapperS.of(drrReport).<String>map("getPayerIdentifierLeg1", cSATransactionReport -> cSATransactionReport.getPayerIdentifierLeg1()).get())
				.setPayment1Receiver(MapperS.of(drrReport).<String>map("getReceiverIdentifierLeg1", cSATransactionReport -> cSATransactionReport.getReceiverIdentifierLeg1()).get())
				.setPayment2Payer(MapperS.of(drrReport).<String>map("getPayerIdentifierLeg2", cSATransactionReport -> cSATransactionReport.getPayerIdentifierLeg2()).get())
				.setPremiumAmount(MapperS.of(drrReport).<BigDecimal>map("getOptionPremiumAmount", cSATransactionReport -> cSATransactionReport.getOptionPremiumAmount()).get())
				.setPremiumCurrency(MapperS.of(drrReport).<ISOCurrencyCodeEnum>map("getOptionPremiumCurrency", cSATransactionReport -> cSATransactionReport.getOptionPremiumCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
				.setPremiumPaymentDateUnadjusted(MapperS.of(drrReport).<Date>map("getOptionPremiumPaymentDate", cSATransactionReport -> cSATransactionReport.getOptionPremiumPaymentDate()).get())
				.setPrice1Price(MapperC.<BigDecimal>of(MapperS.of(drrReport).<PriceFormat>map("getPrice", cSATransactionReport -> cSATransactionReport.getPrice()).<BigDecimal>map("getDecimal", priceFormat -> priceFormat.getDecimal()), MapperS.of(drrReport).<PriceFormat>map("getPrice", cSATransactionReport -> cSATransactionReport.getPrice()).<BigDecimal>map("getDecimal", priceFormat -> priceFormat.getDecimal())).get())
				.setPrice1Units(MapperS.of(drrReport).<String>map("getPriceUnitOfMeasure", cSATransactionReport -> cSATransactionReport.getPriceUnitOfMeasure()).get())
				.setPriorUtiId(MapperS.of(drrReport).<String>map("getPriorUTI", cSATransactionReport -> cSATransactionReport.getPriorUTI()).get())
				.setQuantityFrequencyMultiplierLeg1((integer5 == null ? null : BigDecimal.valueOf(integer5)))
				.setQuantityFrequencyMultiplierLeg2((integer6 == null ? null : BigDecimal.valueOf(integer6)))
				.setResetFrequencyPeriod1(MapperS.of(drrReport).<CommonLeg>map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<FrequencyPeriodEnum>map("getFloatingRateResetFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRateResetFrequencyPeriod()).map("to-string", FrequencyPeriodEnum::toDisplayString).get())
				.setResetFrequencyPeriodMultiplier1((integer7 == null ? null : BigDecimal.valueOf(integer7)))
				.setSellerPayer2(MapperS.of(drrReport).<String>map("getSellerIdentifier", cSATransactionReport -> cSATransactionReport.getSellerIdentifier()).get())
				.setSettlementCurrency1(MapperS.of(drrReport).<CommonLeg>map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).<ISOCurrencyCodeEnum>map("getSettlementCurrency", commonLeg -> commonLeg.getSettlementCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
				.setStrikePrice(ifThenElseResult2)
				.setStrikePriceCurrency(ifThenElseResult3)
				.setCdeStrikePriceCurrency2(ifThenElseResult4)
				.setCdeStrikePriceNotation(MapperS.of(getNotationString.evaluate(thenArg3.get())).get())
				.setSettlementType(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).<String>map("getSettlementType", dTCCAdditionalFields -> dTCCAdditionalFields.getSettlementType()).get())
				.setLeg1CommodityInstrumentId(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).<String>map("getLeg1CommodityInstrumentID", dTCCAdditionalFields -> dTCCAdditionalFields.getLeg1CommodityInstrumentID()).get())
				.setLeg2CommodityInstrumentId(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).<String>map("getLeg2CommodityInstrumentID", dTCCAdditionalFields -> dTCCAdditionalFields.getLeg2CommodityInstrumentID()).get())
				.setLeg1FloatingRateIndex(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).<String>map("getLeg1FloatingRateIndex", dTCCAdditionalFields -> dTCCAdditionalFields.getLeg1FloatingRateIndex()).get())
				.setLeg2FloatingRateIndex(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).<String>map("getLeg2FloatingRateIndex", dTCCAdditionalFields -> dTCCAdditionalFields.getLeg2FloatingRateIndex()).get())
				.setLeg1CommodityUnderlyerId(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).<String>map("getLeg1CommodityUnderlyerID", dTCCAdditionalFields -> dTCCAdditionalFields.getLeg1CommodityUnderlyerID()).get())
				.setLeg2CommodityUnderlyerId(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).<String>map("getLeg2CommodityUnderlyerID", dTCCAdditionalFields -> dTCCAdditionalFields.getLeg2CommodityUnderlyerID()).get())
				.setResponsibleDataSubmitterId(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).<String>map("getResponsibleDataSubmitterID", dTCCAdditionalFields -> dTCCAdditionalFields.getResponsibleDataSubmitterID()).get())
				.setResponsibleDataSubmitterIdType(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).<PartyIdentifierTypeEnum>map("getResponsibleDataSubmitterIDType", dTCCAdditionalFields -> dTCCAdditionalFields.getResponsibleDataSubmitterIDType()).map("to-string", PartyIdentifierTypeEnum::toDisplayString).get())
				.setSecondaryAssetClass(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).<AssetClassEnum>map("getSecondaryAssetClass", dTCCAdditionalFields -> dTCCAdditionalFields.getSecondaryAssetClass()).map("to-string", AssetClassEnum::toDisplayString).get())
				.setTradeParty1BrokerIdType(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).<PartyIdentifierTypeEnum>map("getTradeParty1BrokerIDType", dTCCAdditionalFields -> dTCCAdditionalFields.getTradeParty1BrokerIDType()).map("to-string", PartyIdentifierTypeEnum::toDisplayString).get())
				.setTradeParty1BrokerId(MapperS.of(drrReport).<String>map("getBrokerIdentifier", cSATransactionReport -> cSATransactionReport.getBrokerIdentifier()).get())
				.setExpirationDateUnadjusted(MapperS.of(drrReport).<Date>map("getExpirationDate", cSATransactionReport -> cSATransactionReport.getExpirationDate()).get())
				.setLeg2SpreadAmount(MapperC.<BigDecimal>of(MapperS.of(drrReport).<CommonLeg>map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).<PriceFormat>map("getSpread", commonLeg -> commonLeg.getSpread()).<BigDecimal>map("getMonetary", priceFormat -> priceFormat.getMonetary()), MapperS.of(drrReport).<CommonLeg>map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).<PriceFormat>map("getSpread", commonLeg -> commonLeg.getSpread()).<BigDecimal>map("getDecimal", priceFormat -> priceFormat.getDecimal()), MapperS.of(drrReport).<CommonLeg>map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).<PriceFormat>map("getSpread", commonLeg -> commonLeg.getSpread()).<BigDecimal>map("getPercentage", priceFormat -> priceFormat.getPercentage()), MapperS.of(drrReport).<CommonLeg>map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).<PriceFormat>map("getSpread", commonLeg -> commonLeg.getSpread()).<BigDecimal>map("getBasis", priceFormat -> priceFormat.getBasis())).get())
				.setLeg1PartyPayer(MapperS.of(drrReport).<String>map("getPayerIdentifierLeg1", cSATransactionReport -> cSATransactionReport.getPayerIdentifierLeg1()).get())
				.setLeg2PartyPayer(MapperS.of(drrReport).<String>map("getPayerIdentifierLeg2", cSATransactionReport -> cSATransactionReport.getPayerIdentifierLeg2()).get())
				.setSdMspIndicatorCounterparty1(null)
				.setSdMspIndicatorCounterparty2(null)
				.setPhysicalCommodityContractIndicator(null)
				.setCdeCryptoAssetUnderlyingIndicatorLeg1(MapperS.of(drrReport).<Boolean>map("getCryptoAssetUnderlyingIndicatorLeg1", cSATransactionReport -> cSATransactionReport.getCryptoAssetUnderlyingIndicatorLeg1()).get())
				.setCdeCryptoAssetUnderlyingIndicatorLeg2(MapperS.of(drrReport).<Boolean>map("getCryptoAssetUnderlyingIndicatorLeg2", cSATransactionReport -> cSATransactionReport.getCryptoAssetUnderlyingIndicatorLeg2()).get())
				.setCdeCustomBasketCode(MapperS.of(drrReport).<String>map("getCustomBasketCode", cSATransactionReport -> cSATransactionReport.getCustomBasketCode()).get())
				.setUnderlierIdOtherLeg1(MapperS.of(drrReport).<String>map("getUnderlierIDOtherLeg1", cSATransactionReport -> cSATransactionReport.getUnderlierIDOtherLeg1()).get())
				.setUnderlierIdOtherLeg2(MapperS.of(drrReport).<String>map("getUnderlierIDOtherLeg2", cSATransactionReport -> cSATransactionReport.getUnderlierIDOtherLeg2()).get())
				.setUnderlierIdOtherSourceLeg1(MapperS.of(drrReport).<String>map("getUnderlierIDOtherSourceLeg1", cSATransactionReport -> cSATransactionReport.getUnderlierIDOtherSourceLeg1()).map("to-string", Object::toString).get())
				.setUnderlierIdOtherSourceLeg2(MapperS.of(drrReport).<String>map("getUnderlierIDOtherSourceLeg2", cSATransactionReport -> cSATransactionReport.getUnderlierIDOtherSourceLeg2()).map("to-string", Object::toString).get())
				.setCdeUnderlyingAssetTradingPlatformIdLeg1(MapperS.of(drrReport).<String>map("getUnderlyingAssetTradingPlatformIdentifierLeg1", cSATransactionReport -> cSATransactionReport.getUnderlyingAssetTradingPlatformIdentifierLeg1()).get())
				.setCdeUnderlyingAssetTradingPlatformIdLeg2(MapperS.of(drrReport).<String>map("getUnderlyingAssetTradingPlatformIdentifierLeg2", cSATransactionReport -> cSATransactionReport.getUnderlyingAssetTradingPlatformIdentifierLeg2()).get())
				.setCdeUnderlyingAssetPriceSourceLeg1(MapperS.of(drrReport).<String>map("getUnderlyingAssetPriceSourceLeg1", cSATransactionReport -> cSATransactionReport.getUnderlyingAssetPriceSourceLeg1()).get())
				.setCdeUnderlyingAssetPriceSourceLeg2(MapperS.of(drrReport).<String>map("getUnderlyingAssetPriceSourceLeg2", cSATransactionReport -> cSATransactionReport.getUnderlyingAssetPriceSourceLeg2()).get())
				.setTotalQuantity(ifThenElseResult5)
				.setLeg1SpreadAmount(MapperC.<BigDecimal>of(MapperS.of(drrReport).<CommonLeg>map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).<PriceFormat>map("getSpread", commonLeg -> commonLeg.getSpread()).<BigDecimal>map("getMonetary", priceFormat -> priceFormat.getMonetary()), MapperS.of(drrReport).<CommonLeg>map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).<PriceFormat>map("getSpread", commonLeg -> commonLeg.getSpread()).<BigDecimal>map("getDecimal", priceFormat -> priceFormat.getDecimal()), MapperS.of(drrReport).<CommonLeg>map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).<PriceFormat>map("getSpread", commonLeg -> commonLeg.getSpread()).<BigDecimal>map("getPercentage", priceFormat -> priceFormat.getPercentage()), MapperS.of(drrReport).<CommonLeg>map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).<PriceFormat>map("getSpread", commonLeg -> commonLeg.getSpread()).<BigDecimal>map("getBasis", priceFormat -> priceFormat.getBasis())).get())
				.setLeg2PartyReceiver(MapperS.of(drrReport).<String>map("getReceiverIdentifierLeg1", cSATransactionReport -> cSATransactionReport.getReceiverIdentifierLeg1()).get())
				.setLeg1PartyReceiver(MapperS.of(drrReport).<String>map("getReceiverIdentifierLeg2", cSATransactionReport -> cSATransactionReport.getReceiverIdentifierLeg2()).get())
				.setLeg2Quantity(MapperS.of(drrReport).<CommonLeg>map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).<BigDecimal>map("getTotalNotionalQuantity", commonLeg -> commonLeg.getTotalNotionalQuantity()).get())
				.setLoadType(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).<String>map("getLoadType", dTCCAdditionalFields -> dTCCAdditionalFields.getLoadType()).get())
				.setDeliveryLocation(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).<String>map("getDeliveryLocation", dTCCAdditionalFields -> dTCCAdditionalFields.getDeliveryLocation()).get())
				.setUnderlyingAssetExchangeId(distinct(MapperC.<String>of(MapperS.of(drrReport).<String>map("getUnderlyingAssetTradingPlatformIdentifierLeg1", cSATransactionReport -> cSATransactionReport.getUnderlyingAssetTradingPlatformIdentifierLeg1()), MapperS.of(drrReport).<String>map("getUnderlyingAssetTradingPlatformIdentifierLeg2", cSATransactionReport -> cSATransactionReport.getUnderlyingAssetTradingPlatformIdentifierLeg2()))).get())
				.setExchangeRateBasisCurrency1(subString.evaluate(MapperS.of(drrReport).<String>map("getExchangeRateBasisLeg1", cSATransactionReport -> cSATransactionReport.getExchangeRateBasisLeg1()).get(), 1, 3))
				.setExchangeRateBasisCurrency2(subString.evaluate(MapperS.of(drrReport).<String>map("getExchangeRateBasisLeg1", cSATransactionReport -> cSATransactionReport.getExchangeRateBasisLeg1()).get(), 5, 3))
				.setUnderlyingProductId(MapperS.of(drrReport).<UnderlyingIdentifier>map("getUnderlying", cSATransactionReport -> cSATransactionReport.getUnderlying()).<String>map("getUnderlyingIdentification", underlyingIdentifier -> underlyingIdentifier.getUnderlyingIdentification()).get())
				.setExpirationDate(MapperS.of(drrReport).<Date>map("getExpirationDate", cSATransactionReport -> cSATransactionReport.getExpirationDate()).get())
				.setVersion(ifThenElseResult6)
				.setComment1(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).<String>map("getComment1", dTCCAdditionalFields -> dTCCAdditionalFields.getComment1()).get())
				.setDayCountFraction1(MapperC.<String>of(MapperS.of(drrReport).<CommonLeg>map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<InterestComputationMethod4Code>map("getFixedRateDayCountConvention", commonPeriodicPayment -> commonPeriodicPayment.getFixedRateDayCountConvention()).map("to-string", InterestComputationMethod4Code::toDisplayString), MapperS.of(drrReport).<CommonLeg>map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<InterestComputationMethod4Code>map("getFloatingRateDayCountConvention", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRateDayCountConvention()).map("to-string", InterestComputationMethod4Code::toDisplayString)).get())
				.setLeg2DayCountFraction(MapperC.<String>of(MapperS.of(drrReport).<CommonLeg>map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<InterestComputationMethod4Code>map("getFixedRateDayCountConvention", commonPeriodicPayment -> commonPeriodicPayment.getFixedRateDayCountConvention()).map("to-string", InterestComputationMethod4Code::toDisplayString), MapperS.of(drrReport).<CommonLeg>map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<InterestComputationMethod4Code>map("getFloatingRateDayCountConvention", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRateDayCountConvention()).map("to-string", InterestComputationMethod4Code::toDisplayString)).get())
				.setExecutionVenueId(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).<String>map("getExecutionVenueID", dTCCAdditionalFields -> dTCCAdditionalFields.getExecutionVenueID()).get())
				.setExecutionVenueIdType(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).<PartyIdentifierTypeEnum>map("getExecutionVenueIDType", dTCCAdditionalFields -> dTCCAdditionalFields.getExecutionVenueIDType()).map("to-string", PartyIdentifierTypeEnum::toDisplayString).get())
				.setMasterAgreementType(MapperS.of(drrReport).<String>map("getMasterAgreementType", cSATransactionReport -> cSATransactionReport.getMasterAgreementType()).get())
				.setMasterAgreementVersion(MapperS.of(drrReport).<Integer>map("getMasterAgreementVersion", cSATransactionReport -> cSATransactionReport.getMasterAgreementVersion()).map("to-string", Object::toString).get())
				.setClearingDatetime(null)
				.setMaturityDateOfTheUnderlying(MapperS.of(drrReport).<Date>map("getMaturityDateOfTheUnderlying", cSATransactionReport -> cSATransactionReport.getMaturityDateOfTheUnderlying()).get())
				.setProductIdentification(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).<String>map("getProductID", dTCCAdditionalFields -> dTCCAdditionalFields.getProductID()).get())
				.setLevel(MapperS.of(drrReport).<ReportLevelEnum>map("getLevel", cSATransactionReport -> cSATransactionReport.getLevel()).map("to-string", ReportLevelEnum::toDisplayString).get())
				.setExecutionVenueMicCode(MapperS.of(drrReport).<String>map("getPlatformIdentifier", cSATransactionReport -> cSATransactionReport.getPlatformIdentifier()).get())
				.setAllocationType(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).<String>map("getAllocationType", dTCCAdditionalFields -> dTCCAdditionalFields.getAllocationType()).get())
				.setFloatingRatePaymentFrequencyLeg1Multiplier((integer8 == null ? null : BigDecimal.valueOf(integer8)))
				.setFloatingRatePaymentFrequencyLeg1TimePeriod(MapperS.of(drrReport).<CommonLeg>map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<FrequencyPeriodEnum>map("getFloatingRatePaymentFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRatePaymentFrequencyPeriod()).map("to-string", FrequencyPeriodEnum::toDisplayString).get())
				.setFloatingRatePaymentFrequencyLeg2Multiplier((integer9 == null ? null : BigDecimal.valueOf(integer9)))
				.setFloatingRatePaymentFrequencyLeg2TimePeriod(MapperS.of(drrReport).<CommonLeg>map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<FrequencyPeriodEnum>map("getFloatingRatePaymentFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRatePaymentFrequencyPeriod()).map("to-string", FrequencyPeriodEnum::toDisplayString).get())
				.setInteraffiliate(MapperS.of(drrReport).<Boolean>map("getInterAffiliateIndicator", cSATransactionReport -> cSATransactionReport.getInterAffiliateIndicator()).get())
				.setLeg2PaymentTermsFrequencyPeriod(distinct(MapperC.<String>of(MapperS.of(drrReport).<CommonLeg>map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<FrequencyPeriodEnum>map("getFloatingRatePaymentFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRatePaymentFrequencyPeriod()).map("to-string", FrequencyPeriodEnum::toDisplayString), MapperS.of(drrReport).<CommonLeg>map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<FrequencyPeriodEnum>map("getFixedRatePaymentFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFixedRatePaymentFrequencyPeriod()).map("to-string", FrequencyPeriodEnum::toDisplayString))).get())
				.setLeg2PaymentTermsPaymentFrequencyPeriodMultiplier((integer10 == null ? null : BigDecimal.valueOf(integer10)))
				.setMaturityDate(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).<Date>map("getMaturityDateOfTheUnderlying", dTCCAdditionalFields -> dTCCAdditionalFields.getMaturityDateOfTheUnderlying()).get())
				.setOriginalSwapSdrId(null)
				.setOriginalSwapSdrIdType(null)
				.setPaymentFrequencyPeriodLeg1(MapperC.<String>of(MapperS.of(drrReport).<CommonLeg>map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<FrequencyPeriodEnum>map("getFixedRatePaymentFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFixedRatePaymentFrequencyPeriod()).map("to-string", FrequencyPeriodEnum::toDisplayString), MapperS.of(drrReport).<CommonLeg>map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<FrequencyPeriodEnum>map("getFloatingRatePaymentFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRatePaymentFrequencyPeriod()).map("to-string", FrequencyPeriodEnum::toDisplayString)).get())
				.setPaymentFrequencyPeriodLeg2(MapperC.<String>of(MapperS.of(drrReport).<CommonLeg>map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<FrequencyPeriodEnum>map("getFixedRatePaymentFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFixedRatePaymentFrequencyPeriod()).map("to-string", FrequencyPeriodEnum::toDisplayString), MapperS.of(drrReport).<CommonLeg>map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<FrequencyPeriodEnum>map("getFloatingRatePaymentFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRatePaymentFrequencyPeriod()).map("to-string", FrequencyPeriodEnum::toDisplayString)).get())
				.setPaymentFrequencyPeriodMultiplierLeg1((integer11 == null ? null : BigDecimal.valueOf(integer11)))
				.setPaymentFrequencyPeriodMultiplierLeg2((integer12 == null ? null : BigDecimal.valueOf(integer12)))
				.setOriginalSwapUsi(null)
				.setOriginalSwapUti(null)
				.setCounterparty1FederalEntityIndicator(null)
				.setCounterparty2FederalEntityIndicator(null)
				.setEventIdentifier(MapperS.of(drrReport).<String>map("getEventIdentifier", cSATransactionReport -> cSATransactionReport.getEventIdentifier()).get())
				.setPackageIndicator(MapperS.of(drrReport).<Boolean>map("getPackageIndicator", cSATransactionReport -> cSATransactionReport.getPackageIndicator()).get())
				.setCdePackageIdentifier(MapperS.of(drrReport).<String>map("getPackageIdentifier", cSATransactionReport -> cSATransactionReport.getPackageIdentifier()).get())
				.setCdePackageTransactionPrice(MapperC.<BigDecimal>of(MapperS.of(drrReport).<PriceFormat>map("getPackageTransactionPrice", cSATransactionReport -> cSATransactionReport.getPackageTransactionPrice()).<BigDecimal>map("getMonetary", priceFormat -> priceFormat.getMonetary()), MapperS.of(drrReport).<PriceFormat>map("getPackageTransactionPrice", cSATransactionReport -> cSATransactionReport.getPackageTransactionPrice()).<BigDecimal>map("getDecimal", priceFormat -> priceFormat.getDecimal()), MapperS.of(drrReport).<PriceFormat>map("getPackageTransactionPrice", cSATransactionReport -> cSATransactionReport.getPackageTransactionPrice()).<BigDecimal>map("getPercentage", priceFormat -> priceFormat.getPercentage()), MapperS.of(drrReport).<PriceFormat>map("getPackageTransactionPrice", cSATransactionReport -> cSATransactionReport.getPackageTransactionPrice()).<BigDecimal>map("getBasis", priceFormat -> priceFormat.getBasis())).get())
				.setCdePackageTransactionPriceCurrency(MapperS.of(drrReport).<ISOCurrencyCodeEnum>map("getPackageTransactionPriceCurrency", cSATransactionReport -> cSATransactionReport.getPackageTransactionPriceCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
				.setCdePackageTransactionPriceNotation(MapperS.of(drrReport).<PriceNotationEnum>map("getPackageTransactionPriceNotation", cSATransactionReport -> cSATransactionReport.getPackageTransactionPriceNotation()).map("to-string", PriceNotationEnum::toDisplayString).get())
				.setCdePackageTransactionSpread(MapperC.<BigDecimal>of(MapperS.of(drrReport).<PriceFormat>map("getPackageTransactionSpread", cSATransactionReport -> cSATransactionReport.getPackageTransactionSpread()).<BigDecimal>map("getMonetary", priceFormat -> priceFormat.getMonetary()), MapperS.of(drrReport).<PriceFormat>map("getPackageTransactionSpread", cSATransactionReport -> cSATransactionReport.getPackageTransactionSpread()).<BigDecimal>map("getDecimal", priceFormat -> priceFormat.getDecimal()), MapperS.of(drrReport).<PriceFormat>map("getPackageTransactionSpread", cSATransactionReport -> cSATransactionReport.getPackageTransactionSpread()).<BigDecimal>map("getPercentage", priceFormat -> priceFormat.getPercentage()), MapperS.of(drrReport).<PriceFormat>map("getPackageTransactionSpread", cSATransactionReport -> cSATransactionReport.getPackageTransactionSpread()).<BigDecimal>map("getBasis", priceFormat -> priceFormat.getBasis())).get())
				.setCdePackageTransactionSpreadNotation(MapperS.of(drrReport).<PriceNotationEnum>map("getPackageTransactionSpreadNotation", cSATransactionReport -> cSATransactionReport.getPackageTransactionSpreadNotation()).map("to-string", PriceNotationEnum::toDisplayString).get())
				.setPostPricedSwapIndicator(null)
				.setPrimeBrokerageTransactionIndicator(null)
				.setSwapReportingJurisdiction(null)
				.setInitialMarginCollateralPortfolioCode(MapperS.of(drrReport).<String>map("getInitialMarginCollateralPortfolioCode", cSATransactionReport -> cSATransactionReport.getInitialMarginCollateralPortfolioCode()).get())
				.setVariationMarginCollateralPortfolioCode(MapperS.of(drrReport).<String>map("getVariationMarginCollateralPortfolioCode", cSATransactionReport -> cSATransactionReport.getVariationMarginCollateralPortfolioCode()).get())
				.setLargeNotionalOffFacilitySwapElectionIndicator(null)
				.setSefOrDcmAnonymousExecutionIndicator(MapperS.of(drrReport).<Boolean>map("getPlatformAnonymousExecutionIndicator", cSATransactionReport -> cSATransactionReport.getPlatformAnonymousExecutionIndicator()).get())
				.setBlockTradeElectionIndicator(null)
				.setSefOrDcmIndicator(null)
				.setMandatoryClearingIndicator(null)
				.setPriorUsiId(MapperS.of(drrReport).<String>map("getPriorUSI", cSATransactionReport -> cSATransactionReport.getPriorUSI()).get())
				.setContractType(MapperS.of(drrReport).<CommonContractType>map("getContractType", cSATransactionReport -> cSATransactionReport.getContractType()).map("to-string", CommonContractType::toDisplayString).get())
				.setPayment1FrequencyPeriod(MapperC.<String>of(MapperS.of(drrReport).<CommonLeg>map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<FrequencyPeriodEnum>map("getFloatingRatePaymentFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRatePaymentFrequencyPeriod()).map("to-string", FrequencyPeriodEnum::toDisplayString), MapperS.of(drrReport).<CommonLeg>map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<FrequencyPeriodEnum>map("getFixedRatePaymentFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFixedRatePaymentFrequencyPeriod()).map("to-string", FrequencyPeriodEnum::toDisplayString)).get())
				.setPayment1FrequencyPeriodMultiplier((integer13 == null ? null : BigDecimal.valueOf(integer13)))
				.setPayment2FrequencyPeriod(MapperC.<String>of(MapperS.of(drrReport).<CommonLeg>map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<FrequencyPeriodEnum>map("getFloatingRatePaymentFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFloatingRatePaymentFrequencyPeriod()).map("to-string", FrequencyPeriodEnum::toDisplayString), MapperS.of(drrReport).<CommonLeg>map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).<CommonPeriodicPayment>map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).<FrequencyPeriodEnum>map("getFixedRatePaymentFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFixedRatePaymentFrequencyPeriod()).map("to-string", FrequencyPeriodEnum::toDisplayString)).get())
				.setPayment2FrequencyPeriodMultiplier((integer14 == null ? null : BigDecimal.valueOf(integer14)))
				.setPayment1Amount(MapperS.of(drrReport).<CommonLeg>map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).<BigDecimal>map("getNotionalAmount", commonLeg -> commonLeg.getNotionalAmount()).get())
				.setPayment1Currency(MapperS.of(drrReport).<CommonLeg>map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).<ISOCurrencyCodeEnum>map("getNotionalCurrency", commonLeg -> commonLeg.getNotionalCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
				.setPayment2Amount(MapperS.of(drrReport).<CommonLeg>map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).<BigDecimal>map("getNotionalAmount", commonLeg -> commonLeg.getNotionalAmount()).get())
				.setCurrencyOfPrice(MapperS.of(drrReport).<ISOCurrencyCodeEnum>map("getPriceCurrency", cSATransactionReport -> cSATransactionReport.getPriceCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
				.setPayment2Currency(MapperS.of(drrReport).<CommonLeg>map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).<ISOCurrencyCodeEnum>map("getNotionalCurrency", commonLeg -> commonLeg.getNotionalCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
				.setPrice1Currency(MapperS.of(drrReport).<ISOCurrencyCodeEnum>map("getPriceCurrency", cSATransactionReport -> cSATransactionReport.getPriceCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
				.setLeg2CommodityUnitOfMeasure(ifThenElseResult7)
				.setLeg2NotionalQuantityFrequency(MapperS.of(drrReport).<CommonLeg>map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).<FrequencyPeriodEnum>map("getQuantityFrequency", commonLeg -> commonLeg.getQuantityFrequency()).map("to-string", FrequencyPeriodEnum::toDisplayString).get())
				.setLeg1CommodityUnitOfMeasure(ifThenElseResult8)
				.setLeg1NotionalQuantityUnit(MapperS.of(drrReport).<String>map("getQuantityUnitOfMeasureLeg1", cSATransactionReport -> cSATransactionReport.getQuantityUnitOfMeasureLeg1()).get())
				.setLeg1NotionalQuantityFrequency(MapperS.of(drrReport).<CommonLeg>map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).<FrequencyPeriodEnum>map("getQuantityFrequency", commonLeg -> commonLeg.getQuantityFrequency()).map("to-string", FrequencyPeriodEnum::toDisplayString).get())
				.setLeg2NotionalQuantityUnit(MapperS.of(drrReport).<String>map("getQuantityUnitOfMeasureLeg2", cSATransactionReport -> cSATransactionReport.getQuantityUnitOfMeasureLeg2()).get())
				.setLeg2QuantityUnit(MapperS.of(drrReport).<String>map("getQuantityUnitOfMeasureLeg2", cSATransactionReport -> cSATransactionReport.getQuantityUnitOfMeasureLeg2()).get())
				.setSettlementDateUnadjusted(null)
				.setAttachmentPoint(MapperS.of(drrReport).<BigDecimal>map("getCdSIndexAttachmentPoint", cSATransactionReport -> cSATransactionReport.getCdSIndexAttachmentPoint()).get())
				.setExhaustionPoint(MapperS.of(drrReport).<BigDecimal>map("getCdSIndexDetachmentPoint", cSATransactionReport -> cSATransactionReport.getCdSIndexDetachmentPoint()).get())
				.setCrversion(null)
				.setSettlementFixingDate(null)
				.setForwardExchangeRate(null)
				.setSettlementDate(null)
				.setCcpValuationAmount(null)
				.setCcpValuationCurrency(null)
				.setCcpValuationDatetime(null)
				.setCcpValuationType(null)
				.setEuUnderlyingAssetIdType(null)
				.setProductClassification(null)
				.setQuantity(null)
				.setConfirmationDatetime(null)
				.setEuUnderlyingAssetId(null)
				.setReportTrackingNumber(null)
				.setIntragroupIndicator(null)
				.setClearingExceptionPartyId(null)
				.setClearingExceptionPartyIdType(null)
				.setClearingExceptionType(null)
				.setTradeParty1CftcFinancialEntityStatus(null)
				.setTradeParty2CftcFinancialEntityStatus(null)
				.setCdeCallAmountLeg2(null)
				.setCdeCallCurrencyLeg2(null)
				.setCdePutAmountLeg2(null)
				.setCdePutCurrencyLeg2(null)
				.setCdeSettlementLocationLeg2(null)
				.setChangeInNotionalAmount1(null)
				.setChangeInNotionalAmount2(null)
				.setLeg2CommodityUnderlyerDetails(null)
				.setLeg2CommodityCurrency(null)
				.setLeg2CommodityExchangeId(null)
				.setLeg1CommodityRateSource(null)
				.setLeg1CommodityRateSourcePage(null)
				.setLeg2SpecifiedPrice(null)
				.setCommencementDateUnadjusted(null)
				.setExerciseExpirationDateUnadjusted(null)
				.setScheduledTerminationDateAdjusted(null)
				.setLeg1CommodityExchangeId(null)
				.setLeg2CommodityRateSource(null)
				.setLeg1EffectiveDateUnadjusted(null)
				.setLeg2EffectiveDateUnadjusted(null)
				.setCoProductType(null)
				.setTotalQuantityUnit(null)
				.setFixedPrice(null)
				.setFixedPriceCurrency(null)
				.setLeg1CommodityCurrency(null)
				.setLeg1SpecifiedPrice(null)
				.setCoalSource(null)
				.setCommodityBase(null)
				.setCommodityDetails(null)
				.setInterconnectionPoint(null)
				.setFixedPriceUnit(null)
				.setExercisePaymentDateUnadjusted(null)
				.setLeg1PaymentDatesUnadjusted(null)
				.setLeg2PaymentDateUnadjusted(null)
				.setLeg1CommodityUnderlyerDetails(null)
				.setLeg2CommodityRateSourcePage(null)
				.setValueDate(null)
				.setGtrQuantityUnit(null)
				.setMthToDefault(null)
				.setNthToDefault(null)
				.setSeniority(null)
				.setSeries(null)
				.setTranche(null)
				.setReferenceObligation(null)
				.setReferenceObligationIdType(null)
				.setUnderlyingFixedRatePayerBuyer(null)
				.setUnderlyingFloatRatePayerSeller(null)
				.setUnderlyingAssetNumberOfUnits(null)
				.setOptionalEarlyTerminationType(null)
				.setOptionalEarlyTerminationElectingPartyValue(null)
				.setOptionalEarlyTerminationIndicator(null)
				.setUnderlyingAssetFloatingAmountPayer(null)
				.setUnderlyingAssetFloatingAmountReceiver(null)
				.setFloatingRateOption(null)
				.setUnderlyingAssetFloatingLegSpread(null)
				.setLeg2DesignatedMaturityPeriod(null)
				.setLeg2DesignatedMaturityPeriodMultiplier(null)
				.setUnderlyingAssetEquityAmountPayer(null)
				.setUnderlyingAssetEquityAmountReceiver(null)
				.setUnderlyingAssetInitialPriceCurrency(null)
				.setLeg1ValuationDates(null)
				.setLeg1TypeOfReturn(null)
				.setObservationStartDate(null)
				.setVarianceAmount(null)
				.setVolatilityStrikePrice(null)
				.setVarianceStrikePrice(null)
				.setVarianceCapFactor(null)
				.setReferenceCurrency(null)
				.setSpecialDividendsIndicator(null)
				.setMaterialNoncashDividendIndicator(null)
				.setNumberOfSharesUnits(null)
				.setDividendAmountPayer(null)
				.setDividendAmountReceiver(null)
				.setFixedAmountPayer(null)
				.setFixedAmountReceiver(null)
				.setKnockInEvent(null)
				.setKnockOutEvent(null)
				.setKnockInPrice(null)
				.setKnockOutPrice(null)
				.setBarrierType(null)
				.setEarliestExecutionTime(null)
				.setExecutionPeriodStartDate(null)
				.setPayoutStyle(null)
				.setRateQuoteBasis1(null)
				.setSwapLinkId(null)
				.setTriggerCondition(null)
				.setTriggerCondition2(null)
				.setTriggerRate(null)
				.setTriggerRate2(null)
				.setRateQuoteBasis2(null)
				.setBarrierType2(null)
				.setCancelationOptionBuyer(null)
				.setCancelationOptionCommencementDate(null)
				.setCancelationOptionExerciseStyleType(null)
				.setCancelationOptionExpirationDate(null)
				.setCancelationOptionInitialFeeCurrency(null)
				.setCancelationOptionInitialFeePayer(null)
				.setCancelationOptionPremiumAmount(null)
				.setCancelationOptionSeller(null)
				.setCapRateInitial(null)
				.setCouponType(null)
				.setFinalPrincipalExchangeIndicatorAtTermination(null)
				.setFloorRateInitial(null)
				.setFraDiscountingType(null)
				.setInflationIndexInitialLevel(null)
				.setInflationIndexMainPublication(null)
				.setInflationInterpolationMethod(null)
				.setInflationLagDayType(null)
				.setInflationLagPeriod(null)
				.setInflationRateSourceName(null)
				.setInitialPrincipalExchangeIndicator(null)
				.setIntermediatePrincipalExchangeIndicator(null)
				.setLeg1FloatingRateInitialSpread(null)
				.setLeg1FloatingRateMultiplierInitialValue(null)
				.setLeg1FloatingRateTenorPeriod(null)
				.setLeg1FloatingRateTenorPeriodMultiplier(null)
				.setLeg1KnownAmount(null)
				.setLeg1KnownAmountCurrency(null)
				.setLeg1ReferenceCurrency(null)
				.setLeg2FloatingRateInitialSpread(null)
				.setLeg2FloatingRateMultiplierInitialValue(null)
				.setLeg2FloatingRateTenorPeriod(null)
				.setLeg2FloatingRateTenorPeriodMultiplier(null)
				.setLeg2KnownAmount(null)
				.setLeg2KnownAmountCurrency(null)
				.setLeg2ReferenceCurrency(null)
				.setMandatoryEarlyTerminationDate(null)
				.setMandatoryEarlyTerminationDateTenorPeriod(null)
				.setMandatoryEarlyTerminationDateTenorPeriodMultiplier(null)
				.setNotionalUnits(null)
				.setOptionalEarlyTerminationCommencementDate(null)
				.setOptionalEarlyTerminationExerciseStyle(null)
				.setOptionalEarlyTerminationExpirationDate(null)
				.setPremiumReceiver(null)
				.setUnderlyingCouponRate(null)
				.setUnderlyingMaturityDate(null)
				.setInflationLagPeriodMultiplier(null)
				.setLeg1FixedRateNotation(null)
				.setLeg2FixedRateNotation(null)
				.setSwaptionStraddleIndicator(null)
				.setSinglePartyEarlyTerminationBuyer(null)
				.setLeg1EffectiveDate(null)
				.setAction(null)
				.setEffectiveDate1(null)
				.setExecutionVenueType(null)
				.setPrice1Type(null)
				.setScheduledTerminationDate1(null)
				.setTradeDate(null)
				.setTradeParty1CollateralizationType(null)
				.setTradeParty1EventId(null)
				.setTradeParty2CollateralizationType(null)
				.setTradeParty2EventId(null)
				.setEmbeddedOptionOnSwap(MapperS.of(drrReport).<EmbeddedOptionTypeEnum>map("getEmbeddedOptionType", cSATransactionReport -> cSATransactionReport.getEmbeddedOptionType()).map("to-string", EmbeddedOptionTypeEnum::toDisplayString).get())
				.setCommencementDate(null)
				.setLeg2EffectiveDate(null)
				.setLeg2ScheduledTerminationDate(null)
				.setNumberOfOptions(null)
				.setOptionEntitlement(null)
				.setPayment1Date(null)
				.setPayment2Date(null)
				.setStrikePriceUnits(null)
				.setAsOfDateTime(null)
				.setCompressedTradeIndicator(null)
				.setConfirmationMethod(null)
				.setConfirmationPlatformId(null)
				.setConfirmationPlatformTradeId(null)
				.setPostTradeEffectiveDate(null)
				.setPriorUsiIdPrefix(null)
				.setPriorUtiIdPrefix(null)
				.setTradeParty1BranchLocation(null)
				.setTradeParty1DeskLocation(null)
				.setTradeParty1Domicile(null)
				.setTradeParty1IndustrialSectorType(null)
				.setTradeParty2BranchLocation(null)
				.setTradeParty2DeskLocation(null)
				.setTradeParty2Domicile(null)
				.setTradeParty2IndustrialSectorType(null)
				.setTradeParty1HkCounterpartyOrigin(null)
				.setLeg2SettlementDate(null)
				.setPostTradeTransactionDate(null)
				.setTradeParty1Name(null)
				.setTradeParty2Name(null)
				.setTradeParty1ValuationAmount(null)
				.setTradeParty1ValuationCurrency(null)
				.setTradeParty1ValuationDatetime(null)
				.setTradeParty1ValuationType(null)
				.setTradeParty2ValuationAmount(null)
				.setTradeParty2ValuationCurrency(null)
				.setTradeParty2ValuationDatetime(null)
				.setTradeParty2ValuationType(null)
				.setExecutionType(null)
				.setTradeParty2HkCounterpartyOrigin(null)
				.setTradeParty1CountryOfTheOtherCounterparty(null)
				.setTradeParty2CountryOfTheOtherCounterparty(MapperS.of(drrReport).<String>map("getCountryAndProvinceOrTerritoryOfIndividual", cSATransactionReport -> cSATransactionReport.getCountryAndProvinceOrTerritoryOfIndividual()).get())
				.setTradeParty2BrokerId(null)
				.setTradeParty1BeneficiaryIdType(null)
				.setTradeParty1BeneficiaryId(null)
				.setTradeParty2BeneficiaryIdType(null)
				.setTradeParty2BeneficiaryId(null)
				.setTradeParty1CounterpartySide(null)
				.setTradeParty2CounterpartySide(null)
				.setTradeParty1CollateralPortfolioCode(null)
				.setTradeParty2CollateralPortfolioCode(null)
				.setComplexTradeComponentId(null)
				.setPriceMultiplier(null)
				.setProductClassificationType(null)
				.setProductIdentificationType(null)
				.setTradeParty2BrokerIdType(null)
				.setTradeParty2ClearingBrokerIdType(null)
				.setTradeParty2ClearingBrokerId(null)
				.setTradeParty1ClearingThreshold(null)
				.setTradeParty2ClearingThreshold(null)
				.setTradeParty1CorporateSectorType(null)
				.setTradeParty2CorporateSectorType(null)
				.setTradeParty1DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator(null)
				.setTradeParty2DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator(null)
				.setTradeParty1TradingCapacity1(null)
				.setTradeParty2TradingCapacity1(null)
				.setTradeParty1CollateralPortfolio(null)
				.setTradeParty2CollateralPortfolio(null)
				.setExpirationDateTimeBusinessCenter(null)
				.setExpirationTime(null)
				.setExpirationTimeType(null)
				.setTradeParty1TraderLocation(null)
				.setTradeParty2TraderLocation(null)
				.setPayment3ResetFrequencyPeriodMultiplier(null)
				.setPayment3ResetFrequencyPeriod(null)
				.setPayment4ResetFrequencyPeriodMultiplier(null)
				.setPayment4ResetFrequencyPeriod(null)
				.setPayment5ResetFrequencyPeriodMultiplier(null)
				.setPayment5ResetFrequencyPeriod(null)
				.setPayment1Type(null)
				.setPayment1Reference(null)
				.setPayment2Type(null)
				.setPayment2Reference(null)
				.setPayment3Payer(null)
				.setPayment3Reference(null)
				.setPayment3FrequencyPeriod(null)
				.setPayment3FrequencyPeriodMultiplier(null)
				.setPayment3Date(null)
				.setPayment4Reference(null)
				.setPayment4Payer(null)
				.setPayment4FrequencyPeriod(null)
				.setPayment4FrequencyPeriodMultiplier(null)
				.setPayment4Date(null)
				.setPayment5Reference(null)
				.setPayment5Payer(null)
				.setPayment5FrequencyPeriod(null)
				.setPayment5FrequencyPeriodMultiplier(null)
				.setPayment5Date(null)
				.setPayment3Type(null)
				.setPremiumPayer(null)
				.setTradeParty1NatureOfTheReportingCounterparty(null)
				.setTradeParty2NatureOfTheReportingCounterparty(null)
				.setReservedParticipantUse1(null)
				.setReservedParticipantUse2(null)
				.setReservedParticipantUse3(null)
				.setReservedParticipantUse4(null)
				.setReservedParticipantUse5(null)
				.setLeg1TerminationDate(null)
				.setCalculationBasis(null)
				.setClearingMemberClientAccountId(null)
				.setClearingReceiptDatetime(MapperS.of(drrReport).<ZonedDateTime>map("getClearingReceiptTimestamp", cSATransactionReport -> cSATransactionReport.getClearingReceiptTimestamp()).get())
				.setClearingSwapSdrLeiId(null)
				.setClearingSwapUtiId(null)
				.setCollateralReportingDate(null)
				.setCollateralValuationDatetime(null)
				.setComment2(null)
				.setCommodityStrikePriceUnit(null)
				.setExecutionAgentMaskingIndicator(null)
				.setFeeInCurrency(null)
				.setFeeOutCurrency(null)
				.setFrequencyOfPayment(null)
				.setLargeTradeIndicator(null)
				.setLeg1EffectiveDateAdjusted(null)
				.setLeg1FinalValuationDate(null)
				.setLeg1SettlementPeriod(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).<String>map("getLeg1SettlementPeriod", dTCCAdditionalFields -> dTCCAdditionalFields.getLeg1SettlementPeriod()).get())
				.setLeg2EffectiveDateAdjusted(null)
				.setLeg2SettlementType(null)
				.setLeg2UnderlyingAssetId(null)
				.setLeg2UnderlyingAssetIdType(null)
				.setLeg2UnderlyingAssetName(null)
				.setOptionalEarlyTerminationDate(null)
				.setOptionCommodityCurrency(null)
				.setOptionCommodityExchangeId(null)
				.setOptionCommodityInstrumentId(null)
				.setOptionCommodityRateSource(null)
				.setOptionCommodityRateSourcePage(null)
				.setOptionCommodityUnderlyerDetails(null)
				.setOptionCommodityUnderlyerId(null)
				.setOptionCommodityUnitOfMeasure(null)
				.setOptionSpecifiedPrice(null)
				.setOptionSpreadAmount(null)
				.setOptionSpreadCurrency(null)
				.setOptionSpreadSchedule(null)
				.setOrigin(MapperS.of(drrReport).<ClearingAccountOriginEnum>map("getClearingAccountOrigin", cSATransactionReport -> cSATransactionReport.getClearingAccountOrigin()).map("to-string", ClearingAccountOriginEnum::toDisplayString).get())
				.setPremiumPayerPrefix(null)
				.setPrice2Price(null)
				.setPrice2Type(null)
				.setPrice2Units(null)
				.setPrice3Price(null)
				.setPrice3Type(null)
				.setPrice3Units(null)
				.setPrice4Price(null)
				.setPrice4Type(null)
				.setPrice4Units(null)
				.setPricingContext(null)
				.setPriorUsiType(null)
				.setPriorUtiType(null)
				.setRecoveryPrice(null)
				.setSendToDataCenterCode(null)
				.setStrikePriceType(null)
				.setSubAssetClassForOtherCommodity(null)
				.setTradeParty1CollateralAmount(null)
				.setTradeParty1CollateralCurrency(null)
				.setTradeParty1MandatoryDelegatedReporting(null)
				.setTradeParty1Role(null)
				.setTradeParty2CollateralAmount(null)
				.setTradeParty2CollateralCurrency(null)
				.setTradeParty2MandatoryDelegatedReporting(null)
				.setTradeParty2Role(null)
				.setUpfrontPayment(null)
				.setVerificationMethod(null)
				.setNextFloatingReferenceResetDateLeg1(null)
				.setLastFloatingReferenceValueLeg1(null)
				.setLastFloatingReferenceResetDateLeg1(null)
				.setNextFloatingReferenceResetDateLeg2(null)
				.setLastFloatingReferenceValueLeg2(null)
				.setLastFloatingReferenceResetDateLeg2(null)
				.setCdeDelta(null)
				.setChangeInLeg1NotionalQuantity(null)
				.setChangeInLeg2NotionalQuantity(null)
				.build());
			
			return Optional.ofNullable(harmonized)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
