package drr.projection.dtcc.rds.harmonized.csa.rewrite.trade.functions;

import cdm.base.staticdata.asset.common.AssetClassEnum;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.ClearingExceptionsAndExemptionsEnum;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.trade.CommonLeg;
import drr.regulation.common.trade.basket.BasketConstituentsReport;
import drr.regulation.csa.rewrite.dtcc.DTCCAdditionalFields;
import drr.regulation.csa.rewrite.dtcc.UnderlyingAssetNameReport;
import drr.regulation.csa.rewrite.dtcc.UnderlyingAssetReport;
import drr.regulation.csa.rewrite.trade.CSATransactionReport;
import drr.standards.iosco.cde.payment.OtherPayment;
import drr.standards.iosco.cde.price.PriceFormat;
import drr.standards.iosco.cde.price.PricePeriod;
import drr.standards.iosco.cde.quantity.NotionalPeriod;
import drr.standards.iso.PaymentType4Code;
import iso20022.dtcc.rds.harmonized.HarmonizedRepeatableData;
import iso20022.dtcc.rds.harmonized.HarmonizedRepeatableData.HarmonizedRepeatableDataBuilder;
import java.math.BigDecimal;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(Create_SubmissionHarmonizedRepeatableData.Create_SubmissionHarmonizedRepeatableDataDefault.class)
public abstract class Create_SubmissionHarmonizedRepeatableData implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;

	/**
	* @param drrReport 
	* @return harmonized 
	*/
	public HarmonizedRepeatableData evaluate(CSATransactionReport drrReport) {
		HarmonizedRepeatableData.HarmonizedRepeatableDataBuilder harmonizedBuilder = doEvaluate(drrReport);
		
		final HarmonizedRepeatableData harmonized;
		if (harmonizedBuilder == null) {
			harmonized = null;
		} else {
			harmonized = harmonizedBuilder.build();
			objectValidator.validate(HarmonizedRepeatableData.class, harmonized);
		}
		
		return harmonized;
	}

	protected abstract HarmonizedRepeatableData.HarmonizedRepeatableDataBuilder doEvaluate(CSATransactionReport drrReport);

	protected abstract MapperS<Boolean> needsUpfrontFee(CSATransactionReport drrReport);

	public static class Create_SubmissionHarmonizedRepeatableDataDefault extends Create_SubmissionHarmonizedRepeatableData {
		@Override
		protected HarmonizedRepeatableData.HarmonizedRepeatableDataBuilder doEvaluate(CSATransactionReport drrReport) {
			HarmonizedRepeatableData.HarmonizedRepeatableDataBuilder harmonized = HarmonizedRepeatableData.builder();
			return assignOutput(harmonized, drrReport);
		}
		
		protected HarmonizedRepeatableData.HarmonizedRepeatableDataBuilder assignOutput(HarmonizedRepeatableData.HarmonizedRepeatableDataBuilder harmonized, CSATransactionReport drrReport) {
			final MapperC<BasketConstituentsReport> thenArg = MapperS.of(drrReport).<BasketConstituentsReport>mapC("getBasketConstituents", cSATransactionReport -> cSATransactionReport.getBasketConstituents());
			final List<BigDecimal> ifThenElseResult0;
			if (exists(MapperS.of(drrReport).<PricePeriod>mapC("getStrikePriceSchedule", cSATransactionReport -> cSATransactionReport.getStrikePriceSchedule()).<PriceFormat>map("getPrice", pricePeriod -> pricePeriod.getPrice()).<BigDecimal>map("getMonetary", priceFormat -> priceFormat.getMonetary())).getOrDefault(false)) {
				ifThenElseResult0 = MapperS.of(drrReport).<PricePeriod>mapC("getStrikePriceSchedule", cSATransactionReport -> cSATransactionReport.getStrikePriceSchedule()).<PriceFormat>map("getPrice", pricePeriod -> pricePeriod.getPrice()).<BigDecimal>map("getMonetary", priceFormat -> priceFormat.getMonetary()).getMulti();
			} else {
				ifThenElseResult0 = MapperS.of(drrReport).<PricePeriod>mapC("getStrikePriceSchedule", cSATransactionReport -> cSATransactionReport.getStrikePriceSchedule()).<PriceFormat>map("getPrice", pricePeriod -> pricePeriod.getPrice()).<BigDecimal>map("getDecimal", priceFormat -> priceFormat.getDecimal()).getMulti();
			}
			harmonized = toBuilder(HarmonizedRepeatableData.builder()
				.setUnderlyingAssetId(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).<UnderlyingAssetReport>mapC("getUnderlyingAsset", dTCCAdditionalFields -> dTCCAdditionalFields.getUnderlyingAsset()).<String>map("getUnderlyingAssetID", underlyingAssetReport -> underlyingAssetReport.getUnderlyingAssetID()).getMulti())
				.setUnderlyingAssetIdType(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).<UnderlyingAssetReport>mapC("getUnderlyingAsset", dTCCAdditionalFields -> dTCCAdditionalFields.getUnderlyingAsset()).<String>map("getUnderlyingAssetIDType", underlyingAssetReport -> underlyingAssetReport.getUnderlyingAssetIDType()).getMulti())
				.setUnderlyingAssetName(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).<UnderlyingAssetNameReport>map("getUnderlyingAssetName", dTCCAdditionalFields -> dTCCAdditionalFields.getUnderlyingAssetName()).<String>mapC("getUnderlyingAssetName", underlyingAssetNameReport -> underlyingAssetNameReport.getUnderlyingAssetName()).getMulti())
				.setCdeOtherPaymentPayer(MapperS.of(drrReport).<OtherPayment>mapC("getOtherPayment", cSATransactionReport -> cSATransactionReport.getOtherPayment()).<String>map("getPayer", otherPayment -> otherPayment.getPayer()).getMulti())
				.setCdeOtherPaymentReceiver(MapperS.of(drrReport).<OtherPayment>mapC("getOtherPayment", cSATransactionReport -> cSATransactionReport.getOtherPayment()).<String>map("getReceiver", otherPayment -> otherPayment.getReceiver()).getMulti())
				.setCdeOtherPaymentAmount(MapperS.of(drrReport).<OtherPayment>mapC("getOtherPayment", cSATransactionReport -> cSATransactionReport.getOtherPayment()).<BigDecimal>map("getAmount", otherPayment -> otherPayment.getAmount()).getMulti())
				.setCdeOtherPaymentCurrency(MapperS.of(drrReport).<OtherPayment>mapC("getOtherPayment", cSATransactionReport -> cSATransactionReport.getOtherPayment()).<ISOCurrencyCodeEnum>map("getCurrency", otherPayment -> otherPayment.getCurrency())
					.mapItem(item -> item.map("to-string", ISOCurrencyCodeEnum::toDisplayString)).getMulti())
				.setCdeOtherPaymentDate(MapperS.of(drrReport).<OtherPayment>mapC("getOtherPayment", cSATransactionReport -> cSATransactionReport.getOtherPayment()).<Date>map("getDate", otherPayment -> otherPayment.getDate()).getMulti())
				.setCdeOtherPaymentType(MapperS.of(drrReport).<OtherPayment>mapC("getOtherPayment", cSATransactionReport -> cSATransactionReport.getOtherPayment()).<PaymentType4Code>map("getPaymentType", otherPayment -> otherPayment.getPaymentType())
					.mapItem(item -> item.map("to-string", PaymentType4Code::toDisplayString)).getMulti())
				.setOtherPaymentPayerIdType(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).<String>mapC("getOtherPaymentPayerIDType", dTCCAdditionalFields -> dTCCAdditionalFields.getOtherPaymentPayerIDType()).getMulti())
				.setOtherPaymentReceiverIdType(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).<String>mapC("getOtherPaymentReceiverIDType", dTCCAdditionalFields -> dTCCAdditionalFields.getOtherPaymentReceiverIDType()).getMulti())
				.setTradeParty1ReportingDestination(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).<SupervisoryBodyEnum>mapC("getTradeParty1ReportingDestination", dTCCAdditionalFields -> dTCCAdditionalFields.getTradeParty1ReportingDestination())
					.mapItem(item -> item.map("to-string", SupervisoryBodyEnum::toDisplayString)).getMulti())
				.setTradeParty2ReportingDestination(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).<SupervisoryBodyEnum>mapC("getTradeParty2ReportingDestination", dTCCAdditionalFields -> dTCCAdditionalFields.getTradeParty2ReportingDestination())
					.mapItem(item -> item.map("to-string", SupervisoryBodyEnum::toDisplayString)).getMulti())
				.setCdeEffectiveDateOfNotionalQuantityOfLeg1(MapperS.of(drrReport).<CommonLeg>map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).<NotionalPeriod>mapC("getNotionalQuantitySchedule", commonLeg -> commonLeg.getNotionalQuantitySchedule()).<Date>map("getEffectiveDate", notionalPeriod -> notionalPeriod.getEffectiveDate()).getMulti())
				.setCdeEffectiveDateOfNotionalQuantityOfLeg2(MapperS.of(drrReport).<CommonLeg>map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).<NotionalPeriod>mapC("getNotionalQuantitySchedule", commonLeg -> commonLeg.getNotionalQuantitySchedule()).<Date>map("getEffectiveDate", notionalPeriod -> notionalPeriod.getEffectiveDate()).getMulti())
				.setCdeEndDateOfNotionalQuantityOfLeg1(MapperS.of(drrReport).<CommonLeg>map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).<NotionalPeriod>mapC("getNotionalQuantitySchedule", commonLeg -> commonLeg.getNotionalQuantitySchedule()).<Date>map("getEndDate", notionalPeriod -> notionalPeriod.getEndDate()).getMulti())
				.setCdeEndDateOfNotionalQuantityOfLeg2(MapperS.of(drrReport).<CommonLeg>map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).<NotionalPeriod>mapC("getNotionalQuantitySchedule", commonLeg -> commonLeg.getNotionalQuantitySchedule()).<Date>map("getEndDate", notionalPeriod -> notionalPeriod.getEndDate()).getMulti())
				.setCdeNotionalQuantityInEffectOnAssociatedEffectiveDateOfLeg1(MapperS.of(drrReport).<CommonLeg>map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).<NotionalPeriod>mapC("getNotionalQuantitySchedule", commonLeg -> commonLeg.getNotionalQuantitySchedule()).<BigDecimal>map("getValue", notionalPeriod -> notionalPeriod.getValue()).getMulti())
				.setCdeNotionalQuantityInEffectOnAssociatedEffectiveDateOfLeg2(MapperS.of(drrReport).<CommonLeg>map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).<NotionalPeriod>mapC("getNotionalQuantitySchedule", commonLeg -> commonLeg.getNotionalQuantitySchedule()).<BigDecimal>map("getValue", notionalPeriod -> notionalPeriod.getValue()).getMulti())
				.setCdeBasketConstituentsIdentifier(MapperS.of(drrReport).<BasketConstituentsReport>mapC("getBasketConstituents", cSATransactionReport -> cSATransactionReport.getBasketConstituents()).<String>map("getIdentifier", basketConstituentsReport -> basketConstituentsReport.getIdentifier()).getMulti())
				.setCdeBasketConstituentsIdentifierSource(thenArg
					.mapItem(item -> item.<ProductIdTypeEnum>map("getSource", basketConstituentsReport -> basketConstituentsReport.getSource()).map("to-string", ProductIdTypeEnum::toDisplayString)).getMulti())
				.setCdeBasketConstituentsNumberOfUnits(MapperS.of(drrReport).<BasketConstituentsReport>mapC("getBasketConstituents", cSATransactionReport -> cSATransactionReport.getBasketConstituents()).<BigDecimal>map("getNumberOfUnits", basketConstituentsReport -> basketConstituentsReport.getNumberOfUnits()).getMulti())
				.setCdeBasketConstituentsUnitOfMeasure(MapperS.of(drrReport).<BasketConstituentsReport>mapC("getBasketConstituents", cSATransactionReport -> cSATransactionReport.getBasketConstituents()).<String>map("getUnitOfMeasure", basketConstituentsReport -> basketConstituentsReport.getUnitOfMeasure()).getMulti())
				.setLeg1Quantity(MapperS.of(drrReport).<CommonLeg>map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).<NotionalPeriod>mapC("getNotionalQuantitySchedule", commonLeg -> commonLeg.getNotionalQuantitySchedule()).<BigDecimal>map("getValue", notionalPeriod -> notionalPeriod.getValue()).getMulti())
				.setProductGrade(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).<String>mapC("getProductGrade", dTCCAdditionalFields -> dTCCAdditionalFields.getProductGrade()).getMulti())
				.setPeriodStartDate(MapperS.of(drrReport).<PricePeriod>mapC("getPriceSchedule", cSATransactionReport -> cSATransactionReport.getPriceSchedule()).<Date>map("getEffectiveDate", pricePeriod -> pricePeriod.getEffectiveDate()).getMulti())
				.setPeriodEndDate(MapperS.of(drrReport).<PricePeriod>mapC("getPriceSchedule", cSATransactionReport -> cSATransactionReport.getPriceSchedule()).<Date>map("getEndDate", pricePeriod -> pricePeriod.getEndDate()).getMulti())
				.setPeriodFixedStrike(ifThenElseResult0)
				.setLeg1NotionalStepDate(MapperS.of(drrReport).<CommonLeg>map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).<NotionalPeriod>mapC("getNotionalAmountSchedule", commonLeg -> commonLeg.getNotionalAmountSchedule()).<Date>map("getEffectiveDate", notionalPeriod -> notionalPeriod.getEffectiveDate()).getMulti())
				.setLeg1NotionalStepValues(MapperS.of(drrReport).<CommonLeg>map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).<NotionalPeriod>mapC("getNotionalAmountSchedule", commonLeg -> commonLeg.getNotionalAmountSchedule()).<BigDecimal>map("getValue", notionalPeriod -> notionalPeriod.getValue()).getMulti())
				.setLeg2NotionalStepDate(MapperS.of(drrReport).<CommonLeg>map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).<NotionalPeriod>mapC("getNotionalAmountSchedule", commonLeg -> commonLeg.getNotionalAmountSchedule()).<Date>map("getEffectiveDate", notionalPeriod -> notionalPeriod.getEffectiveDate()).getMulti())
				.setLeg2NotionalStepValues(MapperS.of(drrReport).<CommonLeg>map("getLeg2", cSATransactionReport -> cSATransactionReport.getLeg2()).<NotionalPeriod>mapC("getNotionalAmountSchedule", commonLeg -> commonLeg.getNotionalAmountSchedule()).<BigDecimal>map("getValue", notionalPeriod -> notionalPeriod.getValue()).getMulti())
				.setClearingSwapUsiId(Collections.<String>emptyList())
				.setDeliveryPoint(Collections.<String>emptyList())
				.setLoadDeliveryIntervals(Collections.<LocalTime>emptyList())
				.setDeliveryEndDateAndTime(Collections.<ZonedDateTime>emptyList())
				.setDuration(Collections.<String>emptyList())
				.setDeliveryCapacity(Collections.<String>emptyList())
				.setPriceTimeIntervalQuantities(Collections.<BigDecimal>emptyList())
				.setDeliveryStartDateAndTime(Collections.<ZonedDateTime>emptyList())
				.setQuantityUnit(Collections.<String>emptyList())
				.setClearingExceptionTypeParty2(MapperS.of(drrReport).<ClearingExceptionsAndExemptionsEnum>mapC("getClearingExceptionsAndExemptionsCounterparty2", cSATransactionReport -> cSATransactionReport.getClearingExceptionsAndExemptionsCounterparty2())
					.mapItem(item -> item.map("to-string", ClearingExceptionsAndExemptionsEnum::toDisplayString)).getMulti())
				.setLeg1QuantityFrequency(Collections.<String>emptyList())
				.setTradeParty1ThirdPartyViewerId(Collections.<String>emptyList())
				.setTradeParty2ThirdPartyViewerId(Collections.<String>emptyList())
				.setTradeParty1ThirdPartyViewerIdType(Collections.<String>emptyList())
				.setTradeParty2ThirdPartyViewerIdType(Collections.<String>emptyList())
				.setLeg1QuantityUnit(Collections.<String>emptyList())
				.setElectricityPhysicalLegDeliveryStepQuantity(Collections.<BigDecimal>emptyList())
				.setElectricityPhysicalLegDeliveryStepQuantityFrequency(Collections.<String>emptyList())
				.setElectricityPhysicalLegDeliveryStepQuantityUnit(Collections.<String>emptyList())
				.setBasketWeightPercentage(Collections.<BigDecimal>emptyList())
				.setReferenceObligationType(Collections.<String>emptyList())
				.setUnderlyingAssetPlaceOfIncorporation(Collections.<String>emptyList())
				.setUnderlyingAssetPlaceOfIssuance(Collections.<String>emptyList())
				.setReferenceEntityId(Collections.<String>emptyList())
				.setReferenceEntityIdType(Collections.<String>emptyList())
				.setUnderlyingAssetFixedRate(Collections.<BigDecimal>emptyList())
				.setUnderlyingAssetNotionalCurrency(Collections.<String>emptyList())
				.setPeriodFixedAmount(Collections.<BigDecimal>emptyList())
				.setUnderlyingAssetNotionalAmount(Collections.<BigDecimal>emptyList())
				.setDividendPaymentDate(Collections.<Date>emptyList())
				.setFixedAmountPaymentDate(Collections.<Date>emptyList())
				.setLeg1PaymentDates(Collections.<Date>emptyList())
				.setLeg2PaymentDates(Collections.<Date>emptyList())
				.setUnderlyingAssetInitialPrice(Collections.<BigDecimal>emptyList())
				.setCancelationOptionExerciseDates(Collections.<Date>emptyList())
				.setCancelationOptionRelevantUnderlyingDates(Collections.<Date>emptyList())
				.setCapRateStepDate(Collections.<Date>emptyList())
				.setCapRateStepValues(Collections.<BigDecimal>emptyList())
				.setExerciseDates(Collections.<Date>emptyList())
				.setFloorRateStepDate(Collections.<Date>emptyList())
				.setFloorRateStepValue(Collections.<BigDecimal>emptyList())
				.setLeg1FixedRateStepDate(Collections.<Date>emptyList())
				.setLeg1FixedRateStepValues(Collections.<BigDecimal>emptyList())
				.setLeg1FloatingRateMultiplierStepDate(Collections.<Date>emptyList())
				.setLeg1FloatingRateMultiplierStepValues(Collections.<BigDecimal>emptyList())
				.setLeg1FloatingRateSpreadStepDate(Collections.<Date>emptyList())
				.setLeg1FloatingRateSpreadStepValues(Collections.<BigDecimal>emptyList())
				.setLeg2FixedRateStepDate(Collections.<Date>emptyList())
				.setLeg2FixedRateStepValues(Collections.<BigDecimal>emptyList())
				.setLeg2FloatingRateMultiplierStepDate(Collections.<Date>emptyList())
				.setLeg2FloatingRateMultiplierStepValues(Collections.<BigDecimal>emptyList())
				.setLeg2FloatingRateSpreadStepDate(Collections.<Date>emptyList())
				.setLeg2FloatingRateSpreadStepValues(Collections.<BigDecimal>emptyList())
				.setOptionalEarlyTerminationDates(Collections.<Date>emptyList())
				.setOptionalEarlyTerminationExerciseDates(Collections.<Date>emptyList())
				.setOptionalEarlyTerminationUnderlyingDates(Collections.<Date>emptyList())
				.setRelevantUnderlyingDatesUnadjustedDates(Collections.<Date>emptyList())
				.setOptionalEarlyTerminationExerciseAdjustedDates(Collections.<Date>emptyList())
				.setMandatoryClearingJurisdiction(Collections.<String>emptyList())
				.setClearingSwapUsiIdPrefix(Collections.<String>emptyList())
				.setTradeParty1LocalCounterpartyJurisdiction(MapperS.of(drrReport).<String>mapC("getJurisdictionOfCounterparty1", cSATransactionReport -> cSATransactionReport.getJurisdictionOfCounterparty1()).getMulti())
				.setTradeParty2LocalCounterpartyJurisdiction(MapperS.of(drrReport).<String>mapC("getJurisdictionOfCounterparty2", cSATransactionReport -> cSATransactionReport.getJurisdictionOfCounterparty2()).getMulti())
				.build());
			
			final List<String> ifThenElseResult1;
			if (needsUpfrontFee(drrReport).getOrDefault(false)) {
				ifThenElseResult1 = MapperS.of(drrReport).<String>map("getBuyerIdentifier", cSATransactionReport -> cSATransactionReport.getBuyerIdentifier()).getMulti();
			} else {
				ifThenElseResult1 = Collections.<String>emptyList();
			}
			harmonized
				.addCdeOtherPaymentPayer(ifThenElseResult1);
			
			final List<String> ifThenElseResult2;
			if (needsUpfrontFee(drrReport).getOrDefault(false)) {
				ifThenElseResult2 = MapperS.of(drrReport).<String>map("getSellerIdentifier", cSATransactionReport -> cSATransactionReport.getSellerIdentifier()).getMulti();
			} else {
				ifThenElseResult2 = Collections.<String>emptyList();
			}
			harmonized
				.addCdeOtherPaymentReceiver(ifThenElseResult2);
			
			final List<String> ifThenElseResult3;
			if (needsUpfrontFee(drrReport).getOrDefault(false)) {
				final String string0 = "UFRO";
				ifThenElseResult3 = string0 == null ? Collections.<String>emptyList() : Collections.singletonList(string0);
			} else {
				ifThenElseResult3 = Collections.<String>emptyList();
			}
			harmonized
				.addCdeOtherPaymentType(ifThenElseResult3);
			
			final List<BigDecimal> ifThenElseResult4;
			if (needsUpfrontFee(drrReport).getOrDefault(false)) {
				ifThenElseResult4 = Collections.singletonList(BigDecimal.valueOf(0));
			} else {
				ifThenElseResult4 = Collections.<BigDecimal>emptyList();
			}
			harmonized
				.addCdeOtherPaymentAmount(ifThenElseResult4);
			
			final List<String> ifThenElseResult5;
			if (needsUpfrontFee(drrReport).getOrDefault(false)) {
				ifThenElseResult5 = MapperS.of(drrReport).<CommonLeg>map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).<ISOCurrencyCodeEnum>map("getNotionalCurrency", commonLeg -> commonLeg.getNotionalCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).getMulti();
			} else {
				ifThenElseResult5 = Collections.<String>emptyList();
			}
			harmonized
				.addCdeOtherPaymentCurrency(ifThenElseResult5);
			
			final List<Date> ifThenElseResult6;
			if (needsUpfrontFee(drrReport).getOrDefault(false)) {
				ifThenElseResult6 = MapperS.of(drrReport).<Date>map("getEffectiveDate", cSATransactionReport -> cSATransactionReport.getEffectiveDate()).getMulti();
			} else {
				ifThenElseResult6 = Collections.<Date>emptyList();
			}
			harmonized
				.addCdeOtherPaymentDate(ifThenElseResult6);
			
			final List<String> ifThenElseResult7;
			if (needsUpfrontFee(drrReport).getOrDefault(false)) {
				final String string1 = "LEI";
				ifThenElseResult7 = string1 == null ? Collections.<String>emptyList() : Collections.singletonList(string1);
			} else {
				ifThenElseResult7 = Collections.<String>emptyList();
			}
			harmonized
				.addOtherPaymentPayerIdType(ifThenElseResult7);
			
			final List<String> ifThenElseResult8;
			if (needsUpfrontFee(drrReport).getOrDefault(false)) {
				final String string2 = "LEI";
				ifThenElseResult8 = string2 == null ? Collections.<String>emptyList() : Collections.singletonList(string2);
			} else {
				ifThenElseResult8 = Collections.<String>emptyList();
			}
			harmonized
				.addOtherPaymentReceiverIdType(ifThenElseResult8);
			
			return Optional.ofNullable(harmonized)
				.map(o -> o.prune())
				.orElse(null);
		}
		
		@Override
		protected MapperS<Boolean> needsUpfrontFee(CSATransactionReport drrReport) {
			return notExists(MapperS.of(drrReport).<OtherPayment>mapC("getOtherPayment", cSATransactionReport -> cSATransactionReport.getOtherPayment()).<PaymentType4Code>map("getPaymentType", otherPayment -> otherPayment.getPaymentType())).and(areEqual(MapperS.of(drrReport).<DTCCAdditionalFields>map("getDtccAdditionalFields", cSATransactionReport -> cSATransactionReport.getDtccAdditionalFields()).<AssetClassEnum>map("getPrimaryAssetClass", dTCCAdditionalFields -> dTCCAdditionalFields.getPrimaryAssetClass()).map("to-string", AssetClassEnum::toDisplayString), MapperS.of("Credit"), CardinalityOperator.All)).and(notExists(MapperS.of(drrReport).<CommonLeg>map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).<BigDecimal>map("getFixedRate", commonLeg -> commonLeg.getFixedRate()))).and(notExists(MapperS.of(drrReport).<CommonLeg>map("getLeg1", cSATransactionReport -> cSATransactionReport.getLeg1()).<PriceFormat>map("getSpread", commonLeg -> commonLeg.getSpread()))).asMapper();
		}
	}
}
