package drr.projection.dtcc.rds.harmonized.csa.rewrite.valuation.functions;

import cdm.base.datetime.functions.Now;
import cdm.base.staticdata.asset.common.AssetClassEnum;
import cdm.base.staticdata.party.PartyIdentifierTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.csa.rewrite.valuation.CSAValuationReport;
import drr.standards.iso.ActionTypeEnum;
import iso20022.dtcc.rds.harmonized.Core;
import iso20022.dtcc.rds.harmonized.Core.CoreBuilder;
import java.time.ZonedDateTime;
import java.util.Collections;
import java.util.Optional;
import javax.inject.Inject;


@ImplementedBy(Create_SubmissionCore.Create_SubmissionCoreDefault.class)
public abstract class Create_SubmissionCore implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected Now now;

	/**
	* @param drrReport 
	* @return core 
	*/
	public Core evaluate(CSAValuationReport drrReport) {
		Core.CoreBuilder coreBuilder = doEvaluate(drrReport);
		
		final Core core;
		if (coreBuilder == null) {
			core = null;
		} else {
			core = coreBuilder.build();
			objectValidator.validate(Core.class, core);
		}
		
		return core;
	}

	protected abstract Core.CoreBuilder doEvaluate(CSAValuationReport drrReport);

	public static class Create_SubmissionCoreDefault extends Create_SubmissionCore {
		@Override
		protected Core.CoreBuilder doEvaluate(CSAValuationReport drrReport) {
			Core.CoreBuilder core = Core.builder();
			return assignOutput(core, drrReport);
		}
		
		protected Core.CoreBuilder assignOutput(Core.CoreBuilder core, CSAValuationReport drrReport) {
			core = toBuilder(Core.builder()
				.setTradeLegTypes(null)
				.setLatestExecutionDatetime(null)
				.setProductId(null)
				.setMessageId(MapperS.of(drrReport).<String>map("getMessageID", cSAValuationReport -> cSAValuationReport.getMessageID()).get())
				.setMessageType(MapperS.of(drrReport).<String>map("getMessageType", cSAValuationReport -> cSAValuationReport.getMessageType()).get())
				.setPrimaryAssetClass(MapperS.of(drrReport).<AssetClassEnum>map("getPrimaryAssetClass", cSAValuationReport -> cSAValuationReport.getPrimaryAssetClass()).map("to-string", AssetClassEnum::toDisplayString).get())
				.setSubmittedForParty(MapperS.of(drrReport).<String>map("getSubmittedForParty", cSAValuationReport -> cSAValuationReport.getSubmittedForParty()).get())
				.setSubmittingPartyId(MapperS.of(drrReport).<String>map("getSubmitterIdentifier", cSAValuationReport -> cSAValuationReport.getSubmitterIdentifier()).get())
				.setSubmittingPartyIdType(MapperS.of(drrReport).<PartyIdentifierTypeEnum>map("getSubmittingPartyIDType", cSAValuationReport -> cSAValuationReport.getSubmittingPartyIDType()).map("to-string", PartyIdentifierTypeEnum::toDisplayString).get())
				.setTradeParty1Id(MapperS.of(drrReport).<String>map("getCounterparty1", cSAValuationReport -> cSAValuationReport.getCounterparty1()).get())
				.setTradeParty1IdType(MapperS.of(drrReport).<PartyIdentifierTypeEnum>map("getTradeParty1IDType", cSAValuationReport -> cSAValuationReport.getTradeParty1IDType()).map("to-string", PartyIdentifierTypeEnum::toDisplayString).get())
				.setTradeParty1ReportingDestination(MapperS.of(MapperS.of(drrReport).<SupervisoryBodyEnum>mapC("getTradeParty1ReportingDestination", cSAValuationReport -> cSAValuationReport.getTradeParty1ReportingDestination()).get()).map("to-string", SupervisoryBodyEnum::toDisplayString).getMulti())
				.setTradeParty1TransactionId(MapperS.of(drrReport).<String>map("getTradeParty1TransactionID", cSAValuationReport -> cSAValuationReport.getTradeParty1TransactionID()).get())
				.setTradeParty2Id(MapperS.of(drrReport).<String>map("getCounterparty2", cSAValuationReport -> cSAValuationReport.getCounterparty2()).get())
				.setTradeParty2IdType(MapperS.of(drrReport).<String>map("getCounterparty2IdentifierSource", cSAValuationReport -> cSAValuationReport.getCounterparty2IdentifierSource()).get())
				.setTradeParty2ReportingDestination(MapperS.of(MapperS.of(drrReport).<SupervisoryBodyEnum>mapC("getTradeParty2ReportingDestination", cSAValuationReport -> cSAValuationReport.getTradeParty2ReportingDestination()).get()).map("to-string", SupervisoryBodyEnum::toDisplayString).getMulti())
				.setUsiId(MapperS.of(drrReport).<String>map("getUsiID", cSAValuationReport -> cSAValuationReport.getUsiID()).get())
				.setUsiIdPrefix(MapperS.of(drrReport).<String>map("getUsiIDPrefix", cSAValuationReport -> cSAValuationReport.getUsiIDPrefix()).get())
				.setUtiId(MapperS.of(drrReport).<String>map("getUniqueTransactionIdentifier", cSAValuationReport -> cSAValuationReport.getUniqueTransactionIdentifier()).get())
				.setTradeParty1ExecutionAgentId(MapperS.of(drrReport).<String>map("getTradeParty1ExecutionAgentID", cSAValuationReport -> cSAValuationReport.getTradeParty1ExecutionAgentID()).get())
				.setTradeParty1ExecutionAgentIdType(MapperS.of(drrReport).<PartyIdentifierTypeEnum>map("getTradeParty1ExecutionAgentIDType", cSAValuationReport -> cSAValuationReport.getTradeParty1ExecutionAgentIDType()).map("to-string", PartyIdentifierTypeEnum::toDisplayString).get())
				.setTradeParty2ExecutionAgentId(MapperS.of(drrReport).<String>map("getTradeParty2ExecutionAgentID", cSAValuationReport -> cSAValuationReport.getTradeParty2ExecutionAgentID()).get())
				.setTradeParty2ExecutionAgentIdType(MapperS.of(drrReport).<PartyIdentifierTypeEnum>map("getTradeParty2ExecutionAgentIDType", cSAValuationReport -> cSAValuationReport.getTradeParty2ExecutionAgentIDType()).map("to-string", PartyIdentifierTypeEnum::toDisplayString).get())
				.setReportingTimestamp(MapperS.of(drrReport).<ZonedDateTime>map("getReportingTimestamp", cSAValuationReport -> cSAValuationReport.getReportingTimestamp()).getOrDefault(now.evaluate()))
				.setUpi(null)
				.setInitialMarginCollateralPortfolioCode(MapperS.of(drrReport).<String>map("getInitialMarginCollateralPortfolioCode", cSAValuationReport -> cSAValuationReport.getInitialMarginCollateralPortfolioCode()).get())
				.setVariationMarginCollateralPortfolioCode(MapperS.of(drrReport).<String>map("getVariationMarginCollateralPortfolioCode", cSAValuationReport -> cSAValuationReport.getVariationMarginCollateralPortfolioCode()).get())
				.setUtiIdPrefix(null)
				.setCorporateActionNewTradeParty1Lei(null)
				.setProductIdType(null)
				.setTradeParty2TransactionId(null)
				.setTransactionType(null)
				.setLifecycleEventType(null)
				.setTradeParty1ThirdPartyViewerId(Collections.<String>emptyList())
				.setTradeParty2ThirdPartyViewerId(Collections.<String>emptyList())
				.setTradeParty1ThirdPartyViewerIdType(Collections.<String>emptyList())
				.setTradeParty2ThirdPartyViewerIdType(Collections.<String>emptyList())
				.setAiParty1Id(null)
				.setAiParty1IdType(null)
				.setAiParty2Id(null)
				.setAiParty2IdType(null)
				.setTradeParty1RegulatoryActionType1(null)
				.setTradeParty2RegulatoryActionType1(null)
				.setNoaActionType(MapperS.of(drrReport).<ActionTypeEnum>map("getActionType", cSAValuationReport -> cSAValuationReport.getActionType()).map("to-string", ActionTypeEnum::toDisplayString).get())
				.setNoaEventType(null)
				.build());
			
			return Optional.ofNullable(core)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
