package drr.projection.dtcc.rds.harmonized.csa.rewrite.valuation.functions;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.regulation.csa.rewrite.valuation.CSAValuationReport;
import drr.standards.iso.ActionTypeEnum;
import drr.standards.iso.ValuationType1Code;
import iso20022.dtcc.rds.harmonized.HarmonizedData;
import iso20022.dtcc.rds.harmonized.HarmonizedData.HarmonizedDataBuilder;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Optional;
import javax.inject.Inject;


@ImplementedBy(Create_SubmissionHarmonizedData.Create_SubmissionHarmonizedDataDefault.class)
public abstract class Create_SubmissionHarmonizedData implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;

	/**
	* @param drrReport 
	* @return harmonized 
	*/
	public HarmonizedData evaluate(CSAValuationReport drrReport) {
		HarmonizedData.HarmonizedDataBuilder harmonizedBuilder = doEvaluate(drrReport);
		
		final HarmonizedData harmonized;
		if (harmonizedBuilder == null) {
			harmonized = null;
		} else {
			harmonized = harmonizedBuilder.build();
			objectValidator.validate(HarmonizedData.class, harmonized);
		}
		
		return harmonized;
	}

	protected abstract HarmonizedData.HarmonizedDataBuilder doEvaluate(CSAValuationReport drrReport);

	public static class Create_SubmissionHarmonizedDataDefault extends Create_SubmissionHarmonizedData {
		@Override
		protected HarmonizedData.HarmonizedDataBuilder doEvaluate(CSAValuationReport drrReport) {
			HarmonizedData.HarmonizedDataBuilder harmonized = HarmonizedData.builder();
			return assignOutput(harmonized, drrReport);
		}
		
		protected HarmonizedData.HarmonizedDataBuilder assignOutput(HarmonizedData.HarmonizedDataBuilder harmonized, CSAValuationReport drrReport) {
			harmonized = toBuilder(HarmonizedData.builder()
				.setAmendmentIndicator(null)
				.setCdePackageTransactionSpreadCurrency(null)
				.setClearingVenueIdType(null)
				.setClearingVenueId(null)
				.setTradeParty1ClearingBrokerId(null)
				.setTradeParty1ClearingBrokerIdType(null)
				.setBuyerPayer1(null)
				.setCdeCallAmountLeg1(null)
				.setCdeCallCurrencyLeg1(null)
				.setCdeEffectiveDate(null)
				.setCustomBasketIndicator(null)
				.setCdeExpirationDate(null)
				.setCdeFinalContractualSettlementDate(null)
				.setCdeFirstExerciseDate(null)
				.setCdeFixedRateDayCountConventionLeg1(null)
				.setCdeFixedRateDayCountConventionLeg2(null)
				.setCdeFixedRatePaymentFrequencyPeriodMultiplierLeg1(null)
				.setCdeFixedRatePaymentFrequencyPeriodMultiplierLeg2(null)
				.setCdeFixedRatePaymentFrequencyPeriodLeg1(null)
				.setCdeFixedRatePaymentFrequencyPeriodLeg2(null)
				.setCdeFloatingRateDayCountConventionLeg1(null)
				.setCdeFloatingRateDayCountConventionLeg2(null)
				.setCdeFloatingRatePaymentFrequencyPeriodMultiplierLeg1(null)
				.setCdeFloatingRatePaymentFrequencyPeriodMultiplierLeg2(null)
				.setCdeFloatingRatePaymentFrequencyPeriodLeg1(null)
				.setCdeFloatingRatePaymentFrequencyPeriodLeg2(null)
				.setCdePlatformIdentifier(null)
				.setCdePriceCurrency(null)
				.setCdePriceNotation(null)
				.setCdePutAmountLeg1(null)
				.setCdePutCurrencyLeg1(null)
				.setCdeQuantityUnitOfMeasureLeg1(null)
				.setCdeQuantityUnitOfMeasureLeg2(null)
				.setCdeReceiverIdentifierLeg2(null)
				.setCdeSettlementLocationLeg1(null)
				.setCdeSpreadNotationLeg1(null)
				.setCdeSpreadNotationLeg2(null)
				.setClearingStatus(null)
				.setEventType(null)
				.setFixingDateLeg1(null)
				.setFixingDateLeg2(null)
				.setIndexFactor(null)
				.setExchangeRate(null)
				.setLeg1FixedRateInitial(null)
				.setLeg1NotionalQuantity(null)
				.setLeg1SpreadCurrency(null)
				.setLeg1TotalNotionalQuantity(null)
				.setLeg2FixedRateInitial(null)
				.setLeg2NotionalQuantity(null)
				.setLeg2QuantityFrequency(null)
				.setLeg2ResetFrequencyPeriod(null)
				.setLeg2ResetFrequencyPeriodMultiplier(null)
				.setLeg2SettlementCurrency(null)
				.setLeg2SpreadCurrency(null)
				.setLeg2TotalNotionalQuantity(null)
				.setNewSdrIdentifier(null)
				.setNoaActionType(MapperS.of(drrReport).<ActionTypeEnum>map("getActionType", cSAValuationReport -> cSAValuationReport.getActionType()).map("to-string", ActionTypeEnum::toDisplayString).get())
				.setNonStandardTradeIndicator(null)
				.setNotionalAmount1(null)
				.setNotionalAmount2(null)
				.setNotionalCurrency1(null)
				.setNotionalCurrency2(null)
				.setOptionStyle(null)
				.setOptionType(null)
				.setOriginalExecutionTimestamp(null)
				.setPayment1Payer(null)
				.setPayment1Receiver(null)
				.setPayment2Payer(null)
				.setPremiumAmount(null)
				.setPremiumCurrency(null)
				.setPremiumPaymentDateUnadjusted(null)
				.setPrice1Price(null)
				.setPrice1Units(null)
				.setPriorUtiId(null)
				.setQuantityFrequencyMultiplierLeg1(null)
				.setQuantityFrequencyMultiplierLeg2(null)
				.setResetFrequencyPeriod1(null)
				.setResetFrequencyPeriodMultiplier1(null)
				.setSellerPayer2(null)
				.setSettlementCurrency1(null)
				.setStrikePrice(null)
				.setStrikePriceCurrency(null)
				.setCdeStrikePriceNotation(null)
				.setSettlementType(null)
				.setCdeStrikePriceCurrency2(null)
				.setLeg1CommodityInstrumentId(null)
				.setLeg2CommodityInstrumentId(null)
				.setLeg1FloatingRateIndex(null)
				.setLeg2FloatingRateIndex(null)
				.setLeg1CommodityUnderlyerId(null)
				.setLeg2CommodityUnderlyerId(null)
				.setResponsibleDataSubmitterId(null)
				.setResponsibleDataSubmitterIdType(null)
				.setSecondaryAssetClass(null)
				.setTradeParty1BrokerIdType(null)
				.setTradeParty1BrokerId(null)
				.setExpirationDateUnadjusted(null)
				.setLeg2SpreadAmount(null)
				.setLeg1PartyPayer(null)
				.setLeg2PartyPayer(null)
				.setSdMspIndicatorCounterparty1(null)
				.setSdMspIndicatorCounterparty2(null)
				.setPhysicalCommodityContractIndicator(null)
				.setCdeCryptoAssetUnderlyingIndicatorLeg1(null)
				.setCdeCryptoAssetUnderlyingIndicatorLeg2(null)
				.setCdeCustomBasketCode(null)
				.setUnderlierIdOtherLeg1(null)
				.setUnderlierIdOtherLeg2(null)
				.setUnderlierIdOtherSourceLeg1(null)
				.setUnderlierIdOtherSourceLeg2(null)
				.setCdeUnderlyingAssetTradingPlatformIdLeg1(null)
				.setCdeUnderlyingAssetTradingPlatformIdLeg2(null)
				.setCdeUnderlyingAssetPriceSourceLeg1(null)
				.setCdeUnderlyingAssetPriceSourceLeg2(null)
				.setTotalQuantity(null)
				.setLeg1SpreadAmount(null)
				.setLeg2PartyReceiver(null)
				.setLeg1PartyReceiver(null)
				.setLeg2Quantity(null)
				.setLoadType(null)
				.setDeliveryLocation(null)
				.setUnderlyingAssetExchangeId(null)
				.setExchangeRateBasisCurrency1(null)
				.setExchangeRateBasisCurrency2(null)
				.setUnderlyingProductId(null)
				.setExpirationDate(null)
				.setVersion(MapperS.of(drrReport).<String>map("getVersion", cSAValuationReport -> cSAValuationReport.getVersion()).get())
				.setComment1(MapperS.of(drrReport).<String>map("getComment1", cSAValuationReport -> cSAValuationReport.getComment1()).get())
				.setDayCountFraction1(null)
				.setLeg2DayCountFraction(null)
				.setExecutionVenueId(null)
				.setExecutionVenueIdType(null)
				.setMasterAgreementType(null)
				.setMasterAgreementVersion(null)
				.setClearingDatetime(null)
				.setMaturityDateOfTheUnderlying(null)
				.setProductIdentification(null)
				.setLevel(null)
				.setExecutionVenueMicCode(null)
				.setAllocationType(null)
				.setFloatingRatePaymentFrequencyLeg1Multiplier(null)
				.setFloatingRatePaymentFrequencyLeg1TimePeriod(null)
				.setFloatingRatePaymentFrequencyLeg2Multiplier(null)
				.setFloatingRatePaymentFrequencyLeg2TimePeriod(null)
				.setInteraffiliate(null)
				.setLeg2PaymentTermsFrequencyPeriod(null)
				.setLeg2PaymentTermsPaymentFrequencyPeriodMultiplier(null)
				.setMaturityDate(null)
				.setOriginalSwapSdrId(null)
				.setOriginalSwapSdrIdType(null)
				.setPaymentFrequencyPeriodLeg1(null)
				.setPaymentFrequencyPeriodLeg2(null)
				.setPaymentFrequencyPeriodMultiplierLeg1(null)
				.setPaymentFrequencyPeriodMultiplierLeg2(null)
				.setOriginalSwapUsi(null)
				.setOriginalSwapUti(null)
				.setCounterparty1FederalEntityIndicator(null)
				.setCounterparty2FederalEntityIndicator(null)
				.setEventIdentifier(null)
				.setPackageIndicator(null)
				.setCdePackageIdentifier(null)
				.setCdePackageTransactionPrice(null)
				.setCdePackageTransactionPriceCurrency(null)
				.setCdePackageTransactionPriceNotation(null)
				.setCdePackageTransactionSpread(null)
				.setCdePackageTransactionSpreadNotation(null)
				.setPostPricedSwapIndicator(null)
				.setPrimeBrokerageTransactionIndicator(null)
				.setSwapReportingJurisdiction(null)
				.setInitialMarginCollateralPortfolioCode(MapperS.of(drrReport).<String>map("getInitialMarginCollateralPortfolioCode", cSAValuationReport -> cSAValuationReport.getInitialMarginCollateralPortfolioCode()).get())
				.setVariationMarginCollateralPortfolioCode(MapperS.of(drrReport).<String>map("getVariationMarginCollateralPortfolioCode", cSAValuationReport -> cSAValuationReport.getVariationMarginCollateralPortfolioCode()).get())
				.setLargeNotionalOffFacilitySwapElectionIndicator(null)
				.setSefOrDcmAnonymousExecutionIndicator(null)
				.setBlockTradeElectionIndicator(null)
				.setSefOrDcmIndicator(null)
				.setMandatoryClearingIndicator(null)
				.setPriorUsiId(null)
				.setContractType(null)
				.setPayment1FrequencyPeriod(null)
				.setPayment1FrequencyPeriodMultiplier(null)
				.setPayment2FrequencyPeriod(null)
				.setPayment2FrequencyPeriodMultiplier(null)
				.setPayment1Amount(null)
				.setPayment1Currency(null)
				.setPayment2Amount(null)
				.setCurrencyOfPrice(null)
				.setPayment2Currency(null)
				.setPrice1Currency(null)
				.setLeg2CommodityUnitOfMeasure(null)
				.setLeg2NotionalQuantityFrequency(null)
				.setLeg1CommodityUnitOfMeasure(null)
				.setLeg1NotionalQuantityUnit(null)
				.setLeg1NotionalQuantityFrequency(null)
				.setLeg2NotionalQuantityUnit(null)
				.setLeg2QuantityUnit(null)
				.setSettlementDateUnadjusted(null)
				.setAttachmentPoint(null)
				.setExhaustionPoint(null)
				.setCrversion(null)
				.setSettlementFixingDate(null)
				.setForwardExchangeRate(null)
				.setSettlementDate(null)
				.setCcpValuationAmount(MapperS.of(drrReport).<BigDecimal>map("getValuationAmount", cSAValuationReport -> cSAValuationReport.getValuationAmount()).get())
				.setCcpValuationCurrency(MapperS.of(drrReport).<ISOCurrencyCodeEnum>map("getValuationCurrency", cSAValuationReport -> cSAValuationReport.getValuationCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
				.setCcpValuationDatetime(MapperS.of(drrReport).<ZonedDateTime>map("getValuationTimestamp", cSAValuationReport -> cSAValuationReport.getValuationTimestamp()).get())
				.setCcpValuationType(MapperS.of(drrReport).<ValuationType1Code>map("getValuationMethod", cSAValuationReport -> cSAValuationReport.getValuationMethod()).map("to-string", ValuationType1Code::toDisplayString).get())
				.setEuUnderlyingAssetIdType(null)
				.setProductClassification(null)
				.setQuantity(null)
				.setConfirmationDatetime(null)
				.setEuUnderlyingAssetId(null)
				.setReportTrackingNumber(null)
				.setIntragroupIndicator(null)
				.setClearingExceptionPartyId(null)
				.setClearingExceptionPartyIdType(null)
				.setClearingExceptionType(null)
				.setTradeParty1CftcFinancialEntityStatus(null)
				.setTradeParty2CftcFinancialEntityStatus(null)
				.setCdeCallAmountLeg2(null)
				.setCdeCallCurrencyLeg2(null)
				.setCdePutAmountLeg2(null)
				.setCdePutCurrencyLeg2(null)
				.setCdeSettlementLocationLeg2(null)
				.setChangeInNotionalAmount1(null)
				.setChangeInNotionalAmount2(null)
				.setLeg2CommodityUnderlyerDetails(null)
				.setLeg2CommodityCurrency(null)
				.setLeg2CommodityExchangeId(null)
				.setLeg1CommodityRateSource(null)
				.setLeg1CommodityRateSourcePage(null)
				.setLeg2SpecifiedPrice(null)
				.setCommencementDateUnadjusted(null)
				.setExerciseExpirationDateUnadjusted(null)
				.setScheduledTerminationDateAdjusted(null)
				.setLeg1CommodityExchangeId(null)
				.setLeg2CommodityRateSource(null)
				.setLeg1EffectiveDateUnadjusted(null)
				.setLeg2EffectiveDateUnadjusted(null)
				.setCoProductType(null)
				.setTotalQuantityUnit(null)
				.setFixedPrice(null)
				.setFixedPriceCurrency(null)
				.setLeg1CommodityCurrency(null)
				.setLeg1SpecifiedPrice(null)
				.setCoalSource(null)
				.setCommodityBase(null)
				.setCommodityDetails(null)
				.setInterconnectionPoint(null)
				.setFixedPriceUnit(null)
				.setExercisePaymentDateUnadjusted(null)
				.setLeg1PaymentDatesUnadjusted(null)
				.setLeg2PaymentDateUnadjusted(null)
				.setLeg1CommodityUnderlyerDetails(null)
				.setLeg2CommodityRateSourcePage(null)
				.setValueDate(null)
				.setGtrQuantityUnit(null)
				.setMthToDefault(null)
				.setNthToDefault(null)
				.setSeniority(null)
				.setSeries(null)
				.setTranche(null)
				.setReferenceObligation(null)
				.setReferenceObligationIdType(null)
				.setUnderlyingFixedRatePayerBuyer(null)
				.setUnderlyingFloatRatePayerSeller(null)
				.setUnderlyingAssetNumberOfUnits(null)
				.setOptionalEarlyTerminationType(null)
				.setOptionalEarlyTerminationElectingPartyValue(null)
				.setOptionalEarlyTerminationIndicator(null)
				.setUnderlyingAssetFloatingAmountPayer(null)
				.setUnderlyingAssetFloatingAmountReceiver(null)
				.setFloatingRateOption(null)
				.setUnderlyingAssetFloatingLegSpread(null)
				.setLeg2DesignatedMaturityPeriod(null)
				.setLeg2DesignatedMaturityPeriodMultiplier(null)
				.setUnderlyingAssetEquityAmountPayer(null)
				.setUnderlyingAssetEquityAmountReceiver(null)
				.setUnderlyingAssetInitialPriceCurrency(null)
				.setLeg1ValuationDates(null)
				.setLeg1TypeOfReturn(null)
				.setObservationStartDate(null)
				.setVarianceAmount(null)
				.setVolatilityStrikePrice(null)
				.setVarianceStrikePrice(null)
				.setVarianceCapFactor(null)
				.setReferenceCurrency(null)
				.setSpecialDividendsIndicator(null)
				.setMaterialNoncashDividendIndicator(null)
				.setNumberOfSharesUnits(null)
				.setDividendAmountPayer(null)
				.setDividendAmountReceiver(null)
				.setFixedAmountPayer(null)
				.setFixedAmountReceiver(null)
				.setKnockInEvent(null)
				.setKnockOutEvent(null)
				.setKnockInPrice(null)
				.setKnockOutPrice(null)
				.setBarrierType(null)
				.setEarliestExecutionTime(null)
				.setExecutionPeriodStartDate(null)
				.setPayoutStyle(null)
				.setRateQuoteBasis1(null)
				.setSwapLinkId(null)
				.setTriggerCondition(null)
				.setTriggerCondition2(null)
				.setTriggerRate(null)
				.setTriggerRate2(null)
				.setRateQuoteBasis2(null)
				.setBarrierType2(null)
				.setCancelationOptionBuyer(null)
				.setCancelationOptionCommencementDate(null)
				.setCancelationOptionExerciseStyleType(null)
				.setCancelationOptionExpirationDate(null)
				.setCancelationOptionInitialFeeCurrency(null)
				.setCancelationOptionInitialFeePayer(null)
				.setCancelationOptionPremiumAmount(null)
				.setCancelationOptionSeller(null)
				.setCapRateInitial(null)
				.setCouponType(null)
				.setFinalPrincipalExchangeIndicatorAtTermination(null)
				.setFloorRateInitial(null)
				.setFraDiscountingType(null)
				.setInflationIndexInitialLevel(null)
				.setInflationIndexMainPublication(null)
				.setInflationInterpolationMethod(null)
				.setInflationLagDayType(null)
				.setInflationLagPeriod(null)
				.setInflationRateSourceName(null)
				.setInitialPrincipalExchangeIndicator(null)
				.setIntermediatePrincipalExchangeIndicator(null)
				.setLeg1FloatingRateInitialSpread(null)
				.setLeg1FloatingRateMultiplierInitialValue(null)
				.setLeg1FloatingRateTenorPeriod(null)
				.setLeg1FloatingRateTenorPeriodMultiplier(null)
				.setLeg1KnownAmount(null)
				.setLeg1KnownAmountCurrency(null)
				.setLeg1ReferenceCurrency(null)
				.setLeg2FloatingRateInitialSpread(null)
				.setLeg2FloatingRateMultiplierInitialValue(null)
				.setLeg2FloatingRateTenorPeriod(null)
				.setLeg2FloatingRateTenorPeriodMultiplier(null)
				.setLeg2KnownAmount(null)
				.setLeg2KnownAmountCurrency(null)
				.setLeg2ReferenceCurrency(null)
				.setMandatoryEarlyTerminationDate(null)
				.setMandatoryEarlyTerminationDateTenorPeriod(null)
				.setMandatoryEarlyTerminationDateTenorPeriodMultiplier(null)
				.setNotionalUnits(null)
				.setOptionalEarlyTerminationCommencementDate(null)
				.setOptionalEarlyTerminationExerciseStyle(null)
				.setOptionalEarlyTerminationExpirationDate(null)
				.setPremiumReceiver(null)
				.setUnderlyingCouponRate(null)
				.setUnderlyingMaturityDate(null)
				.setInflationLagPeriodMultiplier(null)
				.setLeg1FixedRateNotation(null)
				.setLeg2FixedRateNotation(null)
				.setSwaptionStraddleIndicator(null)
				.setSinglePartyEarlyTerminationBuyer(null)
				.setLeg1EffectiveDate(null)
				.setAction(null)
				.setEffectiveDate1(null)
				.setExecutionVenueType(null)
				.setPrice1Type(null)
				.setScheduledTerminationDate1(null)
				.setTradeDate(null)
				.setTradeParty1CollateralizationType(null)
				.setTradeParty1EventId(null)
				.setTradeParty2CollateralizationType(null)
				.setTradeParty2EventId(null)
				.setEmbeddedOptionOnSwap(null)
				.setCommencementDate(null)
				.setLeg2EffectiveDate(null)
				.setLeg2ScheduledTerminationDate(null)
				.setNumberOfOptions(null)
				.setOptionEntitlement(null)
				.setPayment1Date(null)
				.setPayment2Date(null)
				.setStrikePriceUnits(null)
				.setAsOfDateTime(null)
				.setCompressedTradeIndicator(null)
				.setConfirmationMethod(null)
				.setConfirmationPlatformId(null)
				.setConfirmationPlatformTradeId(null)
				.setPostTradeEffectiveDate(null)
				.setPriorUsiIdPrefix(null)
				.setPriorUtiIdPrefix(null)
				.setTradeParty1BranchLocation(null)
				.setTradeParty1DeskLocation(null)
				.setTradeParty1Domicile(null)
				.setTradeParty1IndustrialSectorType(null)
				.setTradeParty2BranchLocation(null)
				.setTradeParty2DeskLocation(null)
				.setTradeParty2Domicile(null)
				.setTradeParty2IndustrialSectorType(null)
				.setTradeParty1HkCounterpartyOrigin(null)
				.setLeg2SettlementDate(null)
				.setPostTradeTransactionDate(null)
				.setTradeParty1Name(null)
				.setTradeParty2Name(null)
				.setTradeParty1ValuationAmount(MapperS.of(drrReport).<BigDecimal>map("getValuationAmount", cSAValuationReport -> cSAValuationReport.getValuationAmount()).get())
				.setTradeParty1ValuationCurrency(MapperS.of(drrReport).<ISOCurrencyCodeEnum>map("getValuationCurrency", cSAValuationReport -> cSAValuationReport.getValuationCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
				.setTradeParty1ValuationDatetime(MapperS.of(drrReport).<ZonedDateTime>map("getValuationTimestamp", cSAValuationReport -> cSAValuationReport.getValuationTimestamp()).get())
				.setTradeParty1ValuationType(MapperS.of(drrReport).<ValuationType1Code>map("getValuationMethod", cSAValuationReport -> cSAValuationReport.getValuationMethod()).map("to-string", ValuationType1Code::toDisplayString).get())
				.setTradeParty2ValuationAmount(null)
				.setTradeParty2ValuationCurrency(null)
				.setTradeParty2ValuationDatetime(null)
				.setTradeParty2ValuationType(null)
				.setExecutionType(null)
				.setTradeParty2HkCounterpartyOrigin(null)
				.setTradeParty1CountryOfTheOtherCounterparty(null)
				.setTradeParty2CountryOfTheOtherCounterparty(null)
				.setTradeParty2BrokerId(null)
				.setTradeParty1BeneficiaryIdType(null)
				.setTradeParty1BeneficiaryId(null)
				.setTradeParty2BeneficiaryIdType(null)
				.setTradeParty2BeneficiaryId(null)
				.setTradeParty1CounterpartySide(null)
				.setTradeParty2CounterpartySide(null)
				.setTradeParty1CollateralPortfolioCode(null)
				.setTradeParty2CollateralPortfolioCode(null)
				.setComplexTradeComponentId(null)
				.setPriceMultiplier(null)
				.setProductClassificationType(null)
				.setProductIdentificationType(null)
				.setTradeParty2BrokerIdType(null)
				.setTradeParty2ClearingBrokerIdType(null)
				.setTradeParty2ClearingBrokerId(null)
				.setTradeParty1ClearingThreshold(null)
				.setTradeParty2ClearingThreshold(null)
				.setTradeParty1CorporateSectorType(null)
				.setTradeParty2CorporateSectorType(null)
				.setTradeParty1DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator(null)
				.setTradeParty2DirectlyLinkedToCommercialActivityOrTreasuryFinancingIndicator(null)
				.setTradeParty1TradingCapacity1(null)
				.setTradeParty2TradingCapacity1(null)
				.setTradeParty1CollateralPortfolio(null)
				.setTradeParty2CollateralPortfolio(null)
				.setExpirationDateTimeBusinessCenter(null)
				.setExpirationTime(null)
				.setExpirationTimeType(null)
				.setTradeParty1TraderLocation(null)
				.setTradeParty2TraderLocation(null)
				.setPayment3ResetFrequencyPeriodMultiplier(null)
				.setPayment3ResetFrequencyPeriod(null)
				.setPayment4ResetFrequencyPeriodMultiplier(null)
				.setPayment4ResetFrequencyPeriod(null)
				.setPayment5ResetFrequencyPeriodMultiplier(null)
				.setPayment5ResetFrequencyPeriod(null)
				.setPayment1Type(null)
				.setPayment1Reference(null)
				.setPayment2Type(null)
				.setPayment2Reference(null)
				.setPayment3Payer(null)
				.setPayment3Reference(null)
				.setPayment3FrequencyPeriod(null)
				.setPayment3FrequencyPeriodMultiplier(null)
				.setPayment3Date(null)
				.setPayment4Reference(null)
				.setPayment4Payer(null)
				.setPayment4FrequencyPeriod(null)
				.setPayment4FrequencyPeriodMultiplier(null)
				.setPayment4Date(null)
				.setPayment5Reference(null)
				.setPayment5Payer(null)
				.setPayment5FrequencyPeriod(null)
				.setPayment5FrequencyPeriodMultiplier(null)
				.setPayment5Date(null)
				.setPayment3Type(null)
				.setPremiumPayer(null)
				.setTradeParty1NatureOfTheReportingCounterparty(null)
				.setTradeParty2NatureOfTheReportingCounterparty(null)
				.setReservedParticipantUse1(null)
				.setReservedParticipantUse2(null)
				.setReservedParticipantUse3(null)
				.setReservedParticipantUse4(null)
				.setReservedParticipantUse5(null)
				.setLeg1TerminationDate(null)
				.setCalculationBasis(null)
				.setClearingMemberClientAccountId(null)
				.setClearingReceiptDatetime(null)
				.setClearingSwapSdrLeiId(null)
				.setClearingSwapUtiId(null)
				.setCollateralReportingDate(null)
				.setCollateralValuationDatetime(null)
				.setComment2(null)
				.setCommodityStrikePriceUnit(null)
				.setExecutionAgentMaskingIndicator(null)
				.setFeeInCurrency(null)
				.setFeeOutCurrency(null)
				.setFrequencyOfPayment(null)
				.setLargeTradeIndicator(null)
				.setLeg1EffectiveDateAdjusted(null)
				.setLeg1FinalValuationDate(null)
				.setLeg1SettlementPeriod(null)
				.setLeg2EffectiveDateAdjusted(null)
				.setLeg2SettlementType(null)
				.setLeg2UnderlyingAssetId(null)
				.setLeg2UnderlyingAssetIdType(null)
				.setLeg2UnderlyingAssetName(null)
				.setOptionalEarlyTerminationDate(null)
				.setOptionCommodityCurrency(null)
				.setOptionCommodityExchangeId(null)
				.setOptionCommodityInstrumentId(null)
				.setOptionCommodityRateSource(null)
				.setOptionCommodityRateSourcePage(null)
				.setOptionCommodityUnderlyerDetails(null)
				.setOptionCommodityUnderlyerId(null)
				.setOptionCommodityUnitOfMeasure(null)
				.setOptionSpecifiedPrice(null)
				.setOptionSpreadAmount(null)
				.setOptionSpreadCurrency(null)
				.setOptionSpreadSchedule(null)
				.setOrigin(null)
				.setPremiumPayerPrefix(null)
				.setPrice2Price(null)
				.setPrice2Type(null)
				.setPrice2Units(null)
				.setPrice3Price(null)
				.setPrice3Type(null)
				.setPrice3Units(null)
				.setPrice4Price(null)
				.setPrice4Type(null)
				.setPrice4Units(null)
				.setPricingContext(null)
				.setPriorUsiType(null)
				.setPriorUtiType(null)
				.setRecoveryPrice(null)
				.setSendToDataCenterCode(null)
				.setStrikePriceType(null)
				.setSubAssetClassForOtherCommodity(null)
				.setTradeParty1CollateralAmount(null)
				.setTradeParty1CollateralCurrency(null)
				.setTradeParty1MandatoryDelegatedReporting(null)
				.setTradeParty1Role(null)
				.setTradeParty2CollateralAmount(null)
				.setTradeParty2CollateralCurrency(null)
				.setTradeParty2MandatoryDelegatedReporting(null)
				.setTradeParty2Role(null)
				.setUpfrontPayment(null)
				.setVerificationMethod(null)
				.setNextFloatingReferenceResetDateLeg1(MapperS.of(drrReport).<Date>map("getNextFloatingReferenceResetDateLeg1", cSAValuationReport -> cSAValuationReport.getNextFloatingReferenceResetDateLeg1()).get())
				.setLastFloatingReferenceValueLeg1(MapperS.of(drrReport).<BigDecimal>map("getLastFloatingReferenceValueLeg1", cSAValuationReport -> cSAValuationReport.getLastFloatingReferenceValueLeg1()).get())
				.setLastFloatingReferenceResetDateLeg1(MapperS.of(drrReport).<Date>map("getLastFloatingReferenceResetDateLeg1", cSAValuationReport -> cSAValuationReport.getLastFloatingReferenceResetDateLeg1()).get())
				.setNextFloatingReferenceResetDateLeg2(MapperS.of(drrReport).<Date>map("getNextFloatingReferenceResetDateLeg2", cSAValuationReport -> cSAValuationReport.getNextFloatingReferenceResetDateLeg2()).get())
				.setLastFloatingReferenceValueLeg2(MapperS.of(drrReport).<BigDecimal>map("getLastFloatingReferenceValueLeg2", cSAValuationReport -> cSAValuationReport.getLastFloatingReferenceValueLeg2()).get())
				.setLastFloatingReferenceResetDateLeg2(MapperS.of(drrReport).<Date>map("getLastFloatingReferenceResetDateLeg2", cSAValuationReport -> cSAValuationReport.getLastFloatingReferenceResetDateLeg2()).get())
				.setCdeDelta(MapperS.of(drrReport).<BigDecimal>map("getDelta", cSAValuationReport -> cSAValuationReport.getDelta()).get())
				.setChangeInLeg1NotionalQuantity(null)
				.setChangeInLeg2NotionalQuantity(null)
				.build());
			
			return Optional.ofNullable(harmonized)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
