package drr.projection.iso20022.esma.emir.refit.margin.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.regulation.esma.emir.refit.margin.CollateralReport;
import drr.regulation.esma.emir.refit.margin.PartiesToTheDerivative;
import drr.standards.iso.CollateralisationType3Code__1;
import iso20022.auth108.esma.CollateralPortfolioCode5Choice__1;
import iso20022.auth108.esma.MarginCollateralReport4__1;
import iso20022.auth108.esma.MarginReportData7__1;
import iso20022.auth108.esma.MarginReportData7__1.MarginReportData7__1Builder;
import iso20022.auth108.esma.NotApplicable1Code;
import iso20022.auth108.esma.PortfolioCode3Choice;
import iso20022.auth108.esma.UniqueTransactionIdentifier2Choice__1;
import java.time.ZonedDateTime;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(Create_MarginReportData.Create_MarginReportDataDefault.class)
public abstract class Create_MarginReportData implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected Create_CounterpartySpecificData create_CounterpartySpecificData;
	@Inject protected Create_PostedMarginReport create_PostedMarginReport;
	@Inject protected Create_ReceivedMarginReport create_ReceivedMarginReport;

	/**
	* @param partiesToTheDerivative 
	* @param collateralReport 
	* @return details 
	*/
	public MarginReportData7__1 evaluate(PartiesToTheDerivative partiesToTheDerivative, CollateralReport collateralReport) {
		MarginReportData7__1.MarginReportData7__1Builder detailsBuilder = doEvaluate(partiesToTheDerivative, collateralReport);
		
		final MarginReportData7__1 details;
		if (detailsBuilder == null) {
			details = null;
		} else {
			details = detailsBuilder.build();
			objectValidator.validate(MarginReportData7__1.class, details);
		}
		
		return details;
	}

	protected abstract MarginReportData7__1.MarginReportData7__1Builder doEvaluate(PartiesToTheDerivative partiesToTheDerivative, CollateralReport collateralReport);

	public static class Create_MarginReportDataDefault extends Create_MarginReportData {
		@Override
		protected MarginReportData7__1.MarginReportData7__1Builder doEvaluate(PartiesToTheDerivative partiesToTheDerivative, CollateralReport collateralReport) {
			MarginReportData7__1.MarginReportData7__1Builder details = MarginReportData7__1.builder();
			return assignOutput(details, partiesToTheDerivative, collateralReport);
		}
		
		protected MarginReportData7__1.MarginReportData7__1Builder assignOutput(MarginReportData7__1.MarginReportData7__1Builder details, PartiesToTheDerivative partiesToTheDerivative, CollateralReport collateralReport) {
			String ifThenElseResult0 = null;
			if (exists(MapperS.of(collateralReport).<String>map("getCollateralPortfolioCode", _collateralReport -> _collateralReport.getCollateralPortfolioCode())).getOrDefault(false)) {
				ifThenElseResult0 = MapperS.of(collateralReport).<String>map("getCollateralPortfolioCode", _collateralReport -> _collateralReport.getCollateralPortfolioCode()).get();
			}
			NotApplicable1Code ifThenElseResult1 = null;
			if (notExists(MapperS.of(collateralReport).<String>map("getCollateralPortfolioCode", _collateralReport -> _collateralReport.getCollateralPortfolioCode())).getOrDefault(false)) {
				ifThenElseResult1 = NotApplicable1Code.NOAP;
			}
			details = toBuilder(MarginReportData7__1.builder()
				.setRptgTmStmp(MapperS.of(partiesToTheDerivative).<ZonedDateTime>map("getReportingTimestamp", _partiesToTheDerivative -> _partiesToTheDerivative.getReportingTimestamp()).get())
				.setTxId(UniqueTransactionIdentifier2Choice__1.builder()
					.setUnqTxIdr(MapperS.of(collateralReport).<String>map("getUti", _collateralReport -> _collateralReport.getUti()).get())
					.build())
				.setCtrPtyId(create_CounterpartySpecificData.evaluate(partiesToTheDerivative, collateralReport))
				.setColl(MarginCollateralReport4__1.builder()
					.setCollstnCtgy(MapperS.of(collateralReport).<CollateralisationType3Code__1>map("getCollateralisationCategory", _collateralReport -> _collateralReport.getCollateralisationCategory()).checkedMap("to-enum", e -> iso20022.auth108.esma.CollateralisationType3Code__1.valueOf(e.name()), IllegalArgumentException.class).get())
					.setCollPrtflCd(CollateralPortfolioCode5Choice__1.builder()
						.setPrtfl(PortfolioCode3Choice.builder()
							.setCd(ifThenElseResult0)
							.setNoPrtfl(ifThenElseResult1)
							.build())
						.build())
					.setTmStmp(MapperS.of(collateralReport).<ZonedDateTime>map("getCollateralTimestamp", _collateralReport -> _collateralReport.getCollateralTimestamp()).get())
					.build())
				.setPstdMrgnOrColl(create_PostedMarginReport.evaluate(collateralReport))
				.setRcvdMrgnOrColl(create_ReceivedMarginReport.evaluate(collateralReport))
				.setEvtDt(MapperS.of(collateralReport).<Date>map("getEventDate", _collateralReport -> _collateralReport.getEventDate()).get())
				.build());
			
			return Optional.ofNullable(details)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
