package drr.projection.iso20022.esma.emir.refit.trade.functions;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.CommonAssetClass;
import drr.regulation.common.CommonContractType;
import drr.regulation.esma.emir.refit.trade.ESMAEMIRTransactionReport;
import drr.standards.iosco.cde.price.PriceFormat;
import drr.standards.iosco.cde.price.PriceNotationEnum;
import drr.standards.iosco.cde.price.PricePeriod;
import drr.standards.iso.OptionStyleEnum;
import drr.standards.iso.OptionTypeCode;
import iso20022.auth030.esma.ActiveOrHistoricCurrencyAnd13DecimalAmount__1;
import iso20022.auth030.esma.ActiveOrHistoricCurrencyAnd5DecimalAmount__1;
import iso20022.auth030.esma.AmountAndDirection106__1;
import iso20022.auth030.esma.OptionOrSwaption10__1;
import iso20022.auth030.esma.OptionOrSwaption10__1.OptionOrSwaption10__1Builder;
import iso20022.auth030.esma.OptionStyle6Code__1;
import iso20022.auth030.esma.OptionType2Code;
import iso20022.auth030.esma.Schedule4__1;
import iso20022.auth030.esma.SecuritiesTransactionPrice17Choice__1;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(GetOptn.GetOptnDefault.class)
public abstract class GetOptn implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;

	/**
	* @param drrReport 
	* @return optn 
	*/
	public OptionOrSwaption10__1 evaluate(ESMAEMIRTransactionReport drrReport) {
		OptionOrSwaption10__1.OptionOrSwaption10__1Builder optnBuilder = doEvaluate(drrReport);
		
		final OptionOrSwaption10__1 optn;
		if (optnBuilder == null) {
			optn = null;
		} else {
			optn = optnBuilder.build();
			objectValidator.validate(OptionOrSwaption10__1.class, optn);
		}
		
		return optn;
	}

	protected abstract OptionOrSwaption10__1.OptionOrSwaption10__1Builder doEvaluate(ESMAEMIRTransactionReport drrReport);

	public static class GetOptnDefault extends GetOptn {
		@Override
		protected OptionOrSwaption10__1.OptionOrSwaption10__1Builder doEvaluate(ESMAEMIRTransactionReport drrReport) {
			OptionOrSwaption10__1.OptionOrSwaption10__1Builder optn = OptionOrSwaption10__1.builder();
			return assignOutput(optn, drrReport);
		}
		
		protected OptionOrSwaption10__1.OptionOrSwaption10__1Builder assignOutput(OptionOrSwaption10__1.OptionOrSwaption10__1Builder optn, ESMAEMIRTransactionReport drrReport) {
			optn = toBuilder(OptionOrSwaption10__1.builder()
				.setTp(MapperS.of(drrReport).<OptionTypeCode>map("getOptionType", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getOptionType()).checkedMap("to-enum", e -> OptionType2Code.valueOf(e.name()), IllegalArgumentException.class).get())
				.setExrcStyle(MapperS.of(drrReport).<OptionStyleEnum>map("getOptionStyle", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getOptionStyle()).checkedMap("to-enum", e -> OptionStyle6Code__1.valueOf(e.name()), IllegalArgumentException.class).get())
				.setStrkPric(MapperS.of(drrReport)
					.mapSingleToItem(item -> {
						AmountAndDirection106__1 ifThenElseResult1 = null;
						if (areEqual(item.<PriceNotationEnum>map("getStrikePriceNotation", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getStrikePriceNotation()), MapperS.of(PriceNotationEnum.MONETARY), CardinalityOperator.All).getOrDefault(false)) {
							String ifThenElseResult0 = null;
							if (areEqual(areEqual(MapperS.of(drrReport).<CommonContractType>map("getContractType", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getContractType()), MapperS.of(CommonContractType.OPTN), CardinalityOperator.All).or(areEqual(MapperS.of(drrReport).<CommonContractType>map("getContractType", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getContractType()), MapperS.of(CommonContractType.SWPT), CardinalityOperator.All)).and(areEqual(MapperS.of(drrReport).<CommonAssetClass>map("getAssetClass", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getAssetClass()), MapperS.of(CommonAssetClass.CURR), CardinalityOperator.All).or(areEqual(MapperS.of(drrReport).<CommonAssetClass>map("getAssetClass", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getAssetClass()), MapperS.of(CommonAssetClass.INTR), CardinalityOperator.All))), MapperS.of(false), CardinalityOperator.All).getOrDefault(false)) {
								ifThenElseResult0 = MapperS.of(drrReport).<String>map("getStrikePriceCurrency", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getStrikePriceCurrency()).map("to-string", Object::toString).get();
							}
							ifThenElseResult1 = AmountAndDirection106__1.builder()
								.setAmt(ActiveOrHistoricCurrencyAnd13DecimalAmount__1.builder()
									.setValue(item.<PriceFormat>map("getStrikePrice", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getStrikePrice()).<BigDecimal>map("getMonetary", priceFormat -> priceFormat.getMonetary()).get())
									.setCcy(ifThenElseResult0)
									.build())
								.build();
						}
						BigDecimal ifThenElseResult2 = null;
						if (areEqual(item.<PriceNotationEnum>map("getStrikePriceNotation", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getStrikePriceNotation()), MapperS.of(PriceNotationEnum.PERCENTAGE), CardinalityOperator.All).getOrDefault(false)) {
							ifThenElseResult2 = item.<PriceFormat>map("getStrikePrice", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getStrikePrice()).<BigDecimal>map("getPercentage", priceFormat -> priceFormat.getPercentage()).get();
						}
						return MapperS.of(SecuritiesTransactionPrice17Choice__1.builder()
							.setMntryVal(ifThenElseResult1)
							.setPctg(ifThenElseResult2)
							.build());
					}).get())
				.setStrkPricSchdl(MapperS.of(drrReport).<PricePeriod>mapC("getStrikePriceSchedule", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getStrikePriceSchedule())
					.mapItem(item -> {
						AmountAndDirection106__1 ifThenElseResult1 = null;
						if (exists(item.<PriceFormat>map("getPrice", pricePeriod -> pricePeriod.getPrice()).<BigDecimal>map("getMonetary", priceFormat -> priceFormat.getMonetary())).getOrDefault(false)) {
							String ifThenElseResult0 = null;
							if (areEqual(MapperS.of(drrReport).<CommonContractType>map("getContractType", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getContractType()), MapperS.of(CommonContractType.OPTN), CardinalityOperator.All).or(areEqual(MapperS.of(drrReport).<CommonContractType>map("getContractType", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getContractType()), MapperS.of(CommonContractType.SWPT), CardinalityOperator.All)).and(areEqual(areEqual(MapperS.of(drrReport).<CommonAssetClass>map("getAssetClass", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getAssetClass()), MapperS.of(CommonAssetClass.CURR), CardinalityOperator.All).or(areEqual(MapperS.of(drrReport).<CommonAssetClass>map("getAssetClass", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getAssetClass()), MapperS.of(CommonAssetClass.INTR), CardinalityOperator.All)), MapperS.of(false), CardinalityOperator.All)).getOrDefault(false)) {
								ifThenElseResult0 = MapperS.of(drrReport).<String>map("getStrikePriceCurrency", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getStrikePriceCurrency()).map("to-string", Object::toString).get();
							}
							ifThenElseResult1 = AmountAndDirection106__1.builder()
								.setAmt(ActiveOrHistoricCurrencyAnd13DecimalAmount__1.builder()
									.setValue(item.<PriceFormat>map("getPrice", pricePeriod -> pricePeriod.getPrice()).<BigDecimal>map("getMonetary", priceFormat -> priceFormat.getMonetary()).get())
									.setCcy(ifThenElseResult0)
									.build())
								.build();
						}
						BigDecimal ifThenElseResult2 = null;
						if (exists(item.<PriceFormat>map("getPrice", pricePeriod -> pricePeriod.getPrice()).<BigDecimal>map("getPercentage", priceFormat -> priceFormat.getPercentage())).getOrDefault(false)) {
							ifThenElseResult2 = item.<PriceFormat>map("getPrice", pricePeriod -> pricePeriod.getPrice()).<BigDecimal>map("getPercentage", priceFormat -> priceFormat.getPercentage()).get();
						}
						return MapperS.of(Schedule4__1.builder()
							.setUadjstdFctvDt(item.<Date>map("getEffectiveDate", pricePeriod -> pricePeriod.getEffectiveDate()).get())
							.setUadjstdEndDt(item.<Date>map("getEndDate", pricePeriod -> pricePeriod.getEndDate()).get())
							.setPric(SecuritiesTransactionPrice17Choice__1.builder()
								.setMntryVal(ifThenElseResult1)
								.setPctg(ifThenElseResult2)
								.build())
							.build());
					}).getMulti())
				.setPrmAmt(ActiveOrHistoricCurrencyAnd5DecimalAmount__1.builder()
					.setValue(MapperS.of(drrReport).<BigDecimal>map("getOptionPremiumAmount", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getOptionPremiumAmount()).get())
					.setCcy(MapperS.of(drrReport).<ISOCurrencyCodeEnum>map("getOptionPremiumCurrency", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getOptionPremiumCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
					.build())
				.setPrmPmtDt(MapperS.of(drrReport).<Date>map("getOptionPremiumPaymentDate", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getOptionPremiumPaymentDate()).get())
				.setMtrtyDtOfUndrlyg(MapperS.of(drrReport).<Date>map("getMaturityDateOfTheUnderlying", eSMAEMIRTransactionReport -> eSMAEMIRTransactionReport.getMaturityDateOfTheUnderlying()).get())
				.build());
			
			return Optional.ofNullable(optn)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
