package drr.projection.iso20022.hkma.rewrite.trade.tr.functions;

import cdm.base.math.functions.Abs;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.CommonAssetClass;
import drr.regulation.common.CommonContractType;
import drr.regulation.common.trade.CommonLeg;
import drr.regulation.hkma.rewrite.trade.HKMATransactionReport;
import drr.standards.iosco.cde.price.PriceFormat;
import drr.standards.iosco.cde.price.PriceNotationEnum;
import drr.standards.iosco.cde.price.PricePeriod;
import drr.standards.iso.EmbeddedOptionTypeEnum;
import drr.standards.iso.OptionStyleEnum;
import drr.standards.iso.OptionTypeCode;
import iso20022.auth030.hkma.tr.ActiveOrHistoricCurrencyAnd13DecimalAmount;
import iso20022.auth030.hkma.tr.ActiveOrHistoricCurrencyAnd5DecimalAmount;
import iso20022.auth030.hkma.tr.AmountAndDirection106__1;
import iso20022.auth030.hkma.tr.AmountAndDirection106__2;
import iso20022.auth030.hkma.tr.EmbeddedType1Code;
import iso20022.auth030.hkma.tr.ExerciseDate1Choice__1;
import iso20022.auth030.hkma.tr.OptionOrSwaption11__1;
import iso20022.auth030.hkma.tr.OptionOrSwaption11__1.OptionOrSwaption11__1Builder;
import iso20022.auth030.hkma.tr.OptionStyle6Code;
import iso20022.auth030.hkma.tr.OptionType2Code;
import iso20022.auth030.hkma.tr.Schedule4__1;
import iso20022.auth030.hkma.tr.SecuritiesTransactionPrice17Choice__1;
import iso20022.auth030.hkma.tr.SecuritiesTransactionPrice17Choice__2;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(GetOptn.GetOptnDefault.class)
public abstract class GetOptn implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected Abs abs;
	@Inject protected Create_OptionBarrierLevel1Choice__1 create_OptionBarrierLevel1Choice__1;

	/**
	* @param drrReport 
	* @return optn 
	*/
	public OptionOrSwaption11__1 evaluate(HKMATransactionReport drrReport) {
		OptionOrSwaption11__1.OptionOrSwaption11__1Builder optnBuilder = doEvaluate(drrReport);
		
		final OptionOrSwaption11__1 optn;
		if (optnBuilder == null) {
			optn = null;
		} else {
			optn = optnBuilder.build();
			objectValidator.validate(OptionOrSwaption11__1.class, optn);
		}
		
		return optn;
	}

	protected abstract OptionOrSwaption11__1.OptionOrSwaption11__1Builder doEvaluate(HKMATransactionReport drrReport);

	public static class GetOptnDefault extends GetOptn {
		@Override
		protected OptionOrSwaption11__1.OptionOrSwaption11__1Builder doEvaluate(HKMATransactionReport drrReport) {
			OptionOrSwaption11__1.OptionOrSwaption11__1Builder optn = OptionOrSwaption11__1.builder();
			return assignOutput(optn, drrReport);
		}
		
		protected OptionOrSwaption11__1.OptionOrSwaption11__1Builder assignOutput(OptionOrSwaption11__1.OptionOrSwaption11__1Builder optn, HKMATransactionReport drrReport) {
			final String ifThenElseResult;
			if (exists(MapperS.of(drrReport).<ISOCurrencyCodeEnum>map("getOptionPremiumCurrency", hKMATransactionReport -> hKMATransactionReport.getOptionPremiumCurrency())).getOrDefault(false)) {
				ifThenElseResult = MapperS.of(drrReport).<ISOCurrencyCodeEnum>map("getOptionPremiumCurrency", hKMATransactionReport -> hKMATransactionReport.getOptionPremiumCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get();
			} else if (areEqual(MapperS.of(drrReport).<BigDecimal>map("getOptionPremiumAmount", hKMATransactionReport -> hKMATransactionReport.getOptionPremiumAmount()), MapperS.of(BigDecimal.valueOf(0)), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult = MapperS.of(drrReport).<CommonLeg>map("getLeg1", hKMATransactionReport -> hKMATransactionReport.getLeg1()).<ISOCurrencyCodeEnum>map("getSettlementCurrency", commonLeg -> commonLeg.getSettlementCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get();
			} else {
				ifThenElseResult = null;
			}
			optn = toBuilder(OptionOrSwaption11__1.builder()
				.setStrkPric(MapperS.of(drrReport)
					.mapSingleToItem(item -> {
						AmountAndDirection106__1 ifThenElseResult2 = null;
						if (areEqual(item.<PriceNotationEnum>map("getStrikePriceNotation", hKMATransactionReport -> hKMATransactionReport.getStrikePriceNotation()), MapperS.of(PriceNotationEnum.MONETARY), CardinalityOperator.All).getOrDefault(false)) {
							String ifThenElseResult0 = null;
							if (areEqual(MapperS.of(drrReport).<CommonContractType>map("getContractType", hKMATransactionReport -> hKMATransactionReport.getContractType()), MapperS.of(CommonContractType.OPTN), CardinalityOperator.All).or(areEqual(MapperS.of(drrReport).<CommonContractType>map("getContractType", hKMATransactionReport -> hKMATransactionReport.getContractType()), MapperS.of(CommonContractType.SWPT), CardinalityOperator.All)).and(areEqual(areEqual(MapperS.of(drrReport).<CommonAssetClass>map("getAssetClass", hKMATransactionReport -> hKMATransactionReport.getAssetClass()), MapperS.of(CommonAssetClass.CURR), CardinalityOperator.All).or(areEqual(MapperS.of(drrReport).<CommonAssetClass>map("getAssetClass", hKMATransactionReport -> hKMATransactionReport.getAssetClass()), MapperS.of(CommonAssetClass.INTR), CardinalityOperator.All)), MapperS.of(false), CardinalityOperator.All)).getOrDefault(false)) {
								ifThenElseResult0 = MapperS.of(drrReport).<String>map("getStrikePriceCurrency", hKMATransactionReport -> hKMATransactionReport.getStrikePriceCurrency()).map("to-string", Object::toString).get();
							}
							Boolean ifThenElseResult1 = null;
							if (lessThan(item.<PriceFormat>map("getStrikePrice", hKMATransactionReport -> hKMATransactionReport.getStrikePrice()).<BigDecimal>map("getMonetary", priceFormat -> priceFormat.getMonetary()), MapperS.of(BigDecimal.valueOf(0)), CardinalityOperator.All).getOrDefault(false)) {
								ifThenElseResult1 = false;
							}
							ifThenElseResult2 = AmountAndDirection106__1.builder()
								.setAmt(ActiveOrHistoricCurrencyAnd13DecimalAmount.builder()
									.setValue(abs.evaluate(item.<PriceFormat>map("getStrikePrice", hKMATransactionReport -> hKMATransactionReport.getStrikePrice()).<BigDecimal>map("getMonetary", priceFormat -> priceFormat.getMonetary()).get()))
									.setCcy(ifThenElseResult0)
									.build())
								.setSgn(ifThenElseResult1)
								.build();
						}
						BigDecimal ifThenElseResult3 = null;
						if (areEqual(item.<PriceNotationEnum>map("getStrikePriceNotation", hKMATransactionReport -> hKMATransactionReport.getStrikePriceNotation()), MapperS.of(PriceNotationEnum.DECIMAL), CardinalityOperator.All).getOrDefault(false)) {
							ifThenElseResult3 = item.<PriceFormat>map("getStrikePrice", hKMATransactionReport -> hKMATransactionReport.getStrikePrice()).<BigDecimal>map("getDecimal", priceFormat -> priceFormat.getDecimal()).get();
						}
						return MapperS.of(SecuritiesTransactionPrice17Choice__1.builder()
							.setMntryVal(ifThenElseResult2)
							.setDcml(ifThenElseResult3)
							.build());
					}).get())
				.setCallAmt(ActiveOrHistoricCurrencyAnd5DecimalAmount.builder()
					.setValue(MapperS.of(drrReport).<BigDecimal>map("getCallAmount", hKMATransactionReport -> hKMATransactionReport.getCallAmount()).get())
					.setCcy(MapperS.of(drrReport).<ISOCurrencyCodeEnum>map("getCallCurrency", hKMATransactionReport -> hKMATransactionReport.getCallCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
					.build())
				.setPutAmt(ActiveOrHistoricCurrencyAnd5DecimalAmount.builder()
					.setValue(MapperS.of(drrReport).<BigDecimal>map("getPutAmount", hKMATransactionReport -> hKMATransactionReport.getPutAmount()).get())
					.setCcy(MapperS.of(drrReport).<ISOCurrencyCodeEnum>map("getPutCurrency", hKMATransactionReport -> hKMATransactionReport.getPutCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
					.build())
				.setPrmAmt(ActiveOrHistoricCurrencyAnd5DecimalAmount.builder()
					.setValue(MapperS.of(drrReport).<BigDecimal>map("getOptionPremiumAmount", hKMATransactionReport -> hKMATransactionReport.getOptionPremiumAmount()).get())
					.setCcy(ifThenElseResult)
					.build())
				.setPrmPmtDt(MapperS.of(drrReport).<Date>map("getOptionPremiumPaymentDate", hKMATransactionReport -> hKMATransactionReport.getOptionPremiumPaymentDate()).get())
				.setMtrtyDtOfUndrlyg(MapperS.of(drrReport).<Date>map("getMaturityDateOfTheUnderlying", hKMATransactionReport -> hKMATransactionReport.getMaturityDateOfTheUnderlying()).get())
				.setBrrrLvls(create_OptionBarrierLevel1Choice__1.evaluate(drrReport))
				.setTp(MapperS.of(drrReport).<OptionTypeCode>map("getOptionType", hKMATransactionReport -> hKMATransactionReport.getOptionType()).checkedMap("to-enum", e -> OptionType2Code.valueOf(e.name()), IllegalArgumentException.class).get())
				.setMbddTp(MapperS.of(drrReport).<EmbeddedOptionTypeEnum>map("getEmbeddedOptionType", hKMATransactionReport -> hKMATransactionReport.getEmbeddedOptionType()).checkedMap("to-enum", e -> EmbeddedType1Code.valueOf(e.name()), IllegalArgumentException.class).get())
				.setExrcStyle(MapperS.of(drrReport).<OptionStyleEnum>map("getOptionStyle", hKMATransactionReport -> hKMATransactionReport.getOptionStyle()).checkedMap("to-enum", e -> OptionStyle6Code.valueOf(e.name()), IllegalArgumentException.class).get())
				.setExrcDt(ExerciseDate1Choice__1.builder()
					.setFrstExrcDt(MapperS.of(drrReport).<Date>map("getFirstExerciseDate", hKMATransactionReport -> hKMATransactionReport.getFirstExerciseDate()).get())
					.build())
				.setStrkPricSchdl(MapperS.of(drrReport).<PricePeriod>mapC("getStrikePriceSchedule", hKMATransactionReport -> hKMATransactionReport.getStrikePriceSchedule())
					.mapItem(item -> MapperS.of(Schedule4__1.builder()
						.setUadjstdFctvDt(item.<Date>map("getEffectiveDate", pricePeriod -> pricePeriod.getEffectiveDate()).get())
						.setUadjstdEndDt(item.<Date>map("getEndDate", pricePeriod -> pricePeriod.getEndDate()).get())
						.setPric(SecuritiesTransactionPrice17Choice__2.builder()
							.setMntryVal(AmountAndDirection106__2.builder()
								.setAmt(ActiveOrHistoricCurrencyAnd13DecimalAmount.builder()
									.setValue(item.<PriceFormat>map("getPrice", pricePeriod -> pricePeriod.getPrice()).<BigDecimal>map("getMonetary", priceFormat -> priceFormat.getMonetary()).get())
									.setCcy(MapperS.of(drrReport).<String>map("getStrikePriceCurrency", hKMATransactionReport -> hKMATransactionReport.getStrikePriceCurrency()).get())
									.build())
								.build())
							.setDcml(item.<PriceFormat>map("getPrice", pricePeriod -> pricePeriod.getPrice()).<BigDecimal>map("getDecimal", priceFormat -> priceFormat.getDecimal()).get())
							.build())
						.build())).getMulti())
				.build());
			
			return Optional.ofNullable(optn)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
