package drr.projection.iso20022.hkma.rewrite.valuation.tr.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.PartyIdentifierFormat2Enum;
import iso20022.auth030.hkma.tr.GenericIdentification175__2;
import iso20022.auth030.hkma.tr.HKTRPartyScheme;
import iso20022.auth030.hkma.tr.OrganisationIdentification15Choice__3;
import iso20022.auth030.hkma.tr.OrganisationIdentification15Choice__3.OrganisationIdentification15Choice__3Builder;
import iso20022.auth030.hkma.tr.OrganisationIdentification38__2;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(Create_OrganisationIdentification15Choice__3.Create_OrganisationIdentification15Choice__3Default.class)
public abstract class Create_OrganisationIdentification15Choice__3 implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;

	/**
	* @param idFormat 
	* @param idFromReport 
	* @param idSchemeName 
	* @return id 
	*/
	public OrganisationIdentification15Choice__3 evaluate(PartyIdentifierFormat2Enum idFormat, String idFromReport, HKTRPartyScheme idSchemeName) {
		OrganisationIdentification15Choice__3.OrganisationIdentification15Choice__3Builder idBuilder = doEvaluate(idFormat, idFromReport, idSchemeName);
		
		final OrganisationIdentification15Choice__3 id;
		if (idBuilder == null) {
			id = null;
		} else {
			id = idBuilder.build();
			objectValidator.validate(OrganisationIdentification15Choice__3.class, id);
		}
		
		return id;
	}

	protected abstract OrganisationIdentification15Choice__3.OrganisationIdentification15Choice__3Builder doEvaluate(PartyIdentifierFormat2Enum idFormat, String idFromReport, HKTRPartyScheme idSchemeName);

	public static class Create_OrganisationIdentification15Choice__3Default extends Create_OrganisationIdentification15Choice__3 {
		@Override
		protected OrganisationIdentification15Choice__3.OrganisationIdentification15Choice__3Builder doEvaluate(PartyIdentifierFormat2Enum idFormat, String idFromReport, HKTRPartyScheme idSchemeName) {
			OrganisationIdentification15Choice__3.OrganisationIdentification15Choice__3Builder id = OrganisationIdentification15Choice__3.builder();
			return assignOutput(id, idFormat, idFromReport, idSchemeName);
		}
		
		protected OrganisationIdentification15Choice__3.OrganisationIdentification15Choice__3Builder assignOutput(OrganisationIdentification15Choice__3.OrganisationIdentification15Choice__3Builder id, PartyIdentifierFormat2Enum idFormat, String idFromReport, HKTRPartyScheme idSchemeName) {
			String ifThenElseResult0 = null;
			if (areEqual(MapperS.of(idFormat), MapperS.of(PartyIdentifierFormat2Enum.LEI), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult0 = idFromReport;
			}
			OrganisationIdentification38__2 ifThenElseResult2 = null;
			if (areEqual(MapperS.of(idFormat), MapperS.of(PartyIdentifierFormat2Enum.OTHER), CardinalityOperator.All).getOrDefault(false)) {
				final HKTRPartyScheme ifThenElseResult1;
				if (areEqual(MapperS.of(idSchemeName), MapperS.of(HKTRPartyScheme.BRNO), CardinalityOperator.All).getOrDefault(false)) {
					ifThenElseResult1 = HKTRPartyScheme.BRNO;
				} else if (areEqual(MapperS.of(idSchemeName), MapperS.of(HKTRPartyScheme.CICR), CardinalityOperator.All).getOrDefault(false)) {
					ifThenElseResult1 = HKTRPartyScheme.CICR;
				} else if (areEqual(MapperS.of(idSchemeName), MapperS.of(HKTRPartyScheme.TRID), CardinalityOperator.All).getOrDefault(false)) {
					ifThenElseResult1 = HKTRPartyScheme.TRID;
				} else if (areEqual(MapperS.of(idSchemeName), MapperS.of(HKTRPartyScheme.UBIN), CardinalityOperator.All).getOrDefault(false)) {
					ifThenElseResult1 = HKTRPartyScheme.UBIN;
				} else if (areEqual(MapperS.of(idSchemeName), MapperS.of(HKTRPartyScheme.USDC), CardinalityOperator.All).getOrDefault(false)) {
					ifThenElseResult1 = HKTRPartyScheme.USDC;
				} else {
					ifThenElseResult1 = null;
				}
				ifThenElseResult2 = OrganisationIdentification38__2.builder()
					.setId(GenericIdentification175__2.builder()
						.setId(idFromReport)
						.setSchmeNm(ifThenElseResult1)
						.build())
					.build();
			}
			String ifThenElseResult3 = null;
			if (areEqual(MapperS.of(idFormat), MapperS.of(PartyIdentifierFormat2Enum.SWIFTBIC), CardinalityOperator.All).getOrDefault(false)) {
				ifThenElseResult3 = idFromReport;
			}
			id = toBuilder(OrganisationIdentification15Choice__3.builder()
				.setLei(ifThenElseResult0)
				.setOthr(ifThenElseResult2)
				.setAnyBIC(ifThenElseResult3)
				.build());
			
			return Optional.ofNullable(id)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
