package drr.projection.iso20022.jfsa.rewrite.margin.functions;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.jfsa.rewrite.margin.CollateralReport;
import iso20022.auth108.jfsa.ActiveOrHistoricCurrencyAnd5DecimalAmount;
import iso20022.auth108.jfsa.PostedMarginOrCollateral6__1;
import iso20022.auth108.jfsa.PostedMarginOrCollateral6__1.PostedMarginOrCollateral6__1Builder;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;


@ImplementedBy(Create_PostedMarginReport.Create_PostedMarginReportDefault.class)
public abstract class Create_PostedMarginReport implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;

	/**
	* @param collateralReport 
	* @return postMarginData 
	*/
	public PostedMarginOrCollateral6__1 evaluate(CollateralReport collateralReport) {
		PostedMarginOrCollateral6__1.PostedMarginOrCollateral6__1Builder postMarginDataBuilder = doEvaluate(collateralReport);
		
		final PostedMarginOrCollateral6__1 postMarginData;
		if (postMarginDataBuilder == null) {
			postMarginData = null;
		} else {
			postMarginData = postMarginDataBuilder.build();
			objectValidator.validate(PostedMarginOrCollateral6__1.class, postMarginData);
		}
		
		return postMarginData;
	}

	protected abstract PostedMarginOrCollateral6__1.PostedMarginOrCollateral6__1Builder doEvaluate(CollateralReport collateralReport);

	public static class Create_PostedMarginReportDefault extends Create_PostedMarginReport {
		@Override
		protected PostedMarginOrCollateral6__1.PostedMarginOrCollateral6__1Builder doEvaluate(CollateralReport collateralReport) {
			PostedMarginOrCollateral6__1.PostedMarginOrCollateral6__1Builder postMarginData = PostedMarginOrCollateral6__1.builder();
			return assignOutput(postMarginData, collateralReport);
		}
		
		protected PostedMarginOrCollateral6__1.PostedMarginOrCollateral6__1Builder assignOutput(PostedMarginOrCollateral6__1.PostedMarginOrCollateral6__1Builder postMarginData, CollateralReport collateralReport) {
			postMarginData = toBuilder(PostedMarginOrCollateral6__1.builder()
				.setInitlMrgnPstdPreHrcut(ActiveOrHistoricCurrencyAnd5DecimalAmount.builder()
					.setValue(MapperS.of(collateralReport).<BigDecimal>map("getInitialMarginPostedByTheReportingCounterpartyPreHaircut", _collateralReport -> _collateralReport.getInitialMarginPostedByTheReportingCounterpartyPreHaircut()).get())
					.setCcy(MapperS.of(collateralReport).<ISOCurrencyCodeEnum>map("getCurrencyofInitialMarginPosted", _collateralReport -> _collateralReport.getCurrencyofInitialMarginPosted()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
					.build())
				.setInitlMrgnPstdPstHrcut(ActiveOrHistoricCurrencyAnd5DecimalAmount.builder()
					.setValue(MapperS.of(collateralReport).<BigDecimal>map("getInitialMarginPostedByTheReportingCounterpartyPostHaircut", _collateralReport -> _collateralReport.getInitialMarginPostedByTheReportingCounterpartyPostHaircut()).get())
					.setCcy(MapperS.of(collateralReport).<ISOCurrencyCodeEnum>map("getCurrencyofInitialMarginPosted", _collateralReport -> _collateralReport.getCurrencyofInitialMarginPosted()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
					.build())
				.setVartnMrgnPstdPreHrcut(ActiveOrHistoricCurrencyAnd5DecimalAmount.builder()
					.setValue(MapperS.of(collateralReport).<BigDecimal>map("getVariationMarginPostedByTheReportingCounterpartyPreHaircut", _collateralReport -> _collateralReport.getVariationMarginPostedByTheReportingCounterpartyPreHaircut()).get())
					.setCcy(MapperS.of(collateralReport).<ISOCurrencyCodeEnum>map("getCurrencyOfVariationMarginPosted", _collateralReport -> _collateralReport.getCurrencyOfVariationMarginPosted()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
					.build())
				.setVartnMrgnPstdPstHrcut(ActiveOrHistoricCurrencyAnd5DecimalAmount.builder()
					.setValue(MapperS.of(collateralReport).<BigDecimal>map("getVariationMarginPostedByTheReportingCounterpartyPostHaircut", _collateralReport -> _collateralReport.getVariationMarginPostedByTheReportingCounterpartyPostHaircut()).get())
					.setCcy(MapperS.of(collateralReport).<ISOCurrencyCodeEnum>map("getCurrencyOfVariationMarginPosted", _collateralReport -> _collateralReport.getCurrencyOfVariationMarginPosted()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
					.build())
				.setXcssCollPstd(ActiveOrHistoricCurrencyAnd5DecimalAmount.builder()
					.setValue(MapperS.of(collateralReport).<BigDecimal>map("getExcessCollateralPostedByTheReportingCounterparty", _collateralReport -> _collateralReport.getExcessCollateralPostedByTheReportingCounterparty()).get())
					.setCcy(MapperS.of(collateralReport).<String>map("getCurrencyOfTheExcessCollateralPosted", _collateralReport -> _collateralReport.getCurrencyOfTheExcessCollateralPosted()).map("to-string", Object::toString).get())
					.build())
				.build());
			
			return Optional.ofNullable(postMarginData)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
