package drr.projection.iso20022.jfsa.rewrite.trade.functions;

import cdm.base.math.functions.Abs;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.jfsa.rewrite.trade.JFSATransactionReport;
import drr.standards.iosco.cde.price.PriceFormat;
import drr.standards.iosco.cde.price.PriceNotationEnum;
import iso20022.auth030.jfsa.ActiveOrHistoricCurrencyAnd13DecimalAmount;
import iso20022.auth030.jfsa.AmountAndDirection106__1;
import iso20022.auth030.jfsa.Package4__1;
import iso20022.auth030.jfsa.Package4__1.Package4__1Builder;
import iso20022.auth030.jfsa.SecuritiesTransactionPrice17Choice__1;
import iso20022.auth030.jfsa.SecuritiesTransactionPrice20Choice__1;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(GetPackg.GetPackgDefault.class)
public abstract class GetPackg implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected Abs abs;

	/**
	* @param drrReport 
	* @return packg 
	*/
	public Package4__1 evaluate(JFSATransactionReport drrReport) {
		Package4__1.Package4__1Builder packgBuilder = doEvaluate(drrReport);
		
		final Package4__1 packg;
		if (packgBuilder == null) {
			packg = null;
		} else {
			packg = packgBuilder.build();
			objectValidator.validate(Package4__1.class, packg);
		}
		
		return packg;
	}

	protected abstract Package4__1.Package4__1Builder doEvaluate(JFSATransactionReport drrReport);

	public static class GetPackgDefault extends GetPackg {
		@Override
		protected Package4__1.Package4__1Builder doEvaluate(JFSATransactionReport drrReport) {
			Package4__1.Package4__1Builder packg = Package4__1.builder();
			return assignOutput(packg, drrReport);
		}
		
		protected Package4__1.Package4__1Builder assignOutput(Package4__1.Package4__1Builder packg, JFSATransactionReport drrReport) {
			packg = toBuilder(Package4__1.builder()
				.setCmplxTradId(MapperS.of(drrReport).<String>map("getPackageIdentifier", jFSATransactionReport -> jFSATransactionReport.getPackageIdentifier()).get())
				.setPric(MapperS.of(drrReport)
					.mapSingleToItem(item -> {
						AmountAndDirection106__1 ifThenElseResult1 = null;
						if (areEqual(item.<PriceNotationEnum>map("getPackageTransactionPriceNotation", jFSATransactionReport -> jFSATransactionReport.getPackageTransactionPriceNotation()), MapperS.of(PriceNotationEnum.MONETARY), CardinalityOperator.All).getOrDefault(false)) {
							Boolean ifThenElseResult0 = null;
							if (lessThan(item.<PriceFormat>map("getPackageTransactionPrice", jFSATransactionReport -> jFSATransactionReport.getPackageTransactionPrice()).<BigDecimal>map("getMonetary", priceFormat -> priceFormat.getMonetary()), MapperS.of(BigDecimal.valueOf(0)), CardinalityOperator.All).getOrDefault(false)) {
								ifThenElseResult0 = false;
							}
							ifThenElseResult1 = AmountAndDirection106__1.builder()
								.setAmt(ActiveOrHistoricCurrencyAnd13DecimalAmount.builder()
									.setValue(abs.evaluate(MapperS.of(drrReport).<PriceFormat>map("getPackageTransactionPrice", jFSATransactionReport -> jFSATransactionReport.getPackageTransactionPrice()).<BigDecimal>map("getMonetary", priceFormat -> priceFormat.getMonetary()).get()))
									.setCcy(MapperS.of(drrReport).<ISOCurrencyCodeEnum>map("getPackageTransactionPriceCurrency", jFSATransactionReport -> jFSATransactionReport.getPackageTransactionPriceCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
									.build())
								.setSgn(ifThenElseResult0)
								.build();
						}
						BigDecimal ifThenElseResult2 = null;
						if (areEqual(MapperS.of(drrReport).<PriceNotationEnum>map("getPackageTransactionPriceNotation", jFSATransactionReport -> jFSATransactionReport.getPackageTransactionPriceNotation()), MapperS.of(PriceNotationEnum.DECIMAL), CardinalityOperator.All).getOrDefault(false)) {
							ifThenElseResult2 = MapperS.of(drrReport).<PriceFormat>map("getPackageTransactionPrice", jFSATransactionReport -> jFSATransactionReport.getPackageTransactionPrice()).<BigDecimal>map("getMonetary", priceFormat -> priceFormat.getMonetary()).get();
						}
						return MapperS.of(SecuritiesTransactionPrice17Choice__1.builder()
							.setMntryVal(ifThenElseResult1)
							.setDcml(ifThenElseResult2)
							.build());
					}).get())
				.setSprd(MapperS.of(drrReport)
					.mapSingleToItem(item -> {
						AmountAndDirection106__1 ifThenElseResult1 = null;
						if (areEqual(item.<PriceNotationEnum>map("getPackageTransactionSpreadNotation", jFSATransactionReport -> jFSATransactionReport.getPackageTransactionSpreadNotation()), MapperS.of(PriceNotationEnum.MONETARY), CardinalityOperator.All).getOrDefault(false)) {
							Boolean ifThenElseResult0 = null;
							if (lessThan(item.<PriceFormat>map("getPackageTransactionSpread", jFSATransactionReport -> jFSATransactionReport.getPackageTransactionSpread()).<BigDecimal>map("getMonetary", priceFormat -> priceFormat.getMonetary()), MapperS.of(BigDecimal.valueOf(0)), CardinalityOperator.All).getOrDefault(false)) {
								ifThenElseResult0 = false;
							}
							ifThenElseResult1 = AmountAndDirection106__1.builder()
								.setAmt(ActiveOrHistoricCurrencyAnd13DecimalAmount.builder()
									.setValue(abs.evaluate(MapperS.of(drrReport).<PriceFormat>map("getPackageTransactionSpread", jFSATransactionReport -> jFSATransactionReport.getPackageTransactionSpread()).<BigDecimal>map("getMonetary", priceFormat -> priceFormat.getMonetary()).get()))
									.setCcy(MapperS.of(drrReport).<ISOCurrencyCodeEnum>map("getPackageTransactionSpreadCurrency", jFSATransactionReport -> jFSATransactionReport.getPackageTransactionSpreadCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get())
									.build())
								.setSgn(ifThenElseResult0)
								.build();
						}
						BigDecimal ifThenElseResult2 = null;
						if (areEqual(MapperS.of(drrReport).<PriceNotationEnum>map("getPackageTransactionSpreadNotation", jFSATransactionReport -> jFSATransactionReport.getPackageTransactionSpreadNotation()), MapperS.of(PriceNotationEnum.DECIMAL), CardinalityOperator.All).getOrDefault(false)) {
							ifThenElseResult2 = MapperS.of(drrReport).<PriceFormat>map("getPackageTransactionSpread", jFSATransactionReport -> jFSATransactionReport.getPackageTransactionSpread()).<BigDecimal>map("getDecimal", priceFormat -> priceFormat.getDecimal()).get();
						}
						Integer ifThenElseResult3 = null;
						if (areEqual(MapperS.of(drrReport).<PriceNotationEnum>map("getPackageTransactionSpreadNotation", jFSATransactionReport -> jFSATransactionReport.getPackageTransactionSpreadNotation()), MapperS.of(PriceNotationEnum.BASIS), CardinalityOperator.All).getOrDefault(false)) {
							final BigDecimal bigDecimal = MapperS.of(drrReport).<PriceFormat>map("getPackageTransactionSpread", jFSATransactionReport -> jFSATransactionReport.getPackageTransactionSpread()).<BigDecimal>map("getBasis", priceFormat -> priceFormat.getBasis()).get();
							ifThenElseResult3 = bigDecimal == null ? null : bigDecimal.intValueExact();
						}
						return MapperS.of(SecuritiesTransactionPrice20Choice__1.builder()
							.setMntryVal(ifThenElseResult1)
							.setDcml(ifThenElseResult2)
							.setBsisPtSprd(ifThenElseResult3)
							.build());
					}).get())
				.build());
			
			return Optional.ofNullable(packg)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
