package drr.projection.iso20022.jfsa.rewrite.trade.functions;

import cdm.base.math.functions.Abs;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.CommonAssetClass;
import drr.regulation.common.CommonContractType;
import drr.regulation.jfsa.rewrite.trade.JFSATransactionReport;
import drr.standards.iosco.cde.price.PriceFormat;
import drr.standards.iosco.cde.price.PriceNotationEnum;
import iso20022.auth030.jfsa.ActiveOrHistoricCurrencyAnd13DecimalAmount;
import iso20022.auth030.jfsa.AmountAndDirection106__1;
import iso20022.auth030.jfsa.SecuritiesTransactionPrice17Choice__1;
import iso20022.auth030.jfsa.SecuritiesTransactionPrice17Choice__1.SecuritiesTransactionPrice17Choice__1Builder;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(GetStrkPric.GetStrkPricDefault.class)
public abstract class GetStrkPric implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected Abs abs;

	/**
	* @param drrReport 
	* @return strkPric 
	*/
	public SecuritiesTransactionPrice17Choice__1 evaluate(JFSATransactionReport drrReport) {
		SecuritiesTransactionPrice17Choice__1.SecuritiesTransactionPrice17Choice__1Builder strkPricBuilder = doEvaluate(drrReport);
		
		final SecuritiesTransactionPrice17Choice__1 strkPric;
		if (strkPricBuilder == null) {
			strkPric = null;
		} else {
			strkPric = strkPricBuilder.build();
			objectValidator.validate(SecuritiesTransactionPrice17Choice__1.class, strkPric);
		}
		
		return strkPric;
	}

	protected abstract SecuritiesTransactionPrice17Choice__1.SecuritiesTransactionPrice17Choice__1Builder doEvaluate(JFSATransactionReport drrReport);

	public static class GetStrkPricDefault extends GetStrkPric {
		@Override
		protected SecuritiesTransactionPrice17Choice__1.SecuritiesTransactionPrice17Choice__1Builder doEvaluate(JFSATransactionReport drrReport) {
			SecuritiesTransactionPrice17Choice__1.SecuritiesTransactionPrice17Choice__1Builder strkPric = SecuritiesTransactionPrice17Choice__1.builder();
			return assignOutput(strkPric, drrReport);
		}
		
		protected SecuritiesTransactionPrice17Choice__1.SecuritiesTransactionPrice17Choice__1Builder assignOutput(SecuritiesTransactionPrice17Choice__1.SecuritiesTransactionPrice17Choice__1Builder strkPric, JFSATransactionReport drrReport) {
			strkPric = toBuilder(MapperS.of(drrReport)
				.mapSingleToItem(item -> {
					AmountAndDirection106__1 ifThenElseResult2 = null;
					if (areEqual(item.<PriceNotationEnum>map("getStrikePriceNotation", jFSATransactionReport -> jFSATransactionReport.getStrikePriceNotation()), MapperS.of(PriceNotationEnum.MONETARY), CardinalityOperator.All).getOrDefault(false)) {
						String ifThenElseResult0 = null;
						if (areEqual(MapperS.of(drrReport).<CommonContractType>map("getContractType", jFSATransactionReport -> jFSATransactionReport.getContractType()), MapperS.of(CommonContractType.OPTN), CardinalityOperator.All).or(areEqual(MapperS.of(drrReport).<CommonContractType>map("getContractType", jFSATransactionReport -> jFSATransactionReport.getContractType()), MapperS.of(CommonContractType.SWPT), CardinalityOperator.All)).and(areEqual(areEqual(MapperS.of(drrReport).<CommonAssetClass>map("getAssetClass", jFSATransactionReport -> jFSATransactionReport.getAssetClass()), MapperS.of(CommonAssetClass.CURR), CardinalityOperator.All).or(areEqual(MapperS.of(drrReport).<CommonAssetClass>map("getAssetClass", jFSATransactionReport -> jFSATransactionReport.getAssetClass()), MapperS.of(CommonAssetClass.INTR), CardinalityOperator.All)), MapperS.of(false), CardinalityOperator.All)).getOrDefault(false)) {
							ifThenElseResult0 = item.<String>map("getStrikePriceCurrency", jFSATransactionReport -> jFSATransactionReport.getStrikePriceCurrency()).map("to-string", Object::toString).get();
						}
						Boolean ifThenElseResult1 = null;
						if (lessThan(item.<PriceFormat>map("getStrikePrice", jFSATransactionReport -> jFSATransactionReport.getStrikePrice()).<BigDecimal>map("getMonetary", priceFormat -> priceFormat.getMonetary()), MapperS.of(BigDecimal.valueOf(0)), CardinalityOperator.All).getOrDefault(false)) {
							ifThenElseResult1 = false;
						}
						ifThenElseResult2 = AmountAndDirection106__1.builder()
							.setAmt(ActiveOrHistoricCurrencyAnd13DecimalAmount.builder()
								.setValue(abs.evaluate(item.<PriceFormat>map("getStrikePrice", jFSATransactionReport -> jFSATransactionReport.getStrikePrice()).<BigDecimal>map("getMonetary", priceFormat -> priceFormat.getMonetary()).get()))
								.setCcy(ifThenElseResult0)
								.build())
							.setSgn(ifThenElseResult1)
							.build();
					}
					BigDecimal ifThenElseResult3 = null;
					if (areEqual(item.<PriceNotationEnum>map("getStrikePriceNotation", jFSATransactionReport -> jFSATransactionReport.getStrikePriceNotation()), MapperS.of(PriceNotationEnum.DECIMAL), CardinalityOperator.All).getOrDefault(false)) {
						ifThenElseResult3 = item.<PriceFormat>map("getStrikePrice", jFSATransactionReport -> jFSATransactionReport.getStrikePrice()).<BigDecimal>map("getDecimal", priceFormat -> priceFormat.getDecimal()).get();
					}
					return MapperS.of(SecuritiesTransactionPrice17Choice__1.builder()
						.setMntryVal(ifThenElseResult2)
						.setDcml(ifThenElseResult3)
						.build());
				}).get());
			
			return Optional.ofNullable(strkPric)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
