package drr.regulation.asic.rewrite.margin.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaReport;
import com.rosetta.model.lib.annotations.RuneLabelProvider;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.asic.rewrite.margin.ASICMarginReport;
import drr.regulation.asic.rewrite.margin.ASICMarginReport.ASICMarginReportBuilder;
import drr.regulation.asic.rewrite.margin.labels.ASICMarginLabelProvider;
import drr.regulation.common.CollateralReportInstruction;
import java.util.Optional;
import javax.inject.Inject;


@RosettaReport(namespace="drr.regulation.asic.rewrite.margin", body="ASIC", corpusList={"Margin"})
@RuneLabelProvider(labelProvider=ASICMarginLabelProvider.class)
@ImplementedBy(ASICMarginReportFunction.ASICMarginReportFunctionDefault.class)
public abstract class ASICMarginReportFunction implements ReportFunction<CollateralReportInstruction, ASICMarginReport> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected ActionTypeRule actionTypeRule;
	@Inject protected CollateralPortfolioCodeIMRule collateralPortfolioCodeIMRule;
	@Inject protected CollateralPortfolioCodeVMRule collateralPortfolioCodeVMRule;
	@Inject protected CollateralPortfolioIndicatorRule collateralPortfolioIndicatorRule;
	@Inject protected CollateralTimestampRule collateralTimestampRule;
	@Inject protected CollateralisationCategoryRule collateralisationCategoryRule;
	@Inject protected Counterparty1Rule counterparty1Rule;
	@Inject protected Counterparty2IdentifierTypeRule counterparty2IdentifierTypeRule;
	@Inject protected Counterparty2Rule counterparty2Rule;
	@Inject protected CurrencyOfInitialMarginCollectedRule currencyOfInitialMarginCollectedRule;
	@Inject protected CurrencyOfInitialMarginPostedRule currencyOfInitialMarginPostedRule;
	@Inject protected CurrencyOfVariationMarginCollectedRule currencyOfVariationMarginCollectedRule;
	@Inject protected CurrencyOfVariationMarginPostedRule currencyOfVariationMarginPostedRule;
	@Inject protected ExecutionAgentOfCounterparty1Rule executionAgentOfCounterparty1Rule;
	@Inject protected InitialMarginCollectedByTheReportingEntityPostHaircutRule initialMarginCollectedByTheReportingEntityPostHaircutRule;
	@Inject protected InitialMarginCollectedByTheReportingEntityPreHaircutRule initialMarginCollectedByTheReportingEntityPreHaircutRule;
	@Inject protected InitialMarginPostedByTheReportingEntityPostHaircutRule initialMarginPostedByTheReportingEntityPostHaircutRule;
	@Inject protected InitialMarginPostedByTheReportingEntityPreHaircutRule initialMarginPostedByTheReportingEntityPreHaircutRule;
	@Inject protected PortfolioContainingNonReportedComponentIndicatorRule portfolioContainingNonReportedComponentIndicatorRule;
	@Inject protected ReportingEntityRule reportingEntityRule;
	@Inject protected ReportingSubmittingEntityRule reportingSubmittingEntityRule;
	@Inject protected ReportingTimestampRule reportingTimestampRule;
	@Inject protected SmallScaleBuySideEntityIndicatorRule smallScaleBuySideEntityIndicatorRule;
	@Inject protected TechnicalRecordIdRule technicalRecordIdRule;
	@Inject protected UniqueTransactionIdentifierProprietaryRule uniqueTransactionIdentifierProprietaryRule;
	@Inject protected UniqueTransactionIdentifierRule uniqueTransactionIdentifierRule;
	@Inject protected VariationMarginCollectedByTheReportingEntityPreHaircutRule variationMarginCollectedByTheReportingEntityPreHaircutRule;
	@Inject protected VariationMarginPostedByTheReportingEntityPreHaircutRule variationMarginPostedByTheReportingEntityPreHaircutRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public ASICMarginReport evaluate(CollateralReportInstruction input) {
		ASICMarginReport.ASICMarginReportBuilder outputBuilder = doEvaluate(input);
		
		final ASICMarginReport output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.build();
			objectValidator.validate(ASICMarginReport.class, output);
		}
		
		return output;
	}

	protected abstract ASICMarginReport.ASICMarginReportBuilder doEvaluate(CollateralReportInstruction input);

	public static class ASICMarginReportFunctionDefault extends ASICMarginReportFunction {
		@Override
		protected ASICMarginReport.ASICMarginReportBuilder doEvaluate(CollateralReportInstruction input) {
			ASICMarginReport.ASICMarginReportBuilder output = ASICMarginReport.builder();
			return assignOutput(output, input);
		}
		
		protected ASICMarginReport.ASICMarginReportBuilder assignOutput(ASICMarginReport.ASICMarginReportBuilder output, CollateralReportInstruction input) {
			output
				.setUniqueTransactionIdentifier(uniqueTransactionIdentifierRule.evaluate(input));
			
			output
				.setUniqueTransactionIdentifierProprietary(uniqueTransactionIdentifierProprietaryRule.evaluate(input));
			
			output
				.setReportingEntity(reportingEntityRule.evaluate(input));
			
			output
				.setCounterparty1(counterparty1Rule.evaluate(input));
			
			output
				.setSmallScaleBuySideEntityIndicator(smallScaleBuySideEntityIndicatorRule.evaluate(input));
			
			output
				.setCounterparty2(counterparty2Rule.evaluate(input));
			
			output
				.setCollateralTimestamp(collateralTimestampRule.evaluate(input));
			
			output
				.setCollateralisationCategory(collateralisationCategoryRule.evaluate(input));
			
			output
				.setCollateralPortfolioIndicator(collateralPortfolioIndicatorRule.evaluate(input));
			
			output
				.setPortfolioContainingNonReportedComponentIndicator(portfolioContainingNonReportedComponentIndicatorRule.evaluate(input));
			
			output
				.setInitialMarginCollateralPortfolioCode(collateralPortfolioCodeIMRule.evaluate(input));
			
			output
				.setCollateralPortfolioCodeVM(collateralPortfolioCodeVMRule.evaluate(input));
			
			output
				.setInitialMarginPostedByTheReportingEntityPreHaircut(initialMarginPostedByTheReportingEntityPreHaircutRule.evaluate(input));
			
			output
				.setInitialMarginPostedByTheReportingEntityPostHaircut(initialMarginPostedByTheReportingEntityPostHaircutRule.evaluate(input));
			
			output
				.setCurrencyofInitialMarginPosted(currencyOfInitialMarginPostedRule.evaluate(input));
			
			output
				.setInitialMarginCollectedByTheReportingEntityPreHaircut(initialMarginCollectedByTheReportingEntityPreHaircutRule.evaluate(input));
			
			output
				.setInitialMarginCollectedByTheReportingEntityPostHaircut(initialMarginCollectedByTheReportingEntityPostHaircutRule.evaluate(input));
			
			output
				.setCurrencyofInitialMarginCollected(currencyOfInitialMarginCollectedRule.evaluate(input));
			
			output
				.setVariationMarginPostedByTheReportingEntityPreHaircut(variationMarginPostedByTheReportingEntityPreHaircutRule.evaluate(input));
			
			output
				.setCurrencyOfVariationMarginPosted(currencyOfVariationMarginPostedRule.evaluate(input));
			
			output
				.setVariationMarginCollectedByTheReportingEntityPreHaircut(variationMarginCollectedByTheReportingEntityPreHaircutRule.evaluate(input));
			
			output
				.setCurrencyOfVariationMarginCollected(currencyOfVariationMarginCollectedRule.evaluate(input));
			
			output
				.setActionType(actionTypeRule.evaluate(input));
			
			output
				.setReportingTimestamp(reportingTimestampRule.evaluate(input));
			
			output
				.setReportSubmittingEntityID(reportingSubmittingEntityRule.evaluate(input));
			
			output
				.setCounterpartyIdentifierType(counterparty2IdentifierTypeRule.evaluate(input));
			
			output
				.setTechnicalRecordId(technicalRecordIdRule.evaluate(input));
			
			output
				.setExecutionAgentOfCounterparty1(executionAgentOfCounterparty1Rule.evaluate(input));
			
			return Optional.ofNullable(output)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
