package drr.regulation.asic.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaReport;
import com.rosetta.model.lib.annotations.RuneLabelProvider;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.enrichment.common.reports.EnrichmentDataRule;
import drr.enrichment.common.reports.UpiPostEnrichmentDataRule;
import drr.enrichment.common.reports.UpiPreEnrichmentDataRule;
import drr.regulation.asic.rewrite.trade.ASICTransactionReport;
import drr.regulation.asic.rewrite.trade.ASICTransactionReport.ASICTransactionReportBuilder;
import drr.regulation.asic.rewrite.trade.labels.ASICTradeLabelProvider;
import drr.regulation.common.TransactionReportInstruction;
import drr.standards.iosco.cde.event.reports.EventIdentifierRule;
import java.util.Optional;
import javax.inject.Inject;


@RosettaReport(namespace="drr.regulation.asic.rewrite.trade", body="ASIC", corpusList={"Trade"})
@RuneLabelProvider(labelProvider=ASICTradeLabelProvider.class)
@ImplementedBy(ASICTradeReportFunction.ASICTradeReportFunctionDefault.class)
public abstract class ASICTradeReportFunction implements ReportFunction<TransactionReportInstruction, ASICTransactionReport> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected ActionTypeRule actionTypeRule;
	@Inject protected AssetClassRule assetClassRule;
	@Inject protected BasketConstituentsRule basketConstituentsRule;
	@Inject protected BasketStructurerRule basketStructurerRule;
	@Inject protected Beneficiary1IdentifierTypeIndicatorRule beneficiary1IdentifierTypeIndicatorRule;
	@Inject protected Beneficiary1Rule beneficiary1Rule;
	@Inject protected BrokerRule brokerRule;
	@Inject protected CDSIndexAttachmentPointRule cDSIndexAttachmentPointRule;
	@Inject protected CDSIndexDetachmentPointRule cDSIndexDetachmentPointRule;
	@Inject protected CallAmountRule callAmountRule;
	@Inject protected CallCurrencyRule callCurrencyRule;
	@Inject protected CentralCounterpartyRule centralCounterpartyRule;
	@Inject protected ClearedRule clearedRule;
	@Inject protected ClearingMemberRule clearingMemberRule;
	@Inject protected ClearingTimestampRule clearingTimestampRule;
	@Inject protected CollateralPortfolioCodeInitialMarginRule collateralPortfolioCodeInitialMarginRule;
	@Inject protected CollateralPortfolioCodeVariationMarginRule collateralPortfolioCodeVariationMarginRule;
	@Inject protected CollateralPortfolioIndicatorRule collateralPortfolioIndicatorRule;
	@Inject protected ContractTypeRule contractTypeRule;
	@Inject protected Counterparty1Rule counterparty1Rule;
	@Inject protected Counterparty2IdentifierTypeIndicatorRule counterparty2IdentifierTypeIndicatorRule;
	@Inject protected Counterparty2NameRule counterparty2NameRule;
	@Inject protected Counterparty2Rule counterparty2Rule;
	@Inject protected CountryOfCounterparty2Rule countryOfCounterparty2Rule;
	@Inject protected CustomBasketCodeIdentifierRule customBasketCodeIdentifierRule;
	@Inject protected DeltaRule deltaRule;
	@Inject protected Direction1Rule direction1Rule;
	@Inject protected Direction2Leg1Rule direction2Leg1Rule;
	@Inject protected Direction2Leg2Rule direction2Leg2Rule;
	@Inject protected EffectiveDateRule effectiveDateRule;
	@Inject protected EnrichmentDataRule enrichmentDataRule;
	@Inject protected EventIdentifierRule eventIdentifierRule;
	@Inject protected EventTimestampRule eventTimestampRule;
	@Inject protected EventTypeRule eventTypeRule;
	@Inject protected ExchangeRateBasisRule exchangeRateBasisRule;
	@Inject protected ExchangeRateRule exchangeRateRule;
	@Inject protected ExecutionAgentCounterparty1Rule executionAgentCounterparty1Rule;
	@Inject protected ExecutionAgentCounterparty2DTCCRule executionAgentCounterparty2DTCCRule;
	@Inject protected ExecutionTimestampRule executionTimestampRule;
	@Inject protected ExpirationDateRule expirationDateRule;
	@Inject protected IndexFactorRule indexFactorRule;
	@Inject protected Leg1ReportRule leg1ReportRule;
	@Inject protected Leg2ReportRule leg2ReportRule;
	@Inject protected MaturityDateOfTheUnderlierRule maturityDateOfTheUnderlierRule;
	@Inject protected NewDerivativeTradeRepositoryRule newDerivativeTradeRepositoryRule;
	@Inject protected NextFloatingReferenceResetDateLeg1Rule nextFloatingReferenceResetDateLeg1Rule;
	@Inject protected NextFloatingReferenceResetDateLeg2Rule nextFloatingReferenceResetDateLeg2Rule;
	@Inject protected OptionPremiumAmountRule optionPremiumAmountRule;
	@Inject protected OptionPremiumCurrencyRule optionPremiumCurrencyRule;
	@Inject protected OptionPremiumPaymentDateRule optionPremiumPaymentDateRule;
	@Inject protected OtherPaymentRule otherPaymentRule;
	@Inject protected PackageIdentifierRule packageIdentifierRule;
	@Inject protected PackageTransactionPriceCurrencyRule packageTransactionPriceCurrencyRule;
	@Inject protected PackageTransactionPriceNotationRule packageTransactionPriceNotationRule;
	@Inject protected PackageTransactionPriceRule packageTransactionPriceRule;
	@Inject protected PackageTransactionSpreadCurrencyRule packageTransactionSpreadCurrencyRule;
	@Inject protected PackageTransactionSpreadNotationRule packageTransactionSpreadNotationRule;
	@Inject protected PackageTransactionSpreadRule packageTransactionSpreadRule;
	@Inject protected PlatformIdentifierRule platformIdentifierRule;
	@Inject protected PriceCurrencyRule priceCurrencyRule;
	@Inject protected PriceNotationRule priceNotationRule;
	@Inject protected PriceRule priceRule;
	@Inject protected PriceUnitOfMeasureRule priceUnitOfMeasureRule;
	@Inject protected PriorUTIProprietaryRule priorUTIProprietaryRule;
	@Inject protected PriorUTIRule priorUTIRule;
	@Inject protected PutAmountRule putAmountRule;
	@Inject protected PutCurrencyRule putCurrencyRule;
	@Inject protected QuantityUnitOfMeasureLeg1Rule quantityUnitOfMeasureLeg1Rule;
	@Inject protected QuantityUnitOfMeasureLeg2Rule quantityUnitOfMeasureLeg2Rule;
	@Inject protected ReportSubmittingEntityRule reportSubmittingEntityRule;
	@Inject protected ReportingEntityRule reportingEntityRule;
	@Inject protected ReportingTimestampRule reportingTimestampRule;
	@Inject protected SecondaryTransactionIdentifierRule secondaryTransactionIdentifierRule;
	@Inject protected SingleOrUpperAndLowerBarrierRule singleOrUpperAndLowerBarrierRule;
	@Inject protected SmallScaleBuySideEntityIndicatorRule smallScaleBuySideEntityIndicatorRule;
	@Inject protected StrikePriceCurrencyCurrencyPairRule strikePriceCurrencyCurrencyPairRule;
	@Inject protected StrikePriceNotationRule strikePriceNotationRule;
	@Inject protected StrikePriceRule strikePriceRule;
	@Inject protected TechnicalRecordIdRule technicalRecordIdRule;
	@Inject protected UnderlyingIdOtherRule underlyingIdOtherRule;
	@Inject protected UnderlyingIdOtherSourceRule underlyingIdOtherSourceRule;
	@Inject protected UnderlyingIdentificationRule underlyingIdentificationRule;
	@Inject protected UnderlyingIdentificationTypeRule underlyingIdentificationTypeRule;
	@Inject protected UniqueProductIdentifierRule uniqueProductIdentifierRule;
	@Inject protected UniqueTransactionIdentifierRule uniqueTransactionIdentifierRule;
	@Inject protected UpiPostEnrichmentDataRule upiPostEnrichmentDataRule;
	@Inject protected UpiPreEnrichmentDataRule upiPreEnrichmentDataRule;
	@Inject protected UtiProprietaryRule utiProprietaryRule;
	@Inject protected ValuationAmountRule valuationAmountRule;
	@Inject protected ValuationCurrencyRule valuationCurrencyRule;
	@Inject protected ValuationMethodRule valuationMethodRule;
	@Inject protected ValuationTimestampRule valuationTimestampRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public ASICTransactionReport evaluate(TransactionReportInstruction input) {
		ASICTransactionReport.ASICTransactionReportBuilder outputBuilder = doEvaluate(input);
		
		final ASICTransactionReport output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.build();
			objectValidator.validate(ASICTransactionReport.class, output);
		}
		
		return output;
	}

	protected abstract ASICTransactionReport.ASICTransactionReportBuilder doEvaluate(TransactionReportInstruction input);

	public static class ASICTradeReportFunctionDefault extends ASICTradeReportFunction {
		@Override
		protected ASICTransactionReport.ASICTransactionReportBuilder doEvaluate(TransactionReportInstruction input) {
			ASICTransactionReport.ASICTransactionReportBuilder output = ASICTransactionReport.builder();
			return assignOutput(output, input);
		}
		
		protected ASICTransactionReport.ASICTransactionReportBuilder assignOutput(ASICTransactionReport.ASICTransactionReportBuilder output, TransactionReportInstruction input) {
			output
				.setActionType(actionTypeRule.evaluate(input));
			
			output
				.setEventType(eventTypeRule.evaluate(input));
			
			output
				.setEventIdentifier(eventIdentifierRule.evaluate(input));
			
			output
				.setEffectiveDate(effectiveDateRule.evaluate(input));
			
			output
				.setEventTimestamp(eventTimestampRule.evaluate(input));
			
			output
				.setReportingTimestamp(reportingTimestampRule.evaluate(input));
			
			output
				.setExecutionTimestamp(executionTimestampRule.evaluate(input));
			
			output
				.setExpirationDate(expirationDateRule.evaluate(input));
			
			output
				.setCounterparty1(counterparty1Rule.evaluate(input));
			
			output
				.setCounterparty2(counterparty2Rule.evaluate(input));
			
			output
				.setCounterparty2IdentifierType(counterparty2IdentifierTypeIndicatorRule.evaluate(input));
			
			output
				.setBeneficiary1(beneficiary1Rule.evaluate(input));
			
			output
				.setBeneficiary1IdentifierTypeIndicator(beneficiary1IdentifierTypeIndicatorRule.evaluate(input));
			
			output
				.setCleared(clearedRule.evaluate(input));
			
			output
				.setCentralCounterparty(centralCounterpartyRule.evaluate(input));
			
			output
				.setClearingMember(clearingMemberRule.evaluate(input));
			
			output
				.setCallAmount(callAmountRule.evaluate(input));
			
			output
				.setPutAmount(putAmountRule.evaluate(input));
			
			output
				.setCallCurrency(callCurrencyRule.evaluate(input));
			
			output
				.setPutCurrency(putCurrencyRule.evaluate(input));
			
			output
				.setPrice(priceRule.evaluate(input));
			
			output
				.setPriceNotation(priceNotationRule.evaluate(input));
			
			output
				.setPriceCurrency(priceCurrencyRule.evaluate(input));
			
			output
				.setPackageTransactionPrice(packageTransactionPriceRule.evaluate(input));
			
			output
				.setPackageTransactionPriceNotation(packageTransactionPriceNotationRule.evaluate(input));
			
			output
				.setPackageTransactionPriceCurrency(packageTransactionPriceCurrencyRule.evaluate(input));
			
			output
				.setPackageTransactionSpread(packageTransactionSpreadRule.evaluate(input));
			
			output
				.setPackageTransactionSpreadNotation(packageTransactionSpreadNotationRule.evaluate(input));
			
			output
				.setPackageTransactionSpreadCurrency(packageTransactionSpreadCurrencyRule.evaluate(input));
			
			output
				.setStrikePrice(strikePriceRule.evaluate(input));
			
			output
				.setStrikePriceNotation(strikePriceNotationRule.evaluate(input));
			
			output
				.setStrikePriceCurrency(strikePriceCurrencyCurrencyPairRule.evaluate(input));
			
			output
				.setPriceUnitOfMeasure(priceUnitOfMeasureRule.evaluate(input));
			
			output
				.setOptionPremiumAmount(optionPremiumAmountRule.evaluate(input));
			
			output
				.setOptionPremiumCurrency(optionPremiumCurrencyRule.evaluate(input));
			
			output
				.setOptionPremiumPaymentDate(optionPremiumPaymentDateRule.evaluate(input));
			
			output
				.setCdSIndexAttachmentPoint(cDSIndexAttachmentPointRule.evaluate(input));
			
			output
				.setCdSIndexDetachmentPoint(cDSIndexDetachmentPointRule.evaluate(input));
			
			output
				.setCollateralPortfolioIndicator(collateralPortfolioIndicatorRule.evaluate(input));
			
			output
				.setOtherPayment(otherPaymentRule.evaluate(input));
			
			output
				.setLeg1(leg1ReportRule.evaluate(input));
			
			output
				.setLeg2(leg2ReportRule.evaluate(input));
			
			output
				.setCounterparty2Name(counterparty2NameRule.evaluate(input));
			
			output
				.setExecutionAgentCounterparty1(executionAgentCounterparty1Rule.evaluate(input));
			
			output
				.setExecutionAgentCounterparty2DTCC(executionAgentCounterparty2DTCCRule.evaluate(input));
			
			output
				.setReportSubmittingEntityID(reportSubmittingEntityRule.evaluate(input));
			
			output
				.setUniqueTransactionIdentifier(uniqueTransactionIdentifierRule.evaluate(input));
			
			output
				.setUniqueTransactionIdentifierProprietary(utiProprietaryRule.evaluate(input));
			
			output
				.setPriorUTI(priorUTIRule.evaluate(input));
			
			output
				.setPriorUTIProprietary(priorUTIProprietaryRule.evaluate(input));
			
			output
				.setUniqueProductIdentifier(uniqueProductIdentifierRule.evaluate(input));
			
			output
				.setContractType(contractTypeRule.evaluate(input));
			
			output
				.setAssetClass(assetClassRule.evaluate(input));
			
			output
				.setClearingTimestamp(clearingTimestampRule.evaluate(input));
			
			output
				.setPlatformIdentifier(platformIdentifierRule.evaluate(input));
			
			output
				.setDirection1(direction1Rule.evaluate(input));
			
			output
				.setDirection2Leg1(direction2Leg1Rule.evaluate(input));
			
			output
				.setDirection2Leg2(direction2Leg2Rule.evaluate(input));
			
			output
				.setPackageIdentifier(packageIdentifierRule.evaluate(input));
			
			output
				.setBarrier(singleOrUpperAndLowerBarrierRule.evaluate(input));
			
			output
				.setExchangeRate(exchangeRateRule.evaluate(input));
			
			output
				.setExchangeRateBasis(exchangeRateBasisRule.evaluate(input));
			
			output
				.setBasketConstituents(basketConstituentsRule.evaluate(input));
			
			output
				.getOrCreateUnderlying()
				.setUnderlyingIdentification(underlyingIdentificationRule.evaluate(input));
			
			output
				.getOrCreateUnderlying()
				.setUnderlyingIdentificationType(underlyingIdentificationTypeRule.evaluate(input));
			
			output
				.getOrCreateUnderlying()
				.setUnderlyingIdOther(MapperC.of(underlyingIdOtherRule.evaluate(input)).get());
			
			output
				.getOrCreateUnderlying()
				.setUnderlyingIdOtherSource(MapperC.of(underlyingIdOtherSourceRule.evaluate(input)).get());
			
			output
				.setQuantityUnitOfMeasureLeg1(quantityUnitOfMeasureLeg1Rule.evaluate(input));
			
			output
				.setQuantityUnitOfMeasureLeg2(quantityUnitOfMeasureLeg2Rule.evaluate(input));
			
			output
				.setMaturityDateOfTheUnderlying(maturityDateOfTheUnderlierRule.evaluate(input));
			
			output
				.setCountryOfTheCounterparty2(countryOfCounterparty2Rule.evaluate(input));
			
			output
				.setIndexFactor(indexFactorRule.evaluate(input));
			
			output
				.setTechnicalRecordId(technicalRecordIdRule.evaluate(input));
			
			output
				.setSecondaryTransactionIdentifier(secondaryTransactionIdentifierRule.evaluate(input));
			
			output
				.setReportingEntity(reportingEntityRule.evaluate(input));
			
			output
				.setBroker(brokerRule.evaluate(input));
			
			output
				.getOrCreateCustomBasketCode()
				.setBasketStructurerID(basketStructurerRule.evaluate(input));
			
			output
				.getOrCreateCustomBasketCode()
				.setCustomBasketID(customBasketCodeIdentifierRule.evaluate(input));
			
			output
				.setNewDerivativeTradeRepository(newDerivativeTradeRepositoryRule.evaluate(input));
			
			output
				.setValuationTimestamp(valuationTimestampRule.evaluate(input));
			
			output
				.setValuationAmount(valuationAmountRule.evaluate(input));
			
			output
				.setValuationCurrency(valuationCurrencyRule.evaluate(input));
			
			output
				.setValuationMethod(valuationMethodRule.evaluate(input));
			
			output
				.setDelta(deltaRule.evaluate(input));
			
			output
				.setNextFloatingReferenceResetDateLeg1(nextFloatingReferenceResetDateLeg1Rule.evaluate(input));
			
			output
				.setNextFloatingReferenceResetDateLeg2(nextFloatingReferenceResetDateLeg2Rule.evaluate(input));
			
			output
				.setSmallScaleBuySideEntityIndicator(smallScaleBuySideEntityIndicatorRule.evaluate(input));
			
			output
				.setCollateralPortfolioCodeInitialMargin(collateralPortfolioCodeInitialMarginRule.evaluate(input));
			
			output
				.setCollateralPortfolioCodeVariationMargin(collateralPortfolioCodeVariationMarginRule.evaluate(input));
			
			output
				.getOrCreateNonReportable()
				.setEnrichment(enrichmentDataRule.evaluate(input));
			
			output
				.getOrCreateNonReportable()
				.setPreUpiData(upiPreEnrichmentDataRule.evaluate(input));
			
			output
				.getOrCreateNonReportable()
				.setPostUpiData(upiPostEnrichmentDataRule.evaluate(input));
			
			return Optional.ofNullable(output)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
