package drr.regulation.asic.rewrite.trade.reports;

import cdm.base.staticdata.asset.common.ProductIdentifier;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.reports.ReportFunction;


@ImplementedBy(BasketConstituentIdentifiersRule.BasketConstituentIdentifiersRuleDefault.class)
public abstract class BasketConstituentIdentifiersRule implements ReportFunction<ProductIdentifier, Void> {

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Void evaluate(ProductIdentifier input) {
		Void output = doEvaluate(input);
		
		return output;
	}

	protected abstract Void doEvaluate(ProductIdentifier input);

	public static class BasketConstituentIdentifiersRuleDefault extends BasketConstituentIdentifiersRule {
		@Override
		protected Void doEvaluate(ProductIdentifier input) {
			Void output = null;
			return assignOutput(output, input);
		}
		
		protected Void assignOutput(Void output, ProductIdentifier input) {
			output = null;
			
			return output;
		}
	}
}
