package drr.regulation.asic.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.asic.rewrite.trade.functions.IsAllowableActionForASIC;
import drr.regulation.common.CustomBasket;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.ReportableInformation;
import drr.standards.iosco.cde.basket.reports.CustomBasketCodeRule;
import javax.inject.Inject;


@ImplementedBy(CustomBasketCodeIdentifierRule.CustomBasketCodeIdentifierRuleDefault.class)
public abstract class CustomBasketCodeIdentifierRule implements ReportFunction<ReportableEvent, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected CustomBasketCodeRule customBasketCodeRule;
	@Inject protected IsAllowableActionForASIC isAllowableActionForASIC;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(ReportableEvent input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(ReportableEvent input);

	public static class CustomBasketCodeIdentifierRuleDefault extends CustomBasketCodeIdentifierRule {
		@Override
		protected String doEvaluate(ReportableEvent input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, ReportableEvent input) {
			final MapperS<ReportableEvent> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForASIC.evaluate(item.get()));
			output = MapperS.of(thenArg.<ReportableInformation>map("getReportableInformation", reportableEvent -> reportableEvent.getReportableInformation()).<CustomBasket>map("getCustomBasket", reportableInformation -> reportableInformation.getCustomBasket()).<String>map("getCustomBasketCode", customBasket -> customBasket.getCustomBasketCode()).getOrDefault(customBasketCodeRule.evaluate(thenArg.get()))).get();
			
			return output;
		}
	}
}
