package drr.regulation.asic.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.asic.rewrite.trade.functions.IsAllowableActionForASIC;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.CommonLeg;
import drr.regulation.common.trade.CommonLeg.CommonLegBuilder;
import drr.regulation.common.trade.functions.LegEnrichment;
import drr.regulation.common.trade.quantity.reports.NotionalQuantityLeg2Rule;
import drr.standards.iosco.cde.functions.Leg2;
import drr.standards.iosco.cde.quantity.NotionalPeriod;
import drr.standards.iosco.cde.quantity.reports.NotionalAmountScheduleLeg2Rule;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.Optional;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(Leg2ReportRule.Leg2ReportRuleDefault.class)
public abstract class Leg2ReportRule implements ReportFunction<TransactionReportInstruction, CommonLeg> {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected FloatingRateReferencePeriodLeg2Rule floatingRateReferencePeriodLeg2Rule;
	@Inject protected FloatingRateReferencePeriodMultiplierLeg2Rule floatingRateReferencePeriodMultiplierLeg2Rule;
	@Inject protected IndicatorOfTheFloatingRateLeg2Rule indicatorOfTheFloatingRateLeg2Rule;
	@Inject protected IsAllowableActionForASIC isAllowableActionForASIC;
	@Inject protected Leg2 leg2;
	@Inject protected LegEnrichment legEnrichment;
	@Inject protected NotionalAmountScheduleLeg2Rule notionalAmountScheduleLeg2Rule;
	@Inject protected NotionalQuantityLeg2Rule notionalQuantityLeg2Rule;
	@Inject protected SpreadLeg2NotationRule spreadLeg2NotationRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public CommonLeg evaluate(TransactionReportInstruction input) {
		CommonLeg.CommonLegBuilder outputBuilder = doEvaluate(input);
		
		final CommonLeg output;
		if (outputBuilder == null) {
			output = null;
		} else {
			output = outputBuilder.build();
			objectValidator.validate(CommonLeg.class, output);
		}
		
		return output;
	}

	protected abstract CommonLeg.CommonLegBuilder doEvaluate(TransactionReportInstruction input);

	public static class Leg2ReportRuleDefault extends Leg2ReportRule {
		@Override
		protected CommonLeg.CommonLegBuilder doEvaluate(TransactionReportInstruction input) {
			CommonLeg.CommonLegBuilder output = CommonLeg.builder();
			return assignOutput(output, input);
		}
		
		protected CommonLeg.CommonLegBuilder assignOutput(CommonLeg.CommonLegBuilder output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForASIC.evaluate(item.get()));
			final MapperS<CommonLeg> ifThenElseResult;
			if (exists(thenArg).getOrDefault(false)) {
				final BigDecimal bigDecimal = floatingRateReferencePeriodMultiplierLeg2Rule.evaluate(thenArg.get());
				ifThenElseResult = MapperS.of(legEnrichment.evaluate(leg2.evaluate(thenArg.get(), spreadLeg2NotationRule.evaluate(thenArg.get())), notionalAmountScheduleLeg2Rule.evaluate(thenArg.get()), Collections.<NotionalPeriod>emptyList(), notionalQuantityLeg2Rule.evaluate(thenArg.get()), null, null, null, null, null, indicatorOfTheFloatingRateLeg2Rule.evaluate(thenArg.get()), null, floatingRateReferencePeriodLeg2Rule.evaluate(thenArg.get()), (bigDecimal == null ? null : bigDecimal.intValueExact()), null));
			} else {
				ifThenElseResult = MapperS.<CommonLeg>ofNull();
			}
			output = toBuilder(ifThenElseResult.get());
			
			return Optional.ofNullable(output)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
