package drr.regulation.asic.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.asic.rewrite.trade.functions.IsAllowableActionForASIC;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.GetNextFloatingReferenceResetDate;
import drr.regulation.common.functions.InterestRateLeg1;
import drr.regulation.common.functions.ProductForEvent;
import javax.inject.Inject;


@ImplementedBy(NextFloatingReferenceResetDateLeg1Rule.NextFloatingReferenceResetDateLeg1RuleDefault.class)
public abstract class NextFloatingReferenceResetDateLeg1Rule implements ReportFunction<TransactionReportInstruction, Date> {
	
	// RosettaFunction dependencies
	//
	@Inject protected GetNextFloatingReferenceResetDate getNextFloatingReferenceResetDate;
	@Inject protected InterestRateLeg1 interestRateLeg1;
	@Inject protected IsAllowableActionForASIC isAllowableActionForASIC;
	@Inject protected ProductForEvent productForEvent;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public Date evaluate(TransactionReportInstruction input) {
		Date output = doEvaluate(input);
		
		return output;
	}

	protected abstract Date doEvaluate(TransactionReportInstruction input);

	public static class NextFloatingReferenceResetDateLeg1RuleDefault extends NextFloatingReferenceResetDateLeg1Rule {
		@Override
		protected Date doEvaluate(TransactionReportInstruction input) {
			Date output = null;
			return assignOutput(output, input);
		}
		
		protected Date assignOutput(Date output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForASIC.evaluate(item.get()));
			output = thenArg
				.mapSingleToItem(item -> MapperS.of(getNextFloatingReferenceResetDate.evaluate(item.get(), interestRateLeg1.evaluate(productForEvent.evaluate(item.get()))))).get();
			
			return output;
		}
	}
}
