package drr.regulation.asic.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.asic.rewrite.trade.functions.IsAllowableActionForASIC;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.trade.price.functions.IsDefaultPrice;
import drr.standards.iosco.cde.price.PriceNotationEnum;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(PriceNotationRule.PriceNotationRuleDefault.class)
public abstract class PriceNotationRule implements ReportFunction<TransactionReportInstruction, PriceNotationEnum> {
	
	// RosettaFunction dependencies
	//
	@Inject protected IsAllowableActionForASIC isAllowableActionForASIC;
	@Inject protected IsDefaultPrice isDefaultPrice;
	@Inject protected drr.standards.iosco.cde.price.reports.PriceNotationRule priceNotationRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public PriceNotationEnum evaluate(TransactionReportInstruction input) {
		PriceNotationEnum output = doEvaluate(input);
		
		return output;
	}

	protected abstract PriceNotationEnum doEvaluate(TransactionReportInstruction input);

	public static class PriceNotationRuleDefault extends PriceNotationRule {
		@Override
		protected PriceNotationEnum doEvaluate(TransactionReportInstruction input) {
			PriceNotationEnum output = null;
			return assignOutput(output, input);
		}
		
		protected PriceNotationEnum assignOutput(PriceNotationEnum output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForASIC.evaluate(item.get()));
			final MapperS<PriceNotationEnum> ifThenElseResult;
			if (areEqual(MapperS.of(priceNotationRule.evaluate(thenArg.get())), MapperS.of(PriceNotationEnum.PERCENTAGE), CardinalityOperator.All).or(ComparisonResult.of(MapperS.of(isDefaultPrice.evaluate(thenArg.get())))).getOrDefault(false)) {
				ifThenElseResult = MapperS.of(PriceNotationEnum.DECIMAL);
			} else {
				ifThenElseResult = MapperS.of(priceNotationRule.evaluate(thenArg.get()));
			}
			output = ifThenElseResult.get();
			
			return output;
		}
	}
}
