package drr.regulation.asic.rewrite.trade.reports;

import cdm.observable.asset.PriceExpressionEnum;
import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.PriceTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.asic.rewrite.trade.functions.IsAllowableActionForASIC;
import drr.regulation.common.TransactionReportInstruction;
import drr.standards.iosco.cde.price.functions.Contract_Price_Monetary;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperators.*;

@ImplementedBy(PriceUnitOfMeasureRule.PriceUnitOfMeasureRuleDefault.class)
public abstract class PriceUnitOfMeasureRule implements ReportFunction<TransactionReportInstruction, String> {
	
	// RosettaFunction dependencies
	//
	@Inject protected Contract_Price_Monetary contract_Price_Monetary;
	@Inject protected IsAllowableActionForASIC isAllowableActionForASIC;
	@Inject protected drr.standards.iosco.cde.price.reports.PriceUnitOfMeasureRule priceUnitOfMeasureRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransactionReportInstruction input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransactionReportInstruction input);

	public static class PriceUnitOfMeasureRuleDefault extends PriceUnitOfMeasureRule {
		@Override
		protected String doEvaluate(TransactionReportInstruction input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransactionReportInstruction input) {
			final MapperS<TransactionReportInstruction> thenArg = MapperS.of(input)
				.filterSingleNullSafe(item -> isAllowableActionForASIC.evaluate(item.get()));
			output = thenArg
				.mapSingleToItem(item -> {
					if (areEqual(MapperC.<PriceSchedule>of(contract_Price_Monetary.evaluate(item.get())).<PriceTypeEnum>map("getPriceType", priceSchedule -> priceSchedule.getPriceType()), MapperS.of(PriceTypeEnum.CASH_PRICE), CardinalityOperator.Any).and(areEqual(MapperC.<PriceSchedule>of(contract_Price_Monetary.evaluate(item.get())).<PriceExpressionEnum>map("getPriceExpression", priceSchedule -> priceSchedule.getPriceExpression()), MapperS.of(PriceExpressionEnum.PERCENTAGE_OF_NOTIONAL), CardinalityOperator.Any).or(areEqual(MapperC.<PriceSchedule>of(contract_Price_Monetary.evaluate(item.get())).<PriceExpressionEnum>map("getPriceExpression", priceSchedule -> priceSchedule.getPriceExpression()), MapperS.of(PriceExpressionEnum.ABSOLUTE_TERMS), CardinalityOperator.Any))).getOrDefault(false)) {
						return MapperS.of("ACCY");
					}
					return MapperS.of(priceUnitOfMeasureRule.evaluate(item.get()));
				}).get();
			
			return output;
		}
	}
}
