package drr.regulation.asic.rewrite.trade.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.asic.rewrite.trade.ASICCustomBasket;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperators.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class ASICCustomBasketValidator implements Validator<ASICCustomBasket> {

	private List<ComparisonResult> getComparisonResults(ASICCustomBasket o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("basketStructurerID", (String) o.getBasketStructurerID() != null ? 1 : 0, 0, 1), 
				checkCardinality("customBasketID", (String) o.getCustomBasketID() != null ? 1 : 0, 0, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, ASICCustomBasket o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("ASICCustomBasket", ValidationType.CARDINALITY, "ASICCustomBasket", path, "", res.getError());
				}
				return success("ASICCustomBasket", ValidationType.CARDINALITY, "ASICCustomBasket", path, "");
			})
			.collect(toList());
	}

}
