package drr.regulation.asic.rewrite.trade.validation.exists;

import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidationResult.ValidationType;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.asic.rewrite.trade.ASICCustomBasket;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;

public class ASICCustomBasketOnlyExistsValidator implements ValidatorWithArg<ASICCustomBasket, Set<String>> {

	/* Casting is required to ensure types are output to ensure recompilation in Rosetta */
	@Override
	public <T2 extends ASICCustomBasket> ValidationResult<ASICCustomBasket> validate(RosettaPath path, T2 o, Set<String> fields) {
		Map<String, Boolean> fieldExistenceMap = ImmutableMap.<String, Boolean>builder()
				.put("basketStructurerID", ExistenceChecker.isSet((String) o.getBasketStructurerID()))
				.put("customBasketID", ExistenceChecker.isSet((String) o.getCustomBasketID()))
				.build();
		
		// Find the fields that are set
		Set<String> setFields = fieldExistenceMap.entrySet().stream()
				.filter(Map.Entry::getValue)
				.map(Map.Entry::getKey)
				.collect(Collectors.toSet());
		
		if (setFields.equals(fields)) {
			return success("ASICCustomBasket", ValidationType.ONLY_EXISTS, "ASICCustomBasket", path, "");
		}
		return failure("ASICCustomBasket", ValidationType.ONLY_EXISTS, "ASICCustomBasket", path, "",
				String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
	}
}
