package drr.regulation.cftc.rewrite;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.cftc.rewrite.CFTCNonReportablePart43;
import drr.regulation.cftc.rewrite.CFTCNonReportablePart43.CFTCNonReportablePart43Builder;
import drr.regulation.cftc.rewrite.CFTCNonReportablePart43.CFTCNonReportablePart43BuilderImpl;
import drr.regulation.cftc.rewrite.CFTCNonReportablePart43.CFTCNonReportablePart43Impl;
import drr.regulation.cftc.rewrite.meta.CFTCNonReportablePart43Meta;
import drr.regulation.common.PartyIdentifierFormatEnum;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 6.0.0-dev.128
 */
@RosettaDataType(value="CFTCNonReportablePart43", builder=CFTCNonReportablePart43.CFTCNonReportablePart43BuilderImpl.class, version="6.0.0-dev.128")
@RuneDataType(value="CFTCNonReportablePart43", model="drr", builder=CFTCNonReportablePart43.CFTCNonReportablePart43BuilderImpl.class, version="6.0.0-dev.128")
public interface CFTCNonReportablePart43 extends RosettaModelObject {

	CFTCNonReportablePart43Meta metaData = new CFTCNonReportablePart43Meta();

	/*********************** Getter Methods  ***********************/
	/**
	 * Counterparty1 Format - LEI, or LEI and Person.
	 */
	PartyIdentifierFormatEnum getCounterparty1Format();
	/**
	 * Counterparty2 Format - LEI, or LEI and Person.
	 */
	PartyIdentifierFormatEnum getCounterparty2Format();

	/*********************** Build Methods  ***********************/
	CFTCNonReportablePart43 build();
	
	CFTCNonReportablePart43.CFTCNonReportablePart43Builder toBuilder();
	
	static CFTCNonReportablePart43.CFTCNonReportablePart43Builder builder() {
		return new CFTCNonReportablePart43.CFTCNonReportablePart43BuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends CFTCNonReportablePart43> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends CFTCNonReportablePart43> getType() {
		return CFTCNonReportablePart43.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("counterparty1Format"), PartyIdentifierFormatEnum.class, getCounterparty1Format(), this);
		processor.processBasic(path.newSubPath("counterparty2Format"), PartyIdentifierFormatEnum.class, getCounterparty2Format(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface CFTCNonReportablePart43Builder extends CFTCNonReportablePart43, RosettaModelObjectBuilder {
		CFTCNonReportablePart43.CFTCNonReportablePart43Builder setCounterparty1Format(PartyIdentifierFormatEnum counterparty1Format);
		CFTCNonReportablePart43.CFTCNonReportablePart43Builder setCounterparty2Format(PartyIdentifierFormatEnum counterparty2Format);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("counterparty1Format"), PartyIdentifierFormatEnum.class, getCounterparty1Format(), this);
			processor.processBasic(path.newSubPath("counterparty2Format"), PartyIdentifierFormatEnum.class, getCounterparty2Format(), this);
		}
		

		CFTCNonReportablePart43.CFTCNonReportablePart43Builder prune();
	}

	/*********************** Immutable Implementation of CFTCNonReportablePart43  ***********************/
	class CFTCNonReportablePart43Impl implements CFTCNonReportablePart43 {
		private final PartyIdentifierFormatEnum counterparty1Format;
		private final PartyIdentifierFormatEnum counterparty2Format;
		
		protected CFTCNonReportablePart43Impl(CFTCNonReportablePart43.CFTCNonReportablePart43Builder builder) {
			this.counterparty1Format = builder.getCounterparty1Format();
			this.counterparty2Format = builder.getCounterparty2Format();
		}
		
		@Override
		@RosettaAttribute("counterparty1Format")
		@RuneAttribute("counterparty1Format")
		public PartyIdentifierFormatEnum getCounterparty1Format() {
			return counterparty1Format;
		}
		
		@Override
		@RosettaAttribute("counterparty2Format")
		@RuneAttribute("counterparty2Format")
		public PartyIdentifierFormatEnum getCounterparty2Format() {
			return counterparty2Format;
		}
		
		@Override
		public CFTCNonReportablePart43 build() {
			return this;
		}
		
		@Override
		public CFTCNonReportablePart43.CFTCNonReportablePart43Builder toBuilder() {
			CFTCNonReportablePart43.CFTCNonReportablePart43Builder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(CFTCNonReportablePart43.CFTCNonReportablePart43Builder builder) {
			ofNullable(getCounterparty1Format()).ifPresent(builder::setCounterparty1Format);
			ofNullable(getCounterparty2Format()).ifPresent(builder::setCounterparty2Format);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			CFTCNonReportablePart43 _that = getType().cast(o);
		
			if (!Objects.equals(counterparty1Format, _that.getCounterparty1Format())) return false;
			if (!Objects.equals(counterparty2Format, _that.getCounterparty2Format())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (counterparty1Format != null ? counterparty1Format.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (counterparty2Format != null ? counterparty2Format.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "CFTCNonReportablePart43 {" +
				"counterparty1Format=" + this.counterparty1Format + ", " +
				"counterparty2Format=" + this.counterparty2Format +
			'}';
		}
	}

	/*********************** Builder Implementation of CFTCNonReportablePart43  ***********************/
	class CFTCNonReportablePart43BuilderImpl implements CFTCNonReportablePart43.CFTCNonReportablePart43Builder {
	
		protected PartyIdentifierFormatEnum counterparty1Format;
		protected PartyIdentifierFormatEnum counterparty2Format;
		
		@Override
		@RosettaAttribute("counterparty1Format")
		@RuneAttribute("counterparty1Format")
		public PartyIdentifierFormatEnum getCounterparty1Format() {
			return counterparty1Format;
		}
		
		@Override
		@RosettaAttribute("counterparty2Format")
		@RuneAttribute("counterparty2Format")
		public PartyIdentifierFormatEnum getCounterparty2Format() {
			return counterparty2Format;
		}
		
		@Override
		@RosettaAttribute("counterparty1Format")
		@RuneAttribute("counterparty1Format")
		public CFTCNonReportablePart43.CFTCNonReportablePart43Builder setCounterparty1Format(PartyIdentifierFormatEnum _counterparty1Format) {
			this.counterparty1Format = _counterparty1Format == null ? null : _counterparty1Format;
			return this;
		}
		
		@Override
		@RosettaAttribute("counterparty2Format")
		@RuneAttribute("counterparty2Format")
		public CFTCNonReportablePart43.CFTCNonReportablePart43Builder setCounterparty2Format(PartyIdentifierFormatEnum _counterparty2Format) {
			this.counterparty2Format = _counterparty2Format == null ? null : _counterparty2Format;
			return this;
		}
		
		@Override
		public CFTCNonReportablePart43 build() {
			return new CFTCNonReportablePart43.CFTCNonReportablePart43Impl(this);
		}
		
		@Override
		public CFTCNonReportablePart43.CFTCNonReportablePart43Builder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public CFTCNonReportablePart43.CFTCNonReportablePart43Builder prune() {
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getCounterparty1Format()!=null) return true;
			if (getCounterparty2Format()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public CFTCNonReportablePart43.CFTCNonReportablePart43Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			CFTCNonReportablePart43.CFTCNonReportablePart43Builder o = (CFTCNonReportablePart43.CFTCNonReportablePart43Builder) other;
			
			
			merger.mergeBasic(getCounterparty1Format(), o.getCounterparty1Format(), this::setCounterparty1Format);
			merger.mergeBasic(getCounterparty2Format(), o.getCounterparty2Format(), this::setCounterparty2Format);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			CFTCNonReportablePart43 _that = getType().cast(o);
		
			if (!Objects.equals(counterparty1Format, _that.getCounterparty1Format())) return false;
			if (!Objects.equals(counterparty2Format, _that.getCounterparty2Format())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (counterparty1Format != null ? counterparty1Format.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (counterparty2Format != null ? counterparty2Format.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "CFTCNonReportablePart43Builder {" +
				"counterparty1Format=" + this.counterparty1Format + ", " +
				"counterparty2Format=" + this.counterparty2Format +
			'}';
		}
	}
}
