package drr.regulation.cftc.rewrite;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.cftc.rewrite.CFTCNonReportablePart43;
import drr.regulation.cftc.rewrite.CFTCNonReportablePart43.CFTCNonReportablePart43Builder;
import drr.regulation.cftc.rewrite.CFTCNonReportablePart43.CFTCNonReportablePart43BuilderImpl;
import drr.regulation.cftc.rewrite.CFTCNonReportablePart43.CFTCNonReportablePart43Impl;
import drr.regulation.cftc.rewrite.CFTCNonReportablePart45;
import drr.regulation.cftc.rewrite.CFTCNonReportablePart45.CFTCNonReportablePart45Builder;
import drr.regulation.cftc.rewrite.CFTCNonReportablePart45.CFTCNonReportablePart45BuilderImpl;
import drr.regulation.cftc.rewrite.CFTCNonReportablePart45.CFTCNonReportablePart45Impl;
import drr.regulation.cftc.rewrite.meta.CFTCNonReportablePart45Meta;
import drr.regulation.common.PartyIdentifierFormatEnum;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * @version 6.0.0-dev.128
 */
@RosettaDataType(value="CFTCNonReportablePart45", builder=CFTCNonReportablePart45.CFTCNonReportablePart45BuilderImpl.class, version="6.0.0-dev.128")
@RuneDataType(value="CFTCNonReportablePart45", model="drr", builder=CFTCNonReportablePart45.CFTCNonReportablePart45BuilderImpl.class, version="6.0.0-dev.128")
public interface CFTCNonReportablePart45 extends CFTCNonReportablePart43 {

	CFTCNonReportablePart45Meta metaData = new CFTCNonReportablePart45Meta();

	/*********************** Getter Methods  ***********************/
	/**
	 * BuyerIdentifier Format - LEI, or LEI and Person.
	 */
	PartyIdentifierFormatEnum getBuyerIdentifierFormat();
	/**
	 * SellerIdentifier Format - LEI, or LEI and Person.
	 */
	PartyIdentifierFormatEnum getSellerIdentifierFormat();
	/**
	 * PayerIdentifierLeg1 Format - LEI, or LEI and Person.
	 */
	PartyIdentifierFormatEnum getPayerIdentifierLeg1Format();
	/**
	 * PayerIdentifierLeg2 Format - LEI, or LEI and Person.
	 */
	PartyIdentifierFormatEnum getPayerIdentifierLeg2Format();
	/**
	 * ReceiverIdentifierLeg1 Format - LEI, or LEI and Person.
	 */
	PartyIdentifierFormatEnum getReceiverIdentifierLeg1Format();
	/**
	 * ReceiverIdentifierLeg2 Format - LEI, or LEI and Person.
	 */
	PartyIdentifierFormatEnum getReceiverIdentifierLeg2Format();

	/*********************** Build Methods  ***********************/
	CFTCNonReportablePart45 build();
	
	CFTCNonReportablePart45.CFTCNonReportablePart45Builder toBuilder();
	
	static CFTCNonReportablePart45.CFTCNonReportablePart45Builder builder() {
		return new CFTCNonReportablePart45.CFTCNonReportablePart45BuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends CFTCNonReportablePart45> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends CFTCNonReportablePart45> getType() {
		return CFTCNonReportablePart45.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("counterparty1Format"), PartyIdentifierFormatEnum.class, getCounterparty1Format(), this);
		processor.processBasic(path.newSubPath("counterparty2Format"), PartyIdentifierFormatEnum.class, getCounterparty2Format(), this);
		processor.processBasic(path.newSubPath("buyerIdentifierFormat"), PartyIdentifierFormatEnum.class, getBuyerIdentifierFormat(), this);
		processor.processBasic(path.newSubPath("sellerIdentifierFormat"), PartyIdentifierFormatEnum.class, getSellerIdentifierFormat(), this);
		processor.processBasic(path.newSubPath("payerIdentifierLeg1Format"), PartyIdentifierFormatEnum.class, getPayerIdentifierLeg1Format(), this);
		processor.processBasic(path.newSubPath("payerIdentifierLeg2Format"), PartyIdentifierFormatEnum.class, getPayerIdentifierLeg2Format(), this);
		processor.processBasic(path.newSubPath("receiverIdentifierLeg1Format"), PartyIdentifierFormatEnum.class, getReceiverIdentifierLeg1Format(), this);
		processor.processBasic(path.newSubPath("receiverIdentifierLeg2Format"), PartyIdentifierFormatEnum.class, getReceiverIdentifierLeg2Format(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface CFTCNonReportablePart45Builder extends CFTCNonReportablePart45, CFTCNonReportablePart43.CFTCNonReportablePart43Builder {
		@Override
		CFTCNonReportablePart45.CFTCNonReportablePart45Builder setCounterparty1Format(PartyIdentifierFormatEnum counterparty1Format);
		@Override
		CFTCNonReportablePart45.CFTCNonReportablePart45Builder setCounterparty2Format(PartyIdentifierFormatEnum counterparty2Format);
		CFTCNonReportablePart45.CFTCNonReportablePart45Builder setBuyerIdentifierFormat(PartyIdentifierFormatEnum buyerIdentifierFormat);
		CFTCNonReportablePart45.CFTCNonReportablePart45Builder setSellerIdentifierFormat(PartyIdentifierFormatEnum sellerIdentifierFormat);
		CFTCNonReportablePart45.CFTCNonReportablePart45Builder setPayerIdentifierLeg1Format(PartyIdentifierFormatEnum payerIdentifierLeg1Format);
		CFTCNonReportablePart45.CFTCNonReportablePart45Builder setPayerIdentifierLeg2Format(PartyIdentifierFormatEnum payerIdentifierLeg2Format);
		CFTCNonReportablePart45.CFTCNonReportablePart45Builder setReceiverIdentifierLeg1Format(PartyIdentifierFormatEnum receiverIdentifierLeg1Format);
		CFTCNonReportablePart45.CFTCNonReportablePart45Builder setReceiverIdentifierLeg2Format(PartyIdentifierFormatEnum receiverIdentifierLeg2Format);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("counterparty1Format"), PartyIdentifierFormatEnum.class, getCounterparty1Format(), this);
			processor.processBasic(path.newSubPath("counterparty2Format"), PartyIdentifierFormatEnum.class, getCounterparty2Format(), this);
			processor.processBasic(path.newSubPath("buyerIdentifierFormat"), PartyIdentifierFormatEnum.class, getBuyerIdentifierFormat(), this);
			processor.processBasic(path.newSubPath("sellerIdentifierFormat"), PartyIdentifierFormatEnum.class, getSellerIdentifierFormat(), this);
			processor.processBasic(path.newSubPath("payerIdentifierLeg1Format"), PartyIdentifierFormatEnum.class, getPayerIdentifierLeg1Format(), this);
			processor.processBasic(path.newSubPath("payerIdentifierLeg2Format"), PartyIdentifierFormatEnum.class, getPayerIdentifierLeg2Format(), this);
			processor.processBasic(path.newSubPath("receiverIdentifierLeg1Format"), PartyIdentifierFormatEnum.class, getReceiverIdentifierLeg1Format(), this);
			processor.processBasic(path.newSubPath("receiverIdentifierLeg2Format"), PartyIdentifierFormatEnum.class, getReceiverIdentifierLeg2Format(), this);
		}
		

		CFTCNonReportablePart45.CFTCNonReportablePart45Builder prune();
	}

	/*********************** Immutable Implementation of CFTCNonReportablePart45  ***********************/
	class CFTCNonReportablePart45Impl extends CFTCNonReportablePart43.CFTCNonReportablePart43Impl implements CFTCNonReportablePart45 {
		private final PartyIdentifierFormatEnum buyerIdentifierFormat;
		private final PartyIdentifierFormatEnum sellerIdentifierFormat;
		private final PartyIdentifierFormatEnum payerIdentifierLeg1Format;
		private final PartyIdentifierFormatEnum payerIdentifierLeg2Format;
		private final PartyIdentifierFormatEnum receiverIdentifierLeg1Format;
		private final PartyIdentifierFormatEnum receiverIdentifierLeg2Format;
		
		protected CFTCNonReportablePart45Impl(CFTCNonReportablePart45.CFTCNonReportablePart45Builder builder) {
			super(builder);
			this.buyerIdentifierFormat = builder.getBuyerIdentifierFormat();
			this.sellerIdentifierFormat = builder.getSellerIdentifierFormat();
			this.payerIdentifierLeg1Format = builder.getPayerIdentifierLeg1Format();
			this.payerIdentifierLeg2Format = builder.getPayerIdentifierLeg2Format();
			this.receiverIdentifierLeg1Format = builder.getReceiverIdentifierLeg1Format();
			this.receiverIdentifierLeg2Format = builder.getReceiverIdentifierLeg2Format();
		}
		
		@Override
		@RosettaAttribute("buyerIdentifierFormat")
		@RuneAttribute("buyerIdentifierFormat")
		public PartyIdentifierFormatEnum getBuyerIdentifierFormat() {
			return buyerIdentifierFormat;
		}
		
		@Override
		@RosettaAttribute("sellerIdentifierFormat")
		@RuneAttribute("sellerIdentifierFormat")
		public PartyIdentifierFormatEnum getSellerIdentifierFormat() {
			return sellerIdentifierFormat;
		}
		
		@Override
		@RosettaAttribute("payerIdentifierLeg1Format")
		@RuneAttribute("payerIdentifierLeg1Format")
		public PartyIdentifierFormatEnum getPayerIdentifierLeg1Format() {
			return payerIdentifierLeg1Format;
		}
		
		@Override
		@RosettaAttribute("payerIdentifierLeg2Format")
		@RuneAttribute("payerIdentifierLeg2Format")
		public PartyIdentifierFormatEnum getPayerIdentifierLeg2Format() {
			return payerIdentifierLeg2Format;
		}
		
		@Override
		@RosettaAttribute("receiverIdentifierLeg1Format")
		@RuneAttribute("receiverIdentifierLeg1Format")
		public PartyIdentifierFormatEnum getReceiverIdentifierLeg1Format() {
			return receiverIdentifierLeg1Format;
		}
		
		@Override
		@RosettaAttribute("receiverIdentifierLeg2Format")
		@RuneAttribute("receiverIdentifierLeg2Format")
		public PartyIdentifierFormatEnum getReceiverIdentifierLeg2Format() {
			return receiverIdentifierLeg2Format;
		}
		
		@Override
		public CFTCNonReportablePart45 build() {
			return this;
		}
		
		@Override
		public CFTCNonReportablePart45.CFTCNonReportablePart45Builder toBuilder() {
			CFTCNonReportablePart45.CFTCNonReportablePart45Builder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(CFTCNonReportablePart45.CFTCNonReportablePart45Builder builder) {
			super.setBuilderFields(builder);
			ofNullable(getBuyerIdentifierFormat()).ifPresent(builder::setBuyerIdentifierFormat);
			ofNullable(getSellerIdentifierFormat()).ifPresent(builder::setSellerIdentifierFormat);
			ofNullable(getPayerIdentifierLeg1Format()).ifPresent(builder::setPayerIdentifierLeg1Format);
			ofNullable(getPayerIdentifierLeg2Format()).ifPresent(builder::setPayerIdentifierLeg2Format);
			ofNullable(getReceiverIdentifierLeg1Format()).ifPresent(builder::setReceiverIdentifierLeg1Format);
			ofNullable(getReceiverIdentifierLeg2Format()).ifPresent(builder::setReceiverIdentifierLeg2Format);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
			if (!super.equals(o)) return false;
		
			CFTCNonReportablePart45 _that = getType().cast(o);
		
			if (!Objects.equals(buyerIdentifierFormat, _that.getBuyerIdentifierFormat())) return false;
			if (!Objects.equals(sellerIdentifierFormat, _that.getSellerIdentifierFormat())) return false;
			if (!Objects.equals(payerIdentifierLeg1Format, _that.getPayerIdentifierLeg1Format())) return false;
			if (!Objects.equals(payerIdentifierLeg2Format, _that.getPayerIdentifierLeg2Format())) return false;
			if (!Objects.equals(receiverIdentifierLeg1Format, _that.getReceiverIdentifierLeg1Format())) return false;
			if (!Objects.equals(receiverIdentifierLeg2Format, _that.getReceiverIdentifierLeg2Format())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = super.hashCode();
			_result = 31 * _result + (buyerIdentifierFormat != null ? buyerIdentifierFormat.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (sellerIdentifierFormat != null ? sellerIdentifierFormat.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (payerIdentifierLeg1Format != null ? payerIdentifierLeg1Format.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (payerIdentifierLeg2Format != null ? payerIdentifierLeg2Format.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (receiverIdentifierLeg1Format != null ? receiverIdentifierLeg1Format.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (receiverIdentifierLeg2Format != null ? receiverIdentifierLeg2Format.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "CFTCNonReportablePart45 {" +
				"buyerIdentifierFormat=" + this.buyerIdentifierFormat + ", " +
				"sellerIdentifierFormat=" + this.sellerIdentifierFormat + ", " +
				"payerIdentifierLeg1Format=" + this.payerIdentifierLeg1Format + ", " +
				"payerIdentifierLeg2Format=" + this.payerIdentifierLeg2Format + ", " +
				"receiverIdentifierLeg1Format=" + this.receiverIdentifierLeg1Format + ", " +
				"receiverIdentifierLeg2Format=" + this.receiverIdentifierLeg2Format +
			'}' + " " + super.toString();
		}
	}

	/*********************** Builder Implementation of CFTCNonReportablePart45  ***********************/
	class CFTCNonReportablePart45BuilderImpl extends CFTCNonReportablePart43.CFTCNonReportablePart43BuilderImpl implements CFTCNonReportablePart45.CFTCNonReportablePart45Builder {
	
		protected PartyIdentifierFormatEnum buyerIdentifierFormat;
		protected PartyIdentifierFormatEnum sellerIdentifierFormat;
		protected PartyIdentifierFormatEnum payerIdentifierLeg1Format;
		protected PartyIdentifierFormatEnum payerIdentifierLeg2Format;
		protected PartyIdentifierFormatEnum receiverIdentifierLeg1Format;
		protected PartyIdentifierFormatEnum receiverIdentifierLeg2Format;
		
		@Override
		@RosettaAttribute("buyerIdentifierFormat")
		@RuneAttribute("buyerIdentifierFormat")
		public PartyIdentifierFormatEnum getBuyerIdentifierFormat() {
			return buyerIdentifierFormat;
		}
		
		@Override
		@RosettaAttribute("sellerIdentifierFormat")
		@RuneAttribute("sellerIdentifierFormat")
		public PartyIdentifierFormatEnum getSellerIdentifierFormat() {
			return sellerIdentifierFormat;
		}
		
		@Override
		@RosettaAttribute("payerIdentifierLeg1Format")
		@RuneAttribute("payerIdentifierLeg1Format")
		public PartyIdentifierFormatEnum getPayerIdentifierLeg1Format() {
			return payerIdentifierLeg1Format;
		}
		
		@Override
		@RosettaAttribute("payerIdentifierLeg2Format")
		@RuneAttribute("payerIdentifierLeg2Format")
		public PartyIdentifierFormatEnum getPayerIdentifierLeg2Format() {
			return payerIdentifierLeg2Format;
		}
		
		@Override
		@RosettaAttribute("receiverIdentifierLeg1Format")
		@RuneAttribute("receiverIdentifierLeg1Format")
		public PartyIdentifierFormatEnum getReceiverIdentifierLeg1Format() {
			return receiverIdentifierLeg1Format;
		}
		
		@Override
		@RosettaAttribute("receiverIdentifierLeg2Format")
		@RuneAttribute("receiverIdentifierLeg2Format")
		public PartyIdentifierFormatEnum getReceiverIdentifierLeg2Format() {
			return receiverIdentifierLeg2Format;
		}
		
		@Override
		@RosettaAttribute("counterparty1Format")
		@RuneAttribute("counterparty1Format")
		public CFTCNonReportablePart45.CFTCNonReportablePart45Builder setCounterparty1Format(PartyIdentifierFormatEnum _counterparty1Format) {
			this.counterparty1Format = _counterparty1Format == null ? null : _counterparty1Format;
			return this;
		}
		
		@Override
		@RosettaAttribute("counterparty2Format")
		@RuneAttribute("counterparty2Format")
		public CFTCNonReportablePart45.CFTCNonReportablePart45Builder setCounterparty2Format(PartyIdentifierFormatEnum _counterparty2Format) {
			this.counterparty2Format = _counterparty2Format == null ? null : _counterparty2Format;
			return this;
		}
		
		@Override
		@RosettaAttribute("buyerIdentifierFormat")
		@RuneAttribute("buyerIdentifierFormat")
		public CFTCNonReportablePart45.CFTCNonReportablePart45Builder setBuyerIdentifierFormat(PartyIdentifierFormatEnum _buyerIdentifierFormat) {
			this.buyerIdentifierFormat = _buyerIdentifierFormat == null ? null : _buyerIdentifierFormat;
			return this;
		}
		
		@Override
		@RosettaAttribute("sellerIdentifierFormat")
		@RuneAttribute("sellerIdentifierFormat")
		public CFTCNonReportablePart45.CFTCNonReportablePart45Builder setSellerIdentifierFormat(PartyIdentifierFormatEnum _sellerIdentifierFormat) {
			this.sellerIdentifierFormat = _sellerIdentifierFormat == null ? null : _sellerIdentifierFormat;
			return this;
		}
		
		@Override
		@RosettaAttribute("payerIdentifierLeg1Format")
		@RuneAttribute("payerIdentifierLeg1Format")
		public CFTCNonReportablePart45.CFTCNonReportablePart45Builder setPayerIdentifierLeg1Format(PartyIdentifierFormatEnum _payerIdentifierLeg1Format) {
			this.payerIdentifierLeg1Format = _payerIdentifierLeg1Format == null ? null : _payerIdentifierLeg1Format;
			return this;
		}
		
		@Override
		@RosettaAttribute("payerIdentifierLeg2Format")
		@RuneAttribute("payerIdentifierLeg2Format")
		public CFTCNonReportablePart45.CFTCNonReportablePart45Builder setPayerIdentifierLeg2Format(PartyIdentifierFormatEnum _payerIdentifierLeg2Format) {
			this.payerIdentifierLeg2Format = _payerIdentifierLeg2Format == null ? null : _payerIdentifierLeg2Format;
			return this;
		}
		
		@Override
		@RosettaAttribute("receiverIdentifierLeg1Format")
		@RuneAttribute("receiverIdentifierLeg1Format")
		public CFTCNonReportablePart45.CFTCNonReportablePart45Builder setReceiverIdentifierLeg1Format(PartyIdentifierFormatEnum _receiverIdentifierLeg1Format) {
			this.receiverIdentifierLeg1Format = _receiverIdentifierLeg1Format == null ? null : _receiverIdentifierLeg1Format;
			return this;
		}
		
		@Override
		@RosettaAttribute("receiverIdentifierLeg2Format")
		@RuneAttribute("receiverIdentifierLeg2Format")
		public CFTCNonReportablePart45.CFTCNonReportablePart45Builder setReceiverIdentifierLeg2Format(PartyIdentifierFormatEnum _receiverIdentifierLeg2Format) {
			this.receiverIdentifierLeg2Format = _receiverIdentifierLeg2Format == null ? null : _receiverIdentifierLeg2Format;
			return this;
		}
		
		@Override
		public CFTCNonReportablePart45 build() {
			return new CFTCNonReportablePart45.CFTCNonReportablePart45Impl(this);
		}
		
		@Override
		public CFTCNonReportablePart45.CFTCNonReportablePart45Builder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public CFTCNonReportablePart45.CFTCNonReportablePart45Builder prune() {
			super.prune();
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (super.hasData()) return true;
			if (getBuyerIdentifierFormat()!=null) return true;
			if (getSellerIdentifierFormat()!=null) return true;
			if (getPayerIdentifierLeg1Format()!=null) return true;
			if (getPayerIdentifierLeg2Format()!=null) return true;
			if (getReceiverIdentifierLeg1Format()!=null) return true;
			if (getReceiverIdentifierLeg2Format()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public CFTCNonReportablePart45.CFTCNonReportablePart45Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			super.merge(other, merger);
			
			CFTCNonReportablePart45.CFTCNonReportablePart45Builder o = (CFTCNonReportablePart45.CFTCNonReportablePart45Builder) other;
			
			
			merger.mergeBasic(getBuyerIdentifierFormat(), o.getBuyerIdentifierFormat(), this::setBuyerIdentifierFormat);
			merger.mergeBasic(getSellerIdentifierFormat(), o.getSellerIdentifierFormat(), this::setSellerIdentifierFormat);
			merger.mergeBasic(getPayerIdentifierLeg1Format(), o.getPayerIdentifierLeg1Format(), this::setPayerIdentifierLeg1Format);
			merger.mergeBasic(getPayerIdentifierLeg2Format(), o.getPayerIdentifierLeg2Format(), this::setPayerIdentifierLeg2Format);
			merger.mergeBasic(getReceiverIdentifierLeg1Format(), o.getReceiverIdentifierLeg1Format(), this::setReceiverIdentifierLeg1Format);
			merger.mergeBasic(getReceiverIdentifierLeg2Format(), o.getReceiverIdentifierLeg2Format(), this::setReceiverIdentifierLeg2Format);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
			if (!super.equals(o)) return false;
		
			CFTCNonReportablePart45 _that = getType().cast(o);
		
			if (!Objects.equals(buyerIdentifierFormat, _that.getBuyerIdentifierFormat())) return false;
			if (!Objects.equals(sellerIdentifierFormat, _that.getSellerIdentifierFormat())) return false;
			if (!Objects.equals(payerIdentifierLeg1Format, _that.getPayerIdentifierLeg1Format())) return false;
			if (!Objects.equals(payerIdentifierLeg2Format, _that.getPayerIdentifierLeg2Format())) return false;
			if (!Objects.equals(receiverIdentifierLeg1Format, _that.getReceiverIdentifierLeg1Format())) return false;
			if (!Objects.equals(receiverIdentifierLeg2Format, _that.getReceiverIdentifierLeg2Format())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = super.hashCode();
			_result = 31 * _result + (buyerIdentifierFormat != null ? buyerIdentifierFormat.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (sellerIdentifierFormat != null ? sellerIdentifierFormat.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (payerIdentifierLeg1Format != null ? payerIdentifierLeg1Format.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (payerIdentifierLeg2Format != null ? payerIdentifierLeg2Format.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (receiverIdentifierLeg1Format != null ? receiverIdentifierLeg1Format.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (receiverIdentifierLeg2Format != null ? receiverIdentifierLeg2Format.getClass().getName().hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "CFTCNonReportablePart45Builder {" +
				"buyerIdentifierFormat=" + this.buyerIdentifierFormat + ", " +
				"sellerIdentifierFormat=" + this.sellerIdentifierFormat + ", " +
				"payerIdentifierLeg1Format=" + this.payerIdentifierLeg1Format + ", " +
				"payerIdentifierLeg2Format=" + this.payerIdentifierLeg2Format + ", " +
				"receiverIdentifierLeg1Format=" + this.receiverIdentifierLeg1Format + ", " +
				"receiverIdentifierLeg2Format=" + this.receiverIdentifierLeg2Format +
			'}' + " " + super.toString();
		}
	}
}
