package drr.regulation.cftc.rewrite;

import cdm.base.staticdata.asset.common.ISOCountryCodeEnum;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RosettaIgnore;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.util.ListEquals;
import drr.regulation.cftc.rewrite.CFTCGuidebook;
import drr.regulation.cftc.rewrite.CFTCGuidebook.CFTCGuidebookBuilder;
import drr.regulation.cftc.rewrite.CFTCNonReportablePart45;
import drr.regulation.cftc.rewrite.CFTCNonReportablePart45.CFTCNonReportablePart45Builder;
import drr.regulation.cftc.rewrite.CFTCPart45TransactionReport;
import drr.regulation.cftc.rewrite.CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder;
import drr.regulation.cftc.rewrite.CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilderImpl;
import drr.regulation.cftc.rewrite.CFTCPart45TransactionReport.CFTCPart45TransactionReportImpl;
import drr.regulation.cftc.rewrite.CFTCTransactionReport;
import drr.regulation.cftc.rewrite.CFTCTransactionReport.CFTCTransactionReportBuilder;
import drr.regulation.cftc.rewrite.CFTCTransactionReport.CFTCTransactionReportBuilderImpl;
import drr.regulation.cftc.rewrite.CFTCTransactionReport.CFTCTransactionReportImpl;
import drr.regulation.cftc.rewrite.meta.CFTCPart45TransactionReportMeta;
import drr.regulation.common.AllocationIndicatorEnum;
import drr.regulation.common.ClearingAccountOriginEnum;
import drr.regulation.common.ClearingExceptionsAndExemptionsEnum;
import drr.regulation.common.CommonAssetClass;
import drr.regulation.common.CommonContractType;
import drr.regulation.common.Counterparty2IdentifierEnum;
import drr.regulation.common.JurisdictionEnum;
import drr.regulation.common.trade.CommonLeg;
import drr.regulation.common.trade.CommonLeg.CommonLegBuilder;
import drr.regulation.common.trade.basket.BasketConstituentsReport;
import drr.regulation.common.trade.basket.BasketConstituentsReport.BasketConstituentsReportBuilder;
import drr.regulation.common.trade.contract.UnderlyingIdentifier;
import drr.regulation.common.trade.contract.UnderlyingIdentifier.UnderlyingIdentifierBuilder;
import drr.regulation.common.trade.price.SingleOrUpperAndLowerBarrier;
import drr.regulation.common.trade.price.SingleOrUpperAndLowerBarrier.SingleOrUpperAndLowerBarrierBuilder;
import drr.standards.iosco.cde.Leg;
import drr.standards.iosco.cde.payment.OtherPayment;
import drr.standards.iosco.cde.payment.OtherPayment.OtherPaymentBuilder;
import drr.standards.iosco.cde.price.PriceFormat;
import drr.standards.iosco.cde.price.PriceFormat.PriceFormatBuilder;
import drr.standards.iosco.cde.price.PriceNotationEnum;
import drr.standards.iosco.cde.price.PricePeriod;
import drr.standards.iosco.cde.price.PricePeriod.PricePeriodBuilder;
import drr.standards.iso.ActionTypeEnum;
import drr.standards.iso.ClearedEnum;
import drr.standards.iso.ConfirmationEnum;
import drr.standards.iso.DeliveryTypeEnum;
import drr.standards.iso.Direction1Enum;
import drr.standards.iso.Direction2Enum;
import drr.standards.iso.EmbeddedOptionTypeEnum;
import drr.standards.iso.EventTypeEnum;
import drr.standards.iso.OptionStyleEnum;
import drr.standards.iso.OptionTypeCode;
import drr.standards.iso.SeniorityEnum;
import drr.standards.iso.TradingCapacity7Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.stream.Collectors;

import static java.util.Optional.ofNullable;

/**
 * @version 6.0.0-dev.128
 */
@RosettaDataType(value="CFTCPart45TransactionReport", builder=CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilderImpl.class, version="6.0.0-dev.128")
@RuneDataType(value="CFTCPart45TransactionReport", model="drr", builder=CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilderImpl.class, version="6.0.0-dev.128")
public interface CFTCPart45TransactionReport extends CFTCTransactionReport {

	CFTCPart45TransactionReportMeta metaData = new CFTCPart45TransactionReportMeta();

	/*********************** Getter Methods  ***********************/
	CFTCNonReportablePart45 getNonReportable();
	/**
	 *
	 * Body CFTC
	 * Corpus Regulation Part45 CFTC 17 CFR Parts 45 Version 3.0 "Part 45 of the CFTCs regulations specifies the Commissions swap data recordkeeping and reporting requirements, pursuant to section 2(a)(13)(G) of the Commodity Exchange Act (CEA), which states that all swaps, whether cleared or uncleared, must be reported to a Swap Data Repository (SDR)" 
	 * appendix "1" * dataElement "3" * field "Clearing Account Origin"
	 *
	 * Provision Indicator of whether the clearing member acted as principal for a house trade or an agent for a customer trade.
	 *
	 */
	ClearingAccountOriginEnum getClearingAccountOrigin();
	/**
	 *
	 * Body CFTC
	 * Corpus Regulation Part45 CFTC 17 CFR Parts 45 Version 3.0 "Part 45 of the CFTCs regulations specifies the Commissions swap data recordkeeping and reporting requirements, pursuant to section 2(a)(13)(G) of the Commodity Exchange Act (CEA), which states that all swaps, whether cleared or uncleared, must be reported to a Swap Data Repository (SDR)" 
	 * appendix "1" * dataElement "5" * field "Clearing Swap USIs"
	 *
	 * Provision The unique swap identifiers (USI) of each clearing swap that replaces the original swap that was submitted for clearing to the derivatives clearing organization, other than the USI for the swap currently being reported (as 'USI' data element below).
	 *
	 *
	 * Body CFTC
	 * Corpus Regulation Part45_V3_1 CFTC 17 CFR Parts 45 Version 3.1 "Part 45 of the CFTCs regulations specifies the Commissions swap data recordkeeping and reporting requirements, pursuant to section 2(a)(13)(G) of the Commodity Exchange Act (CEA), which states that all swaps, whether cleared or uncleared, must be reported to a Swap Data Repository (SDR).The modifications address 14 data elements for several swap data reporting topics including: clearing, counterparty identification, price, valuation, collateral and margin, and transaction-related data fields." 
	 * appendix "1" * dataElement "5" * field "Clearing Swap USIs" * footnote "18"
	 *
	 * Provision Throughout this Technical Specification, references to 'CFTC USI Data Standard' should refer to the Unique Swap Identifier (USI) Data Standard,
	                 https://www.cftc.gov/sites/default/files/idc/groups/public/@swaps/documents/dfsubmission/usidatastandards100112.pdf
	 *
	 */
	List<String> getClearingSwapUSIs();
	/**
	 *
	 * Body CFTC
	 * Corpus Regulation Part45 CFTC 17 CFR Parts 45 Version 3.0 "Part 45 of the CFTCs regulations specifies the Commissions swap data recordkeeping and reporting requirements, pursuant to section 2(a)(13)(G) of the Commodity Exchange Act (CEA), which states that all swaps, whether cleared or uncleared, must be reported to a Swap Data Repository (SDR)" 
	 * appendix "1" * dataElement "6" * field "Clearing Swap UTIs"
	 *
	 * Provision The unique transaction identifiers (UTI) of each clearing swap that replaces the original swap that was submitted for clearing to the derivatives clearing organization, other than the UTI for the swap currently being reported (as 'UTI' data element below).
	 *
	 */
	List<String> getClearingSwapUTIs();
	/**
	 *
	 * Body CFTC
	 * Corpus Regulation Part45 CFTC 17 CFR Parts 45 Version 3.0 "Part 45 of the CFTCs regulations specifies the Commissions swap data recordkeeping and reporting requirements, pursuant to section 2(a)(13)(G) of the Commodity Exchange Act (CEA), which states that all swaps, whether cleared or uncleared, must be reported to a Swap Data Repository (SDR)" 
	 * appendix "1" * dataElement "7" * field "Original Swap USI"
	 *
	 * Provision The unique swap identifier (USI) of the original swap submitted for clearing to the derivatives clearing organization that is replaced by clearing swaps.
	 *
	 *
	 * Body CFTC
	 * Corpus Regulation Part45_V3_1 CFTC 17 CFR Parts 45 Version 3.1 "Part 45 of the CFTCs regulations specifies the Commissions swap data recordkeeping and reporting requirements, pursuant to section 2(a)(13)(G) of the Commodity Exchange Act (CEA), which states that all swaps, whether cleared or uncleared, must be reported to a Swap Data Repository (SDR).The modifications address 14 data elements for several swap data reporting topics including: clearing, counterparty identification, price, valuation, collateral and margin, and transaction-related data fields." 
	 * appendix "1" * dataElement "7" * field "Original Swap USI" * footnote "19"
	 *
	 * Provision For transactions where no original swap USI is available or not provided, a value of 'NOTAVAILABLE' can be used.
	 *
	 */
	String getOriginalSwapUSI();
	/**
	 *
	 * Body CFTC
	 * Corpus Regulation Part45 CFTC 17 CFR Parts 45 Version 3.0 "Part 45 of the CFTCs regulations specifies the Commissions swap data recordkeeping and reporting requirements, pursuant to section 2(a)(13)(G) of the Commodity Exchange Act (CEA), which states that all swaps, whether cleared or uncleared, must be reported to a Swap Data Repository (SDR)" 
	 * appendix "1" * dataElement "8" * field "Original Swap UTI"
	 *
	 * Provision The unique transaction identifier (UTI) of the original swap submitted for clearing to the derivatives clearing organization that is replaced by clearing swaps.
	 *
	 *
	 * Body CFTC
	 * Corpus Regulation Part45_V3_1 CFTC 17 CFR Parts 45 Version 3.1 "Part 45 of the CFTCs regulations specifies the Commissions swap data recordkeeping and reporting requirements, pursuant to section 2(a)(13)(G) of the Commodity Exchange Act (CEA), which states that all swaps, whether cleared or uncleared, must be reported to a Swap Data Repository (SDR).The modifications address 14 data elements for several swap data reporting topics including: clearing, counterparty identification, price, valuation, collateral and margin, and transaction-related data fields." 
	 * appendix "1" * dataElement "8" * field "Original Swap UTI" * footnote "20"
	 *
	 * Provision For transactions where no original swap UTI is available or not provided, a value of 'NOTAVAILABLE' can be used.
	 *
	 */
	String getOriginalSwapUTI();
	/**
	 *
	 * Body CFTC
	 * Corpus Regulation Part45 CFTC 17 CFR Parts 45 Version 3.0 "Part 45 of the CFTCs regulations specifies the Commissions swap data recordkeeping and reporting requirements, pursuant to section 2(a)(13)(G) of the Commodity Exchange Act (CEA), which states that all swaps, whether cleared or uncleared, must be reported to a Swap Data Repository (SDR)" 
	 * appendix "1" * dataElement "9" * field "Original Swap SDR Identifier"
	 *
	 * Provision Identifier of the swap data repository (SDR) to which the original swap was reported.
	 *
	 *
	 * Body CFTC
	 * Corpus Regulation Part45_V3_1 CFTC 17 CFR Parts 45 Version 3.1 "Part 45 of the CFTCs regulations specifies the Commissions swap data recordkeeping and reporting requirements, pursuant to section 2(a)(13)(G) of the Commodity Exchange Act (CEA), which states that all swaps, whether cleared or uncleared, must be reported to a Swap Data Repository (SDR).The modifications address 14 data elements for several swap data reporting topics including: clearing, counterparty identification, price, valuation, collateral and margin, and transaction-related data fields." 
	 * appendix "1" * dataElement "9" * field "Original Swap SDR Identifier" * footnote "21"
	 *
	 * Provision  For transactions where no original swap SDR identifier is available or not provided, a value of 'NOTAVAILABLE' can be used.
	 *
	 */
	String getOriginalSwapSDRIdentifier();
	/**
	 *
	 * Body CFTC
	 * Corpus Regulation Part45 CFTC 17 CFR Parts 45 Version 3.0 "Part 45 of the CFTCs regulations specifies the Commissions swap data recordkeeping and reporting requirements, pursuant to section 2(a)(13)(G) of the Commodity Exchange Act (CEA), which states that all swaps, whether cleared or uncleared, must be reported to a Swap Data Repository (SDR)" 
	 * appendix "1" * dataElement "10" * field "Clearing Receipt Timestamp"
	 *
	 * Provision The date and time, expressed in UTC, the original swap was received by the derivatives clearing organization (DCO) for clearing and recorded by the DCOs system
	 *
	 */
	ZonedDateTime getClearingReceiptTimestamp();
	/**
	 *
	 * Body CFTC
	 * Corpus Regulation Part45 CFTC 17 CFR Parts 45 Version 3.0 "Part 45 of the CFTCs regulations specifies the Commissions swap data recordkeeping and reporting requirements, pursuant to section 2(a)(13)(G) of the Commodity Exchange Act (CEA), which states that all swaps, whether cleared or uncleared, must be reported to a Swap Data Repository (SDR)" 
	 * appendix "1" * dataElement "11" * field "Clearing Exceptions And Exemptions Counterparty 1"
	 *
	 * Provision Identifies the type of clearing exception or exemption that the Counterparty 1 has elected. All applicable exceptions and exemptions must be selected. The values may be repeated as applicable.
	 *
	 */
	List<ClearingExceptionsAndExemptionsEnum> getClearingExceptionsAndExemptionsCounterparty1();
	/**
	 *
	 * Body CFTC
	 * Corpus Regulation Part45 CFTC 17 CFR Parts 45 Version 3.0 "Part 45 of the CFTCs regulations specifies the Commissions swap data recordkeeping and reporting requirements, pursuant to section 2(a)(13)(G) of the Commodity Exchange Act (CEA), which states that all swaps, whether cleared or uncleared, must be reported to a Swap Data Repository (SDR)" 
	 * appendix "1" * dataElement "12" * field "Clearing Exceptions And Exemptions Counterparty 2"
	 *
	 * Provision Identifies the type of the clearing exception or exemption that the Counterparty 2 has elected. All applicable exceptions and exemptions must be selected. The values may be repeated as applicable.
	 *
	 */
	List<ClearingExceptionsAndExemptionsEnum> getClearingExceptionsAndExemptionsCounterparty2();
	/**
	 *
	 * Body CFTC
	 * Corpus Regulation Part45 CFTC 17 CFR Parts 45 Version 3.0 "Part 45 of the CFTCs regulations specifies the Commissions swap data recordkeeping and reporting requirements, pursuant to section 2(a)(13)(G) of the Commodity Exchange Act (CEA), which states that all swaps, whether cleared or uncleared, must be reported to a Swap Data Repository (SDR)" 
	 * appendix "1" * dataElement "16" * field "Counterparty 1 Financial Entity Indicator"
	 *
	 * Provision Indicator of whether Counterparty 1 is a financial entity as defined in CEA  2(h)(7)(C).
	 *
	 */
	Boolean getCounterparty1FinancialEntityIndicator();
	/**
	 *
	 * Body CFTC
	 * Corpus Regulation Part45 CFTC 17 CFR Parts 45 Version 3.0 "Part 45 of the CFTCs regulations specifies the Commissions swap data recordkeeping and reporting requirements, pursuant to section 2(a)(13)(G) of the Commodity Exchange Act (CEA), which states that all swaps, whether cleared or uncleared, must be reported to a Swap Data Repository (SDR)" 
	 * appendix "1" * dataElement "17" * field "Counterparty 2 Financial Entity Indicator"
	 *
	 * Provision Indicator of whether Counterparty 2 is a financial entity as defined in CEA  2(h)(7)(C).
	 *
	 */
	Boolean getCounterparty2FinancialEntityIndicator();
	/**
	 *
	 * Body CFTC
	 * Corpus Regulation Part45 CFTC 17 CFR Parts 45 Version 3.0 "Part 45 of the CFTCs regulations specifies the Commissions swap data recordkeeping and reporting requirements, pursuant to section 2(a)(13)(G) of the Commodity Exchange Act (CEA), which states that all swaps, whether cleared or uncleared, must be reported to a Swap Data Repository (SDR)" 
	 * appendix "1" * dataElement "18" * field "Buyer Identifier"
	 *
	 * Provision Identifier of the counterparty that is the buyer, as determined at the time of the transaction.
	                 A non-exhaustive list of examples of instruments for which this data element could apply are:
	                     - most forwards and forward-like contracts (except for foreign exchange forwards and foreign exchange non-deliverable forwards)
	                     - most options and option-like contracts including swaptions, caps and floors
	                     - credit default swaps (buyer/seller of protection)
	                     - variance, volatility and correlation swaps
	                     - contracts for difference and spreadbets.
	                 This data element is not applicable to instrument types covered by data elements Payer identifier and Receiver identifier
	 *
	 */
	String getBuyerIdentifier();
	/**
	 *
	 * Body CFTC
	 * Corpus Regulation Part45 CFTC 17 CFR Parts 45 Version 3.0 "Part 45 of the CFTCs regulations specifies the Commissions swap data recordkeeping and reporting requirements, pursuant to section 2(a)(13)(G) of the Commodity Exchange Act (CEA), which states that all swaps, whether cleared or uncleared, must be reported to a Swap Data Repository (SDR)" 
	 * appendix "1" * dataElement "19" * field "Seller Identifier"
	 *
	 * Provision Identifier of the counterparty that is the seller, as determined at the time of the transaction.
	                 A non-exhaustive list of examples of instruments for which this data element could apply are:
	                     - most forwards and forward-like contracts (except for foreign exchange forwards and foreign exchange non-deliverable forwards)
	                     - most options and option-like contracts including swaptions, caps and floors
	                     - credit default swaps (buyer/seller of protection)
	                     - variance, volatility and correlation swaps
	                     - contracts for difference and spreadbets.
	                 This data element is not applicable to instrument types covered by data elements Payer identifier and Receiver identifier
	 *
	 */
	String getSellerIdentifier();
	/**
	 *
	 * Body CFTC
	 * Corpus Regulation Part45 CFTC 17 CFR Parts 45 Version 3.0 "Part 45 of the CFTCs regulations specifies the Commissions swap data recordkeeping and reporting requirements, pursuant to section 2(a)(13)(G) of the Commodity Exchange Act (CEA), which states that all swaps, whether cleared or uncleared, must be reported to a Swap Data Repository (SDR)" 
	 * appendix "1" * dataElement "20" * field "Payer Identifier"
	 *
	 * Provision Identifier of the counterparty of the payer leg as determined at the time of the transaction.
	                 A non-exhaustive list of examples of instruments for which this data element could apply are:
	                     - most swaps and swap-like contracts including interest rate swaps, credit total return swaps, and equity swaps (except for credit default swaps, variance, volatility, and correlation swaps)
	                     - foreign exchange swaps, forwards, non-deliverable forwards.
	                 This data element is not applicable to instrument types covered by data elements Buyer identifier and Seller identifier.
	 *
	 *
	 * Body CFTC
	 * Corpus Regulation Part45_V3_1 CFTC 17 CFR Parts 45 Version 3.1 "Part 45 of the CFTCs regulations specifies the Commissions swap data recordkeeping and reporting requirements, pursuant to section 2(a)(13)(G) of the Commodity Exchange Act (CEA), which states that all swaps, whether cleared or uncleared, must be reported to a Swap Data Repository (SDR).The modifications address 14 data elements for several swap data reporting topics including: clearing, counterparty identification, price, valuation, collateral and margin, and transaction-related data fields." 
	 * appendix "1" * dataElement "20" * field "Payer Identifier" * footnote "29"
	 *
	 * Provision For fixed-floating interest rate swaps, the payer is the counterparty paying the fixed rate
	 *
	 *
	 * Body ISDA
	 * Corpus WorkingGroup PeerReviewGroup ISDA EMIR/CFTC Digital Regulatory Reporting Peer Review "Industry group which works collaboratively to mutualize representation of amended CFTC and EMIR transaction reporting requirements in Digital Regulatory Reporting (DRR) - a digitized, single standard set of open-source machine-executable code using the Common Domain Model (CDM)." 
	 * date "20211123"
	 *
	 * Provision Discussed on US Compliance WG - confirmed as per ISDA best practice for direction provided to CPMI-IOSCO best practice and CFTC tiebreaker logic  - Interest rate FRA  should be reported as payer/receiver.
	 *
	 *
	 * Body ISDA
	 * Corpus WorkingGroup PeerReviewGroup ISDA EMIR/CFTC Digital Regulatory Reporting Peer Review "Industry group which works collaboratively to mutualize representation of amended CFTC and EMIR transaction reporting requirements in Digital Regulatory Reporting (DRR) - a digitized, single standard set of open-source machine-executable code using the Common Domain Model (CDM)." 
	 * date "20220307"
	 *
	 * Provision Only Credit TRS should be considered as payer/seller but not modelled yet. CR are reported as buyer/seller
	 *
	 *
	 * Body ISDA
	 * Corpus WorkingGroup PeerReviewGroup ISDA EMIR/CFTC Digital Regulatory Reporting Peer Review "Industry group which works collaboratively to mutualize representation of amended CFTC and EMIR transaction reporting requirements in Digital Regulatory Reporting (DRR) - a digitized, single standard set of open-source machine-executable code using the Common Domain Model (CDM)." 
	 * date "20220307"
	 *
	 * Provision Peer review recommnended to detect private individual party representations (instead of LEI scheme).
	 *
	 */
	String getPayerIdentifierLeg1();
	/**
	 *
	 * Body CFTC
	 * Corpus Regulation Part45 CFTC 17 CFR Parts 45 Version 3.0 "Part 45 of the CFTCs regulations specifies the Commissions swap data recordkeeping and reporting requirements, pursuant to section 2(a)(13)(G) of the Commodity Exchange Act (CEA), which states that all swaps, whether cleared or uncleared, must be reported to a Swap Data Repository (SDR)" 
	 * appendix "1" * dataElement "20" * field "Payer Identifier"
	 *
	 * Provision Identifier of the counterparty of the payer leg as determined at the time of the transaction.
	                 A non-exhaustive list of examples of instruments for which this data element could apply are:
	                 - most swaps and swap-like contracts including interest rate swaps, credit total return swaps, and equity swaps (except for credit default swaps, variance, volatility, and correlation swaps)
	                 - foreign exchange swaps, forwards, non-deliverable forwards.
	                 This data element is not applicable to instrument types covered by data elements Buyer identifier and Seller identifier.
	 *
	 *
	 * Body CFTC
	 * Corpus Regulation Part45_V3_1 CFTC 17 CFR Parts 45 Version 3.1 "Part 45 of the CFTCs regulations specifies the Commissions swap data recordkeeping and reporting requirements, pursuant to section 2(a)(13)(G) of the Commodity Exchange Act (CEA), which states that all swaps, whether cleared or uncleared, must be reported to a Swap Data Repository (SDR).The modifications address 14 data elements for several swap data reporting topics including: clearing, counterparty identification, price, valuation, collateral and margin, and transaction-related data fields." 
	 * appendix "1" * dataElement "20" * field "Payer Identifier" * footnote "29"
	 *
	 * Provision For fixed-floating interest rate swaps, the payer is the counterparty paying the fixed rate
	 *
	 *
	 * Body ISDA
	 * Corpus WorkingGroup PeerReviewGroup ISDA EMIR/CFTC Digital Regulatory Reporting Peer Review "Industry group which works collaboratively to mutualize representation of amended CFTC and EMIR transaction reporting requirements in Digital Regulatory Reporting (DRR) - a digitized, single standard set of open-source machine-executable code using the Common Domain Model (CDM)." 
	 * date "20211123"
	 *
	 * Provision Discussed on US Compliance WG - confirmed as per ISDA best practice for direction provided to CPMI-IOSCO best practice and CFTC tiebreaker logic - Interest rate FRA should be reported as payer/receiver.
	 *
	 *
	 * Body ISDA
	 * Corpus WorkingGroup PeerReviewGroup ISDA EMIR/CFTC Digital Regulatory Reporting Peer Review "Industry group which works collaboratively to mutualize representation of amended CFTC and EMIR transaction reporting requirements in Digital Regulatory Reporting (DRR) - a digitized, single standard set of open-source machine-executable code using the Common Domain Model (CDM)." 
	 * date "20220307"
	 *
	 * Provision Only Credit TRS should be considered as payer/seller but not modelled yet. CR are reported as buyer/seller
	 *
	 *
	 * Body ISDA
	 * Corpus WorkingGroup PeerReviewGroup ISDA EMIR/CFTC Digital Regulatory Reporting Peer Review "Industry group which works collaboratively to mutualize representation of amended CFTC and EMIR transaction reporting requirements in Digital Regulatory Reporting (DRR) - a digitized, single standard set of open-source machine-executable code using the Common Domain Model (CDM)." 
	 * date "20220307"
	 *
	 * Provision Peer review recommnended to detect private individual party representations (instead of LEI scheme).
	 *
	 */
	String getPayerIdentifierLeg2();
	/**
	 *
	 * Body CFTC
	 * Corpus Regulation Part45 CFTC 17 CFR Parts 45 Version 3.0 "Part 45 of the CFTCs regulations specifies the Commissions swap data recordkeeping and reporting requirements, pursuant to section 2(a)(13)(G) of the Commodity Exchange Act (CEA), which states that all swaps, whether cleared or uncleared, must be reported to a Swap Data Repository (SDR)" 
	 * appendix "1" * dataElement "21" * field "Receiver Identifier"
	 *
	 * Provision Identifier of the counterparty of the payer leg as determined at the time of the transaction.
	                 A non-exhaustive list of examples of instruments for which this data element could apply are:
	                 - most swaps and swap-like contracts including interest rate swaps, credit total return swaps, and equity swaps (except for credit default swaps, variance, volatility, and correlation swaps)
	                 - foreign exchange swaps, forwards, non-deliverable forwards.
	                 This data element is not applicable to instrument types covered by data elements Buyer identifier and Seller identifier.
	 *
	 *
	 * Body CFTC
	 * Corpus Regulation Part45_V3_1 CFTC 17 CFR Parts 45 Version 3.1 "Part 45 of the CFTCs regulations specifies the Commissions swap data recordkeeping and reporting requirements, pursuant to section 2(a)(13)(G) of the Commodity Exchange Act (CEA), which states that all swaps, whether cleared or uncleared, must be reported to a Swap Data Repository (SDR).The modifications address 14 data elements for several swap data reporting topics including: clearing, counterparty identification, price, valuation, collateral and margin, and transaction-related data fields." 
	 * appendix "1" * dataElement "21" * field "Receiver Identifier" * footnote "30"
	 *
	 * Provision For fixed-floating interest rate swaps, the receiver is the counterparty receiving the fixed rate
	 *
	 *
	 * Body ISDA
	 * Corpus WorkingGroup PeerReviewGroup ISDA EMIR/CFTC Digital Regulatory Reporting Peer Review "Industry group which works collaboratively to mutualize representation of amended CFTC and EMIR transaction reporting requirements in Digital Regulatory Reporting (DRR) - a digitized, single standard set of open-source machine-executable code using the Common Domain Model (CDM)." 
	 * date "20211123"
	 *
	 * Provision Discussed on US Compliance WG - confirmed as per ISDA best practice for direction provided to CPMI-IOSCO best practice and CFTC tiebreaker logic  - Interest rate FRA  should be reported as payer/receiver.
	 *
	 *
	 * Body ISDA
	 * Corpus WorkingGroup PeerReviewGroup ISDA EMIR/CFTC Digital Regulatory Reporting Peer Review "Industry group which works collaboratively to mutualize representation of amended CFTC and EMIR transaction reporting requirements in Digital Regulatory Reporting (DRR) - a digitized, single standard set of open-source machine-executable code using the Common Domain Model (CDM)." 
	 * date "20220307"
	 *
	 * Provision Only Credit TRS should be considered as payer/seller but not modelled yet. CR are reported as buyer/seller
	 *
	 *
	 * Body ISDA
	 * Corpus WorkingGroup PeerReviewGroup ISDA EMIR/CFTC Digital Regulatory Reporting Peer Review "Industry group which works collaboratively to mutualize representation of amended CFTC and EMIR transaction reporting requirements in Digital Regulatory Reporting (DRR) - a digitized, single standard set of open-source machine-executable code using the Common Domain Model (CDM)." 
	 * date "20220307"
	 *
	 * Provision Peer review recommnended to detect private individual party representations (instead of LEI scheme).
	 *
	 */
	String getReceiverIdentifierLeg1();
	/**
	 *
	 * Body CFTC
	 * Corpus Regulation Part45 CFTC 17 CFR Parts 45 Version 3.0 "Part 45 of the CFTCs regulations specifies the Commissions swap data recordkeeping and reporting requirements, pursuant to section 2(a)(13)(G) of the Commodity Exchange Act (CEA), which states that all swaps, whether cleared or uncleared, must be reported to a Swap Data Repository (SDR)" 
	 * appendix "1" * dataElement "21" * field "Receiver Identifier"
	 *
	 * Provision Identifier of the counterparty of the payer leg as determined at the time of the transaction.
	                 A non-exhaustive list of examples of instruments for which this data element could apply are:
	                 - most swaps and swap-like contracts including interest rate swaps, credit total return swaps, and equity swaps (except for credit default swaps, variance, volatility, and correlation swaps)
	                 - foreign exchange swaps, forwards, non-deliverable forwards.
	                 This data element is not applicable to instrument types covered by data elements Buyer identifier and Seller identifier.
	 *
	 *
	 * Body CFTC
	 * Corpus Regulation Part45_V3_1 CFTC 17 CFR Parts 45 Version 3.1 "Part 45 of the CFTCs regulations specifies the Commissions swap data recordkeeping and reporting requirements, pursuant to section 2(a)(13)(G) of the Commodity Exchange Act (CEA), which states that all swaps, whether cleared or uncleared, must be reported to a Swap Data Repository (SDR).The modifications address 14 data elements for several swap data reporting topics including: clearing, counterparty identification, price, valuation, collateral and margin, and transaction-related data fields." 
	 * appendix "1" * dataElement "21" * field "Receiver Identifier" * footnote "30"
	 *
	 * Provision For fixed-floating interest rate swaps, the receiver is the counterparty receiving the fixed rate
	 *
	 *
	 * Body ISDA
	 * Corpus WorkingGroup PeerReviewGroup ISDA EMIR/CFTC Digital Regulatory Reporting Peer Review "Industry group which works collaboratively to mutualize representation of amended CFTC and EMIR transaction reporting requirements in Digital Regulatory Reporting (DRR) - a digitized, single standard set of open-source machine-executable code using the Common Domain Model (CDM)." 
	 * date "20211123"
	 *
	 * Provision Discussed on US Compliance WG - confirmed as per ISDA best practice for direction provided to CPMI-IOSCO best practice and CFTC tiebreaker logic  - Interest rate FRA  should be reported as payer/receiver.
	 *
	 *
	 * Body ISDA
	 * Corpus WorkingGroup PeerReviewGroup ISDA EMIR/CFTC Digital Regulatory Reporting Peer Review "Industry group which works collaboratively to mutualize representation of amended CFTC and EMIR transaction reporting requirements in Digital Regulatory Reporting (DRR) - a digitized, single standard set of open-source machine-executable code using the Common Domain Model (CDM)." 
	 * date "20220307"
	 *
	 * Provision Only Credit TRS should be considered as payer/seller but not modelled yet. CR are reported as buyer/seller
	 *
	 *
	 * Body ISDA
	 * Corpus WorkingGroup PeerReviewGroup ISDA EMIR/CFTC Digital Regulatory Reporting Peer Review "Industry group which works collaboratively to mutualize representation of amended CFTC and EMIR transaction reporting requirements in Digital Regulatory Reporting (DRR) - a digitized, single standard set of open-source machine-executable code using the Common Domain Model (CDM)." 
	 * date "20220307"
	 *
	 * Provision Peer review recommnended to detect private individual party representations (instead of LEI scheme).
	 *
	 */
	String getReceiverIdentifierLeg2();
	/**
	 *
	 * Body CFTC
	 * Corpus Regulation Part45 CFTC 17 CFR Parts 45 Version 3.0 "Part 45 of the CFTCs regulations specifies the Commissions swap data recordkeeping and reporting requirements, pursuant to section 2(a)(13)(G) of the Commodity Exchange Act (CEA), which states that all swaps, whether cleared or uncleared, must be reported to a Swap Data Repository (SDR)" 
	 * appendix "1" * dataElement "23" * field "Counterparty 2 Federal Entity Indicator"
	 *
	 * Provision Indicator of whether Counterparty 1 is: (1) One of the following entities: a) An entity established pursuant to federal law, including, but not limited to, the following:  i. An agency as defined in 5 U.S.C.  551(1), a federal instrumentality, or a federal authority;  ii. A government corporation (examples: as such term is defined in 5 U.S.C.  103(1) or in 31 U.S.C.  9101);  iii. A government-sponsored enterprise (example: as such term is defined in 2 U.S.C.  622(8)); iv. A federally funded research and development center on the master list referenced in 48 CFR 35.017-6; and v. An executive department listed in 5 U.S.C.  101; or b) An entity chartered pursuant to federal law after formation (example: an organization listed in title 36 of the U.S. Code); or (2)  An entity that was established by, or at the direction of, one or more of the entities listed in dataElement (1), or has an ultimate parent listed in its LEI reference data that is an entity listed in dataElement (1) or in the first part of this dataElement (2). Notwithstanding the foregoing, the Counterparty 1 federal entity indicator data element does not include federally chartered depository institutions.
	 *
	 */
	Boolean getCounterparty1FederalEntityIndicator();
	/**
	 *
	 * Body CFTC
	 * Corpus Regulation Part45 CFTC 17 CFR Parts 45 Version 3.0 "Part 45 of the CFTCs regulations specifies the Commissions swap data recordkeeping and reporting requirements, pursuant to section 2(a)(13)(G) of the Commodity Exchange Act (CEA), which states that all swaps, whether cleared or uncleared, must be reported to a Swap Data Repository (SDR)" 
	 * appendix "1" * dataElement "24" * field "Counterparty 2 Federal Entity Indicator"
	 *
	 * Provision Indicator of whether Counterparty 2 is: (1) One of the following entities: a) An entity established pursuant to federal law, including, but not limited to, the following:  i. An agency as defined in 5 U.S.C.  551(1), a federal instrumentality, or a federal authority;  ii. A government corporation (examples: as such term is defined in 5 U.S.C.  103(1) or in 31 U.S.C.  9101);  iii. A government-sponsored enterprise (example: as such term is defined in 2 U.S.C.  622(8)); iv. A federally funded research and development center on the master list referenced in 48 CFR 35.017-6; and v. An executive department listed in 5 U.S.C.  101; or b) An entity chartered pursuant to federal law after formation (example: an organization listed in title 36 of the U.S. Code); or (2)  An entity that was established by, or at the direction of, one or more of the entities listed in dataElement (1), or has an ultimate parent listed in its LEI reference data that is an entity listed in dataElement (1) or in the first part of this dataElement (2). Notwithstanding the foregoing, the Counterparty 2 federal entity indicator data element does not include federally chartered depository institutions.
	 *
	 */
	Boolean getCounterparty2FederalEntityIndicator();
	/**
	 *
	 * Body CFTC
	 * Corpus Regulation Part45 CFTC 17 CFR Parts 45 Version 3.0 "Part 45 of the CFTCs regulations specifies the Commissions swap data recordkeeping and reporting requirements, pursuant to section 2(a)(13)(G) of the Commodity Exchange Act (CEA), which states that all swaps, whether cleared or uncleared, must be reported to a Swap Data Repository (SDR)" 
	 * appendix "1" * dataElement "91" * field "Allocation Indicator"
	 *
	 * Provision Indicator of whether the swap transaction is intended to be allocated, will not be allocated, or is a post allocation transaction.
	 *
	 */
	AllocationIndicatorEnum getAllocationIndicator();
	/**
	 *
	 * Body CFTC
	 * Corpus Regulation Part45 CFTC 17 CFR Parts 45 Version 3.0 "Part 45 of the CFTCs regulations specifies the Commissions swap data recordkeeping and reporting requirements, pursuant to section 2(a)(13)(G) of the Commodity Exchange Act (CEA), which states that all swaps, whether cleared or uncleared, must be reported to a Swap Data Repository (SDR)" 
	 * appendix "1" * dataElement "100" * field "Prior USI"
	 *
	 * Provision Unique swap identifier (USI) assigned to the predecessor transaction that has given rise to the reported transaction due to a lifecycle event, in a one-to-one relation between transactions (e.g., in the case of a novation, when a transaction is terminated, and a new transaction is generated) or in a one-to-many relation between transactions (e.g., in clearing or if a transaction is split into several different transactions), This data element is not applicable when reporting many-to-one and many-to-many relations between transactions (e.g., in the case of a compression).
	 *
	 */
	String getPriorUSI();
	/**
	 *
	 * Body CFTC
	 * Corpus Regulation Part45 CFTC 17 CFR Parts 45 Version 3.0 "Part 45 of the CFTCs regulations specifies the Commissions swap data recordkeeping and reporting requirements, pursuant to section 2(a)(13)(G) of the Commodity Exchange Act (CEA), which states that all swaps, whether cleared or uncleared, must be reported to a Swap Data Repository (SDR)" 
	 * appendix "1" * dataElement "104" * field "Jurisdiction Indicator"
	 *
	 * Provision The jurisdiction(s) that is requiring the reporting of the swap transaction.
	 *
	 */
	JurisdictionEnum getJurisdiction();
	/**
	 *
	 * Body CFTC
	 * Corpus Regulation Part45 CFTC 17 CFR Parts 45 Version 3.0 "Part 45 of the CFTCs regulations specifies the Commissions swap data recordkeeping and reporting requirements, pursuant to section 2(a)(13)(G) of the Commodity Exchange Act (CEA), which states that all swaps, whether cleared or uncleared, must be reported to a Swap Data Repository (SDR)" 
	 * appendix "1" * dataElement "105" * field "New SDR Identifier"
	 *
	 * Provision Identifier of the new swap data repository where the swap transaction is transferred to.
	 *
	 *
	 * Body ISDA
	 * Corpus WorkingGroup USComplianceGroup US Compliance Working Group "This is an ISDA US Working Group." 
	 * date "20220802"
	 *
	 * Provision Not returning anything until it gets modelled
	 *
	 */
	String getNewSDRIdentifier();
	/**
	 *
	 * Body CFTC
	 * Corpus Regulation Part45 CFTC 17 CFR Parts 45 Version 3.0 "Part 45 of the CFTCs regulations specifies the Commissions swap data recordkeeping and reporting requirements, pursuant to section 2(a)(13)(G) of the Commodity Exchange Act (CEA), which states that all swaps, whether cleared or uncleared, must be reported to a Swap Data Repository (SDR)" 
	 * appendix "1" * dataElement "116" * field "Initial Margin Collateral Portfolio Code"
	 *
	 * Provision If collateral is reported on a portfolio basis, a unique code assigned by the reporting counterparty to the portfolio that tracks the aggregate initial margin of a set of open swap transactions. This data element is not applicable if the collateralisation was performed on a transaction level basis, or if there is no collateral agreement, or if no collateral is posted or received. The portfolio code is required for both collateral reporting and valuation reporting in order to link the 2 data sets.
	 *
	 *
	 * Body CFTC
	 * Corpus Regulation Part45_V3_1 CFTC 17 CFR Parts 45 Version 3.1 "Part 45 of the CFTCs regulations specifies the Commissions swap data recordkeeping and reporting requirements, pursuant to section 2(a)(13)(G) of the Commodity Exchange Act (CEA), which states that all swaps, whether cleared or uncleared, must be reported to a Swap Data Repository (SDR).The modifications address 14 data elements for several swap data reporting topics including: clearing, counterparty identification, price, valuation, collateral and margin, and transaction-related data fields." 
	 * appendix "1" * dataElement "116" * field "Initial Margin Collateral Portfolio Code" * footnote "81"
	 *
	 * Provision If collateralization was performed on a transaction level basis, 'TRANSACTION-LEVEL' is accepted.
	 *
	 *
	 * Body CFTC
	 * Corpus Regulation Part45_V3_1 CFTC 17 CFR Parts 45 Version 3.1 "Part 45 of the CFTCs regulations specifies the Commissions swap data recordkeeping and reporting requirements, pursuant to section 2(a)(13)(G) of the Commodity Exchange Act (CEA), which states that all swaps, whether cleared or uncleared, must be reported to a Swap Data Repository (SDR).The modifications address 14 data elements for several swap data reporting topics including: clearing, counterparty identification, price, valuation, collateral and margin, and transaction-related data fields." 
	 * appendix "1" * dataElement "116" * field "Initial Margin Collateral Portfolio Code" * footnote "82"
	 *
	 * Provision  The M in the Part 43/45 Asset Class column is for collateral and valuation reporting only.
	 *
	 *
	 * Body ISDA
	 * Corpus WorkingGroup USComplianceGroup US Compliance Working Group "This is an ISDA US Working Group." 
	 * date "20220802"
	 *
	 * Provision Not returning anything until it gets modelled
	 *
	 */
	String getInitialMarginCollateralPortfolioCode();
	/**
	 *
	 * Body CFTC
	 * Corpus Regulation Part45 CFTC 17 CFR Parts 45 Version 3.0 "Part 45 of the CFTCs regulations specifies the Commissions swap data recordkeeping and reporting requirements, pursuant to section 2(a)(13)(G) of the Commodity Exchange Act (CEA), which states that all swaps, whether cleared or uncleared, must be reported to a Swap Data Repository (SDR)" 
	 * appendix "1" * dataElement "124" * field "Variation Margin Collateral Portfolio Code"
	 *
	 * Provision If collateral is reported on a portfolio basis, a unique code assigned by the reporting counterparty to the portfolio that tracks the aggregate variation margin related to a set of open swap transactions. This data element is not applicable if the collateralisation was performed on a transaction level basis, or if there is no collateral agreement, or if no collateral is posted or received. The portfolio code is required for both collateral reporting and valuation reporting in order to link the 2 data sets.
	 *
	 *
	 * Body CFTC
	 * Corpus Regulation Part45_V3_1 CFTC 17 CFR Parts 45 Version 3.1 "Part 45 of the CFTCs regulations specifies the Commissions swap data recordkeeping and reporting requirements, pursuant to section 2(a)(13)(G) of the Commodity Exchange Act (CEA), which states that all swaps, whether cleared or uncleared, must be reported to a Swap Data Repository (SDR).The modifications address 14 data elements for several swap data reporting topics including: clearing, counterparty identification, price, valuation, collateral and margin, and transaction-related data fields." 
	 * appendix "1" * dataElement "124" * field "Variation Margin Collateral Portfolio Code" * footnote "85"
	 *
	 * Provision If collateralization was performed on a transaction level basis, 'TRANSACTION-LEVEL' is accepted.
	 *
	 *
	 * Body CFTC
	 * Corpus Regulation Part45_V3_1 CFTC 17 CFR Parts 45 Version 3.1 "Part 45 of the CFTCs regulations specifies the Commissions swap data recordkeeping and reporting requirements, pursuant to section 2(a)(13)(G) of the Commodity Exchange Act (CEA), which states that all swaps, whether cleared or uncleared, must be reported to a Swap Data Repository (SDR).The modifications address 14 data elements for several swap data reporting topics including: clearing, counterparty identification, price, valuation, collateral and margin, and transaction-related data fields." 
	 * appendix "1" * dataElement "124" * field "Variation Margin Collateral Portfolio Code" * footnote "86"
	 *
	 * Provision The 'M' in the 'Part 43/45 Asset Class' column is for collateral and valuation reporting only.
	 *
	 *
	 * Body ISDA
	 * Corpus WorkingGroup USComplianceGroup US Compliance Working Group "This is an ISDA US Working Group." 
	 * date "20220802"
	 *
	 * Provision Not returning anything until it gets modelled
	 *
	 */
	String getVariationMarginCollateralPortfolioCode();

	/*********************** Build Methods  ***********************/
	CFTCPart45TransactionReport build();
	
	CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder toBuilder();
	
	static CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder builder() {
		return new CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends CFTCPart45TransactionReport> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends CFTCPart45TransactionReport> getType() {
		return CFTCPart45TransactionReport.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("actionType"), ActionTypeEnum.class, getActionType(), this);
		processor.processBasic(path.newSubPath("eventType"), EventTypeEnum.class, getEventType(), this);
		processor.processBasic(path.newSubPath("eventIdentifier"), String.class, getEventIdentifier(), this);
		processor.processBasic(path.newSubPath("effectiveDate"), Date.class, getEffectiveDate(), this);
		processor.processBasic(path.newSubPath("earlyTerminationDate"), Date.class, getEarlyTerminationDate(), this);
		processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, getEventTimestamp(), this);
		processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, getReportingTimestamp(), this);
		processor.processBasic(path.newSubPath("executionTimestamp"), ZonedDateTime.class, getExecutionTimestamp(), this);
		processor.processBasic(path.newSubPath("expirationDate"), Date.class, getExpirationDate(), this);
		processor.processBasic(path.newSubPath("counterparty1"), String.class, getCounterparty1(), this);
		processor.processBasic(path.newSubPath("counterparty2"), String.class, getCounterparty2(), this);
		processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, getCounterparty2IdentifierType(), this);
		processor.processBasic(path.newSubPath("beneficiary1"), String.class, getBeneficiary1(), this);
		processor.processBasic(path.newSubPath("beneficiary1IdentifierTypeIndicator"), Boolean.class, getBeneficiary1IdentifierTypeIndicator(), this);
		processor.processBasic(path.newSubPath("cleared"), ClearedEnum.class, getCleared(), this);
		processor.processBasic(path.newSubPath("centralCounterparty"), String.class, getCentralCounterparty(), this);
		processor.processBasic(path.newSubPath("clearingMember"), String.class, getClearingMember(), this);
		processor.processBasic(path.newSubPath("confirmed"), ConfirmationEnum.class, getConfirmed(), this);
		processor.processBasic(path.newSubPath("callAmount"), BigDecimal.class, getCallAmount(), this);
		processor.processBasic(path.newSubPath("putAmount"), BigDecimal.class, getPutAmount(), this);
		processor.processBasic(path.newSubPath("callCurrency"), ISOCurrencyCodeEnum.class, getCallCurrency(), this);
		processor.processBasic(path.newSubPath("putCurrency"), ISOCurrencyCodeEnum.class, getPutCurrency(), this);
		processRosetta(path.newSubPath("priceSchedule"), processor, PricePeriod.class, getPriceSchedule());
		processRosetta(path.newSubPath("strikePriceSchedule"), processor, PricePeriod.class, getStrikePriceSchedule());
		processRosetta(path.newSubPath("price"), processor, PriceFormat.class, getPrice());
		processor.processBasic(path.newSubPath("priceNotation"), PriceNotationEnum.class, getPriceNotation(), this);
		processor.processBasic(path.newSubPath("priceCurrency"), ISOCurrencyCodeEnum.class, getPriceCurrency(), this);
		processRosetta(path.newSubPath("packageTransactionPrice"), processor, PriceFormat.class, getPackageTransactionPrice());
		processor.processBasic(path.newSubPath("packageTransactionPriceNotation"), PriceNotationEnum.class, getPackageTransactionPriceNotation(), this);
		processor.processBasic(path.newSubPath("packageTransactionPriceCurrency"), ISOCurrencyCodeEnum.class, getPackageTransactionPriceCurrency(), this);
		processRosetta(path.newSubPath("packageTransactionSpread"), processor, PriceFormat.class, getPackageTransactionSpread());
		processor.processBasic(path.newSubPath("packageTransactionSpreadNotation"), PriceNotationEnum.class, getPackageTransactionSpreadNotation(), this);
		processor.processBasic(path.newSubPath("packageTransactionSpreadCurrency"), ISOCurrencyCodeEnum.class, getPackageTransactionSpreadCurrency(), this);
		processRosetta(path.newSubPath("strikePrice"), processor, PriceFormat.class, getStrikePrice());
		processor.processBasic(path.newSubPath("strikePriceNotation"), PriceNotationEnum.class, getStrikePriceNotation(), this);
		processor.processBasic(path.newSubPath("strikePriceCurrency"), String.class, getStrikePriceCurrency(), this);
		processor.processBasic(path.newSubPath("priceUnitOfMeasure"), String.class, getPriceUnitOfMeasure(), this);
		processor.processBasic(path.newSubPath("optionPremiumAmount"), BigDecimal.class, getOptionPremiumAmount(), this);
		processor.processBasic(path.newSubPath("optionPremiumCurrency"), ISOCurrencyCodeEnum.class, getOptionPremiumCurrency(), this);
		processor.processBasic(path.newSubPath("optionPremiumPaymentDate"), Date.class, getOptionPremiumPaymentDate(), this);
		processor.processBasic(path.newSubPath("cdSIndexAttachmentPoint"), BigDecimal.class, getCdSIndexAttachmentPoint(), this);
		processor.processBasic(path.newSubPath("cdSIndexDetachmentPoint"), BigDecimal.class, getCdSIndexDetachmentPoint(), this);
		processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, getCollateralPortfolioIndicator(), this);
		processor.processBasic(path.newSubPath("firstExerciseDate"), Date.class, getFirstExerciseDate(), this);
		processor.processBasic(path.newSubPath("finalContractualSettlementDate"), Date.class, getFinalContractualSettlementDate(), this);
		processRosetta(path.newSubPath("otherPayment"), processor, OtherPayment.class, getOtherPayment());
		processRosetta(path.newSubPath("leg1"), processor, CommonLeg.class, getLeg1());
		processRosetta(path.newSubPath("leg2"), processor, CommonLeg.class, getLeg2());
		processor.processBasic(path.newSubPath("counterparty2Name"), String.class, getCounterparty2Name(), this);
		processor.processBasic(path.newSubPath("executionAgentCounterparty1"), String.class, getExecutionAgentCounterparty1(), this);
		processor.processBasic(path.newSubPath("executionAgentCounterparty2DTCC"), String.class, getExecutionAgentCounterparty2DTCC(), this);
		processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, getReportSubmittingEntityID(), this);
		processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, getUniqueTransactionIdentifier(), this);
		processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, getUniqueTransactionIdentifierProprietary(), this);
		processor.processBasic(path.newSubPath("priorUTI"), String.class, getPriorUTI(), this);
		processor.processBasic(path.newSubPath("priorUTIProprietary"), String.class, getPriorUTIProprietary(), this);
		processor.processBasic(path.newSubPath("uniqueProductIdentifier"), String.class, getUniqueProductIdentifier(), this);
		processor.processBasic(path.newSubPath("contractType"), CommonContractType.class, getContractType(), this);
		processor.processBasic(path.newSubPath("assetClass"), CommonAssetClass.class, getAssetClass(), this);
		processor.processBasic(path.newSubPath("clearingTimestamp"), ZonedDateTime.class, getClearingTimestamp(), this);
		processor.processBasic(path.newSubPath("platformIdentifier"), String.class, getPlatformIdentifier(), this);
		processor.processBasic(path.newSubPath("direction1"), Direction1Enum.class, getDirection1(), this);
		processor.processBasic(path.newSubPath("direction2Leg1"), Direction2Enum.class, getDirection2Leg1(), this);
		processor.processBasic(path.newSubPath("direction2Leg2"), Direction2Enum.class, getDirection2Leg2(), this);
		processor.processBasic(path.newSubPath("packageIdentifier"), String.class, getPackageIdentifier(), this);
		processRosetta(path.newSubPath("barrier"), processor, SingleOrUpperAndLowerBarrier.class, getBarrier());
		processor.processBasic(path.newSubPath("exchangeRate"), BigDecimal.class, getExchangeRate(), this);
		processor.processBasic(path.newSubPath("exchangeRateBasis"), String.class, getExchangeRateBasis(), this);
		processor.processBasic(path.newSubPath("nameOfTheUnderlyingIndex"), String.class, getNameOfTheUnderlyingIndex(), this);
		processRosetta(path.newSubPath("basketConstituents"), processor, BasketConstituentsReport.class, getBasketConstituents());
		processRosetta(path.newSubPath("underlying"), processor, UnderlyingIdentifier.class, getUnderlying());
		processor.processBasic(path.newSubPath("quantityUnitOfMeasureLeg1"), String.class, getQuantityUnitOfMeasureLeg1(), this);
		processor.processBasic(path.newSubPath("quantityUnitOfMeasureLeg2"), String.class, getQuantityUnitOfMeasureLeg2(), this);
		processor.processBasic(path.newSubPath("maturityDateOfTheUnderlying"), Date.class, getMaturityDateOfTheUnderlying(), this);
		processor.processBasic(path.newSubPath("optionType"), OptionTypeCode.class, getOptionType(), this);
		processor.processBasic(path.newSubPath("optionStyle"), OptionStyleEnum.class, getOptionStyle(), this);
		processor.processBasic(path.newSubPath("deliveryType"), DeliveryTypeEnum.class, getDeliveryType(), this);
		processor.processBasic(path.newSubPath("countryOfTheCounterparty2"), ISOCountryCodeEnum.class, getCountryOfTheCounterparty2(), this);
		processor.processBasic(path.newSubPath("bookingLocation"), ISOCountryCodeEnum.class, getBookingLocation(), this);
		processor.processBasic(path.newSubPath("traderLocation"), ISOCountryCodeEnum.class, getTraderLocation(), this);
		processor.processBasic(path.newSubPath("tradingCapacity"), TradingCapacity7Code.class, getTradingCapacity(), this);
		processor.processBasic(path.newSubPath("embeddedOptionType"), EmbeddedOptionTypeEnum.class, getEmbeddedOptionType(), this);
		processor.processBasic(path.newSubPath("seniority"), SeniorityEnum.class, getSeniority(), this);
		processor.processBasic(path.newSubPath("series"), Integer.class, getSeries(), this);
		processor.processBasic(path.newSubPath("indexFactor"), BigDecimal.class, getIndexFactor(), this);
		processor.processBasic(path.newSubPath("technicalRecordId"), String.class, getTechnicalRecordId(), this);
		processor.processBasic(path.newSubPath("counterparty2IdentifierSource"), Counterparty2IdentifierEnum.class, getCounterparty2IdentifierSource(), this);
		processor.processBasic(path.newSubPath("customBasketIndicator"), Boolean.class, getCustomBasketIndicator(), this);
		processor.processBasic(path.newSubPath("amendmentIndicator"), Boolean.class, getAmendmentIndicator(), this);
		processor.processBasic(path.newSubPath("packageIndicator"), Boolean.class, getPackageIndicator(), this);
		processor.processBasic(path.newSubPath("postPricedSwapIndicator"), Boolean.class, getPostPricedSwapIndicator(), this);
		processor.processBasic(path.newSubPath("settlementLocationLeg1"), ISOCountryCodeEnum.class, getSettlementLocationLeg1(), this);
		processor.processBasic(path.newSubPath("settlementLocationLeg2"), ISOCountryCodeEnum.class, getSettlementLocationLeg2(), this);
		processor.processBasic(path.newSubPath("nonStandardizedTermIndicator"), Boolean.class, getNonStandardizedTermIndicator(), this);
		processor.processBasic(path.newSubPath("blockTradeElectionIndicator"), Boolean.class, getBlockTradeElectionIndicator(), this);
		processor.processBasic(path.newSubPath("primeBrokerageTransactionIndicator"), Boolean.class, getPrimeBrokerageTransactionIndicator(), this);
		processor.processBasic(path.newSubPath("uniqueSwapIdentifier"), String.class, getUniqueSwapIdentifier(), this);
		processRosetta(path.newSubPath("cftcGuidebook"), processor, CFTCGuidebook.class, getCftcGuidebook());
		processRosetta(path.newSubPath("nonReportable"), processor, CFTCNonReportablePart45.class, getNonReportable());
		processor.processBasic(path.newSubPath("clearingAccountOrigin"), ClearingAccountOriginEnum.class, getClearingAccountOrigin(), this);
		processor.processBasic(path.newSubPath("clearingSwapUSIs"), String.class, getClearingSwapUSIs(), this);
		processor.processBasic(path.newSubPath("clearingSwapUTIs"), String.class, getClearingSwapUTIs(), this);
		processor.processBasic(path.newSubPath("originalSwapUSI"), String.class, getOriginalSwapUSI(), this);
		processor.processBasic(path.newSubPath("originalSwapUTI"), String.class, getOriginalSwapUTI(), this);
		processor.processBasic(path.newSubPath("originalSwapSDRIdentifier"), String.class, getOriginalSwapSDRIdentifier(), this);
		processor.processBasic(path.newSubPath("clearingReceiptTimestamp"), ZonedDateTime.class, getClearingReceiptTimestamp(), this);
		processor.processBasic(path.newSubPath("clearingExceptionsAndExemptionsCounterparty1"), ClearingExceptionsAndExemptionsEnum.class, getClearingExceptionsAndExemptionsCounterparty1(), this);
		processor.processBasic(path.newSubPath("clearingExceptionsAndExemptionsCounterparty2"), ClearingExceptionsAndExemptionsEnum.class, getClearingExceptionsAndExemptionsCounterparty2(), this);
		processor.processBasic(path.newSubPath("counterparty1FinancialEntityIndicator"), Boolean.class, getCounterparty1FinancialEntityIndicator(), this);
		processor.processBasic(path.newSubPath("counterparty2FinancialEntityIndicator"), Boolean.class, getCounterparty2FinancialEntityIndicator(), this);
		processor.processBasic(path.newSubPath("buyerIdentifier"), String.class, getBuyerIdentifier(), this);
		processor.processBasic(path.newSubPath("sellerIdentifier"), String.class, getSellerIdentifier(), this);
		processor.processBasic(path.newSubPath("payerIdentifierLeg1"), String.class, getPayerIdentifierLeg1(), this);
		processor.processBasic(path.newSubPath("payerIdentifierLeg2"), String.class, getPayerIdentifierLeg2(), this);
		processor.processBasic(path.newSubPath("receiverIdentifierLeg1"), String.class, getReceiverIdentifierLeg1(), this);
		processor.processBasic(path.newSubPath("receiverIdentifierLeg2"), String.class, getReceiverIdentifierLeg2(), this);
		processor.processBasic(path.newSubPath("counterparty1FederalEntityIndicator"), Boolean.class, getCounterparty1FederalEntityIndicator(), this);
		processor.processBasic(path.newSubPath("counterparty2FederalEntityIndicator"), Boolean.class, getCounterparty2FederalEntityIndicator(), this);
		processor.processBasic(path.newSubPath("allocationIndicator"), AllocationIndicatorEnum.class, getAllocationIndicator(), this);
		processor.processBasic(path.newSubPath("priorUSI"), String.class, getPriorUSI(), this);
		processor.processBasic(path.newSubPath("jurisdiction"), JurisdictionEnum.class, getJurisdiction(), this);
		processor.processBasic(path.newSubPath("newSDRIdentifier"), String.class, getNewSDRIdentifier(), this);
		processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, getInitialMarginCollateralPortfolioCode(), this);
		processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, getVariationMarginCollateralPortfolioCode(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface CFTCPart45TransactionReportBuilder extends CFTCPart45TransactionReport, CFTCTransactionReport.CFTCTransactionReportBuilder {
		CFTCNonReportablePart45.CFTCNonReportablePart45Builder getOrCreateNonReportable();
		@Override
		CFTCNonReportablePart45.CFTCNonReportablePart45Builder getNonReportable();
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setActionType(ActionTypeEnum actionType);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setEventType(EventTypeEnum eventType);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setEventIdentifier(String eventIdentifier);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setEffectiveDate(Date effectiveDate);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setEarlyTerminationDate(Date earlyTerminationDate);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setEventTimestamp(ZonedDateTime eventTimestamp);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setReportingTimestamp(ZonedDateTime reportingTimestamp);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setExecutionTimestamp(ZonedDateTime executionTimestamp);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setExpirationDate(Date expirationDate);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCounterparty1(String counterparty1);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCounterparty2(String counterparty2);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCounterparty2IdentifierType(Boolean counterparty2IdentifierType);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setBeneficiary1(String beneficiary1);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setBeneficiary1IdentifierTypeIndicator(Boolean beneficiary1IdentifierTypeIndicator);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCleared(ClearedEnum cleared);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCentralCounterparty(String centralCounterparty);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setClearingMember(String clearingMember);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setConfirmed(ConfirmationEnum confirmed);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCallAmount(BigDecimal callAmount);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPutAmount(BigDecimal putAmount);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCallCurrency(ISOCurrencyCodeEnum callCurrency);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPutCurrency(ISOCurrencyCodeEnum putCurrency);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addPriceSchedule(PricePeriod priceSchedule);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addPriceSchedule(PricePeriod priceSchedule, int _idx);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addPriceSchedule(List<? extends PricePeriod> priceSchedule);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPriceSchedule(List<? extends PricePeriod> priceSchedule);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addStrikePriceSchedule(PricePeriod strikePriceSchedule);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addStrikePriceSchedule(PricePeriod strikePriceSchedule, int _idx);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addStrikePriceSchedule(List<? extends PricePeriod> strikePriceSchedule);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setStrikePriceSchedule(List<? extends PricePeriod> strikePriceSchedule);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPrice(PriceFormat price);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPriceNotation(PriceNotationEnum priceNotation);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPriceCurrency(ISOCurrencyCodeEnum priceCurrency);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPackageTransactionPrice(PriceFormat packageTransactionPrice);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPackageTransactionPriceNotation(PriceNotationEnum packageTransactionPriceNotation);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPackageTransactionPriceCurrency(ISOCurrencyCodeEnum packageTransactionPriceCurrency);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPackageTransactionSpread(PriceFormat packageTransactionSpread);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPackageTransactionSpreadNotation(PriceNotationEnum packageTransactionSpreadNotation);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPackageTransactionSpreadCurrency(ISOCurrencyCodeEnum packageTransactionSpreadCurrency);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setStrikePrice(PriceFormat strikePrice);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setStrikePriceNotation(PriceNotationEnum strikePriceNotation);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setStrikePriceCurrency(String strikePriceCurrency);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPriceUnitOfMeasure(String priceUnitOfMeasure);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setOptionPremiumAmount(BigDecimal optionPremiumAmount);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setOptionPremiumCurrency(ISOCurrencyCodeEnum optionPremiumCurrency);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setOptionPremiumPaymentDate(Date optionPremiumPaymentDate);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCdSIndexAttachmentPoint(BigDecimal cdSIndexAttachmentPoint);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCdSIndexDetachmentPoint(BigDecimal cdSIndexDetachmentPoint);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCollateralPortfolioIndicator(Boolean collateralPortfolioIndicator);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setFirstExerciseDate(Date firstExerciseDate);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setFinalContractualSettlementDate(Date finalContractualSettlementDate);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addOtherPayment(OtherPayment otherPayment);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addOtherPayment(OtherPayment otherPayment, int _idx);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addOtherPayment(List<? extends OtherPayment> otherPayment);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setOtherPayment(List<? extends OtherPayment> otherPayment);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setLeg1(Leg leg1);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setLeg2(Leg leg2);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setLeg1(CommonLeg leg1);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setLeg2(CommonLeg leg2);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCounterparty2Name(String counterparty2Name);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setExecutionAgentCounterparty1(String executionAgentCounterparty1);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setExecutionAgentCounterparty2DTCC(String executionAgentCounterparty2DTCC);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setReportSubmittingEntityID(String reportSubmittingEntityID);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setUniqueTransactionIdentifier(String uniqueTransactionIdentifier);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setUniqueTransactionIdentifierProprietary(String uniqueTransactionIdentifierProprietary);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPriorUTI(String priorUTI);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPriorUTIProprietary(String priorUTIProprietary);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setUniqueProductIdentifier(String uniqueProductIdentifier);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setContractType(CommonContractType contractType);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setAssetClass(CommonAssetClass assetClass);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setClearingTimestamp(ZonedDateTime clearingTimestamp);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPlatformIdentifier(String platformIdentifier);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setDirection1(Direction1Enum direction1);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setDirection2Leg1(Direction2Enum direction2Leg1);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setDirection2Leg2(Direction2Enum direction2Leg2);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPackageIdentifier(String packageIdentifier);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setBarrier(SingleOrUpperAndLowerBarrier barrier);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setExchangeRate(BigDecimal exchangeRate);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setExchangeRateBasis(String exchangeRateBasis);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setNameOfTheUnderlyingIndex(String nameOfTheUnderlyingIndex);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addBasketConstituents(BasketConstituentsReport basketConstituents);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addBasketConstituents(BasketConstituentsReport basketConstituents, int _idx);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addBasketConstituents(List<? extends BasketConstituentsReport> basketConstituents);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setBasketConstituents(List<? extends BasketConstituentsReport> basketConstituents);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setUnderlying(UnderlyingIdentifier underlying);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setQuantityUnitOfMeasureLeg1(String quantityUnitOfMeasureLeg1);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setQuantityUnitOfMeasureLeg2(String quantityUnitOfMeasureLeg2);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setMaturityDateOfTheUnderlying(Date maturityDateOfTheUnderlying);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setOptionType(OptionTypeCode optionType);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setOptionStyle(OptionStyleEnum optionStyle);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setDeliveryType(DeliveryTypeEnum deliveryType);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCountryOfTheCounterparty2(ISOCountryCodeEnum countryOfTheCounterparty2);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setBookingLocation(ISOCountryCodeEnum bookingLocation);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setTraderLocation(ISOCountryCodeEnum traderLocation);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setTradingCapacity(TradingCapacity7Code tradingCapacity);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setEmbeddedOptionType(EmbeddedOptionTypeEnum embeddedOptionType);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setSeniority(SeniorityEnum seniority);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setSeries(Integer series);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setIndexFactor(BigDecimal indexFactor);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setTechnicalRecordId(String technicalRecordId);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCounterparty2IdentifierSource(Counterparty2IdentifierEnum counterparty2IdentifierSource);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCustomBasketIndicator(Boolean customBasketIndicator);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setAmendmentIndicator(Boolean amendmentIndicator);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPackageIndicator(Boolean packageIndicator);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPostPricedSwapIndicator(Boolean postPricedSwapIndicator);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setSettlementLocationLeg1(ISOCountryCodeEnum settlementLocationLeg1);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setSettlementLocationLeg2(ISOCountryCodeEnum settlementLocationLeg2);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setNonStandardizedTermIndicator(Boolean nonStandardizedTermIndicator);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setBlockTradeElectionIndicator(Boolean blockTradeElectionIndicator);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPrimeBrokerageTransactionIndicator(Boolean primeBrokerageTransactionIndicator);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setUniqueSwapIdentifier(String uniqueSwapIdentifier);
		@Override
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCftcGuidebook(CFTCGuidebook cftcGuidebook);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setNonReportable(CFTCNonReportablePart45 nonReportable);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setClearingAccountOrigin(ClearingAccountOriginEnum clearingAccountOrigin);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addClearingSwapUSIs(String clearingSwapUSIs);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addClearingSwapUSIs(String clearingSwapUSIs, int _idx);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addClearingSwapUSIs(List<String> clearingSwapUSIs);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setClearingSwapUSIs(List<String> clearingSwapUSIs);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addClearingSwapUTIs(String clearingSwapUTIs);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addClearingSwapUTIs(String clearingSwapUTIs, int _idx);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addClearingSwapUTIs(List<String> clearingSwapUTIs);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setClearingSwapUTIs(List<String> clearingSwapUTIs);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setOriginalSwapUSI(String originalSwapUSI);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setOriginalSwapUTI(String originalSwapUTI);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setOriginalSwapSDRIdentifier(String originalSwapSDRIdentifier);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setClearingReceiptTimestamp(ZonedDateTime clearingReceiptTimestamp);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(ClearingExceptionsAndExemptionsEnum clearingExceptionsAndExemptionsCounterparty1);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(ClearingExceptionsAndExemptionsEnum clearingExceptionsAndExemptionsCounterparty1, int _idx);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty1);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setClearingExceptionsAndExemptionsCounterparty1(List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty1);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(ClearingExceptionsAndExemptionsEnum clearingExceptionsAndExemptionsCounterparty2);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(ClearingExceptionsAndExemptionsEnum clearingExceptionsAndExemptionsCounterparty2, int _idx);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty2);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setClearingExceptionsAndExemptionsCounterparty2(List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty2);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCounterparty1FinancialEntityIndicator(Boolean counterparty1FinancialEntityIndicator);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCounterparty2FinancialEntityIndicator(Boolean counterparty2FinancialEntityIndicator);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setBuyerIdentifier(String buyerIdentifier);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setSellerIdentifier(String sellerIdentifier);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPayerIdentifierLeg1(String payerIdentifierLeg1);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPayerIdentifierLeg2(String payerIdentifierLeg2);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setReceiverIdentifierLeg1(String receiverIdentifierLeg1);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setReceiverIdentifierLeg2(String receiverIdentifierLeg2);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCounterparty1FederalEntityIndicator(Boolean counterparty1FederalEntityIndicator);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCounterparty2FederalEntityIndicator(Boolean counterparty2FederalEntityIndicator);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setAllocationIndicator(AllocationIndicatorEnum allocationIndicator);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPriorUSI(String priorUSI);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setJurisdiction(JurisdictionEnum jurisdiction);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setNewSDRIdentifier(String newSDRIdentifier);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setInitialMarginCollateralPortfolioCode(String initialMarginCollateralPortfolioCode);
		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setVariationMarginCollateralPortfolioCode(String variationMarginCollateralPortfolioCode);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("actionType"), ActionTypeEnum.class, getActionType(), this);
			processor.processBasic(path.newSubPath("eventType"), EventTypeEnum.class, getEventType(), this);
			processor.processBasic(path.newSubPath("eventIdentifier"), String.class, getEventIdentifier(), this);
			processor.processBasic(path.newSubPath("effectiveDate"), Date.class, getEffectiveDate(), this);
			processor.processBasic(path.newSubPath("earlyTerminationDate"), Date.class, getEarlyTerminationDate(), this);
			processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, getEventTimestamp(), this);
			processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, getReportingTimestamp(), this);
			processor.processBasic(path.newSubPath("executionTimestamp"), ZonedDateTime.class, getExecutionTimestamp(), this);
			processor.processBasic(path.newSubPath("expirationDate"), Date.class, getExpirationDate(), this);
			processor.processBasic(path.newSubPath("counterparty1"), String.class, getCounterparty1(), this);
			processor.processBasic(path.newSubPath("counterparty2"), String.class, getCounterparty2(), this);
			processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, getCounterparty2IdentifierType(), this);
			processor.processBasic(path.newSubPath("beneficiary1"), String.class, getBeneficiary1(), this);
			processor.processBasic(path.newSubPath("beneficiary1IdentifierTypeIndicator"), Boolean.class, getBeneficiary1IdentifierTypeIndicator(), this);
			processor.processBasic(path.newSubPath("cleared"), ClearedEnum.class, getCleared(), this);
			processor.processBasic(path.newSubPath("centralCounterparty"), String.class, getCentralCounterparty(), this);
			processor.processBasic(path.newSubPath("clearingMember"), String.class, getClearingMember(), this);
			processor.processBasic(path.newSubPath("confirmed"), ConfirmationEnum.class, getConfirmed(), this);
			processor.processBasic(path.newSubPath("callAmount"), BigDecimal.class, getCallAmount(), this);
			processor.processBasic(path.newSubPath("putAmount"), BigDecimal.class, getPutAmount(), this);
			processor.processBasic(path.newSubPath("callCurrency"), ISOCurrencyCodeEnum.class, getCallCurrency(), this);
			processor.processBasic(path.newSubPath("putCurrency"), ISOCurrencyCodeEnum.class, getPutCurrency(), this);
			processRosetta(path.newSubPath("priceSchedule"), processor, PricePeriod.PricePeriodBuilder.class, getPriceSchedule());
			processRosetta(path.newSubPath("strikePriceSchedule"), processor, PricePeriod.PricePeriodBuilder.class, getStrikePriceSchedule());
			processRosetta(path.newSubPath("price"), processor, PriceFormat.PriceFormatBuilder.class, getPrice());
			processor.processBasic(path.newSubPath("priceNotation"), PriceNotationEnum.class, getPriceNotation(), this);
			processor.processBasic(path.newSubPath("priceCurrency"), ISOCurrencyCodeEnum.class, getPriceCurrency(), this);
			processRosetta(path.newSubPath("packageTransactionPrice"), processor, PriceFormat.PriceFormatBuilder.class, getPackageTransactionPrice());
			processor.processBasic(path.newSubPath("packageTransactionPriceNotation"), PriceNotationEnum.class, getPackageTransactionPriceNotation(), this);
			processor.processBasic(path.newSubPath("packageTransactionPriceCurrency"), ISOCurrencyCodeEnum.class, getPackageTransactionPriceCurrency(), this);
			processRosetta(path.newSubPath("packageTransactionSpread"), processor, PriceFormat.PriceFormatBuilder.class, getPackageTransactionSpread());
			processor.processBasic(path.newSubPath("packageTransactionSpreadNotation"), PriceNotationEnum.class, getPackageTransactionSpreadNotation(), this);
			processor.processBasic(path.newSubPath("packageTransactionSpreadCurrency"), ISOCurrencyCodeEnum.class, getPackageTransactionSpreadCurrency(), this);
			processRosetta(path.newSubPath("strikePrice"), processor, PriceFormat.PriceFormatBuilder.class, getStrikePrice());
			processor.processBasic(path.newSubPath("strikePriceNotation"), PriceNotationEnum.class, getStrikePriceNotation(), this);
			processor.processBasic(path.newSubPath("strikePriceCurrency"), String.class, getStrikePriceCurrency(), this);
			processor.processBasic(path.newSubPath("priceUnitOfMeasure"), String.class, getPriceUnitOfMeasure(), this);
			processor.processBasic(path.newSubPath("optionPremiumAmount"), BigDecimal.class, getOptionPremiumAmount(), this);
			processor.processBasic(path.newSubPath("optionPremiumCurrency"), ISOCurrencyCodeEnum.class, getOptionPremiumCurrency(), this);
			processor.processBasic(path.newSubPath("optionPremiumPaymentDate"), Date.class, getOptionPremiumPaymentDate(), this);
			processor.processBasic(path.newSubPath("cdSIndexAttachmentPoint"), BigDecimal.class, getCdSIndexAttachmentPoint(), this);
			processor.processBasic(path.newSubPath("cdSIndexDetachmentPoint"), BigDecimal.class, getCdSIndexDetachmentPoint(), this);
			processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, getCollateralPortfolioIndicator(), this);
			processor.processBasic(path.newSubPath("firstExerciseDate"), Date.class, getFirstExerciseDate(), this);
			processor.processBasic(path.newSubPath("finalContractualSettlementDate"), Date.class, getFinalContractualSettlementDate(), this);
			processRosetta(path.newSubPath("otherPayment"), processor, OtherPayment.OtherPaymentBuilder.class, getOtherPayment());
			processRosetta(path.newSubPath("leg1"), processor, CommonLeg.CommonLegBuilder.class, getLeg1());
			processRosetta(path.newSubPath("leg2"), processor, CommonLeg.CommonLegBuilder.class, getLeg2());
			processor.processBasic(path.newSubPath("counterparty2Name"), String.class, getCounterparty2Name(), this);
			processor.processBasic(path.newSubPath("executionAgentCounterparty1"), String.class, getExecutionAgentCounterparty1(), this);
			processor.processBasic(path.newSubPath("executionAgentCounterparty2DTCC"), String.class, getExecutionAgentCounterparty2DTCC(), this);
			processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, getReportSubmittingEntityID(), this);
			processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, getUniqueTransactionIdentifier(), this);
			processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, getUniqueTransactionIdentifierProprietary(), this);
			processor.processBasic(path.newSubPath("priorUTI"), String.class, getPriorUTI(), this);
			processor.processBasic(path.newSubPath("priorUTIProprietary"), String.class, getPriorUTIProprietary(), this);
			processor.processBasic(path.newSubPath("uniqueProductIdentifier"), String.class, getUniqueProductIdentifier(), this);
			processor.processBasic(path.newSubPath("contractType"), CommonContractType.class, getContractType(), this);
			processor.processBasic(path.newSubPath("assetClass"), CommonAssetClass.class, getAssetClass(), this);
			processor.processBasic(path.newSubPath("clearingTimestamp"), ZonedDateTime.class, getClearingTimestamp(), this);
			processor.processBasic(path.newSubPath("platformIdentifier"), String.class, getPlatformIdentifier(), this);
			processor.processBasic(path.newSubPath("direction1"), Direction1Enum.class, getDirection1(), this);
			processor.processBasic(path.newSubPath("direction2Leg1"), Direction2Enum.class, getDirection2Leg1(), this);
			processor.processBasic(path.newSubPath("direction2Leg2"), Direction2Enum.class, getDirection2Leg2(), this);
			processor.processBasic(path.newSubPath("packageIdentifier"), String.class, getPackageIdentifier(), this);
			processRosetta(path.newSubPath("barrier"), processor, SingleOrUpperAndLowerBarrier.SingleOrUpperAndLowerBarrierBuilder.class, getBarrier());
			processor.processBasic(path.newSubPath("exchangeRate"), BigDecimal.class, getExchangeRate(), this);
			processor.processBasic(path.newSubPath("exchangeRateBasis"), String.class, getExchangeRateBasis(), this);
			processor.processBasic(path.newSubPath("nameOfTheUnderlyingIndex"), String.class, getNameOfTheUnderlyingIndex(), this);
			processRosetta(path.newSubPath("basketConstituents"), processor, BasketConstituentsReport.BasketConstituentsReportBuilder.class, getBasketConstituents());
			processRosetta(path.newSubPath("underlying"), processor, UnderlyingIdentifier.UnderlyingIdentifierBuilder.class, getUnderlying());
			processor.processBasic(path.newSubPath("quantityUnitOfMeasureLeg1"), String.class, getQuantityUnitOfMeasureLeg1(), this);
			processor.processBasic(path.newSubPath("quantityUnitOfMeasureLeg2"), String.class, getQuantityUnitOfMeasureLeg2(), this);
			processor.processBasic(path.newSubPath("maturityDateOfTheUnderlying"), Date.class, getMaturityDateOfTheUnderlying(), this);
			processor.processBasic(path.newSubPath("optionType"), OptionTypeCode.class, getOptionType(), this);
			processor.processBasic(path.newSubPath("optionStyle"), OptionStyleEnum.class, getOptionStyle(), this);
			processor.processBasic(path.newSubPath("deliveryType"), DeliveryTypeEnum.class, getDeliveryType(), this);
			processor.processBasic(path.newSubPath("countryOfTheCounterparty2"), ISOCountryCodeEnum.class, getCountryOfTheCounterparty2(), this);
			processor.processBasic(path.newSubPath("bookingLocation"), ISOCountryCodeEnum.class, getBookingLocation(), this);
			processor.processBasic(path.newSubPath("traderLocation"), ISOCountryCodeEnum.class, getTraderLocation(), this);
			processor.processBasic(path.newSubPath("tradingCapacity"), TradingCapacity7Code.class, getTradingCapacity(), this);
			processor.processBasic(path.newSubPath("embeddedOptionType"), EmbeddedOptionTypeEnum.class, getEmbeddedOptionType(), this);
			processor.processBasic(path.newSubPath("seniority"), SeniorityEnum.class, getSeniority(), this);
			processor.processBasic(path.newSubPath("series"), Integer.class, getSeries(), this);
			processor.processBasic(path.newSubPath("indexFactor"), BigDecimal.class, getIndexFactor(), this);
			processor.processBasic(path.newSubPath("technicalRecordId"), String.class, getTechnicalRecordId(), this);
			processor.processBasic(path.newSubPath("counterparty2IdentifierSource"), Counterparty2IdentifierEnum.class, getCounterparty2IdentifierSource(), this);
			processor.processBasic(path.newSubPath("customBasketIndicator"), Boolean.class, getCustomBasketIndicator(), this);
			processor.processBasic(path.newSubPath("amendmentIndicator"), Boolean.class, getAmendmentIndicator(), this);
			processor.processBasic(path.newSubPath("packageIndicator"), Boolean.class, getPackageIndicator(), this);
			processor.processBasic(path.newSubPath("postPricedSwapIndicator"), Boolean.class, getPostPricedSwapIndicator(), this);
			processor.processBasic(path.newSubPath("settlementLocationLeg1"), ISOCountryCodeEnum.class, getSettlementLocationLeg1(), this);
			processor.processBasic(path.newSubPath("settlementLocationLeg2"), ISOCountryCodeEnum.class, getSettlementLocationLeg2(), this);
			processor.processBasic(path.newSubPath("nonStandardizedTermIndicator"), Boolean.class, getNonStandardizedTermIndicator(), this);
			processor.processBasic(path.newSubPath("blockTradeElectionIndicator"), Boolean.class, getBlockTradeElectionIndicator(), this);
			processor.processBasic(path.newSubPath("primeBrokerageTransactionIndicator"), Boolean.class, getPrimeBrokerageTransactionIndicator(), this);
			processor.processBasic(path.newSubPath("uniqueSwapIdentifier"), String.class, getUniqueSwapIdentifier(), this);
			processRosetta(path.newSubPath("cftcGuidebook"), processor, CFTCGuidebook.CFTCGuidebookBuilder.class, getCftcGuidebook());
			processRosetta(path.newSubPath("nonReportable"), processor, CFTCNonReportablePart45.CFTCNonReportablePart45Builder.class, getNonReportable());
			processor.processBasic(path.newSubPath("clearingAccountOrigin"), ClearingAccountOriginEnum.class, getClearingAccountOrigin(), this);
			processor.processBasic(path.newSubPath("clearingSwapUSIs"), String.class, getClearingSwapUSIs(), this);
			processor.processBasic(path.newSubPath("clearingSwapUTIs"), String.class, getClearingSwapUTIs(), this);
			processor.processBasic(path.newSubPath("originalSwapUSI"), String.class, getOriginalSwapUSI(), this);
			processor.processBasic(path.newSubPath("originalSwapUTI"), String.class, getOriginalSwapUTI(), this);
			processor.processBasic(path.newSubPath("originalSwapSDRIdentifier"), String.class, getOriginalSwapSDRIdentifier(), this);
			processor.processBasic(path.newSubPath("clearingReceiptTimestamp"), ZonedDateTime.class, getClearingReceiptTimestamp(), this);
			processor.processBasic(path.newSubPath("clearingExceptionsAndExemptionsCounterparty1"), ClearingExceptionsAndExemptionsEnum.class, getClearingExceptionsAndExemptionsCounterparty1(), this);
			processor.processBasic(path.newSubPath("clearingExceptionsAndExemptionsCounterparty2"), ClearingExceptionsAndExemptionsEnum.class, getClearingExceptionsAndExemptionsCounterparty2(), this);
			processor.processBasic(path.newSubPath("counterparty1FinancialEntityIndicator"), Boolean.class, getCounterparty1FinancialEntityIndicator(), this);
			processor.processBasic(path.newSubPath("counterparty2FinancialEntityIndicator"), Boolean.class, getCounterparty2FinancialEntityIndicator(), this);
			processor.processBasic(path.newSubPath("buyerIdentifier"), String.class, getBuyerIdentifier(), this);
			processor.processBasic(path.newSubPath("sellerIdentifier"), String.class, getSellerIdentifier(), this);
			processor.processBasic(path.newSubPath("payerIdentifierLeg1"), String.class, getPayerIdentifierLeg1(), this);
			processor.processBasic(path.newSubPath("payerIdentifierLeg2"), String.class, getPayerIdentifierLeg2(), this);
			processor.processBasic(path.newSubPath("receiverIdentifierLeg1"), String.class, getReceiverIdentifierLeg1(), this);
			processor.processBasic(path.newSubPath("receiverIdentifierLeg2"), String.class, getReceiverIdentifierLeg2(), this);
			processor.processBasic(path.newSubPath("counterparty1FederalEntityIndicator"), Boolean.class, getCounterparty1FederalEntityIndicator(), this);
			processor.processBasic(path.newSubPath("counterparty2FederalEntityIndicator"), Boolean.class, getCounterparty2FederalEntityIndicator(), this);
			processor.processBasic(path.newSubPath("allocationIndicator"), AllocationIndicatorEnum.class, getAllocationIndicator(), this);
			processor.processBasic(path.newSubPath("priorUSI"), String.class, getPriorUSI(), this);
			processor.processBasic(path.newSubPath("jurisdiction"), JurisdictionEnum.class, getJurisdiction(), this);
			processor.processBasic(path.newSubPath("newSDRIdentifier"), String.class, getNewSDRIdentifier(), this);
			processor.processBasic(path.newSubPath("initialMarginCollateralPortfolioCode"), String.class, getInitialMarginCollateralPortfolioCode(), this);
			processor.processBasic(path.newSubPath("variationMarginCollateralPortfolioCode"), String.class, getVariationMarginCollateralPortfolioCode(), this);
		}
		

		CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder prune();
	}

	/*********************** Immutable Implementation of CFTCPart45TransactionReport  ***********************/
	class CFTCPart45TransactionReportImpl extends CFTCTransactionReport.CFTCTransactionReportImpl implements CFTCPart45TransactionReport {
		private final CFTCNonReportablePart45 nonReportable;
		private final ClearingAccountOriginEnum clearingAccountOrigin;
		private final List<String> clearingSwapUSIs;
		private final List<String> clearingSwapUTIs;
		private final String originalSwapUSI;
		private final String originalSwapUTI;
		private final String originalSwapSDRIdentifier;
		private final ZonedDateTime clearingReceiptTimestamp;
		private final List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty1;
		private final List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty2;
		private final Boolean counterparty1FinancialEntityIndicator;
		private final Boolean counterparty2FinancialEntityIndicator;
		private final String buyerIdentifier;
		private final String sellerIdentifier;
		private final String payerIdentifierLeg1;
		private final String payerIdentifierLeg2;
		private final String receiverIdentifierLeg1;
		private final String receiverIdentifierLeg2;
		private final Boolean counterparty1FederalEntityIndicator;
		private final Boolean counterparty2FederalEntityIndicator;
		private final AllocationIndicatorEnum allocationIndicator;
		private final String priorUSI;
		private final JurisdictionEnum jurisdiction;
		private final String newSDRIdentifier;
		private final String initialMarginCollateralPortfolioCode;
		private final String variationMarginCollateralPortfolioCode;
		
		protected CFTCPart45TransactionReportImpl(CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder builder) {
			super(builder);
			this.nonReportable = ofNullable(builder.getNonReportable()).map(f->f.build()).orElse(null);
			this.clearingAccountOrigin = builder.getClearingAccountOrigin();
			this.clearingSwapUSIs = ofNullable(builder.getClearingSwapUSIs()).filter(_l->!_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
			this.clearingSwapUTIs = ofNullable(builder.getClearingSwapUTIs()).filter(_l->!_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
			this.originalSwapUSI = builder.getOriginalSwapUSI();
			this.originalSwapUTI = builder.getOriginalSwapUTI();
			this.originalSwapSDRIdentifier = builder.getOriginalSwapSDRIdentifier();
			this.clearingReceiptTimestamp = builder.getClearingReceiptTimestamp();
			this.clearingExceptionsAndExemptionsCounterparty1 = ofNullable(builder.getClearingExceptionsAndExemptionsCounterparty1()).filter(_l->!_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
			this.clearingExceptionsAndExemptionsCounterparty2 = ofNullable(builder.getClearingExceptionsAndExemptionsCounterparty2()).filter(_l->!_l.isEmpty()).map(ImmutableList::copyOf).orElse(null);
			this.counterparty1FinancialEntityIndicator = builder.getCounterparty1FinancialEntityIndicator();
			this.counterparty2FinancialEntityIndicator = builder.getCounterparty2FinancialEntityIndicator();
			this.buyerIdentifier = builder.getBuyerIdentifier();
			this.sellerIdentifier = builder.getSellerIdentifier();
			this.payerIdentifierLeg1 = builder.getPayerIdentifierLeg1();
			this.payerIdentifierLeg2 = builder.getPayerIdentifierLeg2();
			this.receiverIdentifierLeg1 = builder.getReceiverIdentifierLeg1();
			this.receiverIdentifierLeg2 = builder.getReceiverIdentifierLeg2();
			this.counterparty1FederalEntityIndicator = builder.getCounterparty1FederalEntityIndicator();
			this.counterparty2FederalEntityIndicator = builder.getCounterparty2FederalEntityIndicator();
			this.allocationIndicator = builder.getAllocationIndicator();
			this.priorUSI = builder.getPriorUSI();
			this.jurisdiction = builder.getJurisdiction();
			this.newSDRIdentifier = builder.getNewSDRIdentifier();
			this.initialMarginCollateralPortfolioCode = builder.getInitialMarginCollateralPortfolioCode();
			this.variationMarginCollateralPortfolioCode = builder.getVariationMarginCollateralPortfolioCode();
		}
		
		@Override
		@RosettaAttribute("nonReportable")
		@RuneAttribute("nonReportable")
		public CFTCNonReportablePart45 getNonReportable() {
			return nonReportable;
		}
		
		@Override
		@RosettaAttribute("clearingAccountOrigin")
		@RuneAttribute("clearingAccountOrigin")
		public ClearingAccountOriginEnum getClearingAccountOrigin() {
			return clearingAccountOrigin;
		}
		
		@Override
		@RosettaAttribute("clearingSwapUSIs")
		@RuneAttribute("clearingSwapUSIs")
		public List<String> getClearingSwapUSIs() {
			return clearingSwapUSIs;
		}
		
		@Override
		@RosettaAttribute("clearingSwapUTIs")
		@RuneAttribute("clearingSwapUTIs")
		public List<String> getClearingSwapUTIs() {
			return clearingSwapUTIs;
		}
		
		@Override
		@RosettaAttribute("originalSwapUSI")
		@RuneAttribute("originalSwapUSI")
		public String getOriginalSwapUSI() {
			return originalSwapUSI;
		}
		
		@Override
		@RosettaAttribute("originalSwapUTI")
		@RuneAttribute("originalSwapUTI")
		public String getOriginalSwapUTI() {
			return originalSwapUTI;
		}
		
		@Override
		@RosettaAttribute("originalSwapSDRIdentifier")
		@RuneAttribute("originalSwapSDRIdentifier")
		public String getOriginalSwapSDRIdentifier() {
			return originalSwapSDRIdentifier;
		}
		
		@Override
		@RosettaAttribute("clearingReceiptTimestamp")
		@RuneAttribute("clearingReceiptTimestamp")
		public ZonedDateTime getClearingReceiptTimestamp() {
			return clearingReceiptTimestamp;
		}
		
		@Override
		@RosettaAttribute("clearingExceptionsAndExemptionsCounterparty1")
		@RuneAttribute("clearingExceptionsAndExemptionsCounterparty1")
		public List<ClearingExceptionsAndExemptionsEnum> getClearingExceptionsAndExemptionsCounterparty1() {
			return clearingExceptionsAndExemptionsCounterparty1;
		}
		
		@Override
		@RosettaAttribute("clearingExceptionsAndExemptionsCounterparty2")
		@RuneAttribute("clearingExceptionsAndExemptionsCounterparty2")
		public List<ClearingExceptionsAndExemptionsEnum> getClearingExceptionsAndExemptionsCounterparty2() {
			return clearingExceptionsAndExemptionsCounterparty2;
		}
		
		@Override
		@RosettaAttribute("counterparty1FinancialEntityIndicator")
		@RuneAttribute("counterparty1FinancialEntityIndicator")
		public Boolean getCounterparty1FinancialEntityIndicator() {
			return counterparty1FinancialEntityIndicator;
		}
		
		@Override
		@RosettaAttribute("counterparty2FinancialEntityIndicator")
		@RuneAttribute("counterparty2FinancialEntityIndicator")
		public Boolean getCounterparty2FinancialEntityIndicator() {
			return counterparty2FinancialEntityIndicator;
		}
		
		@Override
		@RosettaAttribute("buyerIdentifier")
		@RuneAttribute("buyerIdentifier")
		public String getBuyerIdentifier() {
			return buyerIdentifier;
		}
		
		@Override
		@RosettaAttribute("sellerIdentifier")
		@RuneAttribute("sellerIdentifier")
		public String getSellerIdentifier() {
			return sellerIdentifier;
		}
		
		@Override
		@RosettaAttribute("payerIdentifierLeg1")
		@RuneAttribute("payerIdentifierLeg1")
		public String getPayerIdentifierLeg1() {
			return payerIdentifierLeg1;
		}
		
		@Override
		@RosettaAttribute("payerIdentifierLeg2")
		@RuneAttribute("payerIdentifierLeg2")
		public String getPayerIdentifierLeg2() {
			return payerIdentifierLeg2;
		}
		
		@Override
		@RosettaAttribute("receiverIdentifierLeg1")
		@RuneAttribute("receiverIdentifierLeg1")
		public String getReceiverIdentifierLeg1() {
			return receiverIdentifierLeg1;
		}
		
		@Override
		@RosettaAttribute("receiverIdentifierLeg2")
		@RuneAttribute("receiverIdentifierLeg2")
		public String getReceiverIdentifierLeg2() {
			return receiverIdentifierLeg2;
		}
		
		@Override
		@RosettaAttribute("counterparty1FederalEntityIndicator")
		@RuneAttribute("counterparty1FederalEntityIndicator")
		public Boolean getCounterparty1FederalEntityIndicator() {
			return counterparty1FederalEntityIndicator;
		}
		
		@Override
		@RosettaAttribute("counterparty2FederalEntityIndicator")
		@RuneAttribute("counterparty2FederalEntityIndicator")
		public Boolean getCounterparty2FederalEntityIndicator() {
			return counterparty2FederalEntityIndicator;
		}
		
		@Override
		@RosettaAttribute("allocationIndicator")
		@RuneAttribute("allocationIndicator")
		public AllocationIndicatorEnum getAllocationIndicator() {
			return allocationIndicator;
		}
		
		@Override
		@RosettaAttribute("priorUSI")
		@RuneAttribute("priorUSI")
		public String getPriorUSI() {
			return priorUSI;
		}
		
		@Override
		@RosettaAttribute("jurisdiction")
		@RuneAttribute("jurisdiction")
		public JurisdictionEnum getJurisdiction() {
			return jurisdiction;
		}
		
		@Override
		@RosettaAttribute("newSDRIdentifier")
		@RuneAttribute("newSDRIdentifier")
		public String getNewSDRIdentifier() {
			return newSDRIdentifier;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollateralPortfolioCode")
		@RuneAttribute("initialMarginCollateralPortfolioCode")
		public String getInitialMarginCollateralPortfolioCode() {
			return initialMarginCollateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute("variationMarginCollateralPortfolioCode")
		@RuneAttribute("variationMarginCollateralPortfolioCode")
		public String getVariationMarginCollateralPortfolioCode() {
			return variationMarginCollateralPortfolioCode;
		}
		
		@Override
		public CFTCPart45TransactionReport build() {
			return this;
		}
		
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder toBuilder() {
			CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder builder) {
			super.setBuilderFields(builder);
			ofNullable(getNonReportable()).ifPresent(builder::setNonReportable);
			ofNullable(getClearingAccountOrigin()).ifPresent(builder::setClearingAccountOrigin);
			ofNullable(getClearingSwapUSIs()).ifPresent(builder::setClearingSwapUSIs);
			ofNullable(getClearingSwapUTIs()).ifPresent(builder::setClearingSwapUTIs);
			ofNullable(getOriginalSwapUSI()).ifPresent(builder::setOriginalSwapUSI);
			ofNullable(getOriginalSwapUTI()).ifPresent(builder::setOriginalSwapUTI);
			ofNullable(getOriginalSwapSDRIdentifier()).ifPresent(builder::setOriginalSwapSDRIdentifier);
			ofNullable(getClearingReceiptTimestamp()).ifPresent(builder::setClearingReceiptTimestamp);
			ofNullable(getClearingExceptionsAndExemptionsCounterparty1()).ifPresent(builder::setClearingExceptionsAndExemptionsCounterparty1);
			ofNullable(getClearingExceptionsAndExemptionsCounterparty2()).ifPresent(builder::setClearingExceptionsAndExemptionsCounterparty2);
			ofNullable(getCounterparty1FinancialEntityIndicator()).ifPresent(builder::setCounterparty1FinancialEntityIndicator);
			ofNullable(getCounterparty2FinancialEntityIndicator()).ifPresent(builder::setCounterparty2FinancialEntityIndicator);
			ofNullable(getBuyerIdentifier()).ifPresent(builder::setBuyerIdentifier);
			ofNullable(getSellerIdentifier()).ifPresent(builder::setSellerIdentifier);
			ofNullable(getPayerIdentifierLeg1()).ifPresent(builder::setPayerIdentifierLeg1);
			ofNullable(getPayerIdentifierLeg2()).ifPresent(builder::setPayerIdentifierLeg2);
			ofNullable(getReceiverIdentifierLeg1()).ifPresent(builder::setReceiverIdentifierLeg1);
			ofNullable(getReceiverIdentifierLeg2()).ifPresent(builder::setReceiverIdentifierLeg2);
			ofNullable(getCounterparty1FederalEntityIndicator()).ifPresent(builder::setCounterparty1FederalEntityIndicator);
			ofNullable(getCounterparty2FederalEntityIndicator()).ifPresent(builder::setCounterparty2FederalEntityIndicator);
			ofNullable(getAllocationIndicator()).ifPresent(builder::setAllocationIndicator);
			ofNullable(getPriorUSI()).ifPresent(builder::setPriorUSI);
			ofNullable(getJurisdiction()).ifPresent(builder::setJurisdiction);
			ofNullable(getNewSDRIdentifier()).ifPresent(builder::setNewSDRIdentifier);
			ofNullable(getInitialMarginCollateralPortfolioCode()).ifPresent(builder::setInitialMarginCollateralPortfolioCode);
			ofNullable(getVariationMarginCollateralPortfolioCode()).ifPresent(builder::setVariationMarginCollateralPortfolioCode);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
			if (!super.equals(o)) return false;
		
			CFTCPart45TransactionReport _that = getType().cast(o);
		
			if (!Objects.equals(nonReportable, _that.getNonReportable())) return false;
			if (!Objects.equals(clearingAccountOrigin, _that.getClearingAccountOrigin())) return false;
			if (!ListEquals.listEquals(clearingSwapUSIs, _that.getClearingSwapUSIs())) return false;
			if (!ListEquals.listEquals(clearingSwapUTIs, _that.getClearingSwapUTIs())) return false;
			if (!Objects.equals(originalSwapUSI, _that.getOriginalSwapUSI())) return false;
			if (!Objects.equals(originalSwapUTI, _that.getOriginalSwapUTI())) return false;
			if (!Objects.equals(originalSwapSDRIdentifier, _that.getOriginalSwapSDRIdentifier())) return false;
			if (!Objects.equals(clearingReceiptTimestamp, _that.getClearingReceiptTimestamp())) return false;
			if (!ListEquals.listEquals(clearingExceptionsAndExemptionsCounterparty1, _that.getClearingExceptionsAndExemptionsCounterparty1())) return false;
			if (!ListEquals.listEquals(clearingExceptionsAndExemptionsCounterparty2, _that.getClearingExceptionsAndExemptionsCounterparty2())) return false;
			if (!Objects.equals(counterparty1FinancialEntityIndicator, _that.getCounterparty1FinancialEntityIndicator())) return false;
			if (!Objects.equals(counterparty2FinancialEntityIndicator, _that.getCounterparty2FinancialEntityIndicator())) return false;
			if (!Objects.equals(buyerIdentifier, _that.getBuyerIdentifier())) return false;
			if (!Objects.equals(sellerIdentifier, _that.getSellerIdentifier())) return false;
			if (!Objects.equals(payerIdentifierLeg1, _that.getPayerIdentifierLeg1())) return false;
			if (!Objects.equals(payerIdentifierLeg2, _that.getPayerIdentifierLeg2())) return false;
			if (!Objects.equals(receiverIdentifierLeg1, _that.getReceiverIdentifierLeg1())) return false;
			if (!Objects.equals(receiverIdentifierLeg2, _that.getReceiverIdentifierLeg2())) return false;
			if (!Objects.equals(counterparty1FederalEntityIndicator, _that.getCounterparty1FederalEntityIndicator())) return false;
			if (!Objects.equals(counterparty2FederalEntityIndicator, _that.getCounterparty2FederalEntityIndicator())) return false;
			if (!Objects.equals(allocationIndicator, _that.getAllocationIndicator())) return false;
			if (!Objects.equals(priorUSI, _that.getPriorUSI())) return false;
			if (!Objects.equals(jurisdiction, _that.getJurisdiction())) return false;
			if (!Objects.equals(newSDRIdentifier, _that.getNewSDRIdentifier())) return false;
			if (!Objects.equals(initialMarginCollateralPortfolioCode, _that.getInitialMarginCollateralPortfolioCode())) return false;
			if (!Objects.equals(variationMarginCollateralPortfolioCode, _that.getVariationMarginCollateralPortfolioCode())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = super.hashCode();
			_result = 31 * _result + (nonReportable != null ? nonReportable.hashCode() : 0);
			_result = 31 * _result + (clearingAccountOrigin != null ? clearingAccountOrigin.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (clearingSwapUSIs != null ? clearingSwapUSIs.hashCode() : 0);
			_result = 31 * _result + (clearingSwapUTIs != null ? clearingSwapUTIs.hashCode() : 0);
			_result = 31 * _result + (originalSwapUSI != null ? originalSwapUSI.hashCode() : 0);
			_result = 31 * _result + (originalSwapUTI != null ? originalSwapUTI.hashCode() : 0);
			_result = 31 * _result + (originalSwapSDRIdentifier != null ? originalSwapSDRIdentifier.hashCode() : 0);
			_result = 31 * _result + (clearingReceiptTimestamp != null ? clearingReceiptTimestamp.hashCode() : 0);
			_result = 31 * _result + (clearingExceptionsAndExemptionsCounterparty1 != null ? clearingExceptionsAndExemptionsCounterparty1.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
			_result = 31 * _result + (clearingExceptionsAndExemptionsCounterparty2 != null ? clearingExceptionsAndExemptionsCounterparty2.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
			_result = 31 * _result + (counterparty1FinancialEntityIndicator != null ? counterparty1FinancialEntityIndicator.hashCode() : 0);
			_result = 31 * _result + (counterparty2FinancialEntityIndicator != null ? counterparty2FinancialEntityIndicator.hashCode() : 0);
			_result = 31 * _result + (buyerIdentifier != null ? buyerIdentifier.hashCode() : 0);
			_result = 31 * _result + (sellerIdentifier != null ? sellerIdentifier.hashCode() : 0);
			_result = 31 * _result + (payerIdentifierLeg1 != null ? payerIdentifierLeg1.hashCode() : 0);
			_result = 31 * _result + (payerIdentifierLeg2 != null ? payerIdentifierLeg2.hashCode() : 0);
			_result = 31 * _result + (receiverIdentifierLeg1 != null ? receiverIdentifierLeg1.hashCode() : 0);
			_result = 31 * _result + (receiverIdentifierLeg2 != null ? receiverIdentifierLeg2.hashCode() : 0);
			_result = 31 * _result + (counterparty1FederalEntityIndicator != null ? counterparty1FederalEntityIndicator.hashCode() : 0);
			_result = 31 * _result + (counterparty2FederalEntityIndicator != null ? counterparty2FederalEntityIndicator.hashCode() : 0);
			_result = 31 * _result + (allocationIndicator != null ? allocationIndicator.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (priorUSI != null ? priorUSI.hashCode() : 0);
			_result = 31 * _result + (jurisdiction != null ? jurisdiction.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (newSDRIdentifier != null ? newSDRIdentifier.hashCode() : 0);
			_result = 31 * _result + (initialMarginCollateralPortfolioCode != null ? initialMarginCollateralPortfolioCode.hashCode() : 0);
			_result = 31 * _result + (variationMarginCollateralPortfolioCode != null ? variationMarginCollateralPortfolioCode.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "CFTCPart45TransactionReport {" +
				"nonReportable=" + this.nonReportable + ", " +
				"clearingAccountOrigin=" + this.clearingAccountOrigin + ", " +
				"clearingSwapUSIs=" + this.clearingSwapUSIs + ", " +
				"clearingSwapUTIs=" + this.clearingSwapUTIs + ", " +
				"originalSwapUSI=" + this.originalSwapUSI + ", " +
				"originalSwapUTI=" + this.originalSwapUTI + ", " +
				"originalSwapSDRIdentifier=" + this.originalSwapSDRIdentifier + ", " +
				"clearingReceiptTimestamp=" + this.clearingReceiptTimestamp + ", " +
				"clearingExceptionsAndExemptionsCounterparty1=" + this.clearingExceptionsAndExemptionsCounterparty1 + ", " +
				"clearingExceptionsAndExemptionsCounterparty2=" + this.clearingExceptionsAndExemptionsCounterparty2 + ", " +
				"counterparty1FinancialEntityIndicator=" + this.counterparty1FinancialEntityIndicator + ", " +
				"counterparty2FinancialEntityIndicator=" + this.counterparty2FinancialEntityIndicator + ", " +
				"buyerIdentifier=" + this.buyerIdentifier + ", " +
				"sellerIdentifier=" + this.sellerIdentifier + ", " +
				"payerIdentifierLeg1=" + this.payerIdentifierLeg1 + ", " +
				"payerIdentifierLeg2=" + this.payerIdentifierLeg2 + ", " +
				"receiverIdentifierLeg1=" + this.receiverIdentifierLeg1 + ", " +
				"receiverIdentifierLeg2=" + this.receiverIdentifierLeg2 + ", " +
				"counterparty1FederalEntityIndicator=" + this.counterparty1FederalEntityIndicator + ", " +
				"counterparty2FederalEntityIndicator=" + this.counterparty2FederalEntityIndicator + ", " +
				"allocationIndicator=" + this.allocationIndicator + ", " +
				"priorUSI=" + this.priorUSI + ", " +
				"jurisdiction=" + this.jurisdiction + ", " +
				"newSDRIdentifier=" + this.newSDRIdentifier + ", " +
				"initialMarginCollateralPortfolioCode=" + this.initialMarginCollateralPortfolioCode + ", " +
				"variationMarginCollateralPortfolioCode=" + this.variationMarginCollateralPortfolioCode +
			'}' + " " + super.toString();
		}
	}

	/*********************** Builder Implementation of CFTCPart45TransactionReport  ***********************/
	class CFTCPart45TransactionReportBuilderImpl extends CFTCTransactionReport.CFTCTransactionReportBuilderImpl implements CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder {
	
		protected CFTCNonReportablePart45.CFTCNonReportablePart45Builder nonReportable;
		protected ClearingAccountOriginEnum clearingAccountOrigin;
		protected List<String> clearingSwapUSIs = new ArrayList<>();
		protected List<String> clearingSwapUTIs = new ArrayList<>();
		protected String originalSwapUSI;
		protected String originalSwapUTI;
		protected String originalSwapSDRIdentifier;
		protected ZonedDateTime clearingReceiptTimestamp;
		protected List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty1 = new ArrayList<>();
		protected List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty2 = new ArrayList<>();
		protected Boolean counterparty1FinancialEntityIndicator;
		protected Boolean counterparty2FinancialEntityIndicator;
		protected String buyerIdentifier;
		protected String sellerIdentifier;
		protected String payerIdentifierLeg1;
		protected String payerIdentifierLeg2;
		protected String receiverIdentifierLeg1;
		protected String receiverIdentifierLeg2;
		protected Boolean counterparty1FederalEntityIndicator;
		protected Boolean counterparty2FederalEntityIndicator;
		protected AllocationIndicatorEnum allocationIndicator;
		protected String priorUSI;
		protected JurisdictionEnum jurisdiction;
		protected String newSDRIdentifier;
		protected String initialMarginCollateralPortfolioCode;
		protected String variationMarginCollateralPortfolioCode;
		
		@Override
		@RosettaAttribute("nonReportable")
		@RuneAttribute("nonReportable")
		public CFTCNonReportablePart45.CFTCNonReportablePart45Builder getNonReportable() {
			return nonReportable;
		}
		
		@Override
		public CFTCNonReportablePart45.CFTCNonReportablePart45Builder getOrCreateNonReportable() {
			CFTCNonReportablePart45.CFTCNonReportablePart45Builder result;
			if (nonReportable!=null) {
				result = nonReportable;
			}
			else {
				result = nonReportable = CFTCNonReportablePart45.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("clearingAccountOrigin")
		@RuneAttribute("clearingAccountOrigin")
		public ClearingAccountOriginEnum getClearingAccountOrigin() {
			return clearingAccountOrigin;
		}
		
		@Override
		@RosettaAttribute("clearingSwapUSIs")
		@RuneAttribute("clearingSwapUSIs")
		public List<String> getClearingSwapUSIs() {
			return clearingSwapUSIs;
		}
		
		@Override
		@RosettaAttribute("clearingSwapUTIs")
		@RuneAttribute("clearingSwapUTIs")
		public List<String> getClearingSwapUTIs() {
			return clearingSwapUTIs;
		}
		
		@Override
		@RosettaAttribute("originalSwapUSI")
		@RuneAttribute("originalSwapUSI")
		public String getOriginalSwapUSI() {
			return originalSwapUSI;
		}
		
		@Override
		@RosettaAttribute("originalSwapUTI")
		@RuneAttribute("originalSwapUTI")
		public String getOriginalSwapUTI() {
			return originalSwapUTI;
		}
		
		@Override
		@RosettaAttribute("originalSwapSDRIdentifier")
		@RuneAttribute("originalSwapSDRIdentifier")
		public String getOriginalSwapSDRIdentifier() {
			return originalSwapSDRIdentifier;
		}
		
		@Override
		@RosettaAttribute("clearingReceiptTimestamp")
		@RuneAttribute("clearingReceiptTimestamp")
		public ZonedDateTime getClearingReceiptTimestamp() {
			return clearingReceiptTimestamp;
		}
		
		@Override
		@RosettaAttribute("clearingExceptionsAndExemptionsCounterparty1")
		@RuneAttribute("clearingExceptionsAndExemptionsCounterparty1")
		public List<ClearingExceptionsAndExemptionsEnum> getClearingExceptionsAndExemptionsCounterparty1() {
			return clearingExceptionsAndExemptionsCounterparty1;
		}
		
		@Override
		@RosettaAttribute("clearingExceptionsAndExemptionsCounterparty2")
		@RuneAttribute("clearingExceptionsAndExemptionsCounterparty2")
		public List<ClearingExceptionsAndExemptionsEnum> getClearingExceptionsAndExemptionsCounterparty2() {
			return clearingExceptionsAndExemptionsCounterparty2;
		}
		
		@Override
		@RosettaAttribute("counterparty1FinancialEntityIndicator")
		@RuneAttribute("counterparty1FinancialEntityIndicator")
		public Boolean getCounterparty1FinancialEntityIndicator() {
			return counterparty1FinancialEntityIndicator;
		}
		
		@Override
		@RosettaAttribute("counterparty2FinancialEntityIndicator")
		@RuneAttribute("counterparty2FinancialEntityIndicator")
		public Boolean getCounterparty2FinancialEntityIndicator() {
			return counterparty2FinancialEntityIndicator;
		}
		
		@Override
		@RosettaAttribute("buyerIdentifier")
		@RuneAttribute("buyerIdentifier")
		public String getBuyerIdentifier() {
			return buyerIdentifier;
		}
		
		@Override
		@RosettaAttribute("sellerIdentifier")
		@RuneAttribute("sellerIdentifier")
		public String getSellerIdentifier() {
			return sellerIdentifier;
		}
		
		@Override
		@RosettaAttribute("payerIdentifierLeg1")
		@RuneAttribute("payerIdentifierLeg1")
		public String getPayerIdentifierLeg1() {
			return payerIdentifierLeg1;
		}
		
		@Override
		@RosettaAttribute("payerIdentifierLeg2")
		@RuneAttribute("payerIdentifierLeg2")
		public String getPayerIdentifierLeg2() {
			return payerIdentifierLeg2;
		}
		
		@Override
		@RosettaAttribute("receiverIdentifierLeg1")
		@RuneAttribute("receiverIdentifierLeg1")
		public String getReceiverIdentifierLeg1() {
			return receiverIdentifierLeg1;
		}
		
		@Override
		@RosettaAttribute("receiverIdentifierLeg2")
		@RuneAttribute("receiverIdentifierLeg2")
		public String getReceiverIdentifierLeg2() {
			return receiverIdentifierLeg2;
		}
		
		@Override
		@RosettaAttribute("counterparty1FederalEntityIndicator")
		@RuneAttribute("counterparty1FederalEntityIndicator")
		public Boolean getCounterparty1FederalEntityIndicator() {
			return counterparty1FederalEntityIndicator;
		}
		
		@Override
		@RosettaAttribute("counterparty2FederalEntityIndicator")
		@RuneAttribute("counterparty2FederalEntityIndicator")
		public Boolean getCounterparty2FederalEntityIndicator() {
			return counterparty2FederalEntityIndicator;
		}
		
		@Override
		@RosettaAttribute("allocationIndicator")
		@RuneAttribute("allocationIndicator")
		public AllocationIndicatorEnum getAllocationIndicator() {
			return allocationIndicator;
		}
		
		@Override
		@RosettaAttribute("priorUSI")
		@RuneAttribute("priorUSI")
		public String getPriorUSI() {
			return priorUSI;
		}
		
		@Override
		@RosettaAttribute("jurisdiction")
		@RuneAttribute("jurisdiction")
		public JurisdictionEnum getJurisdiction() {
			return jurisdiction;
		}
		
		@Override
		@RosettaAttribute("newSDRIdentifier")
		@RuneAttribute("newSDRIdentifier")
		public String getNewSDRIdentifier() {
			return newSDRIdentifier;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollateralPortfolioCode")
		@RuneAttribute("initialMarginCollateralPortfolioCode")
		public String getInitialMarginCollateralPortfolioCode() {
			return initialMarginCollateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute("variationMarginCollateralPortfolioCode")
		@RuneAttribute("variationMarginCollateralPortfolioCode")
		public String getVariationMarginCollateralPortfolioCode() {
			return variationMarginCollateralPortfolioCode;
		}
		
		@Override
		@RosettaAttribute("actionType")
		@RuneAttribute("actionType")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setActionType(ActionTypeEnum _actionType) {
			this.actionType = _actionType == null ? null : _actionType;
			return this;
		}
		
		@Override
		@RosettaAttribute("eventType")
		@RuneAttribute("eventType")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setEventType(EventTypeEnum _eventType) {
			this.eventType = _eventType == null ? null : _eventType;
			return this;
		}
		
		@Override
		@RosettaAttribute("eventIdentifier")
		@RuneAttribute("eventIdentifier")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setEventIdentifier(String _eventIdentifier) {
			this.eventIdentifier = _eventIdentifier == null ? null : _eventIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("effectiveDate")
		@RuneAttribute("effectiveDate")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setEffectiveDate(Date _effectiveDate) {
			this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("earlyTerminationDate")
		@RuneAttribute("earlyTerminationDate")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setEarlyTerminationDate(Date _earlyTerminationDate) {
			this.earlyTerminationDate = _earlyTerminationDate == null ? null : _earlyTerminationDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("eventTimestamp")
		@RuneAttribute("eventTimestamp")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setEventTimestamp(ZonedDateTime _eventTimestamp) {
			this.eventTimestamp = _eventTimestamp == null ? null : _eventTimestamp;
			return this;
		}
		
		@Override
		@RosettaAttribute("reportingTimestamp")
		@RuneAttribute("reportingTimestamp")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
			this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
			return this;
		}
		
		@Override
		@RosettaAttribute("executionTimestamp")
		@RuneAttribute("executionTimestamp")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setExecutionTimestamp(ZonedDateTime _executionTimestamp) {
			this.executionTimestamp = _executionTimestamp == null ? null : _executionTimestamp;
			return this;
		}
		
		@Override
		@RosettaAttribute("expirationDate")
		@RuneAttribute("expirationDate")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setExpirationDate(Date _expirationDate) {
			this.expirationDate = _expirationDate == null ? null : _expirationDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("counterparty1")
		@RuneAttribute("counterparty1")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCounterparty1(String _counterparty1) {
			this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
			return this;
		}
		
		@Override
		@RosettaAttribute("counterparty2")
		@RuneAttribute("counterparty2")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCounterparty2(String _counterparty2) {
			this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
			return this;
		}
		
		@Override
		@RosettaAttribute("counterparty2IdentifierType")
		@RuneAttribute("counterparty2IdentifierType")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCounterparty2IdentifierType(Boolean _counterparty2IdentifierType) {
			this.counterparty2IdentifierType = _counterparty2IdentifierType == null ? null : _counterparty2IdentifierType;
			return this;
		}
		
		@Override
		@RosettaAttribute("beneficiary1")
		@RuneAttribute("beneficiary1")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setBeneficiary1(String _beneficiary1) {
			this.beneficiary1 = _beneficiary1 == null ? null : _beneficiary1;
			return this;
		}
		
		@Override
		@RosettaAttribute("beneficiary1IdentifierTypeIndicator")
		@RuneAttribute("beneficiary1IdentifierTypeIndicator")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setBeneficiary1IdentifierTypeIndicator(Boolean _beneficiary1IdentifierTypeIndicator) {
			this.beneficiary1IdentifierTypeIndicator = _beneficiary1IdentifierTypeIndicator == null ? null : _beneficiary1IdentifierTypeIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("cleared")
		@RuneAttribute("cleared")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCleared(ClearedEnum _cleared) {
			this.cleared = _cleared == null ? null : _cleared;
			return this;
		}
		
		@Override
		@RosettaAttribute("centralCounterparty")
		@RuneAttribute("centralCounterparty")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCentralCounterparty(String _centralCounterparty) {
			this.centralCounterparty = _centralCounterparty == null ? null : _centralCounterparty;
			return this;
		}
		
		@Override
		@RosettaAttribute("clearingMember")
		@RuneAttribute("clearingMember")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setClearingMember(String _clearingMember) {
			this.clearingMember = _clearingMember == null ? null : _clearingMember;
			return this;
		}
		
		@Override
		@RosettaAttribute("confirmed")
		@RuneAttribute("confirmed")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setConfirmed(ConfirmationEnum _confirmed) {
			this.confirmed = _confirmed == null ? null : _confirmed;
			return this;
		}
		
		@Override
		@RosettaAttribute("callAmount")
		@RuneAttribute("callAmount")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCallAmount(BigDecimal _callAmount) {
			this.callAmount = _callAmount == null ? null : _callAmount;
			return this;
		}
		
		@Override
		@RosettaAttribute("putAmount")
		@RuneAttribute("putAmount")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPutAmount(BigDecimal _putAmount) {
			this.putAmount = _putAmount == null ? null : _putAmount;
			return this;
		}
		
		@Override
		@RosettaAttribute("callCurrency")
		@RuneAttribute("callCurrency")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCallCurrency(ISOCurrencyCodeEnum _callCurrency) {
			this.callCurrency = _callCurrency == null ? null : _callCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("putCurrency")
		@RuneAttribute("putCurrency")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPutCurrency(ISOCurrencyCodeEnum _putCurrency) {
			this.putCurrency = _putCurrency == null ? null : _putCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("priceSchedule")
		@RuneAttribute("priceSchedule")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addPriceSchedule(PricePeriod _priceSchedule) {
			if (_priceSchedule != null) {
				this.priceSchedule.add(_priceSchedule.toBuilder());
			}
			return this;
		}
		
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addPriceSchedule(PricePeriod _priceSchedule, int _idx) {
			getIndex(this.priceSchedule, _idx, () -> _priceSchedule.toBuilder());
			return this;
		}
		
		@Override 
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addPriceSchedule(List<? extends PricePeriod> priceSchedules) {
			if (priceSchedules != null) {
				for (final PricePeriod toAdd : priceSchedules) {
					this.priceSchedule.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("priceSchedule")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPriceSchedule(List<? extends PricePeriod> priceSchedules) {
			if (priceSchedules == null) {
				this.priceSchedule = new ArrayList<>();
			} else {
				this.priceSchedule = priceSchedules.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("strikePriceSchedule")
		@RuneAttribute("strikePriceSchedule")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addStrikePriceSchedule(PricePeriod _strikePriceSchedule) {
			if (_strikePriceSchedule != null) {
				this.strikePriceSchedule.add(_strikePriceSchedule.toBuilder());
			}
			return this;
		}
		
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addStrikePriceSchedule(PricePeriod _strikePriceSchedule, int _idx) {
			getIndex(this.strikePriceSchedule, _idx, () -> _strikePriceSchedule.toBuilder());
			return this;
		}
		
		@Override 
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addStrikePriceSchedule(List<? extends PricePeriod> strikePriceSchedules) {
			if (strikePriceSchedules != null) {
				for (final PricePeriod toAdd : strikePriceSchedules) {
					this.strikePriceSchedule.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("strikePriceSchedule")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setStrikePriceSchedule(List<? extends PricePeriod> strikePriceSchedules) {
			if (strikePriceSchedules == null) {
				this.strikePriceSchedule = new ArrayList<>();
			} else {
				this.strikePriceSchedule = strikePriceSchedules.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("price")
		@RuneAttribute("price")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPrice(PriceFormat _price) {
			this.price = _price == null ? null : _price.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("priceNotation")
		@RuneAttribute("priceNotation")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPriceNotation(PriceNotationEnum _priceNotation) {
			this.priceNotation = _priceNotation == null ? null : _priceNotation;
			return this;
		}
		
		@Override
		@RosettaAttribute("priceCurrency")
		@RuneAttribute("priceCurrency")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPriceCurrency(ISOCurrencyCodeEnum _priceCurrency) {
			this.priceCurrency = _priceCurrency == null ? null : _priceCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("packageTransactionPrice")
		@RuneAttribute("packageTransactionPrice")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPackageTransactionPrice(PriceFormat _packageTransactionPrice) {
			this.packageTransactionPrice = _packageTransactionPrice == null ? null : _packageTransactionPrice.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("packageTransactionPriceNotation")
		@RuneAttribute("packageTransactionPriceNotation")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPackageTransactionPriceNotation(PriceNotationEnum _packageTransactionPriceNotation) {
			this.packageTransactionPriceNotation = _packageTransactionPriceNotation == null ? null : _packageTransactionPriceNotation;
			return this;
		}
		
		@Override
		@RosettaAttribute("packageTransactionPriceCurrency")
		@RuneAttribute("packageTransactionPriceCurrency")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPackageTransactionPriceCurrency(ISOCurrencyCodeEnum _packageTransactionPriceCurrency) {
			this.packageTransactionPriceCurrency = _packageTransactionPriceCurrency == null ? null : _packageTransactionPriceCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("packageTransactionSpread")
		@RuneAttribute("packageTransactionSpread")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPackageTransactionSpread(PriceFormat _packageTransactionSpread) {
			this.packageTransactionSpread = _packageTransactionSpread == null ? null : _packageTransactionSpread.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("packageTransactionSpreadNotation")
		@RuneAttribute("packageTransactionSpreadNotation")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPackageTransactionSpreadNotation(PriceNotationEnum _packageTransactionSpreadNotation) {
			this.packageTransactionSpreadNotation = _packageTransactionSpreadNotation == null ? null : _packageTransactionSpreadNotation;
			return this;
		}
		
		@Override
		@RosettaAttribute("packageTransactionSpreadCurrency")
		@RuneAttribute("packageTransactionSpreadCurrency")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPackageTransactionSpreadCurrency(ISOCurrencyCodeEnum _packageTransactionSpreadCurrency) {
			this.packageTransactionSpreadCurrency = _packageTransactionSpreadCurrency == null ? null : _packageTransactionSpreadCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("strikePrice")
		@RuneAttribute("strikePrice")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setStrikePrice(PriceFormat _strikePrice) {
			this.strikePrice = _strikePrice == null ? null : _strikePrice.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("strikePriceNotation")
		@RuneAttribute("strikePriceNotation")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setStrikePriceNotation(PriceNotationEnum _strikePriceNotation) {
			this.strikePriceNotation = _strikePriceNotation == null ? null : _strikePriceNotation;
			return this;
		}
		
		@Override
		@RosettaAttribute("strikePriceCurrency")
		@RuneAttribute("strikePriceCurrency")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setStrikePriceCurrency(String _strikePriceCurrency) {
			this.strikePriceCurrency = _strikePriceCurrency == null ? null : _strikePriceCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("priceUnitOfMeasure")
		@RuneAttribute("priceUnitOfMeasure")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPriceUnitOfMeasure(String _priceUnitOfMeasure) {
			this.priceUnitOfMeasure = _priceUnitOfMeasure == null ? null : _priceUnitOfMeasure;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionPremiumAmount")
		@RuneAttribute("optionPremiumAmount")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setOptionPremiumAmount(BigDecimal _optionPremiumAmount) {
			this.optionPremiumAmount = _optionPremiumAmount == null ? null : _optionPremiumAmount;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionPremiumCurrency")
		@RuneAttribute("optionPremiumCurrency")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setOptionPremiumCurrency(ISOCurrencyCodeEnum _optionPremiumCurrency) {
			this.optionPremiumCurrency = _optionPremiumCurrency == null ? null : _optionPremiumCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionPremiumPaymentDate")
		@RuneAttribute("optionPremiumPaymentDate")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setOptionPremiumPaymentDate(Date _optionPremiumPaymentDate) {
			this.optionPremiumPaymentDate = _optionPremiumPaymentDate == null ? null : _optionPremiumPaymentDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdSIndexAttachmentPoint")
		@RuneAttribute("cdSIndexAttachmentPoint")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCdSIndexAttachmentPoint(BigDecimal _cdSIndexAttachmentPoint) {
			this.cdSIndexAttachmentPoint = _cdSIndexAttachmentPoint == null ? null : _cdSIndexAttachmentPoint;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdSIndexDetachmentPoint")
		@RuneAttribute("cdSIndexDetachmentPoint")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCdSIndexDetachmentPoint(BigDecimal _cdSIndexDetachmentPoint) {
			this.cdSIndexDetachmentPoint = _cdSIndexDetachmentPoint == null ? null : _cdSIndexDetachmentPoint;
			return this;
		}
		
		@Override
		@RosettaAttribute("collateralPortfolioIndicator")
		@RuneAttribute("collateralPortfolioIndicator")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCollateralPortfolioIndicator(Boolean _collateralPortfolioIndicator) {
			this.collateralPortfolioIndicator = _collateralPortfolioIndicator == null ? null : _collateralPortfolioIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("firstExerciseDate")
		@RuneAttribute("firstExerciseDate")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setFirstExerciseDate(Date _firstExerciseDate) {
			this.firstExerciseDate = _firstExerciseDate == null ? null : _firstExerciseDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("finalContractualSettlementDate")
		@RuneAttribute("finalContractualSettlementDate")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setFinalContractualSettlementDate(Date _finalContractualSettlementDate) {
			this.finalContractualSettlementDate = _finalContractualSettlementDate == null ? null : _finalContractualSettlementDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("otherPayment")
		@RuneAttribute("otherPayment")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addOtherPayment(OtherPayment _otherPayment) {
			if (_otherPayment != null) {
				this.otherPayment.add(_otherPayment.toBuilder());
			}
			return this;
		}
		
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addOtherPayment(OtherPayment _otherPayment, int _idx) {
			getIndex(this.otherPayment, _idx, () -> _otherPayment.toBuilder());
			return this;
		}
		
		@Override 
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addOtherPayment(List<? extends OtherPayment> otherPayments) {
			if (otherPayments != null) {
				for (final OtherPayment toAdd : otherPayments) {
					this.otherPayment.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("otherPayment")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setOtherPayment(List<? extends OtherPayment> otherPayments) {
			if (otherPayments == null) {
				this.otherPayment = new ArrayList<>();
			} else {
				this.otherPayment = otherPayments.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("leg1")
		@RuneAttribute("leg1")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setLeg1(CommonLeg _leg1) {
			this.leg1 = _leg1 == null ? null : _leg1.toBuilder();
			return this;
		}
		
		@Override
		@RosettaIgnore
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setLeg1(Leg _leg1) {
			final CommonLeg ifThenElseResult;
			if (_leg1 == null) {
				ifThenElseResult = null;
			} else {
				ifThenElseResult = _leg1 instanceof CommonLeg ? CommonLeg.class.cast(_leg1) : null;
			}
			return setLeg1(ifThenElseResult);
		}
		
		@Override
		@RosettaAttribute("leg2")
		@RuneAttribute("leg2")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setLeg2(CommonLeg _leg2) {
			this.leg2 = _leg2 == null ? null : _leg2.toBuilder();
			return this;
		}
		
		@Override
		@RosettaIgnore
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setLeg2(Leg _leg2) {
			final CommonLeg ifThenElseResult;
			if (_leg2 == null) {
				ifThenElseResult = null;
			} else {
				ifThenElseResult = _leg2 instanceof CommonLeg ? CommonLeg.class.cast(_leg2) : null;
			}
			return setLeg2(ifThenElseResult);
		}
		
		@Override
		@RosettaAttribute("counterparty2Name")
		@RuneAttribute("counterparty2Name")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCounterparty2Name(String _counterparty2Name) {
			this.counterparty2Name = _counterparty2Name == null ? null : _counterparty2Name;
			return this;
		}
		
		@Override
		@RosettaAttribute("executionAgentCounterparty1")
		@RuneAttribute("executionAgentCounterparty1")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setExecutionAgentCounterparty1(String _executionAgentCounterparty1) {
			this.executionAgentCounterparty1 = _executionAgentCounterparty1 == null ? null : _executionAgentCounterparty1;
			return this;
		}
		
		@Override
		@RosettaAttribute("executionAgentCounterparty2DTCC")
		@RuneAttribute("executionAgentCounterparty2DTCC")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setExecutionAgentCounterparty2DTCC(String _executionAgentCounterparty2DTCC) {
			this.executionAgentCounterparty2DTCC = _executionAgentCounterparty2DTCC == null ? null : _executionAgentCounterparty2DTCC;
			return this;
		}
		
		@Override
		@RosettaAttribute("reportSubmittingEntityID")
		@RuneAttribute("reportSubmittingEntityID")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setReportSubmittingEntityID(String _reportSubmittingEntityID) {
			this.reportSubmittingEntityID = _reportSubmittingEntityID == null ? null : _reportSubmittingEntityID;
			return this;
		}
		
		@Override
		@RosettaAttribute("uniqueTransactionIdentifier")
		@RuneAttribute("uniqueTransactionIdentifier")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setUniqueTransactionIdentifier(String _uniqueTransactionIdentifier) {
			this.uniqueTransactionIdentifier = _uniqueTransactionIdentifier == null ? null : _uniqueTransactionIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("uniqueTransactionIdentifierProprietary")
		@RuneAttribute("uniqueTransactionIdentifierProprietary")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setUniqueTransactionIdentifierProprietary(String _uniqueTransactionIdentifierProprietary) {
			this.uniqueTransactionIdentifierProprietary = _uniqueTransactionIdentifierProprietary == null ? null : _uniqueTransactionIdentifierProprietary;
			return this;
		}
		
		@Override
		@RosettaAttribute("priorUTI")
		@RuneAttribute("priorUTI")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPriorUTI(String _priorUTI) {
			this.priorUTI = _priorUTI == null ? null : _priorUTI;
			return this;
		}
		
		@Override
		@RosettaAttribute("priorUTIProprietary")
		@RuneAttribute("priorUTIProprietary")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPriorUTIProprietary(String _priorUTIProprietary) {
			this.priorUTIProprietary = _priorUTIProprietary == null ? null : _priorUTIProprietary;
			return this;
		}
		
		@Override
		@RosettaAttribute("uniqueProductIdentifier")
		@RuneAttribute("uniqueProductIdentifier")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setUniqueProductIdentifier(String _uniqueProductIdentifier) {
			this.uniqueProductIdentifier = _uniqueProductIdentifier == null ? null : _uniqueProductIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("contractType")
		@RuneAttribute("contractType")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setContractType(CommonContractType _contractType) {
			this.contractType = _contractType == null ? null : _contractType;
			return this;
		}
		
		@Override
		@RosettaAttribute("assetClass")
		@RuneAttribute("assetClass")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setAssetClass(CommonAssetClass _assetClass) {
			this.assetClass = _assetClass == null ? null : _assetClass;
			return this;
		}
		
		@Override
		@RosettaAttribute("clearingTimestamp")
		@RuneAttribute("clearingTimestamp")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setClearingTimestamp(ZonedDateTime _clearingTimestamp) {
			this.clearingTimestamp = _clearingTimestamp == null ? null : _clearingTimestamp;
			return this;
		}
		
		@Override
		@RosettaAttribute("platformIdentifier")
		@RuneAttribute("platformIdentifier")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPlatformIdentifier(String _platformIdentifier) {
			this.platformIdentifier = _platformIdentifier == null ? null : _platformIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("direction1")
		@RuneAttribute("direction1")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setDirection1(Direction1Enum _direction1) {
			this.direction1 = _direction1 == null ? null : _direction1;
			return this;
		}
		
		@Override
		@RosettaAttribute("direction2Leg1")
		@RuneAttribute("direction2Leg1")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setDirection2Leg1(Direction2Enum _direction2Leg1) {
			this.direction2Leg1 = _direction2Leg1 == null ? null : _direction2Leg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("direction2Leg2")
		@RuneAttribute("direction2Leg2")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setDirection2Leg2(Direction2Enum _direction2Leg2) {
			this.direction2Leg2 = _direction2Leg2 == null ? null : _direction2Leg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("packageIdentifier")
		@RuneAttribute("packageIdentifier")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPackageIdentifier(String _packageIdentifier) {
			this.packageIdentifier = _packageIdentifier == null ? null : _packageIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("barrier")
		@RuneAttribute("barrier")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setBarrier(SingleOrUpperAndLowerBarrier _barrier) {
			this.barrier = _barrier == null ? null : _barrier.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("exchangeRate")
		@RuneAttribute("exchangeRate")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setExchangeRate(BigDecimal _exchangeRate) {
			this.exchangeRate = _exchangeRate == null ? null : _exchangeRate;
			return this;
		}
		
		@Override
		@RosettaAttribute("exchangeRateBasis")
		@RuneAttribute("exchangeRateBasis")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setExchangeRateBasis(String _exchangeRateBasis) {
			this.exchangeRateBasis = _exchangeRateBasis == null ? null : _exchangeRateBasis;
			return this;
		}
		
		@Override
		@RosettaAttribute("nameOfTheUnderlyingIndex")
		@RuneAttribute("nameOfTheUnderlyingIndex")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setNameOfTheUnderlyingIndex(String _nameOfTheUnderlyingIndex) {
			this.nameOfTheUnderlyingIndex = _nameOfTheUnderlyingIndex == null ? null : _nameOfTheUnderlyingIndex;
			return this;
		}
		
		@Override
		@RosettaAttribute("basketConstituents")
		@RuneAttribute("basketConstituents")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addBasketConstituents(BasketConstituentsReport _basketConstituents) {
			if (_basketConstituents != null) {
				this.basketConstituents.add(_basketConstituents.toBuilder());
			}
			return this;
		}
		
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addBasketConstituents(BasketConstituentsReport _basketConstituents, int _idx) {
			getIndex(this.basketConstituents, _idx, () -> _basketConstituents.toBuilder());
			return this;
		}
		
		@Override 
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addBasketConstituents(List<? extends BasketConstituentsReport> basketConstituentss) {
			if (basketConstituentss != null) {
				for (final BasketConstituentsReport toAdd : basketConstituentss) {
					this.basketConstituents.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("basketConstituents")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setBasketConstituents(List<? extends BasketConstituentsReport> basketConstituentss) {
			if (basketConstituentss == null) {
				this.basketConstituents = new ArrayList<>();
			} else {
				this.basketConstituents = basketConstituentss.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("underlying")
		@RuneAttribute("underlying")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setUnderlying(UnderlyingIdentifier _underlying) {
			this.underlying = _underlying == null ? null : _underlying.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("quantityUnitOfMeasureLeg1")
		@RuneAttribute("quantityUnitOfMeasureLeg1")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setQuantityUnitOfMeasureLeg1(String _quantityUnitOfMeasureLeg1) {
			this.quantityUnitOfMeasureLeg1 = _quantityUnitOfMeasureLeg1 == null ? null : _quantityUnitOfMeasureLeg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("quantityUnitOfMeasureLeg2")
		@RuneAttribute("quantityUnitOfMeasureLeg2")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setQuantityUnitOfMeasureLeg2(String _quantityUnitOfMeasureLeg2) {
			this.quantityUnitOfMeasureLeg2 = _quantityUnitOfMeasureLeg2 == null ? null : _quantityUnitOfMeasureLeg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("maturityDateOfTheUnderlying")
		@RuneAttribute("maturityDateOfTheUnderlying")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setMaturityDateOfTheUnderlying(Date _maturityDateOfTheUnderlying) {
			this.maturityDateOfTheUnderlying = _maturityDateOfTheUnderlying == null ? null : _maturityDateOfTheUnderlying;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionType")
		@RuneAttribute("optionType")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setOptionType(OptionTypeCode _optionType) {
			this.optionType = _optionType == null ? null : _optionType;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionStyle")
		@RuneAttribute("optionStyle")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setOptionStyle(OptionStyleEnum _optionStyle) {
			this.optionStyle = _optionStyle == null ? null : _optionStyle;
			return this;
		}
		
		@Override
		@RosettaAttribute("deliveryType")
		@RuneAttribute("deliveryType")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setDeliveryType(DeliveryTypeEnum _deliveryType) {
			this.deliveryType = _deliveryType == null ? null : _deliveryType;
			return this;
		}
		
		@Override
		@RosettaAttribute("countryOfTheCounterparty2")
		@RuneAttribute("countryOfTheCounterparty2")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCountryOfTheCounterparty2(ISOCountryCodeEnum _countryOfTheCounterparty2) {
			this.countryOfTheCounterparty2 = _countryOfTheCounterparty2 == null ? null : _countryOfTheCounterparty2;
			return this;
		}
		
		@Override
		@RosettaAttribute("bookingLocation")
		@RuneAttribute("bookingLocation")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setBookingLocation(ISOCountryCodeEnum _bookingLocation) {
			this.bookingLocation = _bookingLocation == null ? null : _bookingLocation;
			return this;
		}
		
		@Override
		@RosettaAttribute("traderLocation")
		@RuneAttribute("traderLocation")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setTraderLocation(ISOCountryCodeEnum _traderLocation) {
			this.traderLocation = _traderLocation == null ? null : _traderLocation;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradingCapacity")
		@RuneAttribute("tradingCapacity")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setTradingCapacity(TradingCapacity7Code _tradingCapacity) {
			this.tradingCapacity = _tradingCapacity == null ? null : _tradingCapacity;
			return this;
		}
		
		@Override
		@RosettaAttribute("embeddedOptionType")
		@RuneAttribute("embeddedOptionType")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setEmbeddedOptionType(EmbeddedOptionTypeEnum _embeddedOptionType) {
			this.embeddedOptionType = _embeddedOptionType == null ? null : _embeddedOptionType;
			return this;
		}
		
		@Override
		@RosettaAttribute("seniority")
		@RuneAttribute("seniority")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setSeniority(SeniorityEnum _seniority) {
			this.seniority = _seniority == null ? null : _seniority;
			return this;
		}
		
		@Override
		@RosettaAttribute("series")
		@RuneAttribute("series")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setSeries(Integer _series) {
			this.series = _series == null ? null : _series;
			return this;
		}
		
		@Override
		@RosettaAttribute("indexFactor")
		@RuneAttribute("indexFactor")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setIndexFactor(BigDecimal _indexFactor) {
			this.indexFactor = _indexFactor == null ? null : _indexFactor;
			return this;
		}
		
		@Override
		@RosettaAttribute("technicalRecordId")
		@RuneAttribute("technicalRecordId")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setTechnicalRecordId(String _technicalRecordId) {
			this.technicalRecordId = _technicalRecordId == null ? null : _technicalRecordId;
			return this;
		}
		
		@Override
		@RosettaAttribute("counterparty2IdentifierSource")
		@RuneAttribute("counterparty2IdentifierSource")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCounterparty2IdentifierSource(Counterparty2IdentifierEnum _counterparty2IdentifierSource) {
			this.counterparty2IdentifierSource = _counterparty2IdentifierSource == null ? null : _counterparty2IdentifierSource;
			return this;
		}
		
		@Override
		@RosettaAttribute("customBasketIndicator")
		@RuneAttribute("customBasketIndicator")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCustomBasketIndicator(Boolean _customBasketIndicator) {
			this.customBasketIndicator = _customBasketIndicator == null ? null : _customBasketIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("amendmentIndicator")
		@RuneAttribute("amendmentIndicator")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setAmendmentIndicator(Boolean _amendmentIndicator) {
			this.amendmentIndicator = _amendmentIndicator == null ? null : _amendmentIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("packageIndicator")
		@RuneAttribute("packageIndicator")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPackageIndicator(Boolean _packageIndicator) {
			this.packageIndicator = _packageIndicator == null ? null : _packageIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("postPricedSwapIndicator")
		@RuneAttribute("postPricedSwapIndicator")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPostPricedSwapIndicator(Boolean _postPricedSwapIndicator) {
			this.postPricedSwapIndicator = _postPricedSwapIndicator == null ? null : _postPricedSwapIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("settlementLocationLeg1")
		@RuneAttribute("settlementLocationLeg1")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setSettlementLocationLeg1(ISOCountryCodeEnum _settlementLocationLeg1) {
			this.settlementLocationLeg1 = _settlementLocationLeg1 == null ? null : _settlementLocationLeg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("settlementLocationLeg2")
		@RuneAttribute("settlementLocationLeg2")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setSettlementLocationLeg2(ISOCountryCodeEnum _settlementLocationLeg2) {
			this.settlementLocationLeg2 = _settlementLocationLeg2 == null ? null : _settlementLocationLeg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("nonStandardizedTermIndicator")
		@RuneAttribute("nonStandardizedTermIndicator")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setNonStandardizedTermIndicator(Boolean _nonStandardizedTermIndicator) {
			this.nonStandardizedTermIndicator = _nonStandardizedTermIndicator == null ? null : _nonStandardizedTermIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("blockTradeElectionIndicator")
		@RuneAttribute("blockTradeElectionIndicator")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setBlockTradeElectionIndicator(Boolean _blockTradeElectionIndicator) {
			this.blockTradeElectionIndicator = _blockTradeElectionIndicator == null ? null : _blockTradeElectionIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("primeBrokerageTransactionIndicator")
		@RuneAttribute("primeBrokerageTransactionIndicator")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPrimeBrokerageTransactionIndicator(Boolean _primeBrokerageTransactionIndicator) {
			this.primeBrokerageTransactionIndicator = _primeBrokerageTransactionIndicator == null ? null : _primeBrokerageTransactionIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("uniqueSwapIdentifier")
		@RuneAttribute("uniqueSwapIdentifier")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setUniqueSwapIdentifier(String _uniqueSwapIdentifier) {
			this.uniqueSwapIdentifier = _uniqueSwapIdentifier == null ? null : _uniqueSwapIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("cftcGuidebook")
		@RuneAttribute("cftcGuidebook")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCftcGuidebook(CFTCGuidebook _cftcGuidebook) {
			this.cftcGuidebook = _cftcGuidebook == null ? null : _cftcGuidebook.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("nonReportable")
		@RuneAttribute("nonReportable")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setNonReportable(CFTCNonReportablePart45 _nonReportable) {
			this.nonReportable = _nonReportable == null ? null : _nonReportable.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("clearingAccountOrigin")
		@RuneAttribute("clearingAccountOrigin")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setClearingAccountOrigin(ClearingAccountOriginEnum _clearingAccountOrigin) {
			this.clearingAccountOrigin = _clearingAccountOrigin == null ? null : _clearingAccountOrigin;
			return this;
		}
		
		@Override
		@RosettaAttribute("clearingSwapUSIs")
		@RuneAttribute("clearingSwapUSIs")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addClearingSwapUSIs(String _clearingSwapUSIs) {
			if (_clearingSwapUSIs != null) {
				this.clearingSwapUSIs.add(_clearingSwapUSIs);
			}
			return this;
		}
		
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addClearingSwapUSIs(String _clearingSwapUSIs, int _idx) {
			getIndex(this.clearingSwapUSIs, _idx, () -> _clearingSwapUSIs);
			return this;
		}
		
		@Override 
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addClearingSwapUSIs(List<String> clearingSwapUSIss) {
			if (clearingSwapUSIss != null) {
				for (final String toAdd : clearingSwapUSIss) {
					this.clearingSwapUSIs.add(toAdd);
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("clearingSwapUSIs")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setClearingSwapUSIs(List<String> clearingSwapUSIss) {
			if (clearingSwapUSIss == null) {
				this.clearingSwapUSIs = new ArrayList<>();
			} else {
				this.clearingSwapUSIs = clearingSwapUSIss.stream()
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("clearingSwapUTIs")
		@RuneAttribute("clearingSwapUTIs")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addClearingSwapUTIs(String _clearingSwapUTIs) {
			if (_clearingSwapUTIs != null) {
				this.clearingSwapUTIs.add(_clearingSwapUTIs);
			}
			return this;
		}
		
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addClearingSwapUTIs(String _clearingSwapUTIs, int _idx) {
			getIndex(this.clearingSwapUTIs, _idx, () -> _clearingSwapUTIs);
			return this;
		}
		
		@Override 
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addClearingSwapUTIs(List<String> clearingSwapUTIss) {
			if (clearingSwapUTIss != null) {
				for (final String toAdd : clearingSwapUTIss) {
					this.clearingSwapUTIs.add(toAdd);
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("clearingSwapUTIs")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setClearingSwapUTIs(List<String> clearingSwapUTIss) {
			if (clearingSwapUTIss == null) {
				this.clearingSwapUTIs = new ArrayList<>();
			} else {
				this.clearingSwapUTIs = clearingSwapUTIss.stream()
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("originalSwapUSI")
		@RuneAttribute("originalSwapUSI")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setOriginalSwapUSI(String _originalSwapUSI) {
			this.originalSwapUSI = _originalSwapUSI == null ? null : _originalSwapUSI;
			return this;
		}
		
		@Override
		@RosettaAttribute("originalSwapUTI")
		@RuneAttribute("originalSwapUTI")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setOriginalSwapUTI(String _originalSwapUTI) {
			this.originalSwapUTI = _originalSwapUTI == null ? null : _originalSwapUTI;
			return this;
		}
		
		@Override
		@RosettaAttribute("originalSwapSDRIdentifier")
		@RuneAttribute("originalSwapSDRIdentifier")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setOriginalSwapSDRIdentifier(String _originalSwapSDRIdentifier) {
			this.originalSwapSDRIdentifier = _originalSwapSDRIdentifier == null ? null : _originalSwapSDRIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("clearingReceiptTimestamp")
		@RuneAttribute("clearingReceiptTimestamp")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setClearingReceiptTimestamp(ZonedDateTime _clearingReceiptTimestamp) {
			this.clearingReceiptTimestamp = _clearingReceiptTimestamp == null ? null : _clearingReceiptTimestamp;
			return this;
		}
		
		@Override
		@RosettaAttribute("clearingExceptionsAndExemptionsCounterparty1")
		@RuneAttribute("clearingExceptionsAndExemptionsCounterparty1")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(ClearingExceptionsAndExemptionsEnum _clearingExceptionsAndExemptionsCounterparty1) {
			if (_clearingExceptionsAndExemptionsCounterparty1 != null) {
				this.clearingExceptionsAndExemptionsCounterparty1.add(_clearingExceptionsAndExemptionsCounterparty1);
			}
			return this;
		}
		
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(ClearingExceptionsAndExemptionsEnum _clearingExceptionsAndExemptionsCounterparty1, int _idx) {
			getIndex(this.clearingExceptionsAndExemptionsCounterparty1, _idx, () -> _clearingExceptionsAndExemptionsCounterparty1);
			return this;
		}
		
		@Override 
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty1(List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty1s) {
			if (clearingExceptionsAndExemptionsCounterparty1s != null) {
				for (final ClearingExceptionsAndExemptionsEnum toAdd : clearingExceptionsAndExemptionsCounterparty1s) {
					this.clearingExceptionsAndExemptionsCounterparty1.add(toAdd);
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("clearingExceptionsAndExemptionsCounterparty1")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setClearingExceptionsAndExemptionsCounterparty1(List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty1s) {
			if (clearingExceptionsAndExemptionsCounterparty1s == null) {
				this.clearingExceptionsAndExemptionsCounterparty1 = new ArrayList<>();
			} else {
				this.clearingExceptionsAndExemptionsCounterparty1 = clearingExceptionsAndExemptionsCounterparty1s.stream()
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("clearingExceptionsAndExemptionsCounterparty2")
		@RuneAttribute("clearingExceptionsAndExemptionsCounterparty2")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(ClearingExceptionsAndExemptionsEnum _clearingExceptionsAndExemptionsCounterparty2) {
			if (_clearingExceptionsAndExemptionsCounterparty2 != null) {
				this.clearingExceptionsAndExemptionsCounterparty2.add(_clearingExceptionsAndExemptionsCounterparty2);
			}
			return this;
		}
		
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(ClearingExceptionsAndExemptionsEnum _clearingExceptionsAndExemptionsCounterparty2, int _idx) {
			getIndex(this.clearingExceptionsAndExemptionsCounterparty2, _idx, () -> _clearingExceptionsAndExemptionsCounterparty2);
			return this;
		}
		
		@Override 
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder addClearingExceptionsAndExemptionsCounterparty2(List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty2s) {
			if (clearingExceptionsAndExemptionsCounterparty2s != null) {
				for (final ClearingExceptionsAndExemptionsEnum toAdd : clearingExceptionsAndExemptionsCounterparty2s) {
					this.clearingExceptionsAndExemptionsCounterparty2.add(toAdd);
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("clearingExceptionsAndExemptionsCounterparty2")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setClearingExceptionsAndExemptionsCounterparty2(List<ClearingExceptionsAndExemptionsEnum> clearingExceptionsAndExemptionsCounterparty2s) {
			if (clearingExceptionsAndExemptionsCounterparty2s == null) {
				this.clearingExceptionsAndExemptionsCounterparty2 = new ArrayList<>();
			} else {
				this.clearingExceptionsAndExemptionsCounterparty2 = clearingExceptionsAndExemptionsCounterparty2s.stream()
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("counterparty1FinancialEntityIndicator")
		@RuneAttribute("counterparty1FinancialEntityIndicator")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCounterparty1FinancialEntityIndicator(Boolean _counterparty1FinancialEntityIndicator) {
			this.counterparty1FinancialEntityIndicator = _counterparty1FinancialEntityIndicator == null ? null : _counterparty1FinancialEntityIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("counterparty2FinancialEntityIndicator")
		@RuneAttribute("counterparty2FinancialEntityIndicator")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCounterparty2FinancialEntityIndicator(Boolean _counterparty2FinancialEntityIndicator) {
			this.counterparty2FinancialEntityIndicator = _counterparty2FinancialEntityIndicator == null ? null : _counterparty2FinancialEntityIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("buyerIdentifier")
		@RuneAttribute("buyerIdentifier")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setBuyerIdentifier(String _buyerIdentifier) {
			this.buyerIdentifier = _buyerIdentifier == null ? null : _buyerIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("sellerIdentifier")
		@RuneAttribute("sellerIdentifier")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setSellerIdentifier(String _sellerIdentifier) {
			this.sellerIdentifier = _sellerIdentifier == null ? null : _sellerIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("payerIdentifierLeg1")
		@RuneAttribute("payerIdentifierLeg1")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPayerIdentifierLeg1(String _payerIdentifierLeg1) {
			this.payerIdentifierLeg1 = _payerIdentifierLeg1 == null ? null : _payerIdentifierLeg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("payerIdentifierLeg2")
		@RuneAttribute("payerIdentifierLeg2")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPayerIdentifierLeg2(String _payerIdentifierLeg2) {
			this.payerIdentifierLeg2 = _payerIdentifierLeg2 == null ? null : _payerIdentifierLeg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("receiverIdentifierLeg1")
		@RuneAttribute("receiverIdentifierLeg1")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setReceiverIdentifierLeg1(String _receiverIdentifierLeg1) {
			this.receiverIdentifierLeg1 = _receiverIdentifierLeg1 == null ? null : _receiverIdentifierLeg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("receiverIdentifierLeg2")
		@RuneAttribute("receiverIdentifierLeg2")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setReceiverIdentifierLeg2(String _receiverIdentifierLeg2) {
			this.receiverIdentifierLeg2 = _receiverIdentifierLeg2 == null ? null : _receiverIdentifierLeg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("counterparty1FederalEntityIndicator")
		@RuneAttribute("counterparty1FederalEntityIndicator")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCounterparty1FederalEntityIndicator(Boolean _counterparty1FederalEntityIndicator) {
			this.counterparty1FederalEntityIndicator = _counterparty1FederalEntityIndicator == null ? null : _counterparty1FederalEntityIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("counterparty2FederalEntityIndicator")
		@RuneAttribute("counterparty2FederalEntityIndicator")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setCounterparty2FederalEntityIndicator(Boolean _counterparty2FederalEntityIndicator) {
			this.counterparty2FederalEntityIndicator = _counterparty2FederalEntityIndicator == null ? null : _counterparty2FederalEntityIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("allocationIndicator")
		@RuneAttribute("allocationIndicator")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setAllocationIndicator(AllocationIndicatorEnum _allocationIndicator) {
			this.allocationIndicator = _allocationIndicator == null ? null : _allocationIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("priorUSI")
		@RuneAttribute("priorUSI")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setPriorUSI(String _priorUSI) {
			this.priorUSI = _priorUSI == null ? null : _priorUSI;
			return this;
		}
		
		@Override
		@RosettaAttribute("jurisdiction")
		@RuneAttribute("jurisdiction")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setJurisdiction(JurisdictionEnum _jurisdiction) {
			this.jurisdiction = _jurisdiction == null ? null : _jurisdiction;
			return this;
		}
		
		@Override
		@RosettaAttribute("newSDRIdentifier")
		@RuneAttribute("newSDRIdentifier")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setNewSDRIdentifier(String _newSDRIdentifier) {
			this.newSDRIdentifier = _newSDRIdentifier == null ? null : _newSDRIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("initialMarginCollateralPortfolioCode")
		@RuneAttribute("initialMarginCollateralPortfolioCode")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setInitialMarginCollateralPortfolioCode(String _initialMarginCollateralPortfolioCode) {
			this.initialMarginCollateralPortfolioCode = _initialMarginCollateralPortfolioCode == null ? null : _initialMarginCollateralPortfolioCode;
			return this;
		}
		
		@Override
		@RosettaAttribute("variationMarginCollateralPortfolioCode")
		@RuneAttribute("variationMarginCollateralPortfolioCode")
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder setVariationMarginCollateralPortfolioCode(String _variationMarginCollateralPortfolioCode) {
			this.variationMarginCollateralPortfolioCode = _variationMarginCollateralPortfolioCode == null ? null : _variationMarginCollateralPortfolioCode;
			return this;
		}
		
		@Override
		public CFTCPart45TransactionReport build() {
			return new CFTCPart45TransactionReport.CFTCPart45TransactionReportImpl(this);
		}
		
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder prune() {
			super.prune();
			if (nonReportable!=null && !nonReportable.prune().hasData()) nonReportable = null;
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (super.hasData()) return true;
			if (getNonReportable()!=null && getNonReportable().hasData()) return true;
			if (getClearingAccountOrigin()!=null) return true;
			if (getClearingSwapUSIs()!=null && !getClearingSwapUSIs().isEmpty()) return true;
			if (getClearingSwapUTIs()!=null && !getClearingSwapUTIs().isEmpty()) return true;
			if (getOriginalSwapUSI()!=null) return true;
			if (getOriginalSwapUTI()!=null) return true;
			if (getOriginalSwapSDRIdentifier()!=null) return true;
			if (getClearingReceiptTimestamp()!=null) return true;
			if (getClearingExceptionsAndExemptionsCounterparty1()!=null && !getClearingExceptionsAndExemptionsCounterparty1().isEmpty()) return true;
			if (getClearingExceptionsAndExemptionsCounterparty2()!=null && !getClearingExceptionsAndExemptionsCounterparty2().isEmpty()) return true;
			if (getCounterparty1FinancialEntityIndicator()!=null) return true;
			if (getCounterparty2FinancialEntityIndicator()!=null) return true;
			if (getBuyerIdentifier()!=null) return true;
			if (getSellerIdentifier()!=null) return true;
			if (getPayerIdentifierLeg1()!=null) return true;
			if (getPayerIdentifierLeg2()!=null) return true;
			if (getReceiverIdentifierLeg1()!=null) return true;
			if (getReceiverIdentifierLeg2()!=null) return true;
			if (getCounterparty1FederalEntityIndicator()!=null) return true;
			if (getCounterparty2FederalEntityIndicator()!=null) return true;
			if (getAllocationIndicator()!=null) return true;
			if (getPriorUSI()!=null) return true;
			if (getJurisdiction()!=null) return true;
			if (getNewSDRIdentifier()!=null) return true;
			if (getInitialMarginCollateralPortfolioCode()!=null) return true;
			if (getVariationMarginCollateralPortfolioCode()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			super.merge(other, merger);
			
			CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder o = (CFTCPart45TransactionReport.CFTCPart45TransactionReportBuilder) other;
			
			merger.mergeRosetta(getNonReportable(), o.getNonReportable(), this::setNonReportable);
			
			merger.mergeBasic(getClearingAccountOrigin(), o.getClearingAccountOrigin(), this::setClearingAccountOrigin);
			merger.mergeBasic(getClearingSwapUSIs(), o.getClearingSwapUSIs(), (Consumer<String>) this::addClearingSwapUSIs);
			merger.mergeBasic(getClearingSwapUTIs(), o.getClearingSwapUTIs(), (Consumer<String>) this::addClearingSwapUTIs);
			merger.mergeBasic(getOriginalSwapUSI(), o.getOriginalSwapUSI(), this::setOriginalSwapUSI);
			merger.mergeBasic(getOriginalSwapUTI(), o.getOriginalSwapUTI(), this::setOriginalSwapUTI);
			merger.mergeBasic(getOriginalSwapSDRIdentifier(), o.getOriginalSwapSDRIdentifier(), this::setOriginalSwapSDRIdentifier);
			merger.mergeBasic(getClearingReceiptTimestamp(), o.getClearingReceiptTimestamp(), this::setClearingReceiptTimestamp);
			merger.mergeBasic(getClearingExceptionsAndExemptionsCounterparty1(), o.getClearingExceptionsAndExemptionsCounterparty1(), (Consumer<ClearingExceptionsAndExemptionsEnum>) this::addClearingExceptionsAndExemptionsCounterparty1);
			merger.mergeBasic(getClearingExceptionsAndExemptionsCounterparty2(), o.getClearingExceptionsAndExemptionsCounterparty2(), (Consumer<ClearingExceptionsAndExemptionsEnum>) this::addClearingExceptionsAndExemptionsCounterparty2);
			merger.mergeBasic(getCounterparty1FinancialEntityIndicator(), o.getCounterparty1FinancialEntityIndicator(), this::setCounterparty1FinancialEntityIndicator);
			merger.mergeBasic(getCounterparty2FinancialEntityIndicator(), o.getCounterparty2FinancialEntityIndicator(), this::setCounterparty2FinancialEntityIndicator);
			merger.mergeBasic(getBuyerIdentifier(), o.getBuyerIdentifier(), this::setBuyerIdentifier);
			merger.mergeBasic(getSellerIdentifier(), o.getSellerIdentifier(), this::setSellerIdentifier);
			merger.mergeBasic(getPayerIdentifierLeg1(), o.getPayerIdentifierLeg1(), this::setPayerIdentifierLeg1);
			merger.mergeBasic(getPayerIdentifierLeg2(), o.getPayerIdentifierLeg2(), this::setPayerIdentifierLeg2);
			merger.mergeBasic(getReceiverIdentifierLeg1(), o.getReceiverIdentifierLeg1(), this::setReceiverIdentifierLeg1);
			merger.mergeBasic(getReceiverIdentifierLeg2(), o.getReceiverIdentifierLeg2(), this::setReceiverIdentifierLeg2);
			merger.mergeBasic(getCounterparty1FederalEntityIndicator(), o.getCounterparty1FederalEntityIndicator(), this::setCounterparty1FederalEntityIndicator);
			merger.mergeBasic(getCounterparty2FederalEntityIndicator(), o.getCounterparty2FederalEntityIndicator(), this::setCounterparty2FederalEntityIndicator);
			merger.mergeBasic(getAllocationIndicator(), o.getAllocationIndicator(), this::setAllocationIndicator);
			merger.mergeBasic(getPriorUSI(), o.getPriorUSI(), this::setPriorUSI);
			merger.mergeBasic(getJurisdiction(), o.getJurisdiction(), this::setJurisdiction);
			merger.mergeBasic(getNewSDRIdentifier(), o.getNewSDRIdentifier(), this::setNewSDRIdentifier);
			merger.mergeBasic(getInitialMarginCollateralPortfolioCode(), o.getInitialMarginCollateralPortfolioCode(), this::setInitialMarginCollateralPortfolioCode);
			merger.mergeBasic(getVariationMarginCollateralPortfolioCode(), o.getVariationMarginCollateralPortfolioCode(), this::setVariationMarginCollateralPortfolioCode);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
			if (!super.equals(o)) return false;
		
			CFTCPart45TransactionReport _that = getType().cast(o);
		
			if (!Objects.equals(nonReportable, _that.getNonReportable())) return false;
			if (!Objects.equals(clearingAccountOrigin, _that.getClearingAccountOrigin())) return false;
			if (!ListEquals.listEquals(clearingSwapUSIs, _that.getClearingSwapUSIs())) return false;
			if (!ListEquals.listEquals(clearingSwapUTIs, _that.getClearingSwapUTIs())) return false;
			if (!Objects.equals(originalSwapUSI, _that.getOriginalSwapUSI())) return false;
			if (!Objects.equals(originalSwapUTI, _that.getOriginalSwapUTI())) return false;
			if (!Objects.equals(originalSwapSDRIdentifier, _that.getOriginalSwapSDRIdentifier())) return false;
			if (!Objects.equals(clearingReceiptTimestamp, _that.getClearingReceiptTimestamp())) return false;
			if (!ListEquals.listEquals(clearingExceptionsAndExemptionsCounterparty1, _that.getClearingExceptionsAndExemptionsCounterparty1())) return false;
			if (!ListEquals.listEquals(clearingExceptionsAndExemptionsCounterparty2, _that.getClearingExceptionsAndExemptionsCounterparty2())) return false;
			if (!Objects.equals(counterparty1FinancialEntityIndicator, _that.getCounterparty1FinancialEntityIndicator())) return false;
			if (!Objects.equals(counterparty2FinancialEntityIndicator, _that.getCounterparty2FinancialEntityIndicator())) return false;
			if (!Objects.equals(buyerIdentifier, _that.getBuyerIdentifier())) return false;
			if (!Objects.equals(sellerIdentifier, _that.getSellerIdentifier())) return false;
			if (!Objects.equals(payerIdentifierLeg1, _that.getPayerIdentifierLeg1())) return false;
			if (!Objects.equals(payerIdentifierLeg2, _that.getPayerIdentifierLeg2())) return false;
			if (!Objects.equals(receiverIdentifierLeg1, _that.getReceiverIdentifierLeg1())) return false;
			if (!Objects.equals(receiverIdentifierLeg2, _that.getReceiverIdentifierLeg2())) return false;
			if (!Objects.equals(counterparty1FederalEntityIndicator, _that.getCounterparty1FederalEntityIndicator())) return false;
			if (!Objects.equals(counterparty2FederalEntityIndicator, _that.getCounterparty2FederalEntityIndicator())) return false;
			if (!Objects.equals(allocationIndicator, _that.getAllocationIndicator())) return false;
			if (!Objects.equals(priorUSI, _that.getPriorUSI())) return false;
			if (!Objects.equals(jurisdiction, _that.getJurisdiction())) return false;
			if (!Objects.equals(newSDRIdentifier, _that.getNewSDRIdentifier())) return false;
			if (!Objects.equals(initialMarginCollateralPortfolioCode, _that.getInitialMarginCollateralPortfolioCode())) return false;
			if (!Objects.equals(variationMarginCollateralPortfolioCode, _that.getVariationMarginCollateralPortfolioCode())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = super.hashCode();
			_result = 31 * _result + (nonReportable != null ? nonReportable.hashCode() : 0);
			_result = 31 * _result + (clearingAccountOrigin != null ? clearingAccountOrigin.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (clearingSwapUSIs != null ? clearingSwapUSIs.hashCode() : 0);
			_result = 31 * _result + (clearingSwapUTIs != null ? clearingSwapUTIs.hashCode() : 0);
			_result = 31 * _result + (originalSwapUSI != null ? originalSwapUSI.hashCode() : 0);
			_result = 31 * _result + (originalSwapUTI != null ? originalSwapUTI.hashCode() : 0);
			_result = 31 * _result + (originalSwapSDRIdentifier != null ? originalSwapSDRIdentifier.hashCode() : 0);
			_result = 31 * _result + (clearingReceiptTimestamp != null ? clearingReceiptTimestamp.hashCode() : 0);
			_result = 31 * _result + (clearingExceptionsAndExemptionsCounterparty1 != null ? clearingExceptionsAndExemptionsCounterparty1.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
			_result = 31 * _result + (clearingExceptionsAndExemptionsCounterparty2 != null ? clearingExceptionsAndExemptionsCounterparty2.stream().map(Object::getClass).map(Class::getName).mapToInt(String::hashCode).sum() : 0);
			_result = 31 * _result + (counterparty1FinancialEntityIndicator != null ? counterparty1FinancialEntityIndicator.hashCode() : 0);
			_result = 31 * _result + (counterparty2FinancialEntityIndicator != null ? counterparty2FinancialEntityIndicator.hashCode() : 0);
			_result = 31 * _result + (buyerIdentifier != null ? buyerIdentifier.hashCode() : 0);
			_result = 31 * _result + (sellerIdentifier != null ? sellerIdentifier.hashCode() : 0);
			_result = 31 * _result + (payerIdentifierLeg1 != null ? payerIdentifierLeg1.hashCode() : 0);
			_result = 31 * _result + (payerIdentifierLeg2 != null ? payerIdentifierLeg2.hashCode() : 0);
			_result = 31 * _result + (receiverIdentifierLeg1 != null ? receiverIdentifierLeg1.hashCode() : 0);
			_result = 31 * _result + (receiverIdentifierLeg2 != null ? receiverIdentifierLeg2.hashCode() : 0);
			_result = 31 * _result + (counterparty1FederalEntityIndicator != null ? counterparty1FederalEntityIndicator.hashCode() : 0);
			_result = 31 * _result + (counterparty2FederalEntityIndicator != null ? counterparty2FederalEntityIndicator.hashCode() : 0);
			_result = 31 * _result + (allocationIndicator != null ? allocationIndicator.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (priorUSI != null ? priorUSI.hashCode() : 0);
			_result = 31 * _result + (jurisdiction != null ? jurisdiction.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (newSDRIdentifier != null ? newSDRIdentifier.hashCode() : 0);
			_result = 31 * _result + (initialMarginCollateralPortfolioCode != null ? initialMarginCollateralPortfolioCode.hashCode() : 0);
			_result = 31 * _result + (variationMarginCollateralPortfolioCode != null ? variationMarginCollateralPortfolioCode.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "CFTCPart45TransactionReportBuilder {" +
				"nonReportable=" + this.nonReportable + ", " +
				"clearingAccountOrigin=" + this.clearingAccountOrigin + ", " +
				"clearingSwapUSIs=" + this.clearingSwapUSIs + ", " +
				"clearingSwapUTIs=" + this.clearingSwapUTIs + ", " +
				"originalSwapUSI=" + this.originalSwapUSI + ", " +
				"originalSwapUTI=" + this.originalSwapUTI + ", " +
				"originalSwapSDRIdentifier=" + this.originalSwapSDRIdentifier + ", " +
				"clearingReceiptTimestamp=" + this.clearingReceiptTimestamp + ", " +
				"clearingExceptionsAndExemptionsCounterparty1=" + this.clearingExceptionsAndExemptionsCounterparty1 + ", " +
				"clearingExceptionsAndExemptionsCounterparty2=" + this.clearingExceptionsAndExemptionsCounterparty2 + ", " +
				"counterparty1FinancialEntityIndicator=" + this.counterparty1FinancialEntityIndicator + ", " +
				"counterparty2FinancialEntityIndicator=" + this.counterparty2FinancialEntityIndicator + ", " +
				"buyerIdentifier=" + this.buyerIdentifier + ", " +
				"sellerIdentifier=" + this.sellerIdentifier + ", " +
				"payerIdentifierLeg1=" + this.payerIdentifierLeg1 + ", " +
				"payerIdentifierLeg2=" + this.payerIdentifierLeg2 + ", " +
				"receiverIdentifierLeg1=" + this.receiverIdentifierLeg1 + ", " +
				"receiverIdentifierLeg2=" + this.receiverIdentifierLeg2 + ", " +
				"counterparty1FederalEntityIndicator=" + this.counterparty1FederalEntityIndicator + ", " +
				"counterparty2FederalEntityIndicator=" + this.counterparty2FederalEntityIndicator + ", " +
				"allocationIndicator=" + this.allocationIndicator + ", " +
				"priorUSI=" + this.priorUSI + ", " +
				"jurisdiction=" + this.jurisdiction + ", " +
				"newSDRIdentifier=" + this.newSDRIdentifier + ", " +
				"initialMarginCollateralPortfolioCode=" + this.initialMarginCollateralPortfolioCode + ", " +
				"variationMarginCollateralPortfolioCode=" + this.variationMarginCollateralPortfolioCode +
			'}' + " " + super.toString();
		}
	}
}
