package drr.regulation.cftc.rewrite;

import cdm.base.staticdata.asset.common.ISOCountryCodeEnum;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RosettaIgnore;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import drr.regulation.cftc.rewrite.CFTCGuidebook;
import drr.regulation.cftc.rewrite.CFTCGuidebook.CFTCGuidebookBuilder;
import drr.regulation.cftc.rewrite.CFTCTransactionReport;
import drr.regulation.cftc.rewrite.CFTCTransactionReport.CFTCTransactionReportBuilder;
import drr.regulation.cftc.rewrite.CFTCTransactionReport.CFTCTransactionReportBuilderImpl;
import drr.regulation.cftc.rewrite.CFTCTransactionReport.CFTCTransactionReportImpl;
import drr.regulation.cftc.rewrite.meta.CFTCTransactionReportMeta;
import drr.regulation.common.CommonAssetClass;
import drr.regulation.common.CommonContractType;
import drr.regulation.common.Counterparty2IdentifierEnum;
import drr.regulation.common.trade.CommonLeg;
import drr.regulation.common.trade.CommonLeg.CommonLegBuilder;
import drr.regulation.common.trade.CommonTransactionReport;
import drr.regulation.common.trade.CommonTransactionReport.CommonTransactionReportBuilder;
import drr.regulation.common.trade.CommonTransactionReport.CommonTransactionReportBuilderImpl;
import drr.regulation.common.trade.CommonTransactionReport.CommonTransactionReportImpl;
import drr.regulation.common.trade.basket.BasketConstituentsReport;
import drr.regulation.common.trade.basket.BasketConstituentsReport.BasketConstituentsReportBuilder;
import drr.regulation.common.trade.contract.UnderlyingIdentifier;
import drr.regulation.common.trade.contract.UnderlyingIdentifier.UnderlyingIdentifierBuilder;
import drr.regulation.common.trade.price.SingleOrUpperAndLowerBarrier;
import drr.regulation.common.trade.price.SingleOrUpperAndLowerBarrier.SingleOrUpperAndLowerBarrierBuilder;
import drr.standards.iosco.cde.Leg;
import drr.standards.iosco.cde.payment.OtherPayment;
import drr.standards.iosco.cde.payment.OtherPayment.OtherPaymentBuilder;
import drr.standards.iosco.cde.price.PriceFormat;
import drr.standards.iosco.cde.price.PriceFormat.PriceFormatBuilder;
import drr.standards.iosco.cde.price.PriceNotationEnum;
import drr.standards.iosco.cde.price.PricePeriod;
import drr.standards.iosco.cde.price.PricePeriod.PricePeriodBuilder;
import drr.standards.iso.ActionTypeEnum;
import drr.standards.iso.ClearedEnum;
import drr.standards.iso.ConfirmationEnum;
import drr.standards.iso.DeliveryTypeEnum;
import drr.standards.iso.Direction1Enum;
import drr.standards.iso.Direction2Enum;
import drr.standards.iso.EmbeddedOptionTypeEnum;
import drr.standards.iso.EventTypeEnum;
import drr.standards.iso.OptionStyleEnum;
import drr.standards.iso.OptionTypeCode;
import drr.standards.iso.SeniorityEnum;
import drr.standards.iso.TradingCapacity7Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

import static java.util.Optional.ofNullable;

/**
 * @version 6.0.0-dev.128
 */
@RosettaDataType(value="CFTCTransactionReport", builder=CFTCTransactionReport.CFTCTransactionReportBuilderImpl.class, version="6.0.0-dev.128")
@RuneDataType(value="CFTCTransactionReport", model="drr", builder=CFTCTransactionReport.CFTCTransactionReportBuilderImpl.class, version="6.0.0-dev.128")
public interface CFTCTransactionReport extends CommonTransactionReport {

	CFTCTransactionReportMeta metaData = new CFTCTransactionReportMeta();

	/*********************** Getter Methods  ***********************/
	/**
	 *
	 * Body CFTC
	 * Corpus Regulation Part45 CFTC 17 CFR Parts 45 Version 3.0 "Part 45 of the CFTCs regulations specifies the Commissions swap data recordkeeping and reporting requirements, pursuant to section 2(a)(13)(G) of the Commodity Exchange Act (CEA), which states that all swaps, whether cleared or uncleared, must be reported to a Swap Data Repository (SDR)" 
	 * appendix "1" * dataElement "15" * field "Counterparty 2 Identifier Source"
	 *
	 * Provision Source used to identify the Counterparty 2.
	 *
	 *
	 * Body CFTC
	 * Corpus Regulation Part45_V3_1 CFTC 17 CFR Parts 45 Version 3.1 "Part 45 of the CFTCs regulations specifies the Commissions swap data recordkeeping and reporting requirements, pursuant to section 2(a)(13)(G) of the Commodity Exchange Act (CEA), which states that all swaps, whether cleared or uncleared, must be reported to a Swap Data Repository (SDR).The modifications address 14 data elements for several swap data reporting topics including: clearing, counterparty identification, price, valuation, collateral and margin, and transaction-related data fields." 
	 * appendix "1" * dataElement "15" * field "Counterparty 2 Identifier Source" * footnote "28"
	 *
	 * Provision Throughout this Technical Specification, for references to 'Privacy Law Identifiers', refer to DMO Letter No. 17-16, http://www.cftc.gov/idc/groups/public/@lrlettergeneral/documents/letter/17-16.pdf
	 *
	 */
	Counterparty2IdentifierEnum getCounterparty2IdentifierSource();
	/**
	 *
	 * Body CFTC
	 * Corpus Regulation Part45 CFTC 17 CFR Parts 45 Version 3.0 "Part 45 of the CFTCs regulations specifies the Commissions swap data recordkeeping and reporting requirements, pursuant to section 2(a)(13)(G) of the Commodity Exchange Act (CEA), which states that all swaps, whether cleared or uncleared, must be reported to a Swap Data Repository (SDR)" 
	 * appendix "1" * dataElement "25" * field "Custom Basket Indicator"
	 *
	 * Provision Indicator of whether the swap transaction is based on a custom basket.
	 *
	 *
	 * Body ISDA
	 * Corpus WorkingGroup USComplianceGroup US Compliance Working Group "This is an ISDA US Working Group." 
	 * date "20220429"
	 *
	 * Provision The US Compliance WG agree on this consistent definition for reporting #25 Custom Basket Indicator. The definition can be used for all 5 asset classes. For purposes of reporting Custom Basket Indicator (CFTC #25), market participants generally refer to a trade as being a custom basket if it is tailored for a specific client, either by the client, by the Swap Dealer, or by both, where the weightings, constituents, roll schedules, etc., are agreed bilaterally with the client and are customized for that specific client. Custom baskets can be in any of the 5 asset classes, which is also reflected in CFTCs validation rule for #25.
	 *
	 */
	Boolean getCustomBasketIndicator();
	/**
	 *
	 * Body CFTC
	 * Corpus Regulation Part45 CFTC 17 CFR Parts 45 Version 3.0 "Part 45 of the CFTCs regulations specifies the Commissions swap data recordkeeping and reporting requirements, pursuant to section 2(a)(13)(G) of the Commodity Exchange Act (CEA), which states that all swaps, whether cleared or uncleared, must be reported to a Swap Data Repository (SDR)" 
	 * appendix "1" * dataElement "28" * field "Amendment Indicator"
	 *
	 * Provision Indicator of whether the modification of the swap transaction reflects newly agreed upon term(s) from the previously negotiated terms.
	 *
	 */
	Boolean getAmendmentIndicator();
	/**
	 *
	 * Body CFTC
	 * Corpus Regulation Part45 CFTC 17 CFR Parts 45 Version 3.0 "Part 45 of the CFTCs regulations specifies the Commissions swap data recordkeeping and reporting requirements, pursuant to section 2(a)(13)(G) of the Commodity Exchange Act (CEA), which states that all swaps, whether cleared or uncleared, must be reported to a Swap Data Repository (SDR)" 
	 * appendix "1" * dataElement "45" * field "Package Indicator"
	 *
	 * Provision Indicator of whether the swap transaction is part of a package transaction.
	 *
	 */
	Boolean getPackageIndicator();
	/**
	 *
	 * Body CFTC
	 * Corpus Regulation Part45 CFTC 17 CFR Parts 45 Version 3.0 "Part 45 of the CFTCs regulations specifies the Commissions swap data recordkeeping and reporting requirements, pursuant to section 2(a)(13)(G) of the Commodity Exchange Act (CEA), which states that all swaps, whether cleared or uncleared, must be reported to a Swap Data Repository (SDR)" 
	 * appendix "1" * dataElement "68" * field "Post-priced Swap Indicator"
	 *
	 * Provision Indicator of whether the swap transaction satisfies the definition of 'post-priced swap' in  43.2(a) of the Commission's regulations.
	 *
	 *
	 * Body CFTC
	 * Corpus Regulation Part45_V3_1 CFTC 17 CFR Parts 45 Version 3.1 "Part 45 of the CFTCs regulations specifies the Commissions swap data recordkeeping and reporting requirements, pursuant to section 2(a)(13)(G) of the Commodity Exchange Act (CEA), which states that all swaps, whether cleared or uncleared, must be reported to a Swap Data Repository (SDR).The modifications address 14 data elements for several swap data reporting topics including: clearing, counterparty identification, price, valuation, collateral and margin, and transaction-related data fields." 
	 * appendix "1" * dataElement "68" * field "Post-priced Swap Indicator" * footnote "59"
	 *
	 * Provision For transactions where the swap price is not known at the time to execution, those unknown swap price-related fields can be reported as blank until such time that the price is known.
	 *
	 */
	Boolean getPostPricedSwapIndicator();
	/**
	 *
	 * Body CFTC
	 * Corpus Regulation Part45 CFTC 17 CFR Parts 45 Version 3.0 "Part 45 of the CFTCs regulations specifies the Commissions swap data recordkeeping and reporting requirements, pursuant to section 2(a)(13)(G) of the Commodity Exchange Act (CEA), which states that all swaps, whether cleared or uncleared, must be reported to a Swap Data Repository (SDR)" 
	 * appendix "1" * dataElement "90" * field "Settlement Location Leg 1"
	 *
	 * Provision Place of settlement of the transaction as stipulated in the contract. This data element is only applicable for transactions that involve an offshore currency (i.e. a currency which is not included in the ISO 4217 currency list, for example CNH).
	 *
	 *
	 * Body CFTC
	 * Corpus Regulation Part45_V3_1 CFTC 17 CFR Parts 45 Version 3.1 "Part 45 of the CFTCs regulations specifies the Commissions swap data recordkeeping and reporting requirements, pursuant to section 2(a)(13)(G) of the Commodity Exchange Act (CEA), which states that all swaps, whether cleared or uncleared, must be reported to a Swap Data Repository (SDR).The modifications address 14 data elements for several swap data reporting topics including: clearing, counterparty identification, price, valuation, collateral and margin, and transaction-related data fields." 
	 * appendix "1" * dataElement "90" * field "Settlement Location Leg 1" * footnote "69"
	 *
	 * Provision CFTC requires ISO country code to be reported using two-letter code (alpha-2).
	 *
	 */
	ISOCountryCodeEnum getSettlementLocationLeg1();
	/**
	 *
	 * Body CFTC
	 * Corpus Regulation Part45 CFTC 17 CFR Parts 45 Version 3.0 "Part 45 of the CFTCs regulations specifies the Commissions swap data recordkeeping and reporting requirements, pursuant to section 2(a)(13)(G) of the Commodity Exchange Act (CEA), which states that all swaps, whether cleared or uncleared, must be reported to a Swap Data Repository (SDR)" 
	 * appendix "1" * dataElement "90" * field "Settlement Location Leg 2"
	 *
	 * Provision Place of settlement of the transaction as stipulated in the contract. This data element is only applicable for transactions that involve an offshore currency (i.e. a currency which is not included in the ISO 4217 currency list, for example CNH).
	 *
	 *
	 * Body CFTC
	 * Corpus Regulation Part45_V3_1 CFTC 17 CFR Parts 45 Version 3.1 "Part 45 of the CFTCs regulations specifies the Commissions swap data recordkeeping and reporting requirements, pursuant to section 2(a)(13)(G) of the Commodity Exchange Act (CEA), which states that all swaps, whether cleared or uncleared, must be reported to a Swap Data Repository (SDR).The modifications address 14 data elements for several swap data reporting topics including: clearing, counterparty identification, price, valuation, collateral and margin, and transaction-related data fields." 
	 * appendix "1" * dataElement "90" * field "Settlement Location Leg 2" * footnote "69"
	 *
	 * Provision CFTC requires ISO country code to be reported using two-letter code (alpha-2).
	 *
	 */
	ISOCountryCodeEnum getSettlementLocationLeg2();
	/**
	 *
	 * Body CFTC
	 * Corpus Regulation Part45 CFTC 17 CFR Parts 45 Version 3.0 "Part 45 of the CFTCs regulations specifies the Commissions swap data recordkeeping and reporting requirements, pursuant to section 2(a)(13)(G) of the Commodity Exchange Act (CEA), which states that all swaps, whether cleared or uncleared, must be reported to a Swap Data Repository (SDR)" 
	 * appendix "1" * dataElement "92" * field "Non-standardized Term Indicator"
	 *
	 * Provision Indicator of whether the swap transaction has one or more additional term(s) or provision(s), other than those disseminated to the public pursuant to part 43, that materially affect(s) the price of the swap transaction.
	 *
	 */
	Boolean getNonStandardizedTermIndicator();
	/**
	 *
	 * Body CFTC
	 * Corpus Regulation Part45 CFTC 17 CFR Parts 45 Version 3.0 "Part 45 of the CFTCs regulations specifies the Commissions swap data recordkeeping and reporting requirements, pursuant to section 2(a)(13)(G) of the Commodity Exchange Act (CEA), which states that all swaps, whether cleared or uncleared, must be reported to a Swap Data Repository (SDR)" 
	 * appendix "1" * dataElement "93" * field "Block Trade Election Indicator"
	 *
	 * Provision Indicator of whether an election has been made to report the swap transaction as a block transaction by the reporting counterparty or as calculated by either the swap data repository acting on behalf of the reporting counterparty or by using a third party.
	 *
	 *
	 * Body ISDA
	 * Corpus WorkingGroup ISDAWorkingGroup ISDA Working Group "This is an ISDA Working Group." 
	 * date "20220420"
	 *
	 * Provision If blockTradeIndicator is not present then report as false
	 *
	 */
	Boolean getBlockTradeElectionIndicator();
	Boolean getPrimeBrokerageTransactionIndicator();
	/**
	 *
	 * Body CFTC
	 * Corpus Regulation Part45 CFTC 17 CFR Parts 45 Version 3.0 "Part 45 of the CFTCs regulations specifies the Commissions swap data recordkeeping and reporting requirements, pursuant to section 2(a)(13)(G) of the Commodity Exchange Act (CEA), which states that all swaps, whether cleared or uncleared, must be reported to a Swap Data Repository (SDR)" 
	 * appendix "1" * dataElement "102" * field "Unique Swap Identifier (USI)"
	 *
	 * Provision The USI is a unique identifier assigned to all swap transactions which identifies the transaction (the swap and its counterparties) uniquely throughout its duration. It consists of a namespace and a transaction identifier.
	 *
	 *
	 * Body CFTC
	 * Corpus Regulation Part45_V3_1 CFTC 17 CFR Parts 45 Version 3.1 "Part 45 of the CFTCs regulations specifies the Commissions swap data recordkeeping and reporting requirements, pursuant to section 2(a)(13)(G) of the Commodity Exchange Act (CEA), which states that all swaps, whether cleared or uncleared, must be reported to a Swap Data Repository (SDR).The modifications address 14 data elements for several swap data reporting topics including: clearing, counterparty identification, price, valuation, collateral and margin, and transaction-related data fields." 
	 * appendix "1" * dataElement "102" * field "Unique Swap Identifier (USI)" * footnote "76"
	 *
	 * Provision Throughout this Technical Specification, references to 'CFTC USI Data Standard' should refer to the USI Data Standard, https://www.cftc.gov/sites/default/files/idc/groups/public/@swaps/documents/dfsubmission/usidatastandards100112.pdf
	 *
	 *
	 * Body ISDA
	 * Corpus WorkingGroup PeerReviewGroup ISDA EMIR/CFTC Digital Regulatory Reporting Peer Review "Industry group which works collaboratively to mutualize representation of amended CFTC and EMIR transaction reporting requirements in Digital Regulatory Reporting (DRR) - a digitized, single standard set of open-source machine-executable code using the Common Domain Model (CDM)." 
	 * date "20220309"
	 *
	 * Provision Rule does not model UTI > USI priority defined in CFTC specification.
	 *
	 *
	 * Body ISDA
	 * Corpus WorkingGroup PeerReviewGroup ISDA EMIR/CFTC Digital Regulatory Reporting Peer Review "Industry group which works collaboratively to mutualize representation of amended CFTC and EMIR transaction reporting requirements in Digital Regulatory Reporting (DRR) - a digitized, single standard set of open-source machine-executable code using the Common Domain Model (CDM)." 
	 * date "20220309"
	 *
	 * Provision Firms do expect to report USI/UTI in both formats: as a single identifier field as well as using Issuer + identifier. The functional model needs to handle both scenarios.
	 *
	 */
	String getUniqueSwapIdentifier();
	/**
	 *
	 * messageType
	 * Body CFTC
	 * Corpus Guidance Guidebook_Extension CFTC Guidebook "Document to specify additional fields required by TR for Part 45" 
	 * table "Table_Ref1" * field "Message Type"
	 *
	 * Provision ***
	 *
	 *
	 * messageType
	 * Body CFTC
	 * Corpus Specifications DTCC_Specs DTCC Specs "Document providing the message specifications required for inbound message for DTCC for CFTC rewrite" 
	 * table "Table_Ref1" * field "Message Type"
	 *
	 * Provision Need to indicate what message is being submitted to GTR
	 *
	 *
	 * messageType
	 * Body CFTC
	 * Corpus Specifications CME_Specs CME Specs "Document providing the message specifications required for inbound message for CME for CFTC rewrite" 
	 * table "Table_Ref1" * field "Submission type"
	 *
	 * Provision An indication of whether the submission meets the requirements of Part 43 or Part 45
	 *
	 *
	 * optionType
	 * Body CFTC
	 * Corpus Guidance Guidebook_Extension CFTC Guidebook "Document to specify additional fields required by TR for Part 45" 
	 * table "Table_Ref1" * field "Option Type"
	 *
	 * Provision TBC with SDR: Indication as to whether the derivative contract is a call (right to purchase a specific underlying asset) or a put (right to sell a specific underlying asset) or whether it cannot be determined whether it is a call or a put at the time of execution of the derivative contract.
	             In case of swaptions it shall be:
	                 - Put, in case of receiver swaption, in which the buyer has the right to enter into a swap as a fixed-rate receiver.
	                 -Call, in case of payer swaption, in which the buyer has the right to enter into a swap as a fixed-rate payer.
	             In case of Caps and Floors it shall be:
	                 -Put, in case of a Floor.
	                 -Call, in case of a Cap
	 *
	 *
	 * optionType
	 * Body CFTC
	 * Corpus Specifications DTCC_Specs DTCC Specs "Document providing the message specifications required for inbound message for DTCC for CFTC rewrite" 
	 * table "Table_Ref1" * field "Option Type"
	 *
	 * Provision The type of option reported.
	 *
	 *
	 * optionType
	 * Body CFTC
	 * Corpus Specifications CME_Specs CME Specs "Document providing the message specifications required for inbound message for CME for CFTC rewrite" 
	 * table "Table_Ref1" * field "Option type"
	 *
	 * Provision Specifies whether an option gives the buyer the right to buy the underlying, ie Call, the right to sell the underlying, ie Sell, or the right to choose whether to buy or sell the underlying at the time of exercise, ie Chooser 
	 *
	 *
	 * optionStyle
	 * Body CFTC
	 * Corpus Guidance Guidebook_Extension CFTC Guidebook "Document to specify additional fields required by TR for Part 45" 
	 * table "Table_Ref1" * field "Option Style"
	 *
	 * Provision TBC with SDR: - Indicates whether the option may be exercised only at a fixed date (European), a series of pre-specified dates (Bermudan) or at any time during the life of the contract (American).
	 *
	 *
	 * optionStyle
	 * Body CFTC
	 * Corpus Specifications DTCC_Specs DTCC Specs "Document providing the message specifications required for inbound message for DTCC for CFTC rewrite" 
	 * table "Table_Ref1" * field "Option Style"
	 *
	 * Provision Need field to determine exercise dates. 
	 *
	 *
	 * optionStyle
	 * Body CFTC
	 * Corpus Specifications CME_Specs CME Specs "Document providing the message specifications required for inbound message for CME for CFTC rewrite" 
	 * table "Table_Ref1" * field "Option style"
	 *
	 * Provision Specifies when an option can be exercised. The value European specifies that an option can only be exercised on the expiration date; American specifies that an option can be exercised any time up to and including on the expiration date; and Bermudan specifies that an option can be exercised only at specified times during the life of the contract. Bermudan-style options include variations such as Canary- and Verde-style options.
	 *
	 *
	 * optionStyle
	 * Body ISDA
	 * Corpus BestPractice EMIRReportingBestPractice 24Apr2024 "The EMIR Reporting Best Practices cover 238 data points across 203 reporting fields, including both over-the-counter and exchange-traded derivatives, and were developed to improve the accuracy and efficiency of trade reporting and to reduce compliance costs. The best practices are available to all market participants to access and implement.  The EMIR Reporting Best Practices is a cross-trade association initiative developed jointly by the European Fund and Asset Management Association (EFAMA), European Venues and Intermediaries Association (EVIA), Futures Industry Association (FIA), German Investment Funds Association (BVI), Global Foreign Exchange Division (GFXD), International Swaps and Derivatives Association, Inc. (ISDA) and Investment Association (IA)." 
	 * table "2" * field "79"
	 *
	 * Provision For Caps and Floors, populated with E(European). Reasoning for CapFloors to be reported as E is that such products would report field 2.1  (Contract Type) as OP and therefore it is required to populate the Option exercise style. While a CapFloor would not have an exercise style, there is no option to report Other. Therefore, best practice is be to report as European E.
	 *
	 *
	 * assetClass
	 * Body CFTC
	 * Corpus Guidance Guidebook_Extension CFTC Guidebook "Document to specify additional fields required by TR for Part 45" 
	 * table "TBC" * field "Asset Class"
	 *
	 * Provision COMM = Commodity and emission allowancesCRDT = CreditCURR = CurrencyEQUI = EquityINTR = Interest Rate
	 *
	 *
	 * assetClass
	 * Body ESMA
	 * Corpus QandAOnEMIRReporting QandA_On_EMIR_Reporting ESMA70-1861941480-52 "Questions and Answers. Implementation of the Regulation (EU) No 648/2012 on OTC derivatives, central counterparties and trade repositories (EMIR)" 
	 * section "TR" * question "1"
	 *
	 * Provision TR Question 1 [last update 24 September 2020] How should the following financial instruments be classified for reporting and other purposes under EMIR? (b) Cross-currency swaps, swaptions, Caps and Floors? (c) Total Return Swaps
	                 TR Answer 1 (b) These financial instruments should be classified as interest rates, in line with current market practice. On the sections to be reported, ESMA finds that where both sections are relevant having in mind the terms of the contract being reported, both sections of reporting fields are to be reported i.e.option and interest rate for swaption, Caps and Floors, and FX and interest rate or crosscurrency swaps. The contract type (Field 1 of Table 2) should be populated with the value ST for swaption.There are two fields for the notional amount currency and one for the notional amount. To avoid that one counterparty reports the notional amount in CCY1 (Field 9 of Table 2) while the other would report in CCY2 (Field 10 of Table 2), which would create a reconciliation problem, the Field Notional Amount (Field 20 of Table 2) should be denominated in the currency reported in Notional currency 1 (Field 9 of Table 2).
	             (c) Total Return Swaps should be classified based on the underlying. For example, a Total Return Swap on an equity index should be reported with value EQ in field Asset class (Table 2 field 2), whereas a Total Return Swap on a bond or loan should be reported with value CR in field Asset class (Table 2 field 2).
	 *
	 *
	 * assetClass
	 * Body DTCC
	 * Corpus Specifications DTCC_Specs DTCC Specs "Document providing the message specifications required for inbound message for DTCC for CFTC rewrite" 
	 * table "Table_Ref1" * field "Primary Asset Class"
	 *
	 * Provision Needed for GTR processing to derive validation based on ISDA taxonomy 
	 *
	 *
	 * assetClass
	 * Body CME
	 * Corpus Specifications CME_Specs CME Specs "Document providing the message specifications required for inbound message for CME for CFTC rewrite" 
	 * table "Table_Ref1" * field "Asset Class"
	 *
	 * Provision Indicates whether the asset, benchmark or another derivatives contract underlying a derivatives contract is, or references, an equity, rate, credit, commodity or foreign exchange asset.
	 *
	 *
	 * mandatoryClearingIndicator
	 * Body CFTC
	 * Corpus Guidance Guidebook_Extension CFTC Guidebook "Document to specify additional fields required by TR for Part 45" 
	 * table "Table_Ref1" * field "Mandatory Clearing Indicator"
	 *
	 * Provision TBC with SDR: 
	 *
	 *
	 * mandatoryClearingIndicator
	 * Body CFTC
	 * Corpus Specifications DTCC_Specs DTCC Specs "Document providing the message specifications required for inbound message for DTCC for CFTC rewrite" 
	 * table "Table_Ref1" * field "Mandatory Clearing Indicator"
	 *
	 * Provision An indicator of whether the transaction is subject to mandatory clearing.
	 *
	 *
	 * mandatoryClearingIndicator
	 * Body CFTC
	 * Corpus Specifications CME_Specs CME Specs "Document providing the message specifications required for inbound message for CME for CFTC rewrite" 
	 * table "Table_Ref1" * field "Mandatory Clearing Indicator"
	 *
	 * Provision An indicator of whether the transaction is subject to mandatory clearing 
	 *
	 *
	 * maturityDateOfTheUnderlier
	 * Body CFTC
	 * Corpus Guidance Guidebook_Extension CFTC Guidebook "Document to specify additional fields required by TR for Part 45" 
	 * table "Table_Ref1" * field "***"
	 *
	 * Provision TBC with SDR: - ***.
	 *
	 *
	 * maturityDateOfTheUnderlier
	 * Body CFTC
	 * Corpus Specifications DTCC_Specs DTCC Specs "Document providing the message specifications required for inbound message for DTCC for CFTC rewrite" 
	 * table "Table_Ref1" * field "Maturity Date of the Underlying"
	 *
	 * Provision The date on which the underlying transaction settles if the option is exercised.
	 *
	 *
	 * maturityDateOfTheUnderlier
	 * Body CFTC
	 * Corpus Specifications CME_Specs CME Specs "Document providing the message specifications required for inbound message for CME for CFTC rewrite" 
	 * table "Table_Ref1" * field "Maturity Date of the Underlier"
	 *
	 * Provision Necessary to fully describe a swaption.
	 *
	 *
	 * largeNotionalOffFacilitySwapElectionIndicator
	 * Body CFTC
	 * Corpus Guidance Guidebook_Extension CFTC Guidebook "Document to specify additional fields required by TR for Part 45" 
	 * table "Table_Ref1" * field "Large notional off-facility swap election indicator"
	 *
	 * Provision ***
	 *
	 *
	 * largeNotionalOffFacilitySwapElectionIndicator
	 * Body CFTC
	 * Corpus Specifications DTCC_Specs DTCC Specs "Document providing the message specifications required for inbound message for DTCC for CFTC rewrite" 
	 * table "Table_Ref1" * field "Large notional off-facility swap election indicator"
	 *
	 * Provision Indicator of whether an election has been made to report the swap transaction as a Large Notional Off-facility Swap by the reporting counterparty or as calculated by either the swap data repository acting on behalf of the reporting counterparty or by using a third party.
	 *
	 *
	 * largeNotionalOffFacilitySwapElectionIndicator
	 * Body CFTC
	 * Corpus Specifications CME_Specs CME Specs "Document providing the message specifications required for inbound message for CME for CFTC rewrite" 
	 * table "Table_Ref1" * field "Large notional off-facility swap election indicator"
	 *
	 * Provision Indicator of whether an election has been made to report the swap transaction as a Large Notional Off-facility Swap by the reporting counterparty or as calculated by either the swap data repository acting on behalf of the reporting counterparty or by using a third party
	 *
	 *
	 * sefOrDcmIndicator
	 * Body CFTC
	 * Corpus Guidance Guidebook_Extension CFTC Guidebook "Document to specify additional fields required by TR for Part 45" 
	 * table "Table_Ref1" * field "SEF or DCM indicator"
	 *
	 * Provision ***
	 *
	 *
	 * sefOrDcmIndicator
	 * Body CFTC
	 * Corpus Specifications DTCC_Specs DTCC Specs "Document providing the message specifications required for inbound message for DTCC for CFTC rewrite" 
	 * table "Table_Ref1" * field "SEF or DCM Indicator"
	 *
	 * Provision An indication of whether the swap was executed on or pursuant to the rules of a swap execution facility or designated contract market.
	 *
	 *
	 * sefOrDcmIndicator
	 * Body CFTC
	 * Corpus Specifications CME_Specs CME Specs "Document providing the message specifications required for inbound message for CME for CFTC rewrite" 
	 * table "Table_Ref1" * field "SEF or DCM Identification"
	 *
	 * Provision An indication of whether the swap was executed on or pursuant to the rules of a swap execution facility or designated contract market.
	 *
	 *
	 * sefOrDcmAnonymousExecutionIndicator
	 * Body CFTC
	 * Corpus Guidance Guidebook_Extension CFTC Guidebook "Document to specify additional fields required by TR for Part 45" 
	 * table "Table_Ref1" * field "SEF or DCM Anonymous Execution Indicator"
	 *
	 * Provision Indicator of whether the swap was executed anonymously on a SEF or DCM. When set to true, counterparty details will be masked on reporting.
	 *
	 *
	 * sefOrDcmAnonymousExecutionIndicator
	 * Body CFTC
	 * Corpus Specifications DTCC_Specs DTCC Specs "Document providing the message specifications required for inbound message for DTCC for CFTC rewrite" 
	 * table "Table_Ref1" * field "SEF or DCM Anonymous Execution Indicator"
	 *
	 * Provision Indicator of whether the swap was executed anonymously on a SEF or DCM. When set to true, counterparty details will be masked on reporting.
	 *
	 *
	 * sefOrDcmAnonymousExecutionIndicator
	 * Body CFTC
	 * Corpus Specifications CME_Specs CME Specs "Document providing the message specifications required for inbound message for CME for CFTC rewrite" 
	 * table "Table_Ref1" * field "AnonymousExecutionIndicator"
	 *
	 * Provision An indicator of whether the swap was executed anonymously on a SEF or DCM
	 *
	 *
	 * Body CFTC
	 * Corpus Guidance Guidebook_Extension CFTC Guidebook "Document to specify additional fields required by TR for Part 45" 
	 * table "Table_Ref1" * field "***"
	 *
	 * Provision TBC with SDR: - ***.
	 *
	 *
	 * Body CFTC
	 * Corpus Specifications DTCC_Specs DTCC Specs "Document providing the message specifications required for inbound message for DTCC for CFTC rewrite" 
	 * table "Table_Ref1" * field "Settlement Type"
	 *
	 * Provision Needed to satisfy conditionality for Settlement Currency.
	 *
	 *
	 * Body CFTC
	 * Corpus Specifications CME_Specs CME Specs "Document providing the message specifications required for inbound message for CME for CFTC rewrite" 
	 * table "Table_Ref1" * field "Delivery type"
	 *
	 * Provision Indicates whether a derivatives contract will deliver a physical asset or a cash equivalent at settlement.
	 *
	 *
	 * sdMspIndicatorParty1
	 * Body CFTC
	 * Corpus Guidance Guidebook_Extension CFTC Guidebook "Document to specify additional fields required by TR for Part 45" 
	 * table "Table_Ref1" * field "SD MSP indicator - Counterparty 1"
	 *
	 * Provision ***
	 *
	 *
	 * sdMspIndicatorParty1
	 * Body CFTC
	 * Corpus Specifications DTCC_Specs DTCC Specs "Document providing the message specifications required for inbound message for DTCC for CFTC rewrite" 
	 * table "Table_Ref1" * field "SD MSP indicator - Counterparty 1"
	 *
	 * Provision Indicator of whether counteparty 1 is SD or MSP.
	 *
	 *
	 * sdMspIndicatorParty1
	 * Body CFTC
	 * Corpus Specifications CME_Specs CME Specs "Document providing the message specifications required for inbound message for CME for CFTC rewrite" 
	 * table "Table_Ref1" * field "SD MSP Indicator Counterparty 1"
	 *
	 * Provision Indicator RP is SD or MSP
	 *
	 *
	 * sdMspIndicatorParty2
	 * Body CFTC
	 * Corpus Guidance Guidebook_Extension CFTC Guidebook "Document to specify additional fields required by TR for Part 45" 
	 * table "Table_Ref1" * field "SD MSP indicator - Counterparty 2"
	 *
	 * Provision ***
	 *
	 *
	 * sdMspIndicatorParty2
	 * Body CFTC
	 * Corpus Specifications DTCC_Specs DTCC Specs "Document providing the message specifications required for inbound message for DTCC for CFTC rewrite" 
	 * table "Table_Ref1" * field "SD MSP indicator - Counterparty 2"
	 *
	 * Provision Indicator of whether counteparty 2 is SD or MSP.
	 *
	 *
	 * sdMspIndicatorParty2
	 * Body CFTC
	 * Corpus Specifications CME_Specs CME Specs "Document providing the message specifications required for inbound message for CME for CFTC rewrite" 
	 * table "Table_Ref1" * field "SD MSP Indicator Counterparty 2"
	 *
	 * Provision Indicator Non-RP is SD or MSP
	 *
	 *
	 * physicalCommodityIndicator
	 * Body CFTC
	 * Corpus Guidance Guidebook_Extension CFTC Guidebook "Document to specify additional fields required by TR for Part 45" 
	 * table "Table_Ref1" * field "Physical commodity contract indicator"
	 *
	 * Provision ***
	 *
	 *
	 * physicalCommodityIndicator
	 * Body CFTC
	 * Corpus Specifications DTCC_Specs DTCC Specs "Document providing the message specifications required for inbound message for DTCC for CFTC rewrite" 
	 * table "Table_Ref1" * field "Physical commodity contract indicator"
	 *
	 * Provision An indication of whether or not the trade being submitted: (1) references one of the contracts described in Appendix B to part 43; or (2) is economically related to one of the contracts described in Appendix B to part 43
	 *
	 *
	 * physicalCommodityIndicator
	 * Body CFTC
	 * Corpus Specifications CME_Specs CME Specs "Document providing the message specifications required for inbound message for CME for CFTC rewrite" 
	 * table "Table_Ref1" * field "Physical commodity contract indicator"
	 *
	 * Provision Indicates whether or not the trade being submitted (1) references one of the contracts described in appendix B to part 43; or (2) is economically related to one of the contracts described in appendix B to part 43
	 *
	 */
	CFTCGuidebook getCftcGuidebook();

	/*********************** Build Methods  ***********************/
	CFTCTransactionReport build();
	
	CFTCTransactionReport.CFTCTransactionReportBuilder toBuilder();
	
	static CFTCTransactionReport.CFTCTransactionReportBuilder builder() {
		return new CFTCTransactionReport.CFTCTransactionReportBuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends CFTCTransactionReport> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends CFTCTransactionReport> getType() {
		return CFTCTransactionReport.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("actionType"), ActionTypeEnum.class, getActionType(), this);
		processor.processBasic(path.newSubPath("eventType"), EventTypeEnum.class, getEventType(), this);
		processor.processBasic(path.newSubPath("eventIdentifier"), String.class, getEventIdentifier(), this);
		processor.processBasic(path.newSubPath("effectiveDate"), Date.class, getEffectiveDate(), this);
		processor.processBasic(path.newSubPath("earlyTerminationDate"), Date.class, getEarlyTerminationDate(), this);
		processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, getEventTimestamp(), this);
		processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, getReportingTimestamp(), this);
		processor.processBasic(path.newSubPath("executionTimestamp"), ZonedDateTime.class, getExecutionTimestamp(), this);
		processor.processBasic(path.newSubPath("expirationDate"), Date.class, getExpirationDate(), this);
		processor.processBasic(path.newSubPath("counterparty1"), String.class, getCounterparty1(), this);
		processor.processBasic(path.newSubPath("counterparty2"), String.class, getCounterparty2(), this);
		processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, getCounterparty2IdentifierType(), this);
		processor.processBasic(path.newSubPath("beneficiary1"), String.class, getBeneficiary1(), this);
		processor.processBasic(path.newSubPath("beneficiary1IdentifierTypeIndicator"), Boolean.class, getBeneficiary1IdentifierTypeIndicator(), this);
		processor.processBasic(path.newSubPath("cleared"), ClearedEnum.class, getCleared(), this);
		processor.processBasic(path.newSubPath("centralCounterparty"), String.class, getCentralCounterparty(), this);
		processor.processBasic(path.newSubPath("clearingMember"), String.class, getClearingMember(), this);
		processor.processBasic(path.newSubPath("confirmed"), ConfirmationEnum.class, getConfirmed(), this);
		processor.processBasic(path.newSubPath("callAmount"), BigDecimal.class, getCallAmount(), this);
		processor.processBasic(path.newSubPath("putAmount"), BigDecimal.class, getPutAmount(), this);
		processor.processBasic(path.newSubPath("callCurrency"), ISOCurrencyCodeEnum.class, getCallCurrency(), this);
		processor.processBasic(path.newSubPath("putCurrency"), ISOCurrencyCodeEnum.class, getPutCurrency(), this);
		processRosetta(path.newSubPath("priceSchedule"), processor, PricePeriod.class, getPriceSchedule());
		processRosetta(path.newSubPath("strikePriceSchedule"), processor, PricePeriod.class, getStrikePriceSchedule());
		processRosetta(path.newSubPath("price"), processor, PriceFormat.class, getPrice());
		processor.processBasic(path.newSubPath("priceNotation"), PriceNotationEnum.class, getPriceNotation(), this);
		processor.processBasic(path.newSubPath("priceCurrency"), ISOCurrencyCodeEnum.class, getPriceCurrency(), this);
		processRosetta(path.newSubPath("packageTransactionPrice"), processor, PriceFormat.class, getPackageTransactionPrice());
		processor.processBasic(path.newSubPath("packageTransactionPriceNotation"), PriceNotationEnum.class, getPackageTransactionPriceNotation(), this);
		processor.processBasic(path.newSubPath("packageTransactionPriceCurrency"), ISOCurrencyCodeEnum.class, getPackageTransactionPriceCurrency(), this);
		processRosetta(path.newSubPath("packageTransactionSpread"), processor, PriceFormat.class, getPackageTransactionSpread());
		processor.processBasic(path.newSubPath("packageTransactionSpreadNotation"), PriceNotationEnum.class, getPackageTransactionSpreadNotation(), this);
		processor.processBasic(path.newSubPath("packageTransactionSpreadCurrency"), ISOCurrencyCodeEnum.class, getPackageTransactionSpreadCurrency(), this);
		processRosetta(path.newSubPath("strikePrice"), processor, PriceFormat.class, getStrikePrice());
		processor.processBasic(path.newSubPath("strikePriceNotation"), PriceNotationEnum.class, getStrikePriceNotation(), this);
		processor.processBasic(path.newSubPath("strikePriceCurrency"), String.class, getStrikePriceCurrency(), this);
		processor.processBasic(path.newSubPath("priceUnitOfMeasure"), String.class, getPriceUnitOfMeasure(), this);
		processor.processBasic(path.newSubPath("optionPremiumAmount"), BigDecimal.class, getOptionPremiumAmount(), this);
		processor.processBasic(path.newSubPath("optionPremiumCurrency"), ISOCurrencyCodeEnum.class, getOptionPremiumCurrency(), this);
		processor.processBasic(path.newSubPath("optionPremiumPaymentDate"), Date.class, getOptionPremiumPaymentDate(), this);
		processor.processBasic(path.newSubPath("cdSIndexAttachmentPoint"), BigDecimal.class, getCdSIndexAttachmentPoint(), this);
		processor.processBasic(path.newSubPath("cdSIndexDetachmentPoint"), BigDecimal.class, getCdSIndexDetachmentPoint(), this);
		processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, getCollateralPortfolioIndicator(), this);
		processor.processBasic(path.newSubPath("firstExerciseDate"), Date.class, getFirstExerciseDate(), this);
		processor.processBasic(path.newSubPath("finalContractualSettlementDate"), Date.class, getFinalContractualSettlementDate(), this);
		processRosetta(path.newSubPath("otherPayment"), processor, OtherPayment.class, getOtherPayment());
		processRosetta(path.newSubPath("leg1"), processor, CommonLeg.class, getLeg1());
		processRosetta(path.newSubPath("leg2"), processor, CommonLeg.class, getLeg2());
		processor.processBasic(path.newSubPath("counterparty2Name"), String.class, getCounterparty2Name(), this);
		processor.processBasic(path.newSubPath("executionAgentCounterparty1"), String.class, getExecutionAgentCounterparty1(), this);
		processor.processBasic(path.newSubPath("executionAgentCounterparty2DTCC"), String.class, getExecutionAgentCounterparty2DTCC(), this);
		processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, getReportSubmittingEntityID(), this);
		processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, getUniqueTransactionIdentifier(), this);
		processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, getUniqueTransactionIdentifierProprietary(), this);
		processor.processBasic(path.newSubPath("priorUTI"), String.class, getPriorUTI(), this);
		processor.processBasic(path.newSubPath("priorUTIProprietary"), String.class, getPriorUTIProprietary(), this);
		processor.processBasic(path.newSubPath("uniqueProductIdentifier"), String.class, getUniqueProductIdentifier(), this);
		processor.processBasic(path.newSubPath("contractType"), CommonContractType.class, getContractType(), this);
		processor.processBasic(path.newSubPath("assetClass"), CommonAssetClass.class, getAssetClass(), this);
		processor.processBasic(path.newSubPath("clearingTimestamp"), ZonedDateTime.class, getClearingTimestamp(), this);
		processor.processBasic(path.newSubPath("platformIdentifier"), String.class, getPlatformIdentifier(), this);
		processor.processBasic(path.newSubPath("direction1"), Direction1Enum.class, getDirection1(), this);
		processor.processBasic(path.newSubPath("direction2Leg1"), Direction2Enum.class, getDirection2Leg1(), this);
		processor.processBasic(path.newSubPath("direction2Leg2"), Direction2Enum.class, getDirection2Leg2(), this);
		processor.processBasic(path.newSubPath("packageIdentifier"), String.class, getPackageIdentifier(), this);
		processRosetta(path.newSubPath("barrier"), processor, SingleOrUpperAndLowerBarrier.class, getBarrier());
		processor.processBasic(path.newSubPath("exchangeRate"), BigDecimal.class, getExchangeRate(), this);
		processor.processBasic(path.newSubPath("exchangeRateBasis"), String.class, getExchangeRateBasis(), this);
		processor.processBasic(path.newSubPath("nameOfTheUnderlyingIndex"), String.class, getNameOfTheUnderlyingIndex(), this);
		processRosetta(path.newSubPath("basketConstituents"), processor, BasketConstituentsReport.class, getBasketConstituents());
		processRosetta(path.newSubPath("underlying"), processor, UnderlyingIdentifier.class, getUnderlying());
		processor.processBasic(path.newSubPath("quantityUnitOfMeasureLeg1"), String.class, getQuantityUnitOfMeasureLeg1(), this);
		processor.processBasic(path.newSubPath("quantityUnitOfMeasureLeg2"), String.class, getQuantityUnitOfMeasureLeg2(), this);
		processor.processBasic(path.newSubPath("maturityDateOfTheUnderlying"), Date.class, getMaturityDateOfTheUnderlying(), this);
		processor.processBasic(path.newSubPath("optionType"), OptionTypeCode.class, getOptionType(), this);
		processor.processBasic(path.newSubPath("optionStyle"), OptionStyleEnum.class, getOptionStyle(), this);
		processor.processBasic(path.newSubPath("deliveryType"), DeliveryTypeEnum.class, getDeliveryType(), this);
		processor.processBasic(path.newSubPath("countryOfTheCounterparty2"), ISOCountryCodeEnum.class, getCountryOfTheCounterparty2(), this);
		processor.processBasic(path.newSubPath("bookingLocation"), ISOCountryCodeEnum.class, getBookingLocation(), this);
		processor.processBasic(path.newSubPath("traderLocation"), ISOCountryCodeEnum.class, getTraderLocation(), this);
		processor.processBasic(path.newSubPath("tradingCapacity"), TradingCapacity7Code.class, getTradingCapacity(), this);
		processor.processBasic(path.newSubPath("embeddedOptionType"), EmbeddedOptionTypeEnum.class, getEmbeddedOptionType(), this);
		processor.processBasic(path.newSubPath("seniority"), SeniorityEnum.class, getSeniority(), this);
		processor.processBasic(path.newSubPath("series"), Integer.class, getSeries(), this);
		processor.processBasic(path.newSubPath("indexFactor"), BigDecimal.class, getIndexFactor(), this);
		processor.processBasic(path.newSubPath("technicalRecordId"), String.class, getTechnicalRecordId(), this);
		processor.processBasic(path.newSubPath("counterparty2IdentifierSource"), Counterparty2IdentifierEnum.class, getCounterparty2IdentifierSource(), this);
		processor.processBasic(path.newSubPath("customBasketIndicator"), Boolean.class, getCustomBasketIndicator(), this);
		processor.processBasic(path.newSubPath("amendmentIndicator"), Boolean.class, getAmendmentIndicator(), this);
		processor.processBasic(path.newSubPath("packageIndicator"), Boolean.class, getPackageIndicator(), this);
		processor.processBasic(path.newSubPath("postPricedSwapIndicator"), Boolean.class, getPostPricedSwapIndicator(), this);
		processor.processBasic(path.newSubPath("settlementLocationLeg1"), ISOCountryCodeEnum.class, getSettlementLocationLeg1(), this);
		processor.processBasic(path.newSubPath("settlementLocationLeg2"), ISOCountryCodeEnum.class, getSettlementLocationLeg2(), this);
		processor.processBasic(path.newSubPath("nonStandardizedTermIndicator"), Boolean.class, getNonStandardizedTermIndicator(), this);
		processor.processBasic(path.newSubPath("blockTradeElectionIndicator"), Boolean.class, getBlockTradeElectionIndicator(), this);
		processor.processBasic(path.newSubPath("primeBrokerageTransactionIndicator"), Boolean.class, getPrimeBrokerageTransactionIndicator(), this);
		processor.processBasic(path.newSubPath("uniqueSwapIdentifier"), String.class, getUniqueSwapIdentifier(), this);
		processRosetta(path.newSubPath("cftcGuidebook"), processor, CFTCGuidebook.class, getCftcGuidebook());
	}
	

	/*********************** Builder Interface  ***********************/
	interface CFTCTransactionReportBuilder extends CFTCTransactionReport, CommonTransactionReport.CommonTransactionReportBuilder {
		CFTCGuidebook.CFTCGuidebookBuilder getOrCreateCftcGuidebook();
		@Override
		CFTCGuidebook.CFTCGuidebookBuilder getCftcGuidebook();
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setActionType(ActionTypeEnum actionType);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setEventType(EventTypeEnum eventType);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setEventIdentifier(String eventIdentifier);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setEffectiveDate(Date effectiveDate);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setEarlyTerminationDate(Date earlyTerminationDate);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setEventTimestamp(ZonedDateTime eventTimestamp);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setReportingTimestamp(ZonedDateTime reportingTimestamp);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setExecutionTimestamp(ZonedDateTime executionTimestamp);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setExpirationDate(Date expirationDate);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setCounterparty1(String counterparty1);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setCounterparty2(String counterparty2);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setCounterparty2IdentifierType(Boolean counterparty2IdentifierType);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setBeneficiary1(String beneficiary1);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setBeneficiary1IdentifierTypeIndicator(Boolean beneficiary1IdentifierTypeIndicator);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setCleared(ClearedEnum cleared);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setCentralCounterparty(String centralCounterparty);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setClearingMember(String clearingMember);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setConfirmed(ConfirmationEnum confirmed);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setCallAmount(BigDecimal callAmount);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setPutAmount(BigDecimal putAmount);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setCallCurrency(ISOCurrencyCodeEnum callCurrency);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setPutCurrency(ISOCurrencyCodeEnum putCurrency);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder addPriceSchedule(PricePeriod priceSchedule);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder addPriceSchedule(PricePeriod priceSchedule, int _idx);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder addPriceSchedule(List<? extends PricePeriod> priceSchedule);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setPriceSchedule(List<? extends PricePeriod> priceSchedule);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder addStrikePriceSchedule(PricePeriod strikePriceSchedule);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder addStrikePriceSchedule(PricePeriod strikePriceSchedule, int _idx);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder addStrikePriceSchedule(List<? extends PricePeriod> strikePriceSchedule);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setStrikePriceSchedule(List<? extends PricePeriod> strikePriceSchedule);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setPrice(PriceFormat price);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setPriceNotation(PriceNotationEnum priceNotation);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setPriceCurrency(ISOCurrencyCodeEnum priceCurrency);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setPackageTransactionPrice(PriceFormat packageTransactionPrice);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setPackageTransactionPriceNotation(PriceNotationEnum packageTransactionPriceNotation);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setPackageTransactionPriceCurrency(ISOCurrencyCodeEnum packageTransactionPriceCurrency);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setPackageTransactionSpread(PriceFormat packageTransactionSpread);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setPackageTransactionSpreadNotation(PriceNotationEnum packageTransactionSpreadNotation);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setPackageTransactionSpreadCurrency(ISOCurrencyCodeEnum packageTransactionSpreadCurrency);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setStrikePrice(PriceFormat strikePrice);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setStrikePriceNotation(PriceNotationEnum strikePriceNotation);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setStrikePriceCurrency(String strikePriceCurrency);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setPriceUnitOfMeasure(String priceUnitOfMeasure);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setOptionPremiumAmount(BigDecimal optionPremiumAmount);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setOptionPremiumCurrency(ISOCurrencyCodeEnum optionPremiumCurrency);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setOptionPremiumPaymentDate(Date optionPremiumPaymentDate);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setCdSIndexAttachmentPoint(BigDecimal cdSIndexAttachmentPoint);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setCdSIndexDetachmentPoint(BigDecimal cdSIndexDetachmentPoint);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setCollateralPortfolioIndicator(Boolean collateralPortfolioIndicator);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setFirstExerciseDate(Date firstExerciseDate);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setFinalContractualSettlementDate(Date finalContractualSettlementDate);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder addOtherPayment(OtherPayment otherPayment);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder addOtherPayment(OtherPayment otherPayment, int _idx);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder addOtherPayment(List<? extends OtherPayment> otherPayment);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setOtherPayment(List<? extends OtherPayment> otherPayment);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setLeg1(Leg leg1);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setLeg2(Leg leg2);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setLeg1(CommonLeg leg1);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setLeg2(CommonLeg leg2);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setCounterparty2Name(String counterparty2Name);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setExecutionAgentCounterparty1(String executionAgentCounterparty1);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setExecutionAgentCounterparty2DTCC(String executionAgentCounterparty2DTCC);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setReportSubmittingEntityID(String reportSubmittingEntityID);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setUniqueTransactionIdentifier(String uniqueTransactionIdentifier);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setUniqueTransactionIdentifierProprietary(String uniqueTransactionIdentifierProprietary);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setPriorUTI(String priorUTI);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setPriorUTIProprietary(String priorUTIProprietary);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setUniqueProductIdentifier(String uniqueProductIdentifier);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setContractType(CommonContractType contractType);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setAssetClass(CommonAssetClass assetClass);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setClearingTimestamp(ZonedDateTime clearingTimestamp);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setPlatformIdentifier(String platformIdentifier);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setDirection1(Direction1Enum direction1);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setDirection2Leg1(Direction2Enum direction2Leg1);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setDirection2Leg2(Direction2Enum direction2Leg2);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setPackageIdentifier(String packageIdentifier);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setBarrier(SingleOrUpperAndLowerBarrier barrier);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setExchangeRate(BigDecimal exchangeRate);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setExchangeRateBasis(String exchangeRateBasis);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setNameOfTheUnderlyingIndex(String nameOfTheUnderlyingIndex);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder addBasketConstituents(BasketConstituentsReport basketConstituents);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder addBasketConstituents(BasketConstituentsReport basketConstituents, int _idx);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder addBasketConstituents(List<? extends BasketConstituentsReport> basketConstituents);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setBasketConstituents(List<? extends BasketConstituentsReport> basketConstituents);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setUnderlying(UnderlyingIdentifier underlying);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setQuantityUnitOfMeasureLeg1(String quantityUnitOfMeasureLeg1);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setQuantityUnitOfMeasureLeg2(String quantityUnitOfMeasureLeg2);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setMaturityDateOfTheUnderlying(Date maturityDateOfTheUnderlying);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setOptionType(OptionTypeCode optionType);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setOptionStyle(OptionStyleEnum optionStyle);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setDeliveryType(DeliveryTypeEnum deliveryType);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setCountryOfTheCounterparty2(ISOCountryCodeEnum countryOfTheCounterparty2);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setBookingLocation(ISOCountryCodeEnum bookingLocation);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setTraderLocation(ISOCountryCodeEnum traderLocation);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setTradingCapacity(TradingCapacity7Code tradingCapacity);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setEmbeddedOptionType(EmbeddedOptionTypeEnum embeddedOptionType);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setSeniority(SeniorityEnum seniority);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setSeries(Integer series);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setIndexFactor(BigDecimal indexFactor);
		@Override
		CFTCTransactionReport.CFTCTransactionReportBuilder setTechnicalRecordId(String technicalRecordId);
		CFTCTransactionReport.CFTCTransactionReportBuilder setCounterparty2IdentifierSource(Counterparty2IdentifierEnum counterparty2IdentifierSource);
		CFTCTransactionReport.CFTCTransactionReportBuilder setCustomBasketIndicator(Boolean customBasketIndicator);
		CFTCTransactionReport.CFTCTransactionReportBuilder setAmendmentIndicator(Boolean amendmentIndicator);
		CFTCTransactionReport.CFTCTransactionReportBuilder setPackageIndicator(Boolean packageIndicator);
		CFTCTransactionReport.CFTCTransactionReportBuilder setPostPricedSwapIndicator(Boolean postPricedSwapIndicator);
		CFTCTransactionReport.CFTCTransactionReportBuilder setSettlementLocationLeg1(ISOCountryCodeEnum settlementLocationLeg1);
		CFTCTransactionReport.CFTCTransactionReportBuilder setSettlementLocationLeg2(ISOCountryCodeEnum settlementLocationLeg2);
		CFTCTransactionReport.CFTCTransactionReportBuilder setNonStandardizedTermIndicator(Boolean nonStandardizedTermIndicator);
		CFTCTransactionReport.CFTCTransactionReportBuilder setBlockTradeElectionIndicator(Boolean blockTradeElectionIndicator);
		CFTCTransactionReport.CFTCTransactionReportBuilder setPrimeBrokerageTransactionIndicator(Boolean primeBrokerageTransactionIndicator);
		CFTCTransactionReport.CFTCTransactionReportBuilder setUniqueSwapIdentifier(String uniqueSwapIdentifier);
		CFTCTransactionReport.CFTCTransactionReportBuilder setCftcGuidebook(CFTCGuidebook cftcGuidebook);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("actionType"), ActionTypeEnum.class, getActionType(), this);
			processor.processBasic(path.newSubPath("eventType"), EventTypeEnum.class, getEventType(), this);
			processor.processBasic(path.newSubPath("eventIdentifier"), String.class, getEventIdentifier(), this);
			processor.processBasic(path.newSubPath("effectiveDate"), Date.class, getEffectiveDate(), this);
			processor.processBasic(path.newSubPath("earlyTerminationDate"), Date.class, getEarlyTerminationDate(), this);
			processor.processBasic(path.newSubPath("eventTimestamp"), ZonedDateTime.class, getEventTimestamp(), this);
			processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, getReportingTimestamp(), this);
			processor.processBasic(path.newSubPath("executionTimestamp"), ZonedDateTime.class, getExecutionTimestamp(), this);
			processor.processBasic(path.newSubPath("expirationDate"), Date.class, getExpirationDate(), this);
			processor.processBasic(path.newSubPath("counterparty1"), String.class, getCounterparty1(), this);
			processor.processBasic(path.newSubPath("counterparty2"), String.class, getCounterparty2(), this);
			processor.processBasic(path.newSubPath("counterparty2IdentifierType"), Boolean.class, getCounterparty2IdentifierType(), this);
			processor.processBasic(path.newSubPath("beneficiary1"), String.class, getBeneficiary1(), this);
			processor.processBasic(path.newSubPath("beneficiary1IdentifierTypeIndicator"), Boolean.class, getBeneficiary1IdentifierTypeIndicator(), this);
			processor.processBasic(path.newSubPath("cleared"), ClearedEnum.class, getCleared(), this);
			processor.processBasic(path.newSubPath("centralCounterparty"), String.class, getCentralCounterparty(), this);
			processor.processBasic(path.newSubPath("clearingMember"), String.class, getClearingMember(), this);
			processor.processBasic(path.newSubPath("confirmed"), ConfirmationEnum.class, getConfirmed(), this);
			processor.processBasic(path.newSubPath("callAmount"), BigDecimal.class, getCallAmount(), this);
			processor.processBasic(path.newSubPath("putAmount"), BigDecimal.class, getPutAmount(), this);
			processor.processBasic(path.newSubPath("callCurrency"), ISOCurrencyCodeEnum.class, getCallCurrency(), this);
			processor.processBasic(path.newSubPath("putCurrency"), ISOCurrencyCodeEnum.class, getPutCurrency(), this);
			processRosetta(path.newSubPath("priceSchedule"), processor, PricePeriod.PricePeriodBuilder.class, getPriceSchedule());
			processRosetta(path.newSubPath("strikePriceSchedule"), processor, PricePeriod.PricePeriodBuilder.class, getStrikePriceSchedule());
			processRosetta(path.newSubPath("price"), processor, PriceFormat.PriceFormatBuilder.class, getPrice());
			processor.processBasic(path.newSubPath("priceNotation"), PriceNotationEnum.class, getPriceNotation(), this);
			processor.processBasic(path.newSubPath("priceCurrency"), ISOCurrencyCodeEnum.class, getPriceCurrency(), this);
			processRosetta(path.newSubPath("packageTransactionPrice"), processor, PriceFormat.PriceFormatBuilder.class, getPackageTransactionPrice());
			processor.processBasic(path.newSubPath("packageTransactionPriceNotation"), PriceNotationEnum.class, getPackageTransactionPriceNotation(), this);
			processor.processBasic(path.newSubPath("packageTransactionPriceCurrency"), ISOCurrencyCodeEnum.class, getPackageTransactionPriceCurrency(), this);
			processRosetta(path.newSubPath("packageTransactionSpread"), processor, PriceFormat.PriceFormatBuilder.class, getPackageTransactionSpread());
			processor.processBasic(path.newSubPath("packageTransactionSpreadNotation"), PriceNotationEnum.class, getPackageTransactionSpreadNotation(), this);
			processor.processBasic(path.newSubPath("packageTransactionSpreadCurrency"), ISOCurrencyCodeEnum.class, getPackageTransactionSpreadCurrency(), this);
			processRosetta(path.newSubPath("strikePrice"), processor, PriceFormat.PriceFormatBuilder.class, getStrikePrice());
			processor.processBasic(path.newSubPath("strikePriceNotation"), PriceNotationEnum.class, getStrikePriceNotation(), this);
			processor.processBasic(path.newSubPath("strikePriceCurrency"), String.class, getStrikePriceCurrency(), this);
			processor.processBasic(path.newSubPath("priceUnitOfMeasure"), String.class, getPriceUnitOfMeasure(), this);
			processor.processBasic(path.newSubPath("optionPremiumAmount"), BigDecimal.class, getOptionPremiumAmount(), this);
			processor.processBasic(path.newSubPath("optionPremiumCurrency"), ISOCurrencyCodeEnum.class, getOptionPremiumCurrency(), this);
			processor.processBasic(path.newSubPath("optionPremiumPaymentDate"), Date.class, getOptionPremiumPaymentDate(), this);
			processor.processBasic(path.newSubPath("cdSIndexAttachmentPoint"), BigDecimal.class, getCdSIndexAttachmentPoint(), this);
			processor.processBasic(path.newSubPath("cdSIndexDetachmentPoint"), BigDecimal.class, getCdSIndexDetachmentPoint(), this);
			processor.processBasic(path.newSubPath("collateralPortfolioIndicator"), Boolean.class, getCollateralPortfolioIndicator(), this);
			processor.processBasic(path.newSubPath("firstExerciseDate"), Date.class, getFirstExerciseDate(), this);
			processor.processBasic(path.newSubPath("finalContractualSettlementDate"), Date.class, getFinalContractualSettlementDate(), this);
			processRosetta(path.newSubPath("otherPayment"), processor, OtherPayment.OtherPaymentBuilder.class, getOtherPayment());
			processRosetta(path.newSubPath("leg1"), processor, CommonLeg.CommonLegBuilder.class, getLeg1());
			processRosetta(path.newSubPath("leg2"), processor, CommonLeg.CommonLegBuilder.class, getLeg2());
			processor.processBasic(path.newSubPath("counterparty2Name"), String.class, getCounterparty2Name(), this);
			processor.processBasic(path.newSubPath("executionAgentCounterparty1"), String.class, getExecutionAgentCounterparty1(), this);
			processor.processBasic(path.newSubPath("executionAgentCounterparty2DTCC"), String.class, getExecutionAgentCounterparty2DTCC(), this);
			processor.processBasic(path.newSubPath("reportSubmittingEntityID"), String.class, getReportSubmittingEntityID(), this);
			processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, getUniqueTransactionIdentifier(), this);
			processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, getUniqueTransactionIdentifierProprietary(), this);
			processor.processBasic(path.newSubPath("priorUTI"), String.class, getPriorUTI(), this);
			processor.processBasic(path.newSubPath("priorUTIProprietary"), String.class, getPriorUTIProprietary(), this);
			processor.processBasic(path.newSubPath("uniqueProductIdentifier"), String.class, getUniqueProductIdentifier(), this);
			processor.processBasic(path.newSubPath("contractType"), CommonContractType.class, getContractType(), this);
			processor.processBasic(path.newSubPath("assetClass"), CommonAssetClass.class, getAssetClass(), this);
			processor.processBasic(path.newSubPath("clearingTimestamp"), ZonedDateTime.class, getClearingTimestamp(), this);
			processor.processBasic(path.newSubPath("platformIdentifier"), String.class, getPlatformIdentifier(), this);
			processor.processBasic(path.newSubPath("direction1"), Direction1Enum.class, getDirection1(), this);
			processor.processBasic(path.newSubPath("direction2Leg1"), Direction2Enum.class, getDirection2Leg1(), this);
			processor.processBasic(path.newSubPath("direction2Leg2"), Direction2Enum.class, getDirection2Leg2(), this);
			processor.processBasic(path.newSubPath("packageIdentifier"), String.class, getPackageIdentifier(), this);
			processRosetta(path.newSubPath("barrier"), processor, SingleOrUpperAndLowerBarrier.SingleOrUpperAndLowerBarrierBuilder.class, getBarrier());
			processor.processBasic(path.newSubPath("exchangeRate"), BigDecimal.class, getExchangeRate(), this);
			processor.processBasic(path.newSubPath("exchangeRateBasis"), String.class, getExchangeRateBasis(), this);
			processor.processBasic(path.newSubPath("nameOfTheUnderlyingIndex"), String.class, getNameOfTheUnderlyingIndex(), this);
			processRosetta(path.newSubPath("basketConstituents"), processor, BasketConstituentsReport.BasketConstituentsReportBuilder.class, getBasketConstituents());
			processRosetta(path.newSubPath("underlying"), processor, UnderlyingIdentifier.UnderlyingIdentifierBuilder.class, getUnderlying());
			processor.processBasic(path.newSubPath("quantityUnitOfMeasureLeg1"), String.class, getQuantityUnitOfMeasureLeg1(), this);
			processor.processBasic(path.newSubPath("quantityUnitOfMeasureLeg2"), String.class, getQuantityUnitOfMeasureLeg2(), this);
			processor.processBasic(path.newSubPath("maturityDateOfTheUnderlying"), Date.class, getMaturityDateOfTheUnderlying(), this);
			processor.processBasic(path.newSubPath("optionType"), OptionTypeCode.class, getOptionType(), this);
			processor.processBasic(path.newSubPath("optionStyle"), OptionStyleEnum.class, getOptionStyle(), this);
			processor.processBasic(path.newSubPath("deliveryType"), DeliveryTypeEnum.class, getDeliveryType(), this);
			processor.processBasic(path.newSubPath("countryOfTheCounterparty2"), ISOCountryCodeEnum.class, getCountryOfTheCounterparty2(), this);
			processor.processBasic(path.newSubPath("bookingLocation"), ISOCountryCodeEnum.class, getBookingLocation(), this);
			processor.processBasic(path.newSubPath("traderLocation"), ISOCountryCodeEnum.class, getTraderLocation(), this);
			processor.processBasic(path.newSubPath("tradingCapacity"), TradingCapacity7Code.class, getTradingCapacity(), this);
			processor.processBasic(path.newSubPath("embeddedOptionType"), EmbeddedOptionTypeEnum.class, getEmbeddedOptionType(), this);
			processor.processBasic(path.newSubPath("seniority"), SeniorityEnum.class, getSeniority(), this);
			processor.processBasic(path.newSubPath("series"), Integer.class, getSeries(), this);
			processor.processBasic(path.newSubPath("indexFactor"), BigDecimal.class, getIndexFactor(), this);
			processor.processBasic(path.newSubPath("technicalRecordId"), String.class, getTechnicalRecordId(), this);
			processor.processBasic(path.newSubPath("counterparty2IdentifierSource"), Counterparty2IdentifierEnum.class, getCounterparty2IdentifierSource(), this);
			processor.processBasic(path.newSubPath("customBasketIndicator"), Boolean.class, getCustomBasketIndicator(), this);
			processor.processBasic(path.newSubPath("amendmentIndicator"), Boolean.class, getAmendmentIndicator(), this);
			processor.processBasic(path.newSubPath("packageIndicator"), Boolean.class, getPackageIndicator(), this);
			processor.processBasic(path.newSubPath("postPricedSwapIndicator"), Boolean.class, getPostPricedSwapIndicator(), this);
			processor.processBasic(path.newSubPath("settlementLocationLeg1"), ISOCountryCodeEnum.class, getSettlementLocationLeg1(), this);
			processor.processBasic(path.newSubPath("settlementLocationLeg2"), ISOCountryCodeEnum.class, getSettlementLocationLeg2(), this);
			processor.processBasic(path.newSubPath("nonStandardizedTermIndicator"), Boolean.class, getNonStandardizedTermIndicator(), this);
			processor.processBasic(path.newSubPath("blockTradeElectionIndicator"), Boolean.class, getBlockTradeElectionIndicator(), this);
			processor.processBasic(path.newSubPath("primeBrokerageTransactionIndicator"), Boolean.class, getPrimeBrokerageTransactionIndicator(), this);
			processor.processBasic(path.newSubPath("uniqueSwapIdentifier"), String.class, getUniqueSwapIdentifier(), this);
			processRosetta(path.newSubPath("cftcGuidebook"), processor, CFTCGuidebook.CFTCGuidebookBuilder.class, getCftcGuidebook());
		}
		

		CFTCTransactionReport.CFTCTransactionReportBuilder prune();
	}

	/*********************** Immutable Implementation of CFTCTransactionReport  ***********************/
	class CFTCTransactionReportImpl extends CommonTransactionReport.CommonTransactionReportImpl implements CFTCTransactionReport {
		private final Counterparty2IdentifierEnum counterparty2IdentifierSource;
		private final Boolean customBasketIndicator;
		private final Boolean amendmentIndicator;
		private final Boolean packageIndicator;
		private final Boolean postPricedSwapIndicator;
		private final ISOCountryCodeEnum settlementLocationLeg1;
		private final ISOCountryCodeEnum settlementLocationLeg2;
		private final Boolean nonStandardizedTermIndicator;
		private final Boolean blockTradeElectionIndicator;
		private final Boolean primeBrokerageTransactionIndicator;
		private final String uniqueSwapIdentifier;
		private final CFTCGuidebook cftcGuidebook;
		
		protected CFTCTransactionReportImpl(CFTCTransactionReport.CFTCTransactionReportBuilder builder) {
			super(builder);
			this.counterparty2IdentifierSource = builder.getCounterparty2IdentifierSource();
			this.customBasketIndicator = builder.getCustomBasketIndicator();
			this.amendmentIndicator = builder.getAmendmentIndicator();
			this.packageIndicator = builder.getPackageIndicator();
			this.postPricedSwapIndicator = builder.getPostPricedSwapIndicator();
			this.settlementLocationLeg1 = builder.getSettlementLocationLeg1();
			this.settlementLocationLeg2 = builder.getSettlementLocationLeg2();
			this.nonStandardizedTermIndicator = builder.getNonStandardizedTermIndicator();
			this.blockTradeElectionIndicator = builder.getBlockTradeElectionIndicator();
			this.primeBrokerageTransactionIndicator = builder.getPrimeBrokerageTransactionIndicator();
			this.uniqueSwapIdentifier = builder.getUniqueSwapIdentifier();
			this.cftcGuidebook = ofNullable(builder.getCftcGuidebook()).map(f->f.build()).orElse(null);
		}
		
		@Override
		@RosettaAttribute("counterparty2IdentifierSource")
		@RuneAttribute("counterparty2IdentifierSource")
		public Counterparty2IdentifierEnum getCounterparty2IdentifierSource() {
			return counterparty2IdentifierSource;
		}
		
		@Override
		@RosettaAttribute("customBasketIndicator")
		@RuneAttribute("customBasketIndicator")
		public Boolean getCustomBasketIndicator() {
			return customBasketIndicator;
		}
		
		@Override
		@RosettaAttribute("amendmentIndicator")
		@RuneAttribute("amendmentIndicator")
		public Boolean getAmendmentIndicator() {
			return amendmentIndicator;
		}
		
		@Override
		@RosettaAttribute("packageIndicator")
		@RuneAttribute("packageIndicator")
		public Boolean getPackageIndicator() {
			return packageIndicator;
		}
		
		@Override
		@RosettaAttribute("postPricedSwapIndicator")
		@RuneAttribute("postPricedSwapIndicator")
		public Boolean getPostPricedSwapIndicator() {
			return postPricedSwapIndicator;
		}
		
		@Override
		@RosettaAttribute("settlementLocationLeg1")
		@RuneAttribute("settlementLocationLeg1")
		public ISOCountryCodeEnum getSettlementLocationLeg1() {
			return settlementLocationLeg1;
		}
		
		@Override
		@RosettaAttribute("settlementLocationLeg2")
		@RuneAttribute("settlementLocationLeg2")
		public ISOCountryCodeEnum getSettlementLocationLeg2() {
			return settlementLocationLeg2;
		}
		
		@Override
		@RosettaAttribute("nonStandardizedTermIndicator")
		@RuneAttribute("nonStandardizedTermIndicator")
		public Boolean getNonStandardizedTermIndicator() {
			return nonStandardizedTermIndicator;
		}
		
		@Override
		@RosettaAttribute("blockTradeElectionIndicator")
		@RuneAttribute("blockTradeElectionIndicator")
		public Boolean getBlockTradeElectionIndicator() {
			return blockTradeElectionIndicator;
		}
		
		@Override
		@RosettaAttribute("primeBrokerageTransactionIndicator")
		@RuneAttribute("primeBrokerageTransactionIndicator")
		public Boolean getPrimeBrokerageTransactionIndicator() {
			return primeBrokerageTransactionIndicator;
		}
		
		@Override
		@RosettaAttribute("uniqueSwapIdentifier")
		@RuneAttribute("uniqueSwapIdentifier")
		public String getUniqueSwapIdentifier() {
			return uniqueSwapIdentifier;
		}
		
		@Override
		@RosettaAttribute("cftcGuidebook")
		@RuneAttribute("cftcGuidebook")
		public CFTCGuidebook getCftcGuidebook() {
			return cftcGuidebook;
		}
		
		@Override
		public CFTCTransactionReport build() {
			return this;
		}
		
		@Override
		public CFTCTransactionReport.CFTCTransactionReportBuilder toBuilder() {
			CFTCTransactionReport.CFTCTransactionReportBuilder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(CFTCTransactionReport.CFTCTransactionReportBuilder builder) {
			super.setBuilderFields(builder);
			ofNullable(getCounterparty2IdentifierSource()).ifPresent(builder::setCounterparty2IdentifierSource);
			ofNullable(getCustomBasketIndicator()).ifPresent(builder::setCustomBasketIndicator);
			ofNullable(getAmendmentIndicator()).ifPresent(builder::setAmendmentIndicator);
			ofNullable(getPackageIndicator()).ifPresent(builder::setPackageIndicator);
			ofNullable(getPostPricedSwapIndicator()).ifPresent(builder::setPostPricedSwapIndicator);
			ofNullable(getSettlementLocationLeg1()).ifPresent(builder::setSettlementLocationLeg1);
			ofNullable(getSettlementLocationLeg2()).ifPresent(builder::setSettlementLocationLeg2);
			ofNullable(getNonStandardizedTermIndicator()).ifPresent(builder::setNonStandardizedTermIndicator);
			ofNullable(getBlockTradeElectionIndicator()).ifPresent(builder::setBlockTradeElectionIndicator);
			ofNullable(getPrimeBrokerageTransactionIndicator()).ifPresent(builder::setPrimeBrokerageTransactionIndicator);
			ofNullable(getUniqueSwapIdentifier()).ifPresent(builder::setUniqueSwapIdentifier);
			ofNullable(getCftcGuidebook()).ifPresent(builder::setCftcGuidebook);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
			if (!super.equals(o)) return false;
		
			CFTCTransactionReport _that = getType().cast(o);
		
			if (!Objects.equals(counterparty2IdentifierSource, _that.getCounterparty2IdentifierSource())) return false;
			if (!Objects.equals(customBasketIndicator, _that.getCustomBasketIndicator())) return false;
			if (!Objects.equals(amendmentIndicator, _that.getAmendmentIndicator())) return false;
			if (!Objects.equals(packageIndicator, _that.getPackageIndicator())) return false;
			if (!Objects.equals(postPricedSwapIndicator, _that.getPostPricedSwapIndicator())) return false;
			if (!Objects.equals(settlementLocationLeg1, _that.getSettlementLocationLeg1())) return false;
			if (!Objects.equals(settlementLocationLeg2, _that.getSettlementLocationLeg2())) return false;
			if (!Objects.equals(nonStandardizedTermIndicator, _that.getNonStandardizedTermIndicator())) return false;
			if (!Objects.equals(blockTradeElectionIndicator, _that.getBlockTradeElectionIndicator())) return false;
			if (!Objects.equals(primeBrokerageTransactionIndicator, _that.getPrimeBrokerageTransactionIndicator())) return false;
			if (!Objects.equals(uniqueSwapIdentifier, _that.getUniqueSwapIdentifier())) return false;
			if (!Objects.equals(cftcGuidebook, _that.getCftcGuidebook())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = super.hashCode();
			_result = 31 * _result + (counterparty2IdentifierSource != null ? counterparty2IdentifierSource.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (customBasketIndicator != null ? customBasketIndicator.hashCode() : 0);
			_result = 31 * _result + (amendmentIndicator != null ? amendmentIndicator.hashCode() : 0);
			_result = 31 * _result + (packageIndicator != null ? packageIndicator.hashCode() : 0);
			_result = 31 * _result + (postPricedSwapIndicator != null ? postPricedSwapIndicator.hashCode() : 0);
			_result = 31 * _result + (settlementLocationLeg1 != null ? settlementLocationLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (settlementLocationLeg2 != null ? settlementLocationLeg2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (nonStandardizedTermIndicator != null ? nonStandardizedTermIndicator.hashCode() : 0);
			_result = 31 * _result + (blockTradeElectionIndicator != null ? blockTradeElectionIndicator.hashCode() : 0);
			_result = 31 * _result + (primeBrokerageTransactionIndicator != null ? primeBrokerageTransactionIndicator.hashCode() : 0);
			_result = 31 * _result + (uniqueSwapIdentifier != null ? uniqueSwapIdentifier.hashCode() : 0);
			_result = 31 * _result + (cftcGuidebook != null ? cftcGuidebook.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "CFTCTransactionReport {" +
				"counterparty2IdentifierSource=" + this.counterparty2IdentifierSource + ", " +
				"customBasketIndicator=" + this.customBasketIndicator + ", " +
				"amendmentIndicator=" + this.amendmentIndicator + ", " +
				"packageIndicator=" + this.packageIndicator + ", " +
				"postPricedSwapIndicator=" + this.postPricedSwapIndicator + ", " +
				"settlementLocationLeg1=" + this.settlementLocationLeg1 + ", " +
				"settlementLocationLeg2=" + this.settlementLocationLeg2 + ", " +
				"nonStandardizedTermIndicator=" + this.nonStandardizedTermIndicator + ", " +
				"blockTradeElectionIndicator=" + this.blockTradeElectionIndicator + ", " +
				"primeBrokerageTransactionIndicator=" + this.primeBrokerageTransactionIndicator + ", " +
				"uniqueSwapIdentifier=" + this.uniqueSwapIdentifier + ", " +
				"cftcGuidebook=" + this.cftcGuidebook +
			'}' + " " + super.toString();
		}
	}

	/*********************** Builder Implementation of CFTCTransactionReport  ***********************/
	class CFTCTransactionReportBuilderImpl extends CommonTransactionReport.CommonTransactionReportBuilderImpl implements CFTCTransactionReport.CFTCTransactionReportBuilder {
	
		protected Counterparty2IdentifierEnum counterparty2IdentifierSource;
		protected Boolean customBasketIndicator;
		protected Boolean amendmentIndicator;
		protected Boolean packageIndicator;
		protected Boolean postPricedSwapIndicator;
		protected ISOCountryCodeEnum settlementLocationLeg1;
		protected ISOCountryCodeEnum settlementLocationLeg2;
		protected Boolean nonStandardizedTermIndicator;
		protected Boolean blockTradeElectionIndicator;
		protected Boolean primeBrokerageTransactionIndicator;
		protected String uniqueSwapIdentifier;
		protected CFTCGuidebook.CFTCGuidebookBuilder cftcGuidebook;
		
		@Override
		@RosettaAttribute("counterparty2IdentifierSource")
		@RuneAttribute("counterparty2IdentifierSource")
		public Counterparty2IdentifierEnum getCounterparty2IdentifierSource() {
			return counterparty2IdentifierSource;
		}
		
		@Override
		@RosettaAttribute("customBasketIndicator")
		@RuneAttribute("customBasketIndicator")
		public Boolean getCustomBasketIndicator() {
			return customBasketIndicator;
		}
		
		@Override
		@RosettaAttribute("amendmentIndicator")
		@RuneAttribute("amendmentIndicator")
		public Boolean getAmendmentIndicator() {
			return amendmentIndicator;
		}
		
		@Override
		@RosettaAttribute("packageIndicator")
		@RuneAttribute("packageIndicator")
		public Boolean getPackageIndicator() {
			return packageIndicator;
		}
		
		@Override
		@RosettaAttribute("postPricedSwapIndicator")
		@RuneAttribute("postPricedSwapIndicator")
		public Boolean getPostPricedSwapIndicator() {
			return postPricedSwapIndicator;
		}
		
		@Override
		@RosettaAttribute("settlementLocationLeg1")
		@RuneAttribute("settlementLocationLeg1")
		public ISOCountryCodeEnum getSettlementLocationLeg1() {
			return settlementLocationLeg1;
		}
		
		@Override
		@RosettaAttribute("settlementLocationLeg2")
		@RuneAttribute("settlementLocationLeg2")
		public ISOCountryCodeEnum getSettlementLocationLeg2() {
			return settlementLocationLeg2;
		}
		
		@Override
		@RosettaAttribute("nonStandardizedTermIndicator")
		@RuneAttribute("nonStandardizedTermIndicator")
		public Boolean getNonStandardizedTermIndicator() {
			return nonStandardizedTermIndicator;
		}
		
		@Override
		@RosettaAttribute("blockTradeElectionIndicator")
		@RuneAttribute("blockTradeElectionIndicator")
		public Boolean getBlockTradeElectionIndicator() {
			return blockTradeElectionIndicator;
		}
		
		@Override
		@RosettaAttribute("primeBrokerageTransactionIndicator")
		@RuneAttribute("primeBrokerageTransactionIndicator")
		public Boolean getPrimeBrokerageTransactionIndicator() {
			return primeBrokerageTransactionIndicator;
		}
		
		@Override
		@RosettaAttribute("uniqueSwapIdentifier")
		@RuneAttribute("uniqueSwapIdentifier")
		public String getUniqueSwapIdentifier() {
			return uniqueSwapIdentifier;
		}
		
		@Override
		@RosettaAttribute("cftcGuidebook")
		@RuneAttribute("cftcGuidebook")
		public CFTCGuidebook.CFTCGuidebookBuilder getCftcGuidebook() {
			return cftcGuidebook;
		}
		
		@Override
		public CFTCGuidebook.CFTCGuidebookBuilder getOrCreateCftcGuidebook() {
			CFTCGuidebook.CFTCGuidebookBuilder result;
			if (cftcGuidebook!=null) {
				result = cftcGuidebook;
			}
			else {
				result = cftcGuidebook = CFTCGuidebook.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("actionType")
		@RuneAttribute("actionType")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setActionType(ActionTypeEnum _actionType) {
			this.actionType = _actionType == null ? null : _actionType;
			return this;
		}
		
		@Override
		@RosettaAttribute("eventType")
		@RuneAttribute("eventType")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setEventType(EventTypeEnum _eventType) {
			this.eventType = _eventType == null ? null : _eventType;
			return this;
		}
		
		@Override
		@RosettaAttribute("eventIdentifier")
		@RuneAttribute("eventIdentifier")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setEventIdentifier(String _eventIdentifier) {
			this.eventIdentifier = _eventIdentifier == null ? null : _eventIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("effectiveDate")
		@RuneAttribute("effectiveDate")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setEffectiveDate(Date _effectiveDate) {
			this.effectiveDate = _effectiveDate == null ? null : _effectiveDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("earlyTerminationDate")
		@RuneAttribute("earlyTerminationDate")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setEarlyTerminationDate(Date _earlyTerminationDate) {
			this.earlyTerminationDate = _earlyTerminationDate == null ? null : _earlyTerminationDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("eventTimestamp")
		@RuneAttribute("eventTimestamp")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setEventTimestamp(ZonedDateTime _eventTimestamp) {
			this.eventTimestamp = _eventTimestamp == null ? null : _eventTimestamp;
			return this;
		}
		
		@Override
		@RosettaAttribute("reportingTimestamp")
		@RuneAttribute("reportingTimestamp")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
			this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
			return this;
		}
		
		@Override
		@RosettaAttribute("executionTimestamp")
		@RuneAttribute("executionTimestamp")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setExecutionTimestamp(ZonedDateTime _executionTimestamp) {
			this.executionTimestamp = _executionTimestamp == null ? null : _executionTimestamp;
			return this;
		}
		
		@Override
		@RosettaAttribute("expirationDate")
		@RuneAttribute("expirationDate")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setExpirationDate(Date _expirationDate) {
			this.expirationDate = _expirationDate == null ? null : _expirationDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("counterparty1")
		@RuneAttribute("counterparty1")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setCounterparty1(String _counterparty1) {
			this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
			return this;
		}
		
		@Override
		@RosettaAttribute("counterparty2")
		@RuneAttribute("counterparty2")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setCounterparty2(String _counterparty2) {
			this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
			return this;
		}
		
		@Override
		@RosettaAttribute("counterparty2IdentifierType")
		@RuneAttribute("counterparty2IdentifierType")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setCounterparty2IdentifierType(Boolean _counterparty2IdentifierType) {
			this.counterparty2IdentifierType = _counterparty2IdentifierType == null ? null : _counterparty2IdentifierType;
			return this;
		}
		
		@Override
		@RosettaAttribute("beneficiary1")
		@RuneAttribute("beneficiary1")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setBeneficiary1(String _beneficiary1) {
			this.beneficiary1 = _beneficiary1 == null ? null : _beneficiary1;
			return this;
		}
		
		@Override
		@RosettaAttribute("beneficiary1IdentifierTypeIndicator")
		@RuneAttribute("beneficiary1IdentifierTypeIndicator")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setBeneficiary1IdentifierTypeIndicator(Boolean _beneficiary1IdentifierTypeIndicator) {
			this.beneficiary1IdentifierTypeIndicator = _beneficiary1IdentifierTypeIndicator == null ? null : _beneficiary1IdentifierTypeIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("cleared")
		@RuneAttribute("cleared")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setCleared(ClearedEnum _cleared) {
			this.cleared = _cleared == null ? null : _cleared;
			return this;
		}
		
		@Override
		@RosettaAttribute("centralCounterparty")
		@RuneAttribute("centralCounterparty")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setCentralCounterparty(String _centralCounterparty) {
			this.centralCounterparty = _centralCounterparty == null ? null : _centralCounterparty;
			return this;
		}
		
		@Override
		@RosettaAttribute("clearingMember")
		@RuneAttribute("clearingMember")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setClearingMember(String _clearingMember) {
			this.clearingMember = _clearingMember == null ? null : _clearingMember;
			return this;
		}
		
		@Override
		@RosettaAttribute("confirmed")
		@RuneAttribute("confirmed")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setConfirmed(ConfirmationEnum _confirmed) {
			this.confirmed = _confirmed == null ? null : _confirmed;
			return this;
		}
		
		@Override
		@RosettaAttribute("callAmount")
		@RuneAttribute("callAmount")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setCallAmount(BigDecimal _callAmount) {
			this.callAmount = _callAmount == null ? null : _callAmount;
			return this;
		}
		
		@Override
		@RosettaAttribute("putAmount")
		@RuneAttribute("putAmount")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setPutAmount(BigDecimal _putAmount) {
			this.putAmount = _putAmount == null ? null : _putAmount;
			return this;
		}
		
		@Override
		@RosettaAttribute("callCurrency")
		@RuneAttribute("callCurrency")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setCallCurrency(ISOCurrencyCodeEnum _callCurrency) {
			this.callCurrency = _callCurrency == null ? null : _callCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("putCurrency")
		@RuneAttribute("putCurrency")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setPutCurrency(ISOCurrencyCodeEnum _putCurrency) {
			this.putCurrency = _putCurrency == null ? null : _putCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("priceSchedule")
		@RuneAttribute("priceSchedule")
		public CFTCTransactionReport.CFTCTransactionReportBuilder addPriceSchedule(PricePeriod _priceSchedule) {
			if (_priceSchedule != null) {
				this.priceSchedule.add(_priceSchedule.toBuilder());
			}
			return this;
		}
		
		@Override
		public CFTCTransactionReport.CFTCTransactionReportBuilder addPriceSchedule(PricePeriod _priceSchedule, int _idx) {
			getIndex(this.priceSchedule, _idx, () -> _priceSchedule.toBuilder());
			return this;
		}
		
		@Override 
		public CFTCTransactionReport.CFTCTransactionReportBuilder addPriceSchedule(List<? extends PricePeriod> priceSchedules) {
			if (priceSchedules != null) {
				for (final PricePeriod toAdd : priceSchedules) {
					this.priceSchedule.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("priceSchedule")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setPriceSchedule(List<? extends PricePeriod> priceSchedules) {
			if (priceSchedules == null) {
				this.priceSchedule = new ArrayList<>();
			} else {
				this.priceSchedule = priceSchedules.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("strikePriceSchedule")
		@RuneAttribute("strikePriceSchedule")
		public CFTCTransactionReport.CFTCTransactionReportBuilder addStrikePriceSchedule(PricePeriod _strikePriceSchedule) {
			if (_strikePriceSchedule != null) {
				this.strikePriceSchedule.add(_strikePriceSchedule.toBuilder());
			}
			return this;
		}
		
		@Override
		public CFTCTransactionReport.CFTCTransactionReportBuilder addStrikePriceSchedule(PricePeriod _strikePriceSchedule, int _idx) {
			getIndex(this.strikePriceSchedule, _idx, () -> _strikePriceSchedule.toBuilder());
			return this;
		}
		
		@Override 
		public CFTCTransactionReport.CFTCTransactionReportBuilder addStrikePriceSchedule(List<? extends PricePeriod> strikePriceSchedules) {
			if (strikePriceSchedules != null) {
				for (final PricePeriod toAdd : strikePriceSchedules) {
					this.strikePriceSchedule.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("strikePriceSchedule")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setStrikePriceSchedule(List<? extends PricePeriod> strikePriceSchedules) {
			if (strikePriceSchedules == null) {
				this.strikePriceSchedule = new ArrayList<>();
			} else {
				this.strikePriceSchedule = strikePriceSchedules.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("price")
		@RuneAttribute("price")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setPrice(PriceFormat _price) {
			this.price = _price == null ? null : _price.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("priceNotation")
		@RuneAttribute("priceNotation")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setPriceNotation(PriceNotationEnum _priceNotation) {
			this.priceNotation = _priceNotation == null ? null : _priceNotation;
			return this;
		}
		
		@Override
		@RosettaAttribute("priceCurrency")
		@RuneAttribute("priceCurrency")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setPriceCurrency(ISOCurrencyCodeEnum _priceCurrency) {
			this.priceCurrency = _priceCurrency == null ? null : _priceCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("packageTransactionPrice")
		@RuneAttribute("packageTransactionPrice")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setPackageTransactionPrice(PriceFormat _packageTransactionPrice) {
			this.packageTransactionPrice = _packageTransactionPrice == null ? null : _packageTransactionPrice.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("packageTransactionPriceNotation")
		@RuneAttribute("packageTransactionPriceNotation")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setPackageTransactionPriceNotation(PriceNotationEnum _packageTransactionPriceNotation) {
			this.packageTransactionPriceNotation = _packageTransactionPriceNotation == null ? null : _packageTransactionPriceNotation;
			return this;
		}
		
		@Override
		@RosettaAttribute("packageTransactionPriceCurrency")
		@RuneAttribute("packageTransactionPriceCurrency")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setPackageTransactionPriceCurrency(ISOCurrencyCodeEnum _packageTransactionPriceCurrency) {
			this.packageTransactionPriceCurrency = _packageTransactionPriceCurrency == null ? null : _packageTransactionPriceCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("packageTransactionSpread")
		@RuneAttribute("packageTransactionSpread")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setPackageTransactionSpread(PriceFormat _packageTransactionSpread) {
			this.packageTransactionSpread = _packageTransactionSpread == null ? null : _packageTransactionSpread.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("packageTransactionSpreadNotation")
		@RuneAttribute("packageTransactionSpreadNotation")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setPackageTransactionSpreadNotation(PriceNotationEnum _packageTransactionSpreadNotation) {
			this.packageTransactionSpreadNotation = _packageTransactionSpreadNotation == null ? null : _packageTransactionSpreadNotation;
			return this;
		}
		
		@Override
		@RosettaAttribute("packageTransactionSpreadCurrency")
		@RuneAttribute("packageTransactionSpreadCurrency")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setPackageTransactionSpreadCurrency(ISOCurrencyCodeEnum _packageTransactionSpreadCurrency) {
			this.packageTransactionSpreadCurrency = _packageTransactionSpreadCurrency == null ? null : _packageTransactionSpreadCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("strikePrice")
		@RuneAttribute("strikePrice")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setStrikePrice(PriceFormat _strikePrice) {
			this.strikePrice = _strikePrice == null ? null : _strikePrice.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("strikePriceNotation")
		@RuneAttribute("strikePriceNotation")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setStrikePriceNotation(PriceNotationEnum _strikePriceNotation) {
			this.strikePriceNotation = _strikePriceNotation == null ? null : _strikePriceNotation;
			return this;
		}
		
		@Override
		@RosettaAttribute("strikePriceCurrency")
		@RuneAttribute("strikePriceCurrency")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setStrikePriceCurrency(String _strikePriceCurrency) {
			this.strikePriceCurrency = _strikePriceCurrency == null ? null : _strikePriceCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("priceUnitOfMeasure")
		@RuneAttribute("priceUnitOfMeasure")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setPriceUnitOfMeasure(String _priceUnitOfMeasure) {
			this.priceUnitOfMeasure = _priceUnitOfMeasure == null ? null : _priceUnitOfMeasure;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionPremiumAmount")
		@RuneAttribute("optionPremiumAmount")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setOptionPremiumAmount(BigDecimal _optionPremiumAmount) {
			this.optionPremiumAmount = _optionPremiumAmount == null ? null : _optionPremiumAmount;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionPremiumCurrency")
		@RuneAttribute("optionPremiumCurrency")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setOptionPremiumCurrency(ISOCurrencyCodeEnum _optionPremiumCurrency) {
			this.optionPremiumCurrency = _optionPremiumCurrency == null ? null : _optionPremiumCurrency;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionPremiumPaymentDate")
		@RuneAttribute("optionPremiumPaymentDate")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setOptionPremiumPaymentDate(Date _optionPremiumPaymentDate) {
			this.optionPremiumPaymentDate = _optionPremiumPaymentDate == null ? null : _optionPremiumPaymentDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdSIndexAttachmentPoint")
		@RuneAttribute("cdSIndexAttachmentPoint")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setCdSIndexAttachmentPoint(BigDecimal _cdSIndexAttachmentPoint) {
			this.cdSIndexAttachmentPoint = _cdSIndexAttachmentPoint == null ? null : _cdSIndexAttachmentPoint;
			return this;
		}
		
		@Override
		@RosettaAttribute("cdSIndexDetachmentPoint")
		@RuneAttribute("cdSIndexDetachmentPoint")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setCdSIndexDetachmentPoint(BigDecimal _cdSIndexDetachmentPoint) {
			this.cdSIndexDetachmentPoint = _cdSIndexDetachmentPoint == null ? null : _cdSIndexDetachmentPoint;
			return this;
		}
		
		@Override
		@RosettaAttribute("collateralPortfolioIndicator")
		@RuneAttribute("collateralPortfolioIndicator")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setCollateralPortfolioIndicator(Boolean _collateralPortfolioIndicator) {
			this.collateralPortfolioIndicator = _collateralPortfolioIndicator == null ? null : _collateralPortfolioIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("firstExerciseDate")
		@RuneAttribute("firstExerciseDate")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setFirstExerciseDate(Date _firstExerciseDate) {
			this.firstExerciseDate = _firstExerciseDate == null ? null : _firstExerciseDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("finalContractualSettlementDate")
		@RuneAttribute("finalContractualSettlementDate")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setFinalContractualSettlementDate(Date _finalContractualSettlementDate) {
			this.finalContractualSettlementDate = _finalContractualSettlementDate == null ? null : _finalContractualSettlementDate;
			return this;
		}
		
		@Override
		@RosettaAttribute("otherPayment")
		@RuneAttribute("otherPayment")
		public CFTCTransactionReport.CFTCTransactionReportBuilder addOtherPayment(OtherPayment _otherPayment) {
			if (_otherPayment != null) {
				this.otherPayment.add(_otherPayment.toBuilder());
			}
			return this;
		}
		
		@Override
		public CFTCTransactionReport.CFTCTransactionReportBuilder addOtherPayment(OtherPayment _otherPayment, int _idx) {
			getIndex(this.otherPayment, _idx, () -> _otherPayment.toBuilder());
			return this;
		}
		
		@Override 
		public CFTCTransactionReport.CFTCTransactionReportBuilder addOtherPayment(List<? extends OtherPayment> otherPayments) {
			if (otherPayments != null) {
				for (final OtherPayment toAdd : otherPayments) {
					this.otherPayment.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("otherPayment")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setOtherPayment(List<? extends OtherPayment> otherPayments) {
			if (otherPayments == null) {
				this.otherPayment = new ArrayList<>();
			} else {
				this.otherPayment = otherPayments.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("leg1")
		@RuneAttribute("leg1")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setLeg1(CommonLeg _leg1) {
			this.leg1 = _leg1 == null ? null : _leg1.toBuilder();
			return this;
		}
		
		@Override
		@RosettaIgnore
		public CFTCTransactionReport.CFTCTransactionReportBuilder setLeg1(Leg _leg1) {
			final CommonLeg ifThenElseResult;
			if (_leg1 == null) {
				ifThenElseResult = null;
			} else {
				ifThenElseResult = _leg1 instanceof CommonLeg ? CommonLeg.class.cast(_leg1) : null;
			}
			return setLeg1(ifThenElseResult);
		}
		
		@Override
		@RosettaAttribute("leg2")
		@RuneAttribute("leg2")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setLeg2(CommonLeg _leg2) {
			this.leg2 = _leg2 == null ? null : _leg2.toBuilder();
			return this;
		}
		
		@Override
		@RosettaIgnore
		public CFTCTransactionReport.CFTCTransactionReportBuilder setLeg2(Leg _leg2) {
			final CommonLeg ifThenElseResult;
			if (_leg2 == null) {
				ifThenElseResult = null;
			} else {
				ifThenElseResult = _leg2 instanceof CommonLeg ? CommonLeg.class.cast(_leg2) : null;
			}
			return setLeg2(ifThenElseResult);
		}
		
		@Override
		@RosettaAttribute("counterparty2Name")
		@RuneAttribute("counterparty2Name")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setCounterparty2Name(String _counterparty2Name) {
			this.counterparty2Name = _counterparty2Name == null ? null : _counterparty2Name;
			return this;
		}
		
		@Override
		@RosettaAttribute("executionAgentCounterparty1")
		@RuneAttribute("executionAgentCounterparty1")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setExecutionAgentCounterparty1(String _executionAgentCounterparty1) {
			this.executionAgentCounterparty1 = _executionAgentCounterparty1 == null ? null : _executionAgentCounterparty1;
			return this;
		}
		
		@Override
		@RosettaAttribute("executionAgentCounterparty2DTCC")
		@RuneAttribute("executionAgentCounterparty2DTCC")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setExecutionAgentCounterparty2DTCC(String _executionAgentCounterparty2DTCC) {
			this.executionAgentCounterparty2DTCC = _executionAgentCounterparty2DTCC == null ? null : _executionAgentCounterparty2DTCC;
			return this;
		}
		
		@Override
		@RosettaAttribute("reportSubmittingEntityID")
		@RuneAttribute("reportSubmittingEntityID")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setReportSubmittingEntityID(String _reportSubmittingEntityID) {
			this.reportSubmittingEntityID = _reportSubmittingEntityID == null ? null : _reportSubmittingEntityID;
			return this;
		}
		
		@Override
		@RosettaAttribute("uniqueTransactionIdentifier")
		@RuneAttribute("uniqueTransactionIdentifier")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setUniqueTransactionIdentifier(String _uniqueTransactionIdentifier) {
			this.uniqueTransactionIdentifier = _uniqueTransactionIdentifier == null ? null : _uniqueTransactionIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("uniqueTransactionIdentifierProprietary")
		@RuneAttribute("uniqueTransactionIdentifierProprietary")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setUniqueTransactionIdentifierProprietary(String _uniqueTransactionIdentifierProprietary) {
			this.uniqueTransactionIdentifierProprietary = _uniqueTransactionIdentifierProprietary == null ? null : _uniqueTransactionIdentifierProprietary;
			return this;
		}
		
		@Override
		@RosettaAttribute("priorUTI")
		@RuneAttribute("priorUTI")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setPriorUTI(String _priorUTI) {
			this.priorUTI = _priorUTI == null ? null : _priorUTI;
			return this;
		}
		
		@Override
		@RosettaAttribute("priorUTIProprietary")
		@RuneAttribute("priorUTIProprietary")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setPriorUTIProprietary(String _priorUTIProprietary) {
			this.priorUTIProprietary = _priorUTIProprietary == null ? null : _priorUTIProprietary;
			return this;
		}
		
		@Override
		@RosettaAttribute("uniqueProductIdentifier")
		@RuneAttribute("uniqueProductIdentifier")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setUniqueProductIdentifier(String _uniqueProductIdentifier) {
			this.uniqueProductIdentifier = _uniqueProductIdentifier == null ? null : _uniqueProductIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("contractType")
		@RuneAttribute("contractType")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setContractType(CommonContractType _contractType) {
			this.contractType = _contractType == null ? null : _contractType;
			return this;
		}
		
		@Override
		@RosettaAttribute("assetClass")
		@RuneAttribute("assetClass")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setAssetClass(CommonAssetClass _assetClass) {
			this.assetClass = _assetClass == null ? null : _assetClass;
			return this;
		}
		
		@Override
		@RosettaAttribute("clearingTimestamp")
		@RuneAttribute("clearingTimestamp")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setClearingTimestamp(ZonedDateTime _clearingTimestamp) {
			this.clearingTimestamp = _clearingTimestamp == null ? null : _clearingTimestamp;
			return this;
		}
		
		@Override
		@RosettaAttribute("platformIdentifier")
		@RuneAttribute("platformIdentifier")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setPlatformIdentifier(String _platformIdentifier) {
			this.platformIdentifier = _platformIdentifier == null ? null : _platformIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("direction1")
		@RuneAttribute("direction1")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setDirection1(Direction1Enum _direction1) {
			this.direction1 = _direction1 == null ? null : _direction1;
			return this;
		}
		
		@Override
		@RosettaAttribute("direction2Leg1")
		@RuneAttribute("direction2Leg1")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setDirection2Leg1(Direction2Enum _direction2Leg1) {
			this.direction2Leg1 = _direction2Leg1 == null ? null : _direction2Leg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("direction2Leg2")
		@RuneAttribute("direction2Leg2")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setDirection2Leg2(Direction2Enum _direction2Leg2) {
			this.direction2Leg2 = _direction2Leg2 == null ? null : _direction2Leg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("packageIdentifier")
		@RuneAttribute("packageIdentifier")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setPackageIdentifier(String _packageIdentifier) {
			this.packageIdentifier = _packageIdentifier == null ? null : _packageIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("barrier")
		@RuneAttribute("barrier")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setBarrier(SingleOrUpperAndLowerBarrier _barrier) {
			this.barrier = _barrier == null ? null : _barrier.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("exchangeRate")
		@RuneAttribute("exchangeRate")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setExchangeRate(BigDecimal _exchangeRate) {
			this.exchangeRate = _exchangeRate == null ? null : _exchangeRate;
			return this;
		}
		
		@Override
		@RosettaAttribute("exchangeRateBasis")
		@RuneAttribute("exchangeRateBasis")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setExchangeRateBasis(String _exchangeRateBasis) {
			this.exchangeRateBasis = _exchangeRateBasis == null ? null : _exchangeRateBasis;
			return this;
		}
		
		@Override
		@RosettaAttribute("nameOfTheUnderlyingIndex")
		@RuneAttribute("nameOfTheUnderlyingIndex")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setNameOfTheUnderlyingIndex(String _nameOfTheUnderlyingIndex) {
			this.nameOfTheUnderlyingIndex = _nameOfTheUnderlyingIndex == null ? null : _nameOfTheUnderlyingIndex;
			return this;
		}
		
		@Override
		@RosettaAttribute("basketConstituents")
		@RuneAttribute("basketConstituents")
		public CFTCTransactionReport.CFTCTransactionReportBuilder addBasketConstituents(BasketConstituentsReport _basketConstituents) {
			if (_basketConstituents != null) {
				this.basketConstituents.add(_basketConstituents.toBuilder());
			}
			return this;
		}
		
		@Override
		public CFTCTransactionReport.CFTCTransactionReportBuilder addBasketConstituents(BasketConstituentsReport _basketConstituents, int _idx) {
			getIndex(this.basketConstituents, _idx, () -> _basketConstituents.toBuilder());
			return this;
		}
		
		@Override 
		public CFTCTransactionReport.CFTCTransactionReportBuilder addBasketConstituents(List<? extends BasketConstituentsReport> basketConstituentss) {
			if (basketConstituentss != null) {
				for (final BasketConstituentsReport toAdd : basketConstituentss) {
					this.basketConstituents.add(toAdd.toBuilder());
				}
			}
			return this;
		}
		
		@Override 
		@RuneAttribute("basketConstituents")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setBasketConstituents(List<? extends BasketConstituentsReport> basketConstituentss) {
			if (basketConstituentss == null) {
				this.basketConstituents = new ArrayList<>();
			} else {
				this.basketConstituents = basketConstituentss.stream()
					.map(_a->_a.toBuilder())
					.collect(Collectors.toCollection(()->new ArrayList<>()));
			}
			return this;
		}
		
		@Override
		@RosettaAttribute("underlying")
		@RuneAttribute("underlying")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setUnderlying(UnderlyingIdentifier _underlying) {
			this.underlying = _underlying == null ? null : _underlying.toBuilder();
			return this;
		}
		
		@Override
		@RosettaAttribute("quantityUnitOfMeasureLeg1")
		@RuneAttribute("quantityUnitOfMeasureLeg1")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setQuantityUnitOfMeasureLeg1(String _quantityUnitOfMeasureLeg1) {
			this.quantityUnitOfMeasureLeg1 = _quantityUnitOfMeasureLeg1 == null ? null : _quantityUnitOfMeasureLeg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("quantityUnitOfMeasureLeg2")
		@RuneAttribute("quantityUnitOfMeasureLeg2")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setQuantityUnitOfMeasureLeg2(String _quantityUnitOfMeasureLeg2) {
			this.quantityUnitOfMeasureLeg2 = _quantityUnitOfMeasureLeg2 == null ? null : _quantityUnitOfMeasureLeg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("maturityDateOfTheUnderlying")
		@RuneAttribute("maturityDateOfTheUnderlying")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setMaturityDateOfTheUnderlying(Date _maturityDateOfTheUnderlying) {
			this.maturityDateOfTheUnderlying = _maturityDateOfTheUnderlying == null ? null : _maturityDateOfTheUnderlying;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionType")
		@RuneAttribute("optionType")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setOptionType(OptionTypeCode _optionType) {
			this.optionType = _optionType == null ? null : _optionType;
			return this;
		}
		
		@Override
		@RosettaAttribute("optionStyle")
		@RuneAttribute("optionStyle")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setOptionStyle(OptionStyleEnum _optionStyle) {
			this.optionStyle = _optionStyle == null ? null : _optionStyle;
			return this;
		}
		
		@Override
		@RosettaAttribute("deliveryType")
		@RuneAttribute("deliveryType")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setDeliveryType(DeliveryTypeEnum _deliveryType) {
			this.deliveryType = _deliveryType == null ? null : _deliveryType;
			return this;
		}
		
		@Override
		@RosettaAttribute("countryOfTheCounterparty2")
		@RuneAttribute("countryOfTheCounterparty2")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setCountryOfTheCounterparty2(ISOCountryCodeEnum _countryOfTheCounterparty2) {
			this.countryOfTheCounterparty2 = _countryOfTheCounterparty2 == null ? null : _countryOfTheCounterparty2;
			return this;
		}
		
		@Override
		@RosettaAttribute("bookingLocation")
		@RuneAttribute("bookingLocation")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setBookingLocation(ISOCountryCodeEnum _bookingLocation) {
			this.bookingLocation = _bookingLocation == null ? null : _bookingLocation;
			return this;
		}
		
		@Override
		@RosettaAttribute("traderLocation")
		@RuneAttribute("traderLocation")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setTraderLocation(ISOCountryCodeEnum _traderLocation) {
			this.traderLocation = _traderLocation == null ? null : _traderLocation;
			return this;
		}
		
		@Override
		@RosettaAttribute("tradingCapacity")
		@RuneAttribute("tradingCapacity")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setTradingCapacity(TradingCapacity7Code _tradingCapacity) {
			this.tradingCapacity = _tradingCapacity == null ? null : _tradingCapacity;
			return this;
		}
		
		@Override
		@RosettaAttribute("embeddedOptionType")
		@RuneAttribute("embeddedOptionType")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setEmbeddedOptionType(EmbeddedOptionTypeEnum _embeddedOptionType) {
			this.embeddedOptionType = _embeddedOptionType == null ? null : _embeddedOptionType;
			return this;
		}
		
		@Override
		@RosettaAttribute("seniority")
		@RuneAttribute("seniority")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setSeniority(SeniorityEnum _seniority) {
			this.seniority = _seniority == null ? null : _seniority;
			return this;
		}
		
		@Override
		@RosettaAttribute("series")
		@RuneAttribute("series")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setSeries(Integer _series) {
			this.series = _series == null ? null : _series;
			return this;
		}
		
		@Override
		@RosettaAttribute("indexFactor")
		@RuneAttribute("indexFactor")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setIndexFactor(BigDecimal _indexFactor) {
			this.indexFactor = _indexFactor == null ? null : _indexFactor;
			return this;
		}
		
		@Override
		@RosettaAttribute("technicalRecordId")
		@RuneAttribute("technicalRecordId")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setTechnicalRecordId(String _technicalRecordId) {
			this.technicalRecordId = _technicalRecordId == null ? null : _technicalRecordId;
			return this;
		}
		
		@Override
		@RosettaAttribute("counterparty2IdentifierSource")
		@RuneAttribute("counterparty2IdentifierSource")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setCounterparty2IdentifierSource(Counterparty2IdentifierEnum _counterparty2IdentifierSource) {
			this.counterparty2IdentifierSource = _counterparty2IdentifierSource == null ? null : _counterparty2IdentifierSource;
			return this;
		}
		
		@Override
		@RosettaAttribute("customBasketIndicator")
		@RuneAttribute("customBasketIndicator")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setCustomBasketIndicator(Boolean _customBasketIndicator) {
			this.customBasketIndicator = _customBasketIndicator == null ? null : _customBasketIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("amendmentIndicator")
		@RuneAttribute("amendmentIndicator")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setAmendmentIndicator(Boolean _amendmentIndicator) {
			this.amendmentIndicator = _amendmentIndicator == null ? null : _amendmentIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("packageIndicator")
		@RuneAttribute("packageIndicator")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setPackageIndicator(Boolean _packageIndicator) {
			this.packageIndicator = _packageIndicator == null ? null : _packageIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("postPricedSwapIndicator")
		@RuneAttribute("postPricedSwapIndicator")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setPostPricedSwapIndicator(Boolean _postPricedSwapIndicator) {
			this.postPricedSwapIndicator = _postPricedSwapIndicator == null ? null : _postPricedSwapIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("settlementLocationLeg1")
		@RuneAttribute("settlementLocationLeg1")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setSettlementLocationLeg1(ISOCountryCodeEnum _settlementLocationLeg1) {
			this.settlementLocationLeg1 = _settlementLocationLeg1 == null ? null : _settlementLocationLeg1;
			return this;
		}
		
		@Override
		@RosettaAttribute("settlementLocationLeg2")
		@RuneAttribute("settlementLocationLeg2")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setSettlementLocationLeg2(ISOCountryCodeEnum _settlementLocationLeg2) {
			this.settlementLocationLeg2 = _settlementLocationLeg2 == null ? null : _settlementLocationLeg2;
			return this;
		}
		
		@Override
		@RosettaAttribute("nonStandardizedTermIndicator")
		@RuneAttribute("nonStandardizedTermIndicator")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setNonStandardizedTermIndicator(Boolean _nonStandardizedTermIndicator) {
			this.nonStandardizedTermIndicator = _nonStandardizedTermIndicator == null ? null : _nonStandardizedTermIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("blockTradeElectionIndicator")
		@RuneAttribute("blockTradeElectionIndicator")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setBlockTradeElectionIndicator(Boolean _blockTradeElectionIndicator) {
			this.blockTradeElectionIndicator = _blockTradeElectionIndicator == null ? null : _blockTradeElectionIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("primeBrokerageTransactionIndicator")
		@RuneAttribute("primeBrokerageTransactionIndicator")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setPrimeBrokerageTransactionIndicator(Boolean _primeBrokerageTransactionIndicator) {
			this.primeBrokerageTransactionIndicator = _primeBrokerageTransactionIndicator == null ? null : _primeBrokerageTransactionIndicator;
			return this;
		}
		
		@Override
		@RosettaAttribute("uniqueSwapIdentifier")
		@RuneAttribute("uniqueSwapIdentifier")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setUniqueSwapIdentifier(String _uniqueSwapIdentifier) {
			this.uniqueSwapIdentifier = _uniqueSwapIdentifier == null ? null : _uniqueSwapIdentifier;
			return this;
		}
		
		@Override
		@RosettaAttribute("cftcGuidebook")
		@RuneAttribute("cftcGuidebook")
		public CFTCTransactionReport.CFTCTransactionReportBuilder setCftcGuidebook(CFTCGuidebook _cftcGuidebook) {
			this.cftcGuidebook = _cftcGuidebook == null ? null : _cftcGuidebook.toBuilder();
			return this;
		}
		
		@Override
		public CFTCTransactionReport build() {
			return new CFTCTransactionReport.CFTCTransactionReportImpl(this);
		}
		
		@Override
		public CFTCTransactionReport.CFTCTransactionReportBuilder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public CFTCTransactionReport.CFTCTransactionReportBuilder prune() {
			super.prune();
			if (cftcGuidebook!=null && !cftcGuidebook.prune().hasData()) cftcGuidebook = null;
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (super.hasData()) return true;
			if (getCounterparty2IdentifierSource()!=null) return true;
			if (getCustomBasketIndicator()!=null) return true;
			if (getAmendmentIndicator()!=null) return true;
			if (getPackageIndicator()!=null) return true;
			if (getPostPricedSwapIndicator()!=null) return true;
			if (getSettlementLocationLeg1()!=null) return true;
			if (getSettlementLocationLeg2()!=null) return true;
			if (getNonStandardizedTermIndicator()!=null) return true;
			if (getBlockTradeElectionIndicator()!=null) return true;
			if (getPrimeBrokerageTransactionIndicator()!=null) return true;
			if (getUniqueSwapIdentifier()!=null) return true;
			if (getCftcGuidebook()!=null && getCftcGuidebook().hasData()) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public CFTCTransactionReport.CFTCTransactionReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			super.merge(other, merger);
			
			CFTCTransactionReport.CFTCTransactionReportBuilder o = (CFTCTransactionReport.CFTCTransactionReportBuilder) other;
			
			merger.mergeRosetta(getCftcGuidebook(), o.getCftcGuidebook(), this::setCftcGuidebook);
			
			merger.mergeBasic(getCounterparty2IdentifierSource(), o.getCounterparty2IdentifierSource(), this::setCounterparty2IdentifierSource);
			merger.mergeBasic(getCustomBasketIndicator(), o.getCustomBasketIndicator(), this::setCustomBasketIndicator);
			merger.mergeBasic(getAmendmentIndicator(), o.getAmendmentIndicator(), this::setAmendmentIndicator);
			merger.mergeBasic(getPackageIndicator(), o.getPackageIndicator(), this::setPackageIndicator);
			merger.mergeBasic(getPostPricedSwapIndicator(), o.getPostPricedSwapIndicator(), this::setPostPricedSwapIndicator);
			merger.mergeBasic(getSettlementLocationLeg1(), o.getSettlementLocationLeg1(), this::setSettlementLocationLeg1);
			merger.mergeBasic(getSettlementLocationLeg2(), o.getSettlementLocationLeg2(), this::setSettlementLocationLeg2);
			merger.mergeBasic(getNonStandardizedTermIndicator(), o.getNonStandardizedTermIndicator(), this::setNonStandardizedTermIndicator);
			merger.mergeBasic(getBlockTradeElectionIndicator(), o.getBlockTradeElectionIndicator(), this::setBlockTradeElectionIndicator);
			merger.mergeBasic(getPrimeBrokerageTransactionIndicator(), o.getPrimeBrokerageTransactionIndicator(), this::setPrimeBrokerageTransactionIndicator);
			merger.mergeBasic(getUniqueSwapIdentifier(), o.getUniqueSwapIdentifier(), this::setUniqueSwapIdentifier);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
			if (!super.equals(o)) return false;
		
			CFTCTransactionReport _that = getType().cast(o);
		
			if (!Objects.equals(counterparty2IdentifierSource, _that.getCounterparty2IdentifierSource())) return false;
			if (!Objects.equals(customBasketIndicator, _that.getCustomBasketIndicator())) return false;
			if (!Objects.equals(amendmentIndicator, _that.getAmendmentIndicator())) return false;
			if (!Objects.equals(packageIndicator, _that.getPackageIndicator())) return false;
			if (!Objects.equals(postPricedSwapIndicator, _that.getPostPricedSwapIndicator())) return false;
			if (!Objects.equals(settlementLocationLeg1, _that.getSettlementLocationLeg1())) return false;
			if (!Objects.equals(settlementLocationLeg2, _that.getSettlementLocationLeg2())) return false;
			if (!Objects.equals(nonStandardizedTermIndicator, _that.getNonStandardizedTermIndicator())) return false;
			if (!Objects.equals(blockTradeElectionIndicator, _that.getBlockTradeElectionIndicator())) return false;
			if (!Objects.equals(primeBrokerageTransactionIndicator, _that.getPrimeBrokerageTransactionIndicator())) return false;
			if (!Objects.equals(uniqueSwapIdentifier, _that.getUniqueSwapIdentifier())) return false;
			if (!Objects.equals(cftcGuidebook, _that.getCftcGuidebook())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = super.hashCode();
			_result = 31 * _result + (counterparty2IdentifierSource != null ? counterparty2IdentifierSource.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (customBasketIndicator != null ? customBasketIndicator.hashCode() : 0);
			_result = 31 * _result + (amendmentIndicator != null ? amendmentIndicator.hashCode() : 0);
			_result = 31 * _result + (packageIndicator != null ? packageIndicator.hashCode() : 0);
			_result = 31 * _result + (postPricedSwapIndicator != null ? postPricedSwapIndicator.hashCode() : 0);
			_result = 31 * _result + (settlementLocationLeg1 != null ? settlementLocationLeg1.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (settlementLocationLeg2 != null ? settlementLocationLeg2.getClass().getName().hashCode() : 0);
			_result = 31 * _result + (nonStandardizedTermIndicator != null ? nonStandardizedTermIndicator.hashCode() : 0);
			_result = 31 * _result + (blockTradeElectionIndicator != null ? blockTradeElectionIndicator.hashCode() : 0);
			_result = 31 * _result + (primeBrokerageTransactionIndicator != null ? primeBrokerageTransactionIndicator.hashCode() : 0);
			_result = 31 * _result + (uniqueSwapIdentifier != null ? uniqueSwapIdentifier.hashCode() : 0);
			_result = 31 * _result + (cftcGuidebook != null ? cftcGuidebook.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "CFTCTransactionReportBuilder {" +
				"counterparty2IdentifierSource=" + this.counterparty2IdentifierSource + ", " +
				"customBasketIndicator=" + this.customBasketIndicator + ", " +
				"amendmentIndicator=" + this.amendmentIndicator + ", " +
				"packageIndicator=" + this.packageIndicator + ", " +
				"postPricedSwapIndicator=" + this.postPricedSwapIndicator + ", " +
				"settlementLocationLeg1=" + this.settlementLocationLeg1 + ", " +
				"settlementLocationLeg2=" + this.settlementLocationLeg2 + ", " +
				"nonStandardizedTermIndicator=" + this.nonStandardizedTermIndicator + ", " +
				"blockTradeElectionIndicator=" + this.blockTradeElectionIndicator + ", " +
				"primeBrokerageTransactionIndicator=" + this.primeBrokerageTransactionIndicator + ", " +
				"uniqueSwapIdentifier=" + this.uniqueSwapIdentifier + ", " +
				"cftcGuidebook=" + this.cftcGuidebook +
			'}' + " " + super.toString();
		}
	}
}
